/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FeatureMapAndEpoch;

public class MockController
implements Controller {
    private static final NotControllerException NOT_CONTROLLER_EXCEPTION = new NotControllerException("This is not the correct controller for this cluster.");
    private volatile boolean active = true;
    private final Map<String, Uuid> topicNameToId = new HashMap<String, Uuid>();
    private final Map<Uuid, MockTopic> topics = new HashMap<Uuid, MockTopic>();

    private MockController(Collection<MockTopic> initialTopics) {
        for (MockTopic topic : initialTopics) {
            this.topics.put(topic.id, topic);
            this.topicNameToId.put(topic.name, topic.id);
        }
    }

    public CompletableFuture<AlterIsrResponseData> alterIsr(AlterIsrRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CreateTopicsResponseData> createTopics(CreateTopicsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> unregisterBroker(int brokerId) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(Collection<String> topicNames) {
        HashMap<String, ResultOrError> results = new HashMap<String, ResultOrError>();
        for (String topicName : topicNames) {
            if (!this.topicNameToId.containsKey(topicName)) {
                results.put(topicName, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION)));
                continue;
            }
            results.put(topicName, new ResultOrError((Object)this.topicNameToId.get(topicName)));
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(Collection<Uuid> topicIds) {
        HashMap<Uuid, ResultOrError> results = new HashMap<Uuid, ResultOrError>();
        for (Uuid topicId : topicIds) {
            MockTopic topic = this.topics.get(topicId);
            if (topic == null) {
                results.put(topicId, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_ID)));
                continue;
            }
            results.put(topicId, new ResultOrError((Object)topic.name));
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<Uuid, ApiError>> deleteTopics(Collection<Uuid> topicIds) {
        if (!this.active) {
            CompletableFuture<Map<Uuid, ApiError>> future = new CompletableFuture<Map<Uuid, ApiError>>();
            future.completeExceptionally((Throwable)NOT_CONTROLLER_EXCEPTION);
            return future;
        }
        HashMap<Uuid, ApiError> results = new HashMap<Uuid, ApiError>();
        for (Uuid topicId : topicIds) {
            MockTopic topic = this.topics.remove(topicId);
            if (topic == null) {
                results.put(topicId, new ApiError(Errors.UNKNOWN_TOPIC_ID));
                continue;
            }
            this.topicNameToId.remove(topic.name);
            results.put(topicId, ApiError.NONE);
        }
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(Map<ConfigResource, Collection<String>> resources) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ElectLeadersRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<FeatureMapAndEpoch> finalizedFeatures() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean validateOnly) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> newConfigs, boolean validateOnly) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(BrokerHeartbeatRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<BrokerRegistrationReply> registerBroker(BrokerRegistrationRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> waitForReadyBrokers(int minBrokers) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> quotaAlterations, boolean validateOnly) {
        throw new UnsupportedOperationException();
    }

    public void beginShutdown() {
        this.active = false;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long curClaimEpoch() {
        return this.active ? 1L : -1L;
    }

    public void close() {
        this.beginShutdown();
    }

    static class MockTopic {
        private final String name;
        private final Uuid id;

        MockTopic(String name, Uuid id) {
            this.name = name;
            this.id = id;
        }
    }

    public static class Builder {
        private final Map<String, MockTopic> initialTopics = new HashMap<String, MockTopic>();

        public Builder newInitialTopic(String name, Uuid id) {
            this.initialTopics.put(name, new MockTopic(name, id));
            return this;
        }

        public MockController build() {
            return new MockController(this.initialTopics.values());
        }
    }
}

