/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import kafka.tools.ChecksumMessageFormatter;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import kafka.tools.NoOpMessageFormatter;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.MockDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001G\r\u0001=!)Q\u0005\u0001C\u0001M!)\u0011\u0006\u0001C\u0001U!)1\b\u0001C\u0001U!)\u0001\t\u0001C\u0001U!)!\t\u0001C\u0001U!)A\t\u0001C\u0001U!)a\t\u0001C\u0001U!)\u0001\n\u0001C\u0001U!)!\n\u0001C\u0001U!)A\n\u0001C\u0001U!)a\n\u0001C\u0001U!)\u0001\u000b\u0001C\u0001U!)!\u000b\u0001C\u0001U!)A\u000b\u0001C\u0001U!)a\u000b\u0001C\u0001U!)\u0001\f\u0001C\u0001U!)!\f\u0001C\u0001U!)A\f\u0001C\u0001U!)a\f\u0001C\u0001U!)\u0001\r\u0001C\u0001U!)!\r\u0001C\u0001U!)A\r\u0001C\u0001U!)a\r\u0001C\u0001U\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u0011!dG\u0001\u0006i>|Gn\u001d\u0006\u00029\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011!G\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002WA\u0011\u0001\u0005L\u0005\u0003[\u0005\u0012A!\u00168ji\"\u0012!a\f\t\u0003aej\u0011!\r\u0006\u0003eM\n1!\u00199j\u0015\t!T'A\u0004kkBLG/\u001a:\u000b\u0005Y:\u0014!\u00026v]&$(\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;c\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002MMDw.\u001e7e%\u0016\u001cX\r^+o\u0007>t7/^7fI>3gm]3ug\n+gm\u001c:f\u000bbLG\u000f\u000b\u0002\u0004{A\u0011\u0001GP\u0005\u0003\u007fE\u0012A\u0001V3ti\u0006\t3\u000f[8vY\u0012d\u0015.\\5u%\u0016\fGm\u001d+p\u001b\u0006DX*Z:tC\u001e,G*[7ji\"\u0012A!P\u0001$g\"|W\u000f\u001c3Ti>\u0004x\u000b[3o\u001fV$\b/\u001e;DQ\u0016\u001c7.\u0012:s_J4\u0015-\u001b7tQ\t)Q(A\u0012tQ>,H\u000e\u001a)beN,g+\u00197jI\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4)\u0005\u0019i\u0014AO:i_VdG\rU1sg\u00164\u0016\r\\5e'&l\u0007\u000f\\3D_:\u001cX/\\3s-\u0006d\u0017\u000eZ\"p]\u001aLwmV5uQ:+X.\u001a:jG>3gm]3uQ\t9Q(A\u0015tQ>,H\u000eZ#ySR|e.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0003\u0011u\n\u0011h\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3TS6\u0004H.Z\"p]N,X.\u001a:WC2LGmQ8oM&<w+\u001b;i'R\u0014\u0018N\\4PM\u001a\u001cX\r\u001e\u0015\u0003\u0013u\nqg\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3D_:\u001cX/\\3s\u0007>tg-[4XSRD\u0017)\u001e;p\u001f\u001a47/\u001a;SKN,G\u000fT1uKN$\bF\u0001\u0006>\u0003e\u001a\bn\\;mIB\u000b'o]3WC2LGmQ8ogVlWM]\"p]\u001aLwmV5uQ\u0006+Ho\\(gMN,GOU3tKR,\u0015M\u001d7jKN$\bFA\u0006>\u0003%\u001b\bn\\;mIB\u000b'o]3WC2LGmQ8ogVlWM]\"p]\u001aLwmV5uQ\u0006+Ho\\(gMN,GOU3tKR\fe\u000eZ'bi\u000eD\u0017N\\4Ge>l')Z4j]:Lgn\u001a\u0015\u0003\u0019u\nqf\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3D_:\u001cX/\\3s\u0007>tg-[4XSRDgj\\(gMN,GOU3tKRD#!D\u001f\u0002\u000fNDw.\u001e7e\u000bbLGo\u00148J]Z\fG.\u001b3D_:4\u0017nZ,ji\"\fU\u000f^8PM\u001a\u001cX\r\u001e*fg\u0016$\u0018I\u001c3D_:4G.[2uS:<gI]8n\u0005\u0016<\u0017N\u001c8j]\u001eD#AD\u001f\u00025MDw.\u001e7e!\u0006\u00148/Z\"p]\u001aLwm\u001d$s_64\u0015\u000e\\3)\u0005=i\u0014AK4s_V\u0004\u0018\nZ:Qe>4\u0018\u000eZ3e\u0013:$\u0015N\u001a4fe\u0016tG\u000f\u00157bG\u0016\u001cX*^:u\u001b\u0006$8\r\u001b\u0015\u0003!u\n\u0011\u0007^3ti\u000e+8\u000f^8n!J|\u0007/\u001a:usNCw.\u001e7e\u0005\u0016\u0004\u0016m]:fIR{7i\u001c8gS\u001e,(/Z'fi\"|G\r\u000b\u0002\u0012{\u0005a3\u000f[8vY\u0012\u0004\u0016M]:f\u000fJ|W\u000f]%e\rJ|WNQ3hS:t\u0017N\\4HSZ,g\u000eV8hKRDWM\u001d\u0015\u0003%u\nAf\u001d5pk2$W\t_5u\u001f:<%o\\;q\u0013\u0012\fe\u000e\u001a)beRLG/[8o\u000f&4XM\u001c+pO\u0016$\b.\u001a:)\u0005Mi\u0014AI:i_VdG-\u0012=ji>swJ\u001a4tKR<\u0016\u000e\u001e5pkR\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0015{\u0005YB/Z:u\t\u00164\u0017-\u001e7u\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;uKJD#!F\u001f\u00021Q,7\u000f\u001e(p\u001fBlUm]:bO\u00164uN]7biR,'\u000f\u000b\u0002\u0017{\u0005aB/Z:u\u0007\",7m[:v[6+7o]1hK\u001a{'/\\1ui\u0016\u0014\bFA\f>\u0001")
public class ConsoleConsumerTest {
    @BeforeEach
    public void setup() {
        ConsoleConsumer$.MODULE$.messageCount_$eq(0);
    }

    @Test
    public void shouldResetUnConsumedOffsetsBeforeExit() {
        String topic = "test";
        int maxMessages = 123;
        int totalMessages = 700;
        Long startOffset = Predef$.MODULE$.long2Long(0L);
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Consumer)mockConsumer, ConsoleConsumer.ConsumerWrapper$.MODULE$.$lessinit$greater$default$6());
        mockConsumer.rebalance((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        mockConsumer.updateBeginningOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)startOffset), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)startOffset)}))).asJava());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> mockConsumer.addRecord(new ConsumerRecord(topic, i % 2, (long)(i / 2), (Object)"key".getBytes(), (Object)"value".getBytes())));
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(maxMessages), formatter, consumer, System.out, false);
        Assertions.assertEquals((long)totalMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        consumer.resetUnconsumedOffsets();
        Assertions.assertEquals((long)maxMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)maxMessages))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
    }

    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)messageLimit))).receive();
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)messageLimit))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        consumer.cleanup();
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((PrintStream)Mockito.verify((Object)printStream)).checkError();
        consumer.cleanup();
    }

    @Test
    public void shouldParseValidConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assertions.assertEquals((long)3L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithStringOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--property", "print.value=false"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((DefaultMessageFormatter)config.formatter()).printValue()));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithNoOffsetReset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$2, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(BoxesRunTime.unboxToInt((Object)x$2), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"});
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            Assertions.assertThrows(IllegalArgumentException.class, () -> ConsoleConsumer$.MODULE$.consumerProps(config));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("request.timeout.ms=1000\n".getBytes());
        propsStream.write("group.id=group1".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
        Assertions.assertEquals((Object)"group1", (Object)config.consumerProps().getProperty("group.id"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$3, message) -> ConsoleConsumerTest.$anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(BoxesRunTime.unboxToInt((Object)x$3), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        ObjectRef args = ObjectRef.create((Object)((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()})));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=test-group".getBytes());
        propsStream.close();
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig((String[])args.elem);
        Properties props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"});
        config = new ConsoleConsumer.ConsumerConfig((String[])args.elem);
        props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testCustomPropertyShouldBePassedToConfigureMethod() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--property", "key.deserializer.my-props=abc"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertTrue((boolean)(config.formatter() instanceof DefaultMessageFormatter));
        Assertions.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assertions.assertTrue((boolean)(formatter.keyDeserializer().get() instanceof MockDeserializer));
        Assertions.assertEquals((int)1, (int)((MockDeserializer)formatter.keyDeserializer().get()).configs.size());
        Assertions.assertEquals((Object)"abc", ((MockDeserializer)formatter.keyDeserializer().get()).configs.get("my-props"));
        Assertions.assertTrue((boolean)((MockDeserializer)formatter.keyDeserializer().get()).isKey);
    }

    @Test
    public void shouldParseGroupIdFromBeginningGivenTogether() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((long)-2L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group"});
        config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnGroupIdAndPartitionGivenTogether() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$4, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(BoxesRunTime.unboxToInt((Object)x$4), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--partition", "0"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnOffsetWithoutPartition() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$5, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnOffsetWithoutPartition$1(BoxesRunTime.unboxToInt((Object)x$5), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--offset", "10"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testDefaultMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        DefaultMessageFormatter formatter = new DefaultMessageFormatter();
        HashMap<String, String> configs = new HashMap<String, String>();
        formatter.configure(configs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"value\n", (Object)out.toString());
        configs.put("print.key", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"key\tvalue\n", (Object)out.toString());
        configs.put("print.partition", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"Partition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.timestamp", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.offset", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        out = new ByteArrayOutputStream();
        ConsumerRecord record2 = new ConsumerRecord("topic", 0, 123L, 123L, TimestampType.CREATE_TIME, 321L, -1, -1, (Object)"key".getBytes(), (Object)"value".getBytes());
        formatter.writeTo(record2, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        formatter.close();
    }

    @Test
    public void testNoOpMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        NoOpMessageFormatter formatter = new NoOpMessageFormatter();
        formatter.configure(new HashMap());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"", (Object)out.toString());
    }

    @Test
    public void testChecksumMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        ChecksumMessageFormatter formatter = new ChecksumMessageFormatter();
        HashMap<String, String> configs = new HashMap<String, String>();
        formatter.configure(configs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"checksum:-1\n", (Object)out.toString());
        configs.put("topic", "topic1");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"topic1:checksum:-1\n", (Object)out.toString());
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(int x$2, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(int x$3, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(int x$4, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnOffsetWithoutPartition$1(int x$5, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

