/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.TimeUnit;
import kafka.utils.MockTime;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u0004/\u0001\u0001\u0006Ia\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019!\u0004\u0001)A\u0005c!9Q\u0007\u0001b\u0001\n\u0013\u0001\u0004B\u0002\u001c\u0001A\u0003%\u0011\u0007C\u00048\u0001\t\u0007I\u0011\u0002\u0019\t\ra\u0002\u0001\u0015!\u00032\u0011\u001dI\u0004A1A\u0005\niBaA\u0012\u0001!\u0002\u0013Y\u0004\"B$\u0001\t\u0003A\u0005\"B,\u0001\t\u0003A\u0005\"B-\u0001\t\u0003A\u0005\"B.\u0001\t\u0003A\u0005\"B/\u0001\t\u0003A\u0005\"B0\u0001\t\u0003A\u0005\"B1\u0001\t\u0003A\u0005\"B2\u0001\t\u0003A\u0005\"B3\u0001\t\u0003A\u0005\"B4\u0001\t\u0013A\u0007\"B<\u0001\t\u0013A\bBB@\u0001\t\u0013\t\tA\u0001\bRk>$\u0018-\u0016;jYN$Vm\u001d;\u000b\u0005iY\u0012!B;uS2\u001c(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005I\u0012\u0001\u0002;j[\u0016,\u0012a\u000b\t\u0003Q1J!!L\r\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n!B\\;n'\u0006l\u0007\u000f\\3t+\u0005\t\u0004C\u0001\u00113\u0013\t\u0019\u0014EA\u0002J]R\f1B\\;n'\u0006l\u0007\u000f\\3tA\u0005y1/Y7qY\u0016<\u0016N\u001c3poN+7-\u0001\ttC6\u0004H.Z,j]\u0012|woU3dA\u0005\tR.\u0019=UQJ|G\u000f\u001e7f)&lW-T:\u0002%5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5\u000fI\u0001\u000b[\u0016$(/[2OC6,W#A\u001e\u0011\u0005q\"U\"A\u001f\u000b\u0005yz\u0014AB2p[6|gN\u0003\u0002\u001d\u0001*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0013\t)UH\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\f1\"\\3ue&\u001cg*Y7fA\u00059C/Z:u)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,W)];bYN\fVo\u001c;b)\u0005I\u0005C\u0001\u0011K\u0013\tY\u0015E\u0001\u0003V]&$\bF\u0001\u0007N!\tqU+D\u0001P\u0015\t\u0001\u0016+A\u0002ba&T!AU*\u0002\u000f),\b/\u001b;fe*\u0011AKQ\u0001\u0006UVt\u0017\u000e^\u0005\u0003->\u0013A\u0001V3ti\u00061C/Z:u)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,')\u001a7poF+x\u000e^1)\u00055i\u0015A\n;fgR$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/Z!c_Z,\u0017+^8uC\"\u0012a\"T\u0001/i\u0016\u001cHOQ8v]\u0012,G\r\u00165s_R$H.\u001a+j[\u0016|%m]3sm\u0016$'+\u0019;f\u000bF,\u0018\r\\:Rk>$\u0018\r\u000b\u0002\u0010\u001b\u0006iC/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,')\u001a7poF+x\u000e^1)\u0005Ai\u0015a\u000e;fgR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/Z!c_Z,\u0017+^8uC\n+Gn\\<MS6LG\u000f\u000b\u0002\u0012\u001b\u00069D/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,\u0017IY8wKF+x\u000e^1BE>4X\rT5nSRD#AE'\u0002mQ,7\u000f\u001e+ie>$H\u000f\\3US6,G\u000b\u001b:poN,\u0005pY3qi&|g.\u00134Qe>4\u0018\u000eZ3e\u001d>t'+\u0019;f\u001b\u0016$(/[2)\u0005Mi\u0015!\u0010;fgR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]&3\u0007K]8wS\u0012,GMT8o%\u0006$X-T3ue&\u001c\u0007F\u0001\u000bN\u0003]\tXo\u001c;b-&|G.\u0019;j_:,\u0005pY3qi&|g\u000e\u0006\u0003j_R4\bC\u00016n\u001b\u0005Y'B\u00017>\u0003\u001diW\r\u001e:jGNL!A\\6\u0003/E+x\u000e^1WS>d\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007\"\u00029\u0016\u0001\u0004\t\u0018!D8cg\u0016\u0014h/\u001a3WC2,X\r\u0005\u0002!e&\u00111/\t\u0002\u0007\t>,(\r\\3\t\u000bU,\u0002\u0019A9\u0002\u000bE,x\u000e^1\t\u000b=*\u0002\u0019A\u0019\u0002\u0019QD'o\u001c;uY\u0016$\u0016.\\3\u0015\tedXP \t\u0003AiL!a_\u0011\u0003\t1{gn\u001a\u0005\u0006aZ\u0001\r!\u001d\u0005\u0006kZ\u0001\r!\u001d\u0005\u0006_Y\u0001\r!M\u0001\u0014E>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.\u001a\u000b\ns\u0006\r\u0011QAA\u0004\u0003\u0013AQ\u0001]\fA\u0002EDQ!^\fA\u0002EDQaL\fA\u0002EBa!a\u0003\u0018\u0001\u0004I\u0018aD7bqRC'o\u001c;uY\u0016$\u0016.\\3")
public class QuotaUtilsTest {
    private final MockTime time = new MockTime();
    private final int numSamples;
    private final int sampleWindowSec;
    private final int maxThrottleTimeMs;
    private final MetricName metricName = new MetricName("test-metric", "groupA", "testA", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());

    private MockTime time() {
        return this.time;
    }

    private int numSamples() {
        return this.numSamples;
    }

    private int sampleWindowSec() {
        return this.sampleWindowSec;
    }

    private int maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName metricName() {
        return this.metricName;
    }

    @Test
    public void testThrottleTimeObservedRateEqualsQuota() {
        int numSamples = 10;
        double observedValue = 16.5;
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples));
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples + 1));
    }

    @Test
    public void testThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 20.4;
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleTimeObservedRateAboveQuota() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)2000L, (long)this.throttleTime(observedValue, quota, 3));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateEqualsQuota() {
        double observedValue = 18.2;
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 22.4;
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples() + 1, this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaBelowLimit() {
        double quota = 50.0;
        double observedValue = 55.0;
        Assertions.assertEquals((long)100L, (long)this.boundedThrottleTime(observedValue, quota, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaAboveLimit() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)this.maxThrottleTimeMs(), (long)this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.throttleTime(new QuotaViolationException(testMetric, 10.0, 20.0), this.time().milliseconds()));
    }

    @Test
    public void testBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.boundedThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs(), this.time().milliseconds()));
    }

    private QuotaViolationException quotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long throttleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.throttleTime(e, this.time().milliseconds());
    }

    private long boundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, maxThrottleTime, this.time().milliseconds());
    }

    public QuotaUtilsTest() {
        this.numSamples = 10;
        this.sampleWindowSec = 1;
        this.maxThrottleTimeMs = 500;
    }
}

