/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.admin;

import java.io.Serializable;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4Aa\u0004\t\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0004.\u0001\u0001\u0007I\u0011\u0001\u0018\t\u000fm\u0002\u0001\u0019!C\u0001y!1Q\t\u0001Q!\n=BQA\u0012\u0001\u0005B\u001dCQa\u0015\u0001\u0005B\u001dCQ\u0001\u0017\u0001\u0005\u0002\u001dCQ!\u0018\u0001\u0005\u0002\u001dCQa\u0018\u0001\u0005\u0002\u001dCQ!\u0019\u0001\u0005\n\tDQ\u0001\u001d\u0001\u0005\u0002\u001dCQ!\u001d\u0001\u0005\u0002I\u0014!\u0004T5ti>3gm]3ug&sG/Z4sCRLwN\u001c+fgRT!!\u0005\n\u0002\u000b\u0005$W.\u001b8\u000b\u0005M!\u0012!B6bM.\f'\"A\u000b\u0002\u0017%tG/Z4sCRLwN\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!D\u0003\u0002\u00167)\t1#\u0003\u0002\u001e5\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002!\u0005IAo\u001c9jG:\u000bW.Z\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw-\u0001\u0006u_BL7MT1nK\u0002\n1\"\u00193nS:\u001cE.[3oiV\tq\u0006\u0005\u00021s5\t\u0011G\u0003\u0002\u0012e)\u00111\u0007N\u0001\bG2LWM\u001c;t\u0015\t\u0019RG\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e2\u0005\u0015\tE-\\5o\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fHCA\u001fD!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0011)f.\u001b;\t\u000f\u0011+\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u0019\u0005$W.\u001b8DY&,g\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0003uB#aB%\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015aA1qS*\u0011ajT\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001v'A\u0003kk:LG/\u0003\u0002S\u0017\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001C+\u0011\u0005)3\u0016BA,L\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nuKN$X)\u0019:mS\u0016\u001cHo\u00144gg\u0016$\bFA\u0005[!\tQ5,\u0003\u0002]\u0017\n!A+Z:u\u0003A!Xm\u001d;MCR,7\u000f^(gMN,G\u000f\u000b\u0002\u000b5\u00061B/Z:u\u001b\u0006DH+[7fgR\fW\u000e](gMN,G\u000f\u000b\u0002\f5\u0006y!/\u001e8GKR\u001c\u0007n\u00144gg\u0016$8\u000fF\u0002dU.\u0004\"\u0001Z4\u000f\u0005A*\u0017B\u000142\u0003Ea\u0015n\u001d;PM\u001a\u001cX\r^:SKN,H\u000e^\u0005\u0003Q&\u0014Q\u0003T5ti>3gm]3ugJ+7/\u001e7u\u0013:4wN\u0003\u0002gc!)Q\u0006\u0004a\u0001_!)A\u000e\u0004a\u0001[\u0006QqN\u001a4tKR\u001c\u0006/Z2\u0011\u0005Ar\u0017BA82\u0005)yeMZ:fiN\u0003XmY\u0001\u0010aJ|G-^2f\u001b\u0016\u001c8/Y4fg\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001t!\r!x/_\u0007\u0002k*\u0011aoP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=v\u0005\r\u0019V-\u001d\t\u0003uvl\u0011a\u001f\u0006\u0003yn\taa]3sm\u0016\u0014\u0018B\u0001@|\u0005-Y\u0015MZ6b\u0007>tg-[4")
public class ListOffsetsIntegrationTest
extends KafkaServerTestHarness {
    private final String topicName;
    private Admin adminClient = null;

    public String topicName() {
        return this.topicName;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.createTopic(this.topicName(), 1, (short)1, this.createTopic$default$4());
        this.produceMessages();
        this.adminClient_$eq(Admin.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        super.tearDown();
    }

    @Test
    public void testEarliestOffset() {
        ListOffsetsResult.ListOffsetsResultInfo earliestOffset = this.runFetchOffsets(this.adminClient(), OffsetSpec.earliest());
        Assertions.assertEquals((long)0L, (long)earliestOffset.offset());
    }

    @Test
    public void testLatestOffset() {
        ListOffsetsResult.ListOffsetsResultInfo latestOffset = this.runFetchOffsets(this.adminClient(), OffsetSpec.latest());
        Assertions.assertEquals((long)3L, (long)latestOffset.offset());
    }

    @Test
    public void testMaxTimestampOffset() {
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), OffsetSpec.maxTimestamp());
        Assertions.assertEquals((long)1L, (long)maxTimestampOffset.offset());
    }

    private ListOffsetsResult.ListOffsetsResultInfo runFetchOffsets(Admin adminClient, OffsetSpec offsetSpec) {
        TopicPartition tp = new TopicPartition(this.topicName(), 0);
        return (ListOffsetsResult.ListOffsetsResultInfo)((java.util.Map)adminClient.listOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetSpec)}))).asJava(), new ListOffsetsOptions()).all().get()).get(tp);
    }

    public void produceMessages() {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10000]), (List)new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10000]), (List)new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10000]), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    public ListOffsetsIntegrationTest() {
        this.topicName = "foo";
    }
}

