/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$LogDirReassignment$;
import kafka.admin.ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ZkIsrManager$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0001\u0011\rb\u0001B1c\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001A\u0002\u0013\u00051\u000fC\u0005\u0002x\u0002\u0001\r\u0011\"\u0001\u0002z\"9\u0011Q \u0001!B\u0013!\bbBA\u0000\u0001\u0011\u0005\u0013q\u001c\u0005\n\u0005/\u0001!\u0019!C\u0001\u00053A\u0001B!\f\u0001A\u0003%!1\u0004\u0005\b\u0005_\u0001A\u0011AAp\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003?DqA!\u0010\u0001\t\u0003\ty\u000eC\u0004\u0003B\u0001!\t!a8\t\u000f\t\r\u0003\u0001\"\u0001\u0002`\"9!q\t\u0001\u0005\u0002\u0005}\u0007b\u0002B&\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005\u001f\u0002A\u0011AAp\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003?DqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003j\u0001!IAa\u001b\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005#\u0003A\u0011AAp\u0011\u001d\u0011)\n\u0001C\u0001\u0003?4aA!'\u0001\u0001\nm\u0005B\u0003BX1\tU\r\u0011\"\u0001\u0002\u0010!Q!\u0011\u0017\r\u0003\u0012\u0003\u0006I!!\u0005\t\u0015\tM\u0006D!f\u0001\n\u0003\ty\u0001\u0003\u0006\u00036b\u0011\t\u0012)A\u0005\u0003#A!Ba.\u0019\u0005+\u0007I\u0011AA\b\u0011)\u0011I\f\u0007B\tB\u0003%\u0011\u0011\u0003\u0005\u0007]b!\tAa/\t\u0013\t\u0015\u0007$!A\u0005\u0002\t\u001d\u0007\"\u0003Bh1E\u0005I\u0011\u0001Bi\u0011%\u00119\u000fGI\u0001\n\u0003\u0011\t\u000eC\u0005\u0003jb\t\n\u0011\"\u0001\u0003R\"I!1\u001e\r\u0002\u0002\u0013\u0005#Q\u001e\u0005\n\u0005_D\u0012\u0011!C\u0001\u0005cD\u0011Ba=\u0019\u0003\u0003%\tA!>\t\u0013\t}\b$!A\u0005B\r\u0005\u0001\"CB\u00051\u0005\u0005I\u0011AB\u0006\u0011%\u0019)\u0002GA\u0001\n\u0003\u001a9\u0002C\u0005\u0004\u001aa\t\t\u0011\"\u0011\u0004\u001c!I1Q\u0004\r\u0002\u0002\u0013\u00053qD\u0004\n\u0007G\u0001\u0011\u0011!E\u0001\u0007K1\u0011B!'\u0001\u0003\u0003E\taa\n\t\r9lC\u0011AB\u001b\u0011%\u0019I\"LA\u0001\n\u000b\u001aY\u0002C\u0005\u000485\n\t\u0011\"!\u0004:!I1\u0011I\u0017\u0002\u0002\u0013\u000551\t\u0005\b\u0007+\u0002A\u0011BB,\u0011\u001d\u0019\t\b\u0001C\u0005\u0007gBqa!&\u0001\t\u0013\u00199\nC\u0004\u0004$\u0002!Ia!*\t\u000f\r]\u0006\u0001\"\u0003\u0004:\u001a11\u0011\u001b\u0001\u0001\u0007'D!b!68\u0005\u0003\u0005\u000b\u0011BBl\u0011)\u0019Yg\u000eBC\u0002\u0013\u0005!\u0011\u001f\u0005\u000b\u0007;<$\u0011!Q\u0001\n\u0005}\u0002B\u000288\t\u0003\u0019y\u000eC\u0005\u0004h^\u0012\r\u0011\"\u0001\u0004j\"A1\u0011_\u001c!\u0002\u0013\u0019Y\u000fC\u0005\u0004t^\u0012\r\u0011\"\u0001\u0004v\"A1Q`\u001c!\u0002\u0013\u00199\u0010C\u0005\u0004\u0000^\u0012\r\u0011\"\u0001\u0004v\"AA\u0011A\u001c!\u0002\u0013\u00199P\u0002\u0003w\u0001\u00019\bBCA\u0007\u0005\n\u0015\r\u0011\"\u0001\u0002\u0010!Q\u00111\u0006\"\u0003\u0002\u0003\u0006I!!\u0005\t\u0015\u00055\"I!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002<\t\u0013\t\u0011)A\u0005\u0003{AaA\u001c\"\u0005\u0002\u0005\u001d\u0003\"CA(\u0005\n\u0007I\u0011AA)\u0011!\tIF\u0011Q\u0001\n\u0005M\u0003\"CA.\u0005\n\u0007I\u0011AA/\u0011!\tIG\u0011Q\u0001\n\u0005}\u0003\"CA6\u0005\n\u0007I\u0011AA7\u0011!\t9I\u0011Q\u0001\n\u0005=\u0004\"CAE\u0005\u0002\u0007I\u0011AAF\u0011%\tyJ\u0011a\u0001\n\u0003\t\t\u000b\u0003\u0005\u0002.\n\u0003\u000b\u0015BAG\u0011%\tyK\u0011a\u0001\n\u0003\ty\u0001C\u0005\u00022\n\u0003\r\u0011\"\u0001\u00024\"A\u0011q\u0017\"!B\u0013\t\t\u0002C\u0005\u0002:\n\u0003\r\u0011\"\u0001\u0002<\"I\u0011Q\u001b\"A\u0002\u0013\u0005\u0011q\u001b\u0005\t\u00037\u0014\u0005\u0015)\u0003\u0002>\"9\u0011Q\u001c\"\u0005\u0002\u0005}\u0007bBAq\u0005\u0012\u0005\u0011q\u001c\u0005\b\u0003G\u0014E\u0011AAp\u0011\u001d\t)O\u0011C\u0001\u0003ODq!!>C\t\u0003\nynB\u0005\u0005\u0004\u0001\t\t\u0011#\u0001\u0005\u0006\u0019Aa\u000fAA\u0001\u0012\u0003!9\u0001\u0003\u0004o;\u0012\u0005A\u0011\u0002\u0005\n\t\u0017i\u0016\u0013!C\u0001\t\u001bA\u0011\u0002\"\u0005^#\u0003%\t\u0001b\u0005\u0003CI+\u0017m]:jO:\u0004\u0016M\u001d;ji&|gn]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r$\u0017!B1e[&t'\"A3\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\f!A_6\n\u00055T'\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002aB\u0011\u0011\u000fA\u0007\u0002E\u000691\r\\;ti\u0016\u0014X#\u0001;\u0011\u0005U\u0014U\"\u0001\u0001\u0003;I+\u0017m]:jO:\u0004\u0016M\u001d;ji&|gn\u001d+fgR\u001cE.^:uKJ\u001cBA\u0011=\u0002\u0002A\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}T(AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9\u0001`\u0001\u0003S>LA!a\u0003\u0002\u0006\tI1\t\\8tK\u0006\u0014G.Z\u0001\nu.\u001cuN\u001c8fGR,\"!!\u0005\u0011\t\u0005M\u0011Q\u0005\b\u0005\u0003+\t\t\u0003\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBZ\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005}\u0011!B:dC2\f\u0017\u0002BA\u0012\u0003;\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'\u0002BA\u0012\u0003;\t!B_6D_:tWm\u0019;!\u0003=\u0019wN\u001c4jO>3XM\u001d:jI\u0016\u001c\b\u0003CA\u0019\u0003o\t\t\"!\u0005\u000e\u0005\u0005M\"\u0002BA\u001b\u0003;\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI$a\r\u0003\u00075\u000b\u0007/A\u000bce>\\WM]\"p]\u001aLwm\u0014<feJLG-Z:\u0011\u0011\u0005E\u0012qGA \u0003_\u0001B!!\u0011\u0002D5\u0011\u0011QD\u0005\u0005\u0003\u000b\niBA\u0002J]R$r\u0001^A%\u0003\u0017\ni\u0005C\u0004\u0002\u000e\u001d\u0003\r!!\u0005\t\u0013\u00055r\t%AA\u0002\u0005=\u0002\"CA\u001e\u000fB\u0005\t\u0019AA\u001f\u0003\u001d\u0011'o\\6feN,\"!a\u0015\u0011\u0011\u0005E\u0012qGA \u0003+\u00022!_A,\u0013\r\t9C_\u0001\tEJ|7.\u001a:tA\u00051Ao\u001c9jGN,\"!a\u0018\u0011\u0011\u0005E\u0012qGA+\u0003C\u0002b!!\r\u0002d\u0005\u001d\u0014\u0002BA3\u0003g\u00111aU3r!\u0019\t\t$a\u0019\u0002@\u00059Ao\u001c9jGN\u0004\u0013!\u00042s_.,'oQ8oM&<7/\u0006\u0002\u0002pA1\u0011\u0011OA<\u0003wj!!a\u001d\u000b\t\u0005U\u00141G\u0001\b[V$\u0018M\u00197f\u0013\u0011\tI(a\u001d\u0003\r\t+hMZ3s!\u0011\ti(a!\u000e\u0005\u0005}$bAAAy\u0006!Q\u000f^5m\u0013\u0011\t))a \u0003\u0015A\u0013x\u000e]3si&,7/\u0001\bce>\\WM]\"p]\u001aLwm\u001d\u0011\u0002\u000fM,'O^3sgV\u0011\u0011Q\u0012\t\u0007\u0003c\ny)a%\n\t\u0005E\u00151\u000f\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI\nZ\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005u\u0015q\u0013\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fH\u0003BAR\u0003S\u0003B!!\u0011\u0002&&!\u0011qUA\u000f\u0005\u0011)f.\u001b;\t\u0013\u0005-v*!AA\u0002\u00055\u0015a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%\u0001\u0006ce>\\WM\u001d'jgR\faB\u0019:pW\u0016\u0014H*[:u?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0006U\u0006\"CAV%\u0006\u0005\t\u0019AA\t\u0003-\u0011'o\\6fe2K7\u000f\u001e\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0003\u0003{\u0003B!a0\u0002R6\u0011\u0011\u0011\u0019\u0006\u0004G\u0006\r'\u0002BAc\u0003\u000f\fqa\u00197jK:$8OC\u0002f\u0003\u0013TA!a3\u0002N\u00061\u0011\r]1dQ\u0016T!!a4\u0002\u0007=\u0014x-\u0003\u0003\u0002T\u0006\u0005'!B!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\t\u0005\r\u0016\u0011\u001c\u0005\n\u0003W+\u0016\u0011!a\u0001\u0003{\u000bA\"\u00193nS:\u001cE.[3oi\u0002\nQa]3ukB$\"!a)\u0002\u001b\r\u0014X-\u0019;f'\u0016\u0014h/\u001a:t\u00031\u0019'/Z1uKR{\u0007/[2t\u0003=\u0001(o\u001c3vG\u0016lUm]:bO\u0016\u001cH\u0003CAR\u0003S\fi/!=\t\u000f\u0005-(\f1\u0001\u0002\u0012\u0005)Ao\u001c9jG\"9\u0011q\u001e.A\u0002\u0005}\u0012!\u00039beRLG/[8o\u0011\u001d\t\u0019P\u0017a\u0001\u0003\u007f\t1B\\;n\u001b\u0016\u001c8/Y4fg\u0006)1\r\\8tK\u0006Y1\r\\;ti\u0016\u0014x\fJ3r)\u0011\t\u0019+a?\t\u0011\u0005-6!!AA\u0002Q\f\u0001b\u00197vgR,'\u000fI\u0001\ti\u0016\f'\u000fR8x]\"\u001aQAa\u0001\u0011\t\t\u0015!1C\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u0005\u0019\u0011\r]5\u000b\t\t5!qB\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011\t\"!4\u0002\u000b),h.\u001b;\n\t\tU!q\u0001\u0002\n\u0003\u001a$XM]#bG\"\f\u0001$\u001e8uQJ|G\u000f\u001e7fI\n\u0013xn[3s\u0007>tg-[4t+\t\u0011Y\u0002\u0005\u0005\u0003\u001e\t\r\u0012q\bB\u0013\u001b\t\u0011yB\u0003\u0003\u0003\"\u0005M\u0012!C5n[V$\u0018M\u00197f\u0013\u0011\tIDa\b\u0011\u0011\tu!1EA+\u0005O\u0001B!!\u0011\u0003*%!!1FA\u000f\u0005\u0011auN\\4\u00023UtG\u000f\u001b:piRdW\r\u001a\"s_.,'oQ8oM&<7\u000fI\u0001\u0011i\u0016\u001cHOU3bgNLwM\\7f]RD3\u0001\u0003B\u001a!\u0011\u0011)A!\u000e\n\t\t]\"q\u0001\u0002\u0005)\u0016\u001cH/\u0001\u0013uKN$(+Z1tg&<g.\\3oi^KG\u000f[!mi\u0016\u0014\u0018j\u001d:ESN\f'\r\\3eQ\rI!1G\u0001/i\u0016\u001cHOU3bgNLwM\\7f]R\u001cu.\u001c9mKRLwN\u001c#ve&tw\rU1si&\fG.\u00169he\u0006$W\rK\u0002\u000b\u0005g\tA$\u001a=fGV$X-\u00118e-\u0016\u0014\u0018NZ=SK\u0006\u001c8/[4o[\u0016tG/A\u0016uKN$\b*[4i/\u0006$XM]'be.\fe\r^3s!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\ra!1G\u0001\u001ei\u0016\u001cH/\u00117uKJ\u0014V-Y:tS\u001etW.\u001a8u)\"\u0014x\u000e\u001e;mK\"\u001aQBa\r\u00023Q,7\u000f\u001e+ie>$H\u000f\\3e%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004\u001d\tM\u0012a\f;fgR\u0004&o\u001c3vG\u0016\fe\u000eZ\"p]N,X.Z,ji\"\u0014V-Y:tS\u001etW.\u001a8u\u0013:\u0004&o\\4sKN\u001c\bfA\b\u00034\u0005\u0001B/Z:u\u0007\u0006t7-\u001a7mCRLwN\u001c\u0015\u0004!\tM\u0012!F<bSR4uN\u001d'pO\u0012K'\u000f\u00165s_R$H.\u001a\u000b\u0007\u0003G\u0013YF!\u001a\t\u000f\tu\u0013\u00031\u0001\u0003`\u0005\u0001B\u000f\u001b:piRdW\r\u001a\"s_.,'o\u001d\t\u0007\u0003'\u0011\t'a\u0010\n\t\t\r\u0014\u0011\u0006\u0002\u0004'\u0016$\bb\u0002B4#\u0001\u0007!qE\u0001\u000fY><G)\u001b:UQJ|G\u000f\u001e7f\u0003i9\u0018-\u001b;G_JLe\u000e^3s\u0005J|7.\u001a:UQJ|G\u000f\u001e7f)\u0019\t\u0019K!\u001c\u0003p!9!Q\f\nA\u0002\t}\u0003b\u0002B9%\u0001\u0007!qE\u0001\u0014S:$XM\u001d\"s_.,'\u000f\u00165s_R$H.Z\u0001\u0017o\u0006LGOR8s\u0005J|7.\u001a:UQJ|G\u000f\u001e7fgR1\u00111\u0015B<\u0005sBqA!\u0018\u0014\u0001\u0004\u0011y\u0006C\u0004\u0003|M\u0001\rA! \u0002\u001dQD'o\u001c;uY\u0016\u001cuN\u001c4jOBA\u0011\u0011GA\u001c\u0003#\u00119#A\u000exC&$hi\u001c:Ce>\\WM\u001d'fm\u0016dG\u000b\u001b:piRdWm\u001d\u000b\u0005\u0003G\u0013\u0019\tC\u0004\u0003\u0006R\u0001\rAa\"\u0002\u001fQ\f'oZ3u)\"\u0014x\u000e\u001e;mKN\u0004\u0002\"!\r\u00028\u0005}\"QP\u0001\u001dI\u0016\u001c8M]5cK\n\u0013xn[3s\u0019\u00164X\r\u001c+ie>$H\u000f\\3t)\u0011\u00119I!$\t\u000f\t=U\u00031\u0001\u0002h\u0005I!M]8lKJLEm]\u0001\u0017i\u0016\u001cH\u000fT8h\t&\u0014(+Z1tg&<g.\\3oi\"\u001aaCa\r\u0002GQ,7\u000f^!mi\u0016\u0014Hj\\4ESJ\u0014V-Y:tS\u001etW.\u001a8u)\"\u0014x\u000e\u001e;mK\"\u001aqCa\r\u0003%1{w\rR5s%\u0016\f7o]5h]6,g\u000e^\n\b1\tu%1\u0015BU!\u0011\t\tEa(\n\t\t\u0005\u0016Q\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0005#QU\u0005\u0005\u0005O\u000biBA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0005#1V\u0005\u0005\u0005[\u000biB\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003kg>t\u0017!\u00026t_:\u0004\u0013AC2veJ,g\u000e\u001e#je\u0006Y1-\u001e:sK:$H)\u001b:!\u0003%!\u0018M]4fi\u0012K'/\u0001\u0006uCJ<W\r\u001e#je\u0002\"\u0002B!0\u0003@\n\u0005'1\u0019\t\u0003kbAqAa, \u0001\u0004\t\t\u0002C\u0004\u00034~\u0001\r!!\u0005\t\u000f\t]v\u00041\u0001\u0002\u0012\u0005!1m\u001c9z)!\u0011iL!3\u0003L\n5\u0007\"\u0003BXAA\u0005\t\u0019AA\t\u0011%\u0011\u0019\f\tI\u0001\u0002\u0004\t\t\u0002C\u0005\u00038\u0002\u0002\n\u00111\u0001\u0002\u0012\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BjU\u0011\t\tB!6,\u0005\t]\u0007\u0003\u0002Bm\u0005Gl!Aa7\u000b\t\tu'q\\\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!9\u0002\u001e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015(1\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011QK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u007f\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003x\nu\b\u0003BA!\u0005sLAAa?\u0002\u001e\t\u0019\u0011I\\=\t\u0013\u0005-f%!AA\u0002\u0005}\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\r\u0001CBA\u0019\u0007\u000b\u001190\u0003\u0003\u0004\b\u0005M\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$Ba!\u0004\u0004\u0014A!\u0011\u0011IB\b\u0013\u0011\u0019\t\"!\b\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0016\u0015\u0002\u0002\u0003\u0007!q_\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qH\u0001\ti>\u001cFO]5oOR\u0011\u0011QK\u0001\u0007KF,\u0018\r\\:\u0015\t\r51\u0011\u0005\u0005\n\u0003W[\u0013\u0011!a\u0001\u0005o\f!\u0003T8h\t&\u0014(+Z1tg&<g.\\3oiB\u0011Q/L\n\u0006[\r%\"\u0011\u0016\t\r\u0007W\u0019\t$!\u0005\u0002\u0012\u0005E!QX\u0007\u0003\u0007[QAaa\f\u0002\u001e\u00059!/\u001e8uS6,\u0017\u0002BB\u001a\u0007[\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0019)#A\u0003baBd\u0017\u0010\u0006\u0005\u0003>\u000em2QHB \u0011\u001d\u0011y\u000b\ra\u0001\u0003#AqAa-1\u0001\u0004\t\t\u0002C\u0004\u00038B\u0002\r!!\u0005\u0002\u000fUt\u0017\r\u001d9msR!1QIB)!\u0019\t\tea\u0012\u0004L%!1\u0011JA\u000f\u0005\u0019y\u0005\u000f^5p]BQ\u0011\u0011IB'\u0003#\t\t\"!\u0005\n\t\r=\u0013Q\u0004\u0002\u0007)V\u0004H.Z\u001a\t\u0013\rM\u0013'!AA\u0002\tu\u0016a\u0001=%a\u00059\"-^5mI2{w\rR5s%\u0016\f7o]5h]6,g\u000e\u001e\u000b\t\u0005{\u001bIf!\u001b\u0004n!911\f\u001aA\u0002\ru\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0007?\u001a)'\u0004\u0002\u0004b)!11MAd\u0003\u0019\u0019w.\\7p]&!1qMB1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dqaa\u001b3\u0001\u0004\ty$\u0001\u0005ce>\\WM]%e\u0011\u001d\u0019yG\ra\u0001\u0003O\n\u0001B]3qY&\u001c\u0017m]\u0001\u0014eVtg+\u001a:jMf\f5o]5h]6,g\u000e\u001e\u000b\t\u0007k\u001aYi!$\u0004\u0012B!1qOBC\u001d\u0011\u0019Ih!!\u000f\t\rm4q\u0010\b\u0005\u0003/\u0019i(C\u0001f\u0013\t\u0019G-C\u0002\u0004\u0004\n\f\u0011DU3bgNLwM\u001c)beRLG/[8og\u000e{W.\\1oI&!1qQBE\u0005Y1VM]5gs\u0006\u001b8/[4o[\u0016tGOU3tk2$(bABBE\"9\u0011\u0011X\u001aA\u0002\u0005u\u0006bBBHg\u0001\u0007\u0011\u0011C\u0001\u000bUN|gn\u0015;sS:<\u0007bBBJg\u0001\u00071QB\u0001\u0012aJ,7/\u001a:wKRC'o\u001c;uY\u0016\u001c\u0018aF<bSR4uN\u001d,fe&4\u00170Q:tS\u001etW.\u001a8u))\t\u0019k!'\u0004\u001c\u000eu5q\u0014\u0005\b\u0003s#\u0004\u0019AA_\u0011\u001d\u0019y\t\u000ea\u0001\u0003#Aqaa%5\u0001\u0004\u0019i\u0001C\u0004\u0004\"R\u0002\ra!\u001e\u0002\u001d\u0015D\b/Z2uK\u0012\u0014Vm];mi\u0006!\"/\u001e8Fq\u0016\u001cW\u000f^3BgNLwM\\7f]R$B\"a)\u0004(\u000e%6QVBY\u0007gCq!!/6\u0001\u0004\ti\fC\u0004\u0004,V\u0002\ra!\u0004\u0002\u0015\u0005$G-\u001b;j_:\fG\u000eC\u0004\u00040V\u0002\r!!\u0005\u0002!I,\u0017m]:jO:lWM\u001c;Kg>t\u0007b\u0002B9k\u0001\u0007!q\u0005\u0005\b\u0007k+\u0004\u0019\u0001B\u0014\u0003m\u0011X\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014x\u000e\u001e;mK\u0006\u0019\"/\u001e8DC:\u001cW\r\\!tg&<g.\\3oiRA11XBf\u0007\u001b\u001cy\r\u0005\u0005\u0002B\ru6\u0011YBb\u0013\u0011\u0019y,!\b\u0003\rQ+\b\u000f\\33!\u0019\t\u0019B!\u0019\u0004^A1\u00111\u0003B1\u0007\u000b\u0004Baa\u0018\u0004H&!1\u0011ZB1\u0005U!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006Dq!!/7\u0001\u0004\ti\fC\u0004\u0004\u0010Z\u0002\r!!\u0005\t\u000f\rMe\u00071\u0001\u0004\u000e\tQ!I]8lKJ$\u0015N]:\u0014\u0007]\u0012i*\u0001\u0004sKN,H\u000e\u001e\t\u0005\u0003\u007f\u001bI.\u0003\u0003\u0004\\\u0006\u0005'!\u0006#fg\u000e\u0014\u0018NY3M_\u001e$\u0015N]:SKN,H\u000e^\u0001\nEJ|7.\u001a:JI\u0002\"ba!9\u0004d\u000e\u0015\bCA;8\u0011\u001d\u0019)n\u000fa\u0001\u0007/Dqaa\u001b<\u0001\u0004\ty$A\u0004m_\u001e$\u0015N]:\u0016\u0005\r-\bCBA9\u0007[\f\t\"\u0003\u0003\u0004p\u0006M$a\u0002%bg\"\u001cV\r^\u0001\tY><G)\u001b:tA\u0005Q1-\u001e:M_\u001e$\u0015N]:\u0016\u0005\r]\b\u0003CA9\u0007s\u001ci&!\u0005\n\t\rm\u00181\u000f\u0002\b\u0011\u0006\u001c\b.T1q\u0003-\u0019WO\u001d'pO\u0012K'o\u001d\u0011\u0002\u001b\u0019,H/\u001e:f\u0019><G)\u001b:t\u000391W\u000f^;sK2{w\rR5sg\u0002\nQDU3bgNLwM\u001c)beRLG/[8ogR+7\u000f^\"mkN$XM\u001d\t\u0003kv\u001b2!\u0018BO)\t!)!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\t\u001fQC!a\f\u0003V\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"\u0001\"\u0006+\t\u0005u\"Q\u001b\u0015\b\u0001\u0011eAq\u0004C\u0011!\u0011\u0011)\u0001b\u0007\n\t\u0011u!q\u0001\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\t\tA\u0006")
public class ReassignPartitionsIntegrationTest
extends ZooKeeperTestHarness {
    private volatile ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment$module;
    private volatile ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster$module;
    private ReassignPartitionsTestCluster cluster = null;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$unthrottledBrokerConfigs$1(BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());

    public ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment() {
        if (this.LogDirReassignment$module == null) {
            this.LogDirReassignment$lzycompute$1();
        }
        return this.LogDirReassignment$module;
    }

    public ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster() {
        if (this.ReassignPartitionsTestCluster$module == null) {
            this.ReassignPartitionsTestCluster$lzycompute$1();
        }
        return this.ReassignPartitionsTestCluster$module;
    }

    public ReassignPartitionsTestCluster cluster() {
        return this.cluster;
    }

    public void cluster_$eq(ReassignPartitionsTestCluster x$1) {
        this.cluster = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.cluster(), (String)"ReassignPartitionsTestCluster");
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs() {
        return this.unthrottledBrokerConfigs;
    }

    @Test
    public void testReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentWithAlterIsrDisabled() {
        Map configOverrides = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)configOverrides, this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentCompletionDuringPartialUpgrade() {
        long x$1 = 500L;
        long x$2 = 100L;
        long x$3 = 500L;
        ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig_$eq(new IsrChangePropagationConfig(x$1, x$3, x$2));
        Map oldIbpConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        Map brokerConfigOverrides = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)oldIbpConfig)}));
        String x$4 = this.zkConnect();
        Map<String, String> x$6 = this.ReassignPartitionsTestCluster().$lessinit$greater$default$2();
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, x$4, x$6, (Map<Object, Map<String, String>>)brokerConfigOverrides));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    public void executeAndVerifyReassignment() {
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"bar\",\"partition\":0,\"replicas\":[3,2,0],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).movesOngoing());
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
    }

    @Test
    public void testHighWaterMarkAfterPartitionReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[3,1,2],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        TopicPartition part = new TopicPartition("foo", 0);
        ((KafkaServer)this.cluster().servers().apply(0)).replicaManager().logManager().truncateFullyAndStartAt(part, 123L, false);
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$1(this, part)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        Assertions.assertEquals((long)123L, (long)((KafkaServer)this.cluster().servers().apply(3)).replicaManager().localLogOrException(part).highWatermark(), (String)"Expected broker 3 to have the correct high water mark for the partition.");
    }

    @Test
    public void testAlterReassignmentThrottle() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":\n      [{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},\n      {\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}\n      ]}";
        long initialThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, initialThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), initialThrottle);
        long updatedThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, assignment, updatedThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), updatedThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThrottledReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        Assertions.assertEquals((Object)new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()), (Object)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$1(this, assignment, interBrokerThrottle)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    @Test
    public void testProduceAndConsumeWithReassignmentInProgress() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, 300L, -1L);
        this.cluster().produceMessages("baz", 2, 100);
        TopicPartition part = new TopicPartition("baz", 2);
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(this.cluster().brokerList(), TestUtils$.MODULE$.createConsumer$default$2(), TestUtils$.MODULE$.createConsumer$default$3(), TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11());){
            consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)part, (List)Nil$.MODULE$)).asJava());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 100, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.cluster().adminClient(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{part}))));
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
    }

    @Test
    public void testCancellation() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 200);
        this.cluster().produceMessages("baz", 1, 200);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":1,\"replicas\":[0,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), false))})), true, (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), false));
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("baz", 1)})), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, true));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).partsOngoing());
    }

    private void waitForLogDirThrottle(Set<Object> throttledBrokers, long logDirThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)logDirThrottle))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForInterBrokerThrottle(Set<Object> throttledBrokers, long interBrokerThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForBrokerThrottles(Set<Object> throttledBrokers, Map<String, Object> throttleConfig) {
        scala.collection.immutable.Map throttledBrokerConfigs = (scala.collection.immutable.Map)this.unthrottledBrokerConfigs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.immutable.Map unthrottledConfig = (scala.collection.immutable.Map)x0$1._2();
            Map expectedThrottleConfig = throttledBrokers.contains((Object)BoxesRunTime.boxToInteger((int)brokerId)) ? throttleConfig : unthrottledConfig;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)expectedThrottleConfig);
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
    }

    private void waitForBrokerLevelThrottles(Map<Object, Map<String, Object>> targetThrottles) {
        ObjectRef curThrottles = ObjectRef.create((Object)Map$.MODULE$.empty());
        long x$3 = 25L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$waitForBrokerLevelThrottles$1(this, curThrottles, targetThrottles)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$waitForBrokerLevelThrottles$2(targetThrottles, curThrottles));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private Map<Object, Map<String, Object>> describeBrokerLevelThrottles(Seq<Object> brokerIds) {
        return ((TraversableOnce)brokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$describeBrokerLevelThrottles$1(this, BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Test
    public void testLogDirReassignment() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long logDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, logDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState(reassignment.currentDir(), reassignment.targetDir(), reassignment.targetDir()))})), true));
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), logDirThrottle);
        this.cluster().adminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, "0"), Collections.singletonList(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), ""), AlterConfigOp.OpType.DELETE)))).all().get();
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
        BrokerDirs info1 = new BrokerDirs(this, this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$3 -> ReassignPartitionsIntegrationTest.$anonfun$testLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).asJavaCollection()), 0);
        Assertions.assertEquals((Object)reassignment.targetDir(), (Object)info1.curLogDirs().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    @Test
    public void testAlterLogDirReassignmentThrottle() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long initialLogDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, initialLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), initialLogDirThrottle);
        long updatedLogDirThrottle = 3000000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, reassignment.json(), -1L, updatedLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), updatedLogDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), targetBrokerId)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
    }

    private LogDirReassignment buildLogDirReassignment(TopicPartition topicPartition, int brokerId, Seq<Object> replicas) {
        DescribeLogDirsResult describeLogDirsResult = this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$4 -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom())).asJavaCollection());
        BrokerDirs logDirInfo = new BrokerDirs(this, describeLogDirsResult, brokerId);
        Assertions.assertTrue((boolean)logDirInfo.futureLogDirs().isEmpty());
        String currentDir = (String)logDirInfo.curLogDirs().apply((Object)topicPartition);
        String newDir = (String)logDirInfo.logDirs().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$2(currentDir, x$5))).get();
        Seq logDirs = (Seq)replicas.map((Function1 & Serializable & scala.Serializable)replicaId -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$3(brokerId, newDir, BoxesRunTime.unboxToInt((Object)replicaId)), Seq$.MODULE$.canBuildFrom());
        String reassignmentJson = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         | { \"version\": 1,\n         |  \"partitions\": [\n         |    {\n         |     \"topic\": \"").append(topicPartition.topic()).append("\",\n         |     \"partition\": ").append(topicPartition.partition()).append(",\n         |     \"replicas\": [").append(replicas.mkString(",")).append("],\n         |     \"log_dirs\": [").append(logDirs.mkString(",")).append("]\n         |    }\n         |   ]\n         |  }\n         |").toString())).stripMargin();
        return new LogDirReassignment(this, reassignmentJson, currentDir, newDir);
    }

    private ReassignPartitionsCommand.VerifyAssignmentResult runVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> verifyAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.verifyAssignment(adminClient, jsonString, preserveThrottles);
    }

    private void waitForVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult) {
        ObjectRef latestResult = ObjectRef.create(null);
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$waitForVerifyAssignment$1(this, latestResult, adminClient, jsonString, preserveThrottles, expectedResult)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$waitForVerifyAssignment$2(expectedResult, latestResult));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private void runExecuteAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long replicaAlterLogDirsThrottle) {
        Predef$.MODULE$.println((Object)new StringBuilder(119).append("==> executeAssignment(adminClient, additional=").append(additional).append(", ").append("reassignmentJson=").append(reassignmentJson).append(", ").append("interBrokerThrottle=").append(interBrokerThrottle).append(", ").append("replicaAlterLogDirsThrottle=").append(replicaAlterLogDirsThrottle).append("))").toString());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(adminClient, additional, reassignmentJson, interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7());
    }

    private Tuple2<Set<TopicPartition>, Set<TopicPartitionReplica>> runCancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> cancelAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.cancelAssignment(adminClient, jsonString, preserveThrottles, ReassignPartitionsCommand$.MODULE$.cancelAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.cancelAssignment$default$5());
    }

    private final void LogDirReassignment$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirReassignment$module == null) {
                this.LogDirReassignment$module = new ReassignPartitionsIntegrationTest$LogDirReassignment$(this);
            }
            return;
        }
    }

    private final void ReassignPartitionsTestCluster$lzycompute$1() {
        synchronized (this) {
            if (this.ReassignPartitionsTestCluster$module == null) {
                this.ReassignPartitionsTestCluster$module = new ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testHighWaterMarkAfterPartitionReassignment$1(ReassignPartitionsIntegrationTest $this, TopicPartition part$1) {
        return ((KafkaServer)$this.cluster().servers().apply(3)).replicaManager().onlinePartition(part$1).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.leaderLogIfLocal()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHighWaterMarkAfterPartitionReassignment$3() {
        return "broker 3 should be the new leader";
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$2(Tuple2 x$2) {
        return ((ReassignPartitionsCommand.PartitionReassignmentState)x$2._2()).done();
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$1(ReassignPartitionsIntegrationTest $this, String assignment$1, long interBrokerThrottle$1) {
        ReassignPartitionsCommand.VerifyAssignmentResult result = $this.runVerifyAssignment($this.cluster().adminClient(), assignment$1, true);
        if (!result.partsOngoing()) {
            return true;
        }
        Assertions.assertFalse((boolean)result.partStates().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$2(x$2))), (String)new StringBuilder(73).append("Expected at least one partition reassignment to be ongoing when result = ").append(result).toString());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("foo", 0))).targetReplicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("baz", 2))).targetReplicas());
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Current result: {}", new Object[]{result});
        }
        $this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle$1);
        return false;
    }

    public static final /* synthetic */ String $anonfun$testThrottledReassignment$3() {
        return "Expected reassignment to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, ObjectRef curThrottles$1, Map targetThrottles$1) {
        curThrottles$1.elem = $this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles$1.keySet().toSeq());
        return targetThrottles$1.equals((Object)((Map)curThrottles$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForBrokerLevelThrottles$2(Map targetThrottles$1, ObjectRef curThrottles$1) {
        return new StringBuilder(73).append("timed out waiting for broker throttle to become ").append(targetThrottles$1).append(".  ").append("Latest throttles were ").append((Map)curThrottles$1.elem).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, int brokerId) {
        Properties props = $this.zkClient().getEntityConfigs("brokers", Integer.toString(brokerId));
        scala.collection.immutable.Map throttles = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable & scala.Serializable)throttleName -> new Tuple2(throttleName, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)props.getOrDefault(throttleName, "-1"))).toLong())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)throttles);
    }

    public static final /* synthetic */ Integer $anonfun$testLogDirReassignment$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ Integer $anonfun$buildLogDirReassignment$1(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$buildLogDirReassignment$2(String currentDir$1, String x$5) {
        return !x$5.equals(currentDir$1);
    }

    public static final /* synthetic */ String $anonfun$buildLogDirReassignment$3(int brokerId$1, String newDir$1, int replicaId) {
        if (replicaId == brokerId$1) {
            return new StringBuilder(2).append("\"").append(newDir$1).append("\"").toString();
        }
        return "\"any\"";
    }

    public static final /* synthetic */ boolean $anonfun$waitForVerifyAssignment$1(ReassignPartitionsIntegrationTest $this, ObjectRef latestResult$1, Admin adminClient$1, String jsonString$1, boolean preserveThrottles$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = $this.runVerifyAssignment(adminClient$1, jsonString$1, preserveThrottles$1);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForVerifyAssignment$2(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(71).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(".  ").append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString();
    }

    public class BrokerDirs {
        private final int brokerId;
        private final HashSet<String> logDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public HashSet<String> logDirs() {
            return this.logDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs() {
            return this.curLogDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs() {
            return this.futureLogDirs;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$BrokerDirs$$$outer() {
            return this.$outer;
        }

        public BrokerDirs(ReassignPartitionsIntegrationTest $outer, DescribeLogDirsResult result, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.logDirs = new HashSet();
            this.curLogDirs = new scala.collection.mutable.HashMap();
            this.futureLogDirs = new scala.collection.mutable.HashMap();
            ((java.util.Map)((KafkaFuture)result.descriptions().get(BoxesRunTime.boxToInteger((int)brokerId))).get()).forEach((x0$1, x1$1) -> {
                String logDirName = x0$1;
                LogDirDescription logDirInfo = x1$1;
                this.logDirs().add((Object)logDirName);
                logDirInfo.replicaInfos().forEach((x0$2, x1$2) -> {
                    TopicPartition part = x0$2;
                    if (x1$2.isFuture()) {
                        this.futureLogDirs().put((Object)part, (Object)logDirName);
                        return;
                    }
                    this.curLogDirs().put((Object)part, (Object)logDirName);
                });
            });
        }
    }

    public class LogDirReassignment
    implements Product,
    scala.Serializable {
        private final String json;
        private final String currentDir;
        private final String targetDir;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String json() {
            return this.json;
        }

        public String currentDir() {
            return this.currentDir;
        }

        public String targetDir() {
            return this.targetDir;
        }

        public LogDirReassignment copy(String json, String currentDir, String targetDir) {
            return new LogDirReassignment(this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer(), json, currentDir, targetDir);
        }

        public String copy$default$1() {
            return this.json();
        }

        public String copy$default$2() {
            return this.currentDir();
        }

        public String copy$default$3() {
            return this.targetDir();
        }

        public String productPrefix() {
            return "LogDirReassignment";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.json();
                }
                case 1: {
                    return this.currentDir();
                }
                case 2: {
                    return this.targetDir();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirReassignment;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirReassignment)) return false;
            if (((LogDirReassignment)x$1).kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() != this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirReassignment logDirReassignment = (LogDirReassignment)x$1;
            String string = this.json();
            String string2 = logDirReassignment.json();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.currentDir();
            String string4 = logDirReassignment.currentDir();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.targetDir();
            String string6 = logDirReassignment.targetDir();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!logDirReassignment.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() {
            return this.$outer;
        }

        public LogDirReassignment(ReassignPartitionsIntegrationTest $outer, String json, String currentDir, String targetDir) {
            this.json = json;
            this.currentDir = currentDir;
            this.targetDir = targetDir;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReassignPartitionsTestCluster
    implements Closeable {
        private final String zkConnect;
        private final Map<String, String> configOverrides;
        private final Map<Object, Map<String, String>> brokerConfigOverrides;
        private final Map<Object, String> brokers;
        private final Map<String, Seq<Seq<Object>>> topics;
        private final Buffer<Properties> brokerConfigs;
        private ArrayBuffer<KafkaServer> servers;
        private String brokerList;
        private Admin adminClient;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public Map<Object, String> brokers() {
            return this.brokers;
        }

        public Map<String, Seq<Seq<Object>>> topics() {
            return this.topics;
        }

        public Buffer<Properties> brokerConfigs() {
            return this.brokerConfigs;
        }

        public ArrayBuffer<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(ArrayBuffer<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public void brokerList_$eq(String x$1) {
            this.brokerList = x$1;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void setup() {
            this.createServers();
            this.createTopics();
        }

        public void createServers() {
            this.brokers().keySet().foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsTestCluster.$anonfun$createServers$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        }

        public void createTopics() {
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
            this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
            this.adminClient_$eq(Admin.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava())));
            this.adminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.topics().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq parts = (Seq)x0$1._2();
                HashMap partMap = new HashMap();
                ((IterableLike)parts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    Seq part = (Seq)x0$2._1();
                    int index = x0$2._2$mcI$sp();
                    java.util.List list = (java.util.List)partMap.put(Predef$.MODULE$.int2Integer(index), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)part.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.unboxToInt((Object)x$6), Seq$.MODULE$.canBuildFrom())).asJava());
                    return list;
                });
                NewTopic newTopic = new NewTopic(topicName, partMap);
                return newTopic;
            }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava()).all().get();
            this.topics().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$3._1();
                Seq parts = (Seq)x0$3._2();
                Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> map = TestUtils$.MODULE$.waitForAllPartitionsMetadata((Seq<KafkaServer>)this.servers(), topicName, parts.size());
                return map;
            });
        }

        public void produceMessages(String topic, int partition, int numMessages) {
            IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$7 -> ReassignPartitionsTestCluster.$anonfun$produceMessages$1(topic, partition, BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
            TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
        }

        @Override
        public void close() {
            this.brokerList_$eq(null);
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            this.adminClient_$eq(null);
            try {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
            }
            finally {
                this.servers().clear();
            }
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void $anonfun$brokerConfigs$3(Properties config$1, Map overrides) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> config$1.setProperty((String)x$1, (String)x$2);
            Map map = Implicits$.MODULE$.MapExtensionMethods(overrides);
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        }

        public static final /* synthetic */ ArrayBuffer $anonfun$createServers$1(ReassignPartitionsTestCluster $this, int brokerId) {
            return $this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.apply((java.util.Map)$this.brokerConfigs().apply(brokerId)), TestUtils$.MODULE$.createServer$default$2()));
        }

        public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int partition$1, int x$7) {
            return new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer(partition$1), null, (Object)new byte[10000]);
        }

        public ReassignPartitionsTestCluster(ReassignPartitionsIntegrationTest $outer, String zkConnect, Map<String, String> configOverrides, Map<Object, Map<String, String>> brokerConfigOverrides) {
            this.zkConnect = zkConnect;
            this.configOverrides = configOverrides;
            this.brokerConfigOverrides = brokerConfigOverrides;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.brokers = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack1")}));
            this.topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1}))), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 1}))), (List)Nil$.MODULE$))))}));
            this.brokerConfigs = ((TraversableOnce)this.brokers().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var4_23;
                void forKeyValue$extension_f;
                void forKeyValue$extension_$this;
                Properties config;
                int brokerId;
                if (x0$1 != null) {
                    brokerId = x0$1._1$mcI$sp();
                    String rack = (String)x0$1._2();
                    String x$22 = this.zkConnect();
                    Some x$3 = new Some((Object)rack);
                    boolean x$4 = false;
                    int x$5 = 3;
                    boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                    int x$7 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                    Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                    Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                    Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                    boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                    boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                    int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                    boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                    int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                    boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                    int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                    boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
                    int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
                    short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
                    config = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$22, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, (Option<String>)x$3, x$5, x$18, x$19, x$20);
                    config.setProperty(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), "100");
                    config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                    config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> config.setProperty((String)x$1, (String)x$2);
                    Map map = Implicits$.MODULE$.MapExtensionMethods($this.configOverrides);
                    if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
                $this.brokerConfigOverrides.get((Object)BoxesRunTime.boxToInteger((int)brokerId)).foreach((Function1 & Serializable & scala.Serializable)overrides -> {
                    ReassignPartitionsTestCluster.$anonfun$brokerConfigs$3(config, overrides);
                    return BoxedUnit.UNIT;
                });
                return var4_23;
            }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
            this.servers = new ArrayBuffer();
            this.brokerList = null;
            this.adminClient = null;
        }
    }
}

