/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0013y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I\u0011B \t\r1\u0003\u0001\u0015!\u0003A\u0011\u001di\u0005A1A\u0005\u0002}BaA\u0014\u0001!\u0002\u0013\u0001\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u00073\u0002\u0001\u000b\u0011B)\t\u000bi\u0003A\u0011A.\t\u000f!\u0004\u0001\u0019!C\u0005S\"9Q\u0010\u0001a\u0001\n\u0013q\bbBA\u0005\u0001\u0001\u0006KA\u001b\u0005\t\u0003\u0017\u0001\u0001\u0019!C\u0005S\"I\u0011Q\u0002\u0001A\u0002\u0013%\u0011q\u0002\u0005\b\u0003'\u0001\u0001\u0015)\u0003k\u0011!\t)\u0002\u0001a\u0001\n\u0013I\u0007\"CA\f\u0001\u0001\u0007I\u0011BA\r\u0011\u001d\ti\u0002\u0001Q!\n)D\u0001\"a\b\u0001\u0001\u0004%I!\u001b\u0005\n\u0003C\u0001\u0001\u0019!C\u0005\u0003GAq!a\n\u0001A\u0003&!\u000eC\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011\u0011\b\u0001!\u0002\u0013\ti\u0003C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011Q\b\u0001!\u0002\u0013\ti\u0003C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005]\u0003\u0001\"\u0011\u0002B!9\u0011\u0011\r\u0001\u0005\u0002\u0005\u0005\u0003bBA6\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t9\b\u0001C\u0001\u0003\u0003Bq!a\u001f\u0001\t\u0003\t\t\u0005C\u0004\u0002\u0000\u0001!\t!!\u0011\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002B!9\u0011q\u0011\u0001\u0005\u0002\u0005\u0005\u0003bBAF\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u001f\u0003A\u0011AA!\u0011\u001d\t\u0019\n\u0001C\u0001\u0003\u0003Bq!a&\u0001\t\u0003\t\tEA\u000eQe>$WoY3s\r\u0006LG.\u001e:f\u0011\u0006tG\r\\5oOR+7\u000f\u001e\u0006\u0003_A\n1!\u00199j\u0015\u0005\t\u0014!B6bM.\f7\u0001A\n\u0003\u0001Q\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0019\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003sY\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"!\u0010\u0001\u000e\u00039\n!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{KV\t\u0001\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0002J]R\f1\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\u0002\nQc]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7/\u0001\ftKJ4XM]'fgN\fw-Z'bq\nKH/Z:!\u0003u\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D\b+\u0019:uSRLwN\u001c\"zi\u0016\u001c\u0018A\b:fa2L7-\u0019$fi\u000eDW*\u0019=QCJ$\u0018\u000e^5p]\nKH/Z:!\u0003q\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D(+Z:q_:\u001cXMQ=uKN\fQD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f*fgB|gn]3CsR,7\u000fI\u0001\u000b]Vl7+\u001a:wKJ\u001c\u0018a\u00038v[N+'O^3sg\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\fE\u0002^A\nl\u0011A\u0018\u0006\u0003?\n\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\tgLA\u0002TKF\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u0019\u0002\rM,'O^3s\u0013\t9GMA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00039s_\u0012,8-\u001a:2+\u0005Q\u0007\u0003B6vo^l\u0011\u0001\u001c\u0006\u0003[:\f\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0003_B\fqa\u00197jK:$8O\u0003\u00022c*\u0011!o]\u0001\u0007CB\f7\r[3\u000b\u0003Q\f1a\u001c:h\u0013\t1HNA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004\u0003bT\u0018BA=C\u0005\u0015\t%O]1z!\t\t50\u0003\u0002}\u0005\n!!)\u001f;f\u00035\u0001(o\u001c3vG\u0016\u0014\u0018g\u0018\u0013fcR\u0019q0!\u0002\u0011\u0007\u0005\u000b\t!C\u0002\u0002\u0004\t\u0013A!\u00168ji\"A\u0011q\u0001\t\u0002\u0002\u0003\u0007!.A\u0002yIE\n!\u0002\u001d:pIV\u001cWM]\u0019!\u0003%\u0001(o\u001c3vG\u0016\u0014('A\u0007qe>$WoY3se}#S-\u001d\u000b\u0004\u007f\u0006E\u0001\u0002CA\u0004'\u0005\u0005\t\u0019\u00016\u0002\u0015A\u0014x\u000eZ;dKJ\u0014\u0004%A\u0005qe>$WoY3sg\u0005i\u0001O]8ek\u000e,'oM0%KF$2a`A\u000e\u0011!\t9AFA\u0001\u0002\u0004Q\u0017A\u00039s_\u0012,8-\u001a:4A\u0005I\u0001O]8ek\u000e,'\u000fN\u0001\u000eaJ|G-^2feRzF%Z9\u0015\u0007}\f)\u0003\u0003\u0005\u0002\be\t\t\u00111\u0001k\u0003)\u0001(o\u001c3vG\u0016\u0014H\u0007I\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005MR+\u0001\u0003mC:<\u0017\u0002BA\u001c\u0003c\u0011aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005)1/\u001a;VaR\tq\u0010K\u0002 \u0003\u000b\u0002B!a\u0012\u0002T5\u0011\u0011\u0011\n\u0006\u0004_\u0005-#\u0002BA'\u0003\u001f\nqA[;qSR,'OC\u0002\u0002RM\fQA[;oSRLA!!\u0016\u0002J\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3\u0001IA.!\u0011\t9%!\u0018\n\t\u0005}\u0013\u0011\n\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0004^3tiR{w\u000eT1sO\u0016\u0014VmY8sI^KG\u000f[!dWj+'o\u001c\u0015\u0004C\u0005\u0015\u0004\u0003BA$\u0003OJA!!\u001b\u0002J\t!A+Z:u\u0003q!Xm\u001d;U_>d\u0015M]4f%\u0016\u001cwN\u001d3XSRD\u0017iY6P]\u0016D3AIA3\u0003-\u001a\u0007.Z2l)>|G*\u0019:hKJ+7m\u001c:e\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGcA@\u0002t!1\u0011QO\u0012A\u0002\u0001\u000bA\"\\1y\r\u0016$8\r[*ju\u0016\fQ\u0006^3tiB\u000b'\u000f^5uS>tGk\\8MCJ<WMR8s%\u0016\u0004H.[2bi&|gnV5uQ\u0006\u001b7.\u00117mQ\r!\u0013QM\u0001-i\u0016\u001cHOU3ta>t7/\u001a+p_2\u000b'oZ3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2D3!JA3\u0003Q!Xm\u001d;O_:,\u00050[:uK:$Hk\u001c9jG\"\u001aa%!\u001a\u0002'Q,7\u000f^,s_:<'I]8lKJd\u0015n\u001d;)\u0007\u001d\n)'\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0004Q\u0005\u0015\u0014a\u0005;fgR\u001cVM\u001c3BMR,'o\u00117pg\u0016$\u0007fA\u0015\u0002f\u0005iB/Z:u\u0007\u0006tgn\u001c;TK:$Gk\\%oi\u0016\u0014h.\u00197U_BL7\rK\u0002+\u0003K\nQ\u0003^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7\u000fK\u0002,\u0003K\n\u0001\u0006^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u00114uKJ\u0014%o\\6feNCW\u000f\u001e3po:D3\u0001LA3\u0001")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer1;
    private KafkaProducer<byte[], byte[]> producer2;
    private KafkaProducer<byte[], byte[]> producer3;
    private KafkaProducer<byte[], byte[]> producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaProducer<byte[], byte[]> producer1() {
        return this.producer1;
    }

    private void producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer1 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer2() {
        return this.producer2;
    }

    private void producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer2 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer3() {
        return this.producer3;
    }

    private void producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer3 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer4() {
        return this.producer4;
    }

    private void producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        String x$1 = this.brokerList();
        int x$2 = 0;
        int x$3 = 0;
        int x$4 = 30000;
        long x$5 = 10000L;
        long x$6 = this.producerBufferSize();
        int x$7 = TestUtils$.MODULE$.createProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createProducer$default$7();
        int x$9 = TestUtils$.MODULE$.createProducer$default$8();
        String x$10 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$11 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$12 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$13 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer1_$eq(TestUtils$.MODULE$.createProducer(x$1, x$2, x$5, x$6, x$3, x$7, x$8, x$9, x$10, x$4, x$11, x$12, x$13, x$14, x$15, x$16));
        String x$17 = this.brokerList();
        int x$18 = 1;
        int x$19 = 0;
        int x$20 = 30000;
        long x$21 = 10000L;
        long x$22 = this.producerBufferSize();
        int x$23 = TestUtils$.MODULE$.createProducer$default$6();
        int x$24 = TestUtils$.MODULE$.createProducer$default$7();
        int x$25 = TestUtils$.MODULE$.createProducer$default$8();
        String x$26 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$27 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$28 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$29 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$30 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$31 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$32 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer2_$eq(TestUtils$.MODULE$.createProducer(x$17, x$18, x$21, x$22, x$19, x$23, x$24, x$25, x$26, x$20, x$27, x$28, x$29, x$30, x$31, x$32));
        String x$33 = this.brokerList();
        int x$34 = -1;
        int x$35 = 0;
        int x$36 = 30000;
        long x$37 = 10000L;
        long x$38 = this.producerBufferSize();
        int x$39 = TestUtils$.MODULE$.createProducer$default$6();
        int x$40 = TestUtils$.MODULE$.createProducer$default$7();
        int x$41 = TestUtils$.MODULE$.createProducer$default$8();
        String x$42 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$43 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$44 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$45 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$46 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$47 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$48 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer3_$eq(TestUtils$.MODULE$.createProducer(x$33, x$34, x$37, x$38, x$35, x$39, x$40, x$41, x$42, x$36, x$43, x$44, x$45, x$46, x$47, x$48));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer1() != null) {
            this.producer1().close();
        }
        if (this.producer2() != null) {
            this.producer2().close();
        }
        if (this.producer3() != null) {
            this.producer3().close();
        }
        if (this.producer4() != null) {
            this.producer4().close();
        }
        super.tearDown();
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer1().send(record).get();
        Assertions.assertNotNull((Object)recordMetadata);
        Assertions.assertFalse((boolean)recordMetadata.hasOffset());
        Assertions.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assertions.assertThrows(ExecutionException.class, () -> this.producer2().send(record).get());
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.numServers()));
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(maxMessageSize));
        String topic10 = "topic10";
        this.createTopic(topic10, this.servers().size(), this.numServers(), topicConfig);
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer3().send(record).get();
        Assertions.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(ExecutionException.class, () -> this.producer1().send(record).get());
    }

    @Test
    public void testWrongBrokerList() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        this.producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(ExecutionException.class, () -> this.producer4().send(record).get());
    }

    @Test
    public void testInvalidPartition() {
        this.createTopic(this.topic1(), 1, this.numServers(), this.createTopic$default$4());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer1().send(higherRecord).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @Test
    public void testSendAfterClosed() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer1().send(record).get();
        this.producer2().send(record).get();
        this.producer3().send(record).get();
        this.producer1().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer1().send(record));
        this.producer2().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer2().send(record));
        this.producer3().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer3().send(record));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get());
        Assertions.assertTrue((boolean)(thrown.getCause() instanceof InvalidTopicException), (String)new StringBuilder(55).append("Unexpected exception while sending to an invalid topic ").append(thrown.getCause()).toString());
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", Integer.toString(this.numServers() + 1));
        int x$2 = this.numServers();
        int x$4 = this.createTopic$default$2();
        this.createTopic(topicName, x$4, x$2, topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer3().send(record).get());
        Assertions.assertEquals(NotEnoughReplicasException.class, e.getCause().getClass());
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", Integer.toString(this.numServers()));
        int x$2 = this.numServers();
        int x$4 = this.createTopic$default$2();
        this.createTopic(topicName, x$4, x$2, topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer3().send(record).get();
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer3().send(record).get());
        Assertions.assertTrue((e.getCause() instanceof NotEnoughReplicasException || e.getCause() instanceof NotEnoughReplicasAfterAppendException || e.getCause() instanceof TimeoutException ? 1 : 0) != 0);
        ((KafkaServer)this.servers().head()).startup();
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(this.serverMessageMaxBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), Integer.toString(this.replicaFetchMaxPartitionBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), Integer.toString(this.replicaFetchMaxResponseBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        this.producer1 = null;
        this.producer2 = null;
        this.producer3 = null;
        this.producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

