/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogSegments;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001\u0002\u001d:\u0001yBQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004U\u0001\u0001\u0006I!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0001Q\u0011\u00191\u0006\u0001)A\u0005#\"9q\u000b\u0001b\u0001\n\u0003\u0001\u0006B\u0002-\u0001A\u0003%\u0011\u000bC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\ry\u0003\u0001\u0015!\u0003\\\u0011\u001dy\u0006A1A\u0005\u0002\u0001Da!\u001b\u0001!\u0002\u0013\t\u0007b\u00026\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007W\u0002\u0001\u000b\u0011B1\t\u000f1\u0004!\u0019!C\u0001[\"1a\u000f\u0001Q\u0001\n9Dqa\u001e\u0001C\u0002\u0013\u0005\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0001y\u0011\u0019q\b\u0001)A\u0005s\"Aq\u0010\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0002\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%\t!a\u000e\t\u0017\u0005\u0015\u0003\u00011AA\u0002\u0013\u0005\u0011q\t\u0005\f\u0003'\u0002\u0001\u0019!A!B\u0013\tI\u0004C\u0006\u0002V\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0003bCA0\u0001\u0001\u0007\t\u0019!C\u0001\u0003CB1\"!\u001a\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002Z!I\u0011q\r\u0001C\u0002\u0013%\u0011\u0011\u000e\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002l!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAH\u0001\u0011\u0005\u0011q\u000f\u0005\b\u00033\u0003A\u0011AA<\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003oBq!a*\u0001\t\u0003\t9\bC\u0004\u0002,\u0002!\t!a\u001e\t\u000f\u0005=\u0006\u0001\"\u0003\u0002x!9\u0011\u0011\u0017\u0001\u0005\n\u0005]\u0004bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003[\u0004A\u0011BAx\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u00030\u0001!IA!\r\t\u000f\tU\u0003\u0001\"\u0003\u0003X!9!\u0011\r\u0001\u0005\n\t\rdA\u0002B9\u0001\u0011\u0011\u0019\b\u0003\u0006\u0002@5\u0012\t\u0011)A\u0005\u0005kBABa\u001f.\u0005\u0003\u0005\u000b\u0011\u0002B?\u0005\u0007C!B!\".\u0005\u0003\u0005\u000b\u0011\u0002BD\u0011)\u0011i)\fB\u0001B\u0003%!q\u0012\u0005\r\u0005Kk#\u0011!Q\u0001\n\t\u001d&Q\u0016\u0005\u000b36\u0012\t\u0011)A\u00057\n=\u0006B\u0003BZ[\t\u0005\t\u0015!\u0003\u00036\"Aq/\fB\u0001B\u0003%\u0011\u0010\u0003\u0004L[\u0011\u0005!Q\u0018\u0005\b\u0005'lC\u0011\tBk\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dWR+7\u000f\u001e\u0006\u0003um\nqa\u00197vgR,'OC\u0001=\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A F!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0011a)S\u0007\u0002\u000f*\u0011\u0001jO\u0001\u0006kRLGn]\u0005\u0003\u0015\u001e\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001bB\u0011a\nA\u0007\u0002s\u0005\u0011b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:t+\u0005\t\u0006C\u0001!S\u0013\t\u0019\u0016IA\u0002J]R\f1C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\u0002\nAB\\;n!J|G-^2feN\fQB\\;n!J|G-^2feN\u0004\u0013!\u00068v[J+7m\u001c:egB+'\u000f\u0015:pIV\u001cWM]\u0001\u0017]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3sA\u0005AQn\\2l)&lW-F\u0001\\!\t1E,\u0003\u0002^\u000f\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00051A/\u001c9ESJ,\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\f!![8\u000b\u0003\u0019\fAA[1wC&\u0011\u0001n\u0019\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u000bG>t7-\u001e:sK:$(BA:f\u0003\u0011)H/\u001b7\n\u0005U\u0004(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013aD1qa\u0016tGmU3nCBDwN]3\u0016\u0003e\u0004\"a\u001c>\n\u0005m\u0004(!C*f[\u0006\u0004\bn\u001c:f\u0003A\t\u0007\u000f]3oIN+W.\u00199i_J,\u0007%\u0001\ntQJLgn[%teN+W.\u00199i_J,\u0017aE:ie&t7.S:s'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013A\u00044pY2|w/\u001a:Rk\u0016,Xm]\u000b\u0003\u0003\u0007\u0001b!!\u0002\u0002\u0010\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0013%lW.\u001e;bE2,'bAA\u0007\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u0011q\u0001\u0002\u000b\u0013:$W\r_3e'\u0016\f\b#B8\u0002\u0016\u0005e\u0011bAA\fa\n\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\u0011\tY\"a\f\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\taA]3d_J$'\u0002BA\u0012\u0003K\taaY8n[>t'b\u0001\u001f\u0002()!\u0011\u0011FA\u0016\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QF\u0001\u0004_J<\u0017\u0002BA\u0019\u0003;\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\u0018a\u00044pY2|w/\u001a:Rk\u0016,Xm\u001d\u0011\u0002\u00151|w-T1oC\u001e,'/\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@m\n1\u0001\\8h\u0013\u0011\t\u0019%!\u0010\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\t\u0005%\u0013q\n\t\u0004\u0001\u0006-\u0013bAA'\u0003\n!QK\\5u\u0011%\t\tfFA\u0001\u0002\u0004\tI$A\u0002yIE\n1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u00033\u00022ATA.\u0013\r\ti&\u000f\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fH\u0003BA%\u0003GB\u0011\"!\u0015\u001b\u0003\u0003\u0005\r!!\u0017\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005-\u0004\u0003BA7\u0003_j!!!\t\n\t\u0005E\u0014\u0011\u0005\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0003HCAA%Q\rq\u00121\u0010\t\u0005\u0003{\nY)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000b\u000b9)A\u0004kkBLG/\u001a:\u000b\t\u0005%\u00151F\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u001b\u000byH\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004?\u0005M\u0005\u0003BA?\u0003+KA!a&\u0002\u0000\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001%i\u0016\u001cHOT8M_\u000e\\7i\u001c8uK:$\u0018n\u001c8XSRDw.\u001e;JgJ,\u0006\u000fZ1uK\"\u001a\u0001%!(\u0011\t\u0005u\u0014qT\u0005\u0005\u0003C\u000byH\u0001\u0003UKN$\u0018\u0001\u000e;fgR\f\u0005\u000f]3oIJ+\u0007\u000f\\5dC\u001a+Go\u00195XSRD7k\u00195fIVdWM]\"iK\u000e\\gi\u001c:TQJLgn[%te\"\u001a\u0011%!(\u0002GQ,7\u000f^!qa\u0016tGMU3qY&\u001c\u0017MR3uG\"<\u0016\u000e\u001e5Va\u0012\fG/Z%te\"\u001a!%!(\u0002QQ,7\u000f^$fiJ+\u0007\u000f\\5dC^KG\u000f[+qI\u0006$X-Q:tS\u001etW.\u001a8u\u0003:$\u0017j\u001d:)\u0007\r\ni*\u0001\u0014d_:\u001cWO\u001d:f]R\u0004&o\u001c3vG\u00164U\r^2i/&$\bNU3bI2{7m[(oYf\f1eY8oGV\u0014(/\u001a8u!J|G-^2f\r\u0016$8\r[,ji\"<&/\u001b;f\u0019>\u001c7.A\btG\",G-\u001e7f\u0003B\u0004XM\u001c3t)\t\t9\f\u0005\u0004\u0002:\u0006%\u0017q\u001a\b\u0005\u0003w\u000b)M\u0004\u0003\u0002>\u0006\rWBAA`\u0015\r\t\t-P\u0001\u0007yI|w\u000e\u001e \n\u0003\tK1!a2B\u0003\u001d\u0001\u0018mY6bO\u0016LA!a3\u0002N\n\u00191+Z9\u000b\u0007\u0005\u001d\u0017\t\r\u0003\u0002R\u0006m\u0007#B8\u0002T\u0006]\u0017bAAka\n1a)\u001e;ve\u0016\u0004B!!7\u0002\\2\u0001AaCAoM\u0005\u0005\t\u0011!B\u0001\u0003?\u00141a\u0018\u00132#\u0011\t\t/a:\u0011\u0007\u0001\u000b\u0019/C\u0002\u0002f\u0006\u0013qAT8uQ&tw\rE\u0002A\u0003SL1!a;B\u0005\r\te._\u0001\u0018g\u000eDW\rZ;mKV\u0003H-\u0019;f\r>dGn\\<feN$B!!=\u0002~B1\u0011\u0011XAe\u0003g\u0004D!!>\u0002zB)q.a5\u0002xB!\u0011\u0011\\A}\t-\tYpJA\u0001\u0002\u0003\u0015\t!a8\u0003\u0007}##\u0007\u0003\u0004\u0002\u0000\u001e\u0002\r!U\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018!E:dQ\u0016$W\u000f\\3TQJLgn[%teR1!Q\u0001B\b\u0005?\u0001DAa\u0002\u0003\fA)q.a5\u0003\nA!\u0011\u0011\u001cB\u0006\t-\u0011i\u0001KA\u0001\u0002\u0003\u0015\t!a8\u0003\u0007}#3\u0007C\u0004\u0003\u0012!\u0002\rAa\u0005\u0002\u0015\u0005\u001cG/\u001b<f\r2\fw\r\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\r\u0011I\u0002]\u0001\u0007CR|W.[2\n\t\tu!q\u0003\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u000f\t\u0005\u0002\u00061\u0001\u0003$\u0005yQn\\2l)&lWm\u00157fKBl5\u000fE\u0002A\u0005KI1Aa\nB\u0005\u0011auN\\4\u0002/M,G/\u001e9QCJ$\u0018\u000e^5p]^KG\u000f['pG.\u001cH\u0003BA-\u0005[Aq!!\u000e*\u0001\u0004\tI$A\nde\u0016\fG/\u001a'pOB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u00034\tm\u0002\u0003\u0002B\u001b\u0005oi\u0011A]\u0005\u0004\u0005s\u0011(A\u0003)s_B,'\u000f^5fg\"9!Q\b\u0016A\u0002\t}\u0012!C8wKJ\u0014\u0018\u000eZ3t!!\u0011\tE!\u0013\u0003P\t=c\u0002\u0002B\"\u0005\u000b\u00022!!0B\u0013\r\u00119%Q\u0001\u0007!J,G-\u001a4\n\t\t-#Q\n\u0002\u0004\u001b\u0006\u0004(b\u0001B$\u0003B!!\u0011\tB)\u0013\u0011\u0011\u0019F!\u0014\u0003\rM#(/\u001b8h\u0003\u0019\t\u0007\u000f]3oIRA\u0011\u0011\nB-\u00057\u0012i\u0006C\u0004\u0002V-\u0002\r!!\u0017\t\r\u0005}8\u00061\u0001R\u0011\u0019y8\u00061\u0001\u0003`A1\u0011\u0011XAe\u0003'\t\u0001$\u001e9eCR,gi\u001c7m_^,'OR3uG\"\u001cF/\u0019;f))\tIE!\u001a\u0003h\t-$Q\u000e\u0005\b\u0003+b\u0003\u0019AA-\u0011\u0019\u0011I\u0007\fa\u0001#\u0006Qam\u001c7m_^,'/\u00133\t\r\u0005}H\u00061\u0001R\u0011\u001d\u0011y\u0007\fa\u0001\u0003'\tQBZ8mY><XM])vKV,'aB*m_^dunZ\n\u0004[\tU\u0004\u0003BA\u001e\u0005oJAA!\u001f\u0002>\t\u0019Aj\\4\u0002\u0011M,w-\\3oiN\u0004B!a\u000f\u0003\u0000%!!\u0011QA\u001f\u0005-aunZ*fO6,g\u000e^:\n\t\tm$qO\u0001\b_\u001a47/\u001a;t!\u0011\tYD!#\n\t\t-\u0015Q\b\u0002\u0011\u0019>\fG-\u001a3M_\u001e|eMZ:fiN\f\u0001\u0003\\3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3\u0011\u000b\u0001\u0013\tJ!&\n\u0007\tM\u0015I\u0001\u0004PaRLwN\u001c\t\u0005\u0005/\u0013\t+\u0004\u0002\u0003\u001a*!!1\u0014BO\u0003\u0015)\u0007o\\2i\u0015\r\u0011yjO\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t\r&\u0011\u0014\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3\u0002)A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s!\u0011\tYD!+\n\t\t-\u0016Q\b\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\n\t\t\u0015&qO\u0005\u0005\u0005c\u00139(\u0001\u0003uS6,\u0017\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0005\u0003\u00038\neVB\u0001BO\u0013\u0011\u0011YL!(\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m)I\u0011yLa1\u0003F\n\u001d'\u0011\u001aBf\u0005\u001b\u0014yM!5\u0011\u0007\t\u0005W&D\u0001\u0001\u0011\u001d\tyD\u000ea\u0001\u0005kBqAa\u001f7\u0001\u0004\u0011i\bC\u0004\u0003\u0006Z\u0002\rAa\"\t\u000f\t5e\u00071\u0001\u0003\u0010\"9!Q\u0015\u001cA\u0002\t\u001d\u0006\"B-7\u0001\u0004Y\u0006b\u0002BZm\u0001\u0007!Q\u0017\u0005\u0006oZ\u0002\r!_\u0001\u000fCB\u0004XM\u001c3Bg2+\u0017\rZ3s)1\u00119N!8\u0003b\n\u0015(q\u001eB\u007f!\u0011\tYD!7\n\t\tm\u0017Q\b\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\t}w\u00071\u0001\u0002\u001a\u00059!/Z2pe\u0012\u001c\bB\u0002Bro\u0001\u0007\u0011+A\u0006mK\u0006$WM]#q_\u000eD\u0007\"\u0003BtoA\u0005\t\u0019\u0001Bu\u0003\u0019y'/[4j]B!\u00111\bBv\u0013\u0011\u0011i/!\u0010\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\t\u0013\tEx\u0007%AA\u0002\tM\u0018AG5oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>t\u0007\u0003\u0002B{\u0005sl!Aa>\u000b\u0007\u0005\u00055(\u0003\u0003\u0003|\n](AC!qSZ+'o]5p]\"I!q`\u001c\u0011\u0002\u0003\u00071\u0011A\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u0005\u0005o\u001b\u0019!\u0003\u0003\u0004\u0006\tu%\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0007")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime;
    private final File tmpDir;
    private final File logDir;
    private final ExecutorService executorService;
    private final Semaphore appendSemaphore;
    private final Semaphore shrinkIsrSemaphore;
    private final IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues;
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues() {
        return this.followerQueues;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, configRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.mockTime(), TestUtils$.MODULE$.createLogManager$default$6()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints, (Option)None$.MODULE$);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleUpdateFollowers(1).foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
    }

    private Seq<Future<?>> scheduleAppends() {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable & scala.Serializable)x$9 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Future<?>> scheduleUpdateFollowers(int numRecords) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)index -> PartitionLockTest.$anonfun$scheduleUpdateFollowers$1(this, numRecords, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public void shrinkIsr(scala.collection.immutable.Set<Object> newIsr) {
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    super.shrinkIsr(newIsr);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
            }

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxProducerIdExpirationMs = 3600000;
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxProducerIdExpirationMs, ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
                LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), logDirFailureChannel, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
                return new SlowLog(this.$outer, log, segments, offsets, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.$outer.mockTime(), logDirFailureChannel, this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), brokerId$1, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1);
            }
        };
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)alterIsrManager.submit((AlterIsrItem)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords, Seq<ArrayBlockingQueue<MemoryRecords>> followerQueues) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> {
            MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
            partition.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
            followerQueues.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.put(batch);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void updateFollowerFetchState(Partition partition, int followerId, int numRecords, ArrayBlockingQueue<MemoryRecords> followerQueue) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            MemoryRecords batch = (MemoryRecords)followerQueue.poll(15L, TimeUnit.SECONDS);
            if (batch == null) {
                throw new RuntimeException(new StringBuilder(33).append("Timed out waiting for next batch ").append(i).toString());
            }
            List batches = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(batch.batches().iterator()).asScala()).toList();
            Assertions.assertEquals((int)1, (int)batches.size());
            MutableRecordBatch recordBatch = (MutableRecordBatch)batches.head();
            return partition.updateFollowerFetchState(followerId, new LogOffsetMetadata(recordBatch.lastOffset() + 1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.mockTime().milliseconds(), partition.localLogOrException().logEndOffset());
        });
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1(int x$1) {
        return new ArrayBlockingQueue(2);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$9) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer(), (Seq<ArrayBlockingQueue<MemoryRecords>>)$this.followerQueues());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1(PartitionLockTest $this, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.updateFollowerFetchState($this.partition(), index, numRecords$1, (ArrayBlockingQueue)$this.followerQueues().apply(index - 1));
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public PartitionLockTest() {
        Logging.$init$((Logging)this);
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
        this.mockTime = new MockTime();
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
        this.appendSemaphore = new Semaphore(0);
        this.shrinkIsrSemaphore = new Semaphore(0);
        this.followerQueues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionLockTest.$anonfun$followerQueues$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    }

    private class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion, RequestLocal requestLocal) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion, requestLocal);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, Log log, LogSegments segments, LoadedLogOffsets offsets, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, MockTime mockTime, LogDirFailureChannel logDirFailureChannel, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), segments, offsets.logStartOffset(), offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), (Time)mockTime, log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), leaderEpochCache, producerStateManager, logDirFailureChannel, (Option)None$.MODULE$, true);
        }
    }
}

