/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000194AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003!\u0003BB\u0017\u0001A\u0003%Q\u0005C\u0004/\u0001\t\u0007I\u0011\u0001\u0013\t\r=\u0002\u0001\u0015!\u0003&\u0011\u001d\u0001\u0004A1A\u0005\u0002EBa\u0001\u000f\u0001!\u0002\u0013\u0011\u0004bB\u001d\u0001\u0005\u0004%\tA\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001e\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0005\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0001K\u0011%\u0001\u0006\u00011A\u0001B\u0003&A\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003a\u0001\u0011\u0005!\u000bC\u0003f\u0001\u0011\u0005!\u000bC\u0003k\u0001\u0011\u0005!\u000bC\u0003m\u0001\u0011\u0005!KA\u0006SKBd\u0017nY1UKN$(B\u0001\u000b\u0016\u0003\u001d\u0019G.^:uKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003M\ta\u0001^7q\t&\u0014X#A\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AA5p\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kU\tQ!\u001e;jYNL!a\u000e\u001b\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\u000b\u0002\rM,'O^3s\u0013\t\u0001UH\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\u0002\u00071|w-F\u0001E!\t)u)D\u0001G\u0015\t\u0011U#\u0003\u0002I\r\n\u0019Aj\\4\u0002\u000f1|wm\u0018\u0013fcR\u00111J\u0014\t\u000351K!!T\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f.\t\t\u00111\u0001E\u0003\rAH%M\u0001\u0005Y><\u0007%A\u0003tKR,\b\u000fF\u0001LQ\tiA\u000b\u0005\u0002V=6\taK\u0003\u0002X1\u0006\u0019\u0011\r]5\u000b\u0005eS\u0016a\u00026va&$XM\u001d\u0006\u00037r\u000bQA[;oSRT\u0011!X\u0001\u0004_J<\u0017BA0W\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012aB\u0019\t\u0003+\u000eL!\u0001\u001a,\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\r;fgR\u001cVmZ7f]R$U\r\\3uS>tw+\u001b;i\u0011&<\u0007nV1uKJl\u0017M]6J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8)\u0005=9\u0007CA+i\u0013\tIgK\u0001\u0003UKN$\u0018A\f;fgR\u001c\u0015M\u001c8pi\u0012+G.\u001a;f'\u0016<W.\u001a8ug\u0006#xJ]!c_Z,\u0007*[4i/\u0006$XM]7be.D#\u0001E4\u0002eQ,7\u000f^\"b]:|G/\u00138de\u0016lWM\u001c;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;QCN$\b*[4i/\u0006$XM]7be.D#!E4")
public class ReplicaTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$1 = this.logDir();
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        MockTime x$7 = this.time();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        None$ x$11 = None$.MODULE$;
        boolean x$12 = true;
        boolean x$13 = Log$.MODULE$.apply$default$11();
        this.log_$eq(Log$.MODULE$.apply(x$1, config, x$3, x$4, (Scheduler)x$5, x$6, (Time)x$7, x$8, x$9, x$10, x$13, (Option)x$11, x$12));
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testSegmentDeletionWithHighWatermarkInitialization() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaTest.$anonfun$testSegmentDeletionWithHighWatermarkInitialization$1(this, expiredTimestamp, BoxesRunTime.unboxToInt((Object)i)));
        long initialHighWatermark = this.log().updateHighWatermark(25L);
        Assertions.assertEquals((long)25L, (long)initialHighWatermark);
        int initialNumSegments = this.log().numberOfSegments();
        this.log().deleteOldSegments();
        Assertions.assertTrue((this.log().numberOfSegments() < initialNumSegments ? 1 : 0) != 0);
        Assertions.assertTrue((this.log().logStartOffset() <= initialHighWatermark ? 1 : 0) != 0);
    }

    @Test
    public void testCannotDeleteSegmentsAtOrAboveHighWatermark() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1(this, expiredTimestamp, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertTrue((this.log().numberOfSegments() > 5 ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)this.log().highWatermark());
        Assertions.assertEquals((long)0L, (long)this.log().logStartOffset());
        Assertions.assertEquals((long)100L, (long)this.log().logEndOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)hw -> {
            this.log().updateHighWatermark((long)hw);
            Assertions.assertEquals((long)hw, (long)this.log().highWatermark());
            this.log().deleteOldSegments();
            Assertions.assertTrue((this.log().logStartOffset() <= (long)hw ? 1 : 0) != 0);
            this.log().logSegments().headOption().foreach((Function1 & Serializable & scala.Serializable)segment -> {
                ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3(this, hw, segment);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)this.log().logSegments().tail()).foreach((Function1 & Serializable & scala.Serializable)segment -> {
                ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$4(this, hw, segment);
                return BoxedUnit.UNIT;
            });
        });
        Assertions.assertEquals((long)100L, (long)this.log().logStartOffset());
        Assertions.assertEquals((int)1, (int)this.log().numberOfSegments());
        Assertions.assertEquals((int)0, (int)this.log().activeSegment().size());
    }

    @Test
    public void testCannotIncrementLogStartOffsetPastHighWatermark() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaTest.$anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1(this, BoxesRunTime.unboxToInt((Object)i)));
        this.log().updateHighWatermark(25L);
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.log().maybeIncrementLogStartOffset(26L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testSegmentDeletionWithHighWatermarkInitialization$1(ReplicaTest $this, long expiredTimestamp$1, int i) {
        byte[] x$1 = new StringBuilder(4).append("test").append(i).toString().getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, expiredTimestamp$1, x$5);
        Log qual$1 = $this.log();
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        RequestLocal x$10 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(records, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1(ReplicaTest $this, long expiredTimestamp$2, int i) {
        byte[] x$1 = new StringBuilder(4).append("test").append(i).toString().getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, expiredTimestamp$2, x$5);
        Log qual$1 = $this.log();
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        RequestLocal x$10 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(records, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3(ReplicaTest $this, int hw$1, LogSegment segment) {
        Assertions.assertTrue((segment.baseOffset() <= (long)hw$1 ? 1 : 0) != 0);
        Assertions.assertTrue((segment.baseOffset() >= $this.log().logStartOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$4(ReplicaTest $this, int hw$1, LogSegment segment) {
        Assertions.assertTrue((segment.baseOffset() > (long)hw$1 ? 1 : 0) != 0);
        Assertions.assertTrue((segment.baseOffset() >= $this.log().logStartOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1(ReplicaTest $this, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringBuilder(4).append("test").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log qual$1 = $this.log();
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(records, x$2, x$3, x$4, x$5);
    }
}

