/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.io.Serializable;
import java.util.ArrayList;
import kafka.common.InterBrokerSendThread;
import kafka.common.InterBrokerSendThread$;
import kafka.common.InterBrokerSendThreadTest$TestInterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.utils.MockTime;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004C\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0011\u0019\u0001\u0006\u0001)A\u0005\u000b\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006B\u0002?\u0001A\u0003%1\u000bC\u0004~\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001)A\u0005\u007f\u001a1\u0011q\u0001\u0001\u0001\u0003\u0013A\u0001b\u0011\u0006\u0003\u0002\u0003\u0006I!\u0012\u0005\u000b\u0003#Q!\u0011!Q\u0001\n\u0005M\u0001B\u0002\u001c\u000b\t\u0003\t\t\u0004C\u0005\u0002:)\u0011\r\u0011\"\u0003\u0002<!A\u00111\u000b\u0006!\u0002\u0013\ti\u0004C\u0004\u0002V)!\t!a\u0016\t\u000f\u0005u#\u0002\"\u0011\u0002`!9\u0011q\r\u0006\u0005B\u0005%t!CA;\u0001\u0005\u0005\t\u0012AA<\r%\t9\u0001AA\u0001\u0012\u0003\tI\b\u0003\u00047)\u0011\u0005\u00111\u0010\u0005\n\u0003{\"\u0012\u0013!C\u0001\u0003\u007fB\u0011\"!&\u0015#\u0003%\t!a&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u0017\u0001\u0005\u0002\u0005u\u0005bBA]\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003{\u0003A\u0011AAO\u0011\u001d\t\t\r\u0001C\u0001\u0003;3a!!2\u0001\t\u0005\u001d\u0007B\u0002\u001c\u001e\t\u0003\t)\u000fC\u0004\u0002jv!\t%a;\u0007\tU\u0003AA\u0016\u0005\u0006m\u0001\"\tA\u0019\u0005\bG\u0002\u0002\r\u0011\"\u0001e\u0011\u001dA\u0007\u00051A\u0005\u0002%Daa\u001c\u0011!B\u0013)\u0007\"\u00039!\u0001\u0004\u0005\r\u0011\"\u0001r\u0011%)\b\u00051AA\u0002\u0013\u0005a\u000fC\u0005yA\u0001\u0007\t\u0011)Q\u0005e\")\u0011\u0010\tC!u\nI\u0012J\u001c;fe\n\u0013xn[3s'\u0016tG\r\u00165sK\u0006$G+Z:u\u0015\tYC&\u0001\u0004d_6lwN\u001c\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000f\t\u0003s\u0001i\u0011AK\u0001\u0005i&lW-F\u0001=!\ti\u0004)D\u0001?\u0015\tyD&A\u0003vi&d7/\u0003\u0002B}\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0007oKR<xN]6DY&,g\u000e^\u000b\u0002\u000bB\u0011aIT\u0007\u0002\u000f*\u0011\u0001*S\u0001\bG2LWM\u001c;t\u0015\ti#J\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<\u0017BA(H\u00055qU\r^<pe.\u001cE.[3oi\u0006qa.\u001a;x_J\\7\t\\5f]R\u0004\u0013!E2p[BdW\r^5p]\"\u000bg\u000e\u001a7feV\t1\u000b\u0005\u0002UA5\t\u0001AA\u000bTiV\u00147i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0014\u0007\u0001:v\f\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!A.\u00198h\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\r=\u0013'.Z2u!\t1\u0005-\u0003\u0002b\u000f\nA\"+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0015\u0003M\u000b\u0001%\u001a=fGV$X\rZ,ji\"$\u0015n]2p]:,7\r^3e%\u0016\u001c\bo\u001c8tKV\tQ\r\u0005\u00022M&\u0011qM\r\u0002\b\u0005>|G.Z1o\u0003\u0011*\u00070Z2vi\u0016$w+\u001b;i\t&\u001c8m\u001c8oK\u000e$X\r\u001a*fgB|gn]3`I\u0015\fHC\u00016n!\t\t4.\u0003\u0002me\t!QK\\5u\u0011\u001dq7%!AA\u0002\u0015\f1\u0001\u001f\u00132\u0003\u0005*\u00070Z2vi\u0016$w+\u001b;i\t&\u001c8m\u001c8oK\u000e$X\r\u001a*fgB|gn]3!\u0003!\u0011Xm\u001d9p]N,W#\u0001:\u0011\u0005\u0019\u001b\u0018B\u0001;H\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\fAB]3ta>t7/Z0%KF$\"A[<\t\u000f94\u0013\u0011!a\u0001e\u0006I!/Z:q_:\u001cX\rI\u0001\u000b_:\u001cu.\u001c9mKR,GC\u00016|\u0011\u0015\u0001\b\u00061\u0001s\u0003I\u0019w.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u0011\u0002!I,\u0017/^3tiRKW.Z8vi6\u001bX#A@\u0011\u0007E\n\t!C\u0002\u0002\u0004I\u00121!\u00138u\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000f\t\u0002\u001a)\u0016\u001cH/\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fGmE\u0002\u000b\u0003\u0017\u00012!OA\u0007\u0013\r\tyA\u000b\u0002\u0016\u0013:$XM\u001d\"s_.,'oU3oIRC'/Z1e\u0003E)\u0007pY3qi&|gnQ1mY\n\f7m\u001b\t\u0007c\u0005U\u0011\u0011\u00046\n\u0007\u0005]!GA\u0005Gk:\u001cG/[8ocA!\u00111DA\u0016\u001d\u0011\ti\"a\n\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t/\u0003\u0019a$o\\8u}%\t1'C\u0002\u0002*I\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002.\u0005=\"!\u0003+ie><\u0018M\u00197f\u0015\r\tIC\r\u000b\u0007\u0003g\t)$a\u000e\u0011\u0005QS\u0001bB\"\u000e!\u0003\u0005\r!\u0012\u0005\n\u0003#i\u0001\u0013!a\u0001\u0003'\tQ!];fk\u0016,\"!!\u0010\u0011\r\u0005}\u0012\u0011JA'\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000f\u0012\u0014AC2pY2,7\r^5p]&!\u00111JA!\u0005\u0015\tV/Z;f!\rI\u0014qJ\u0005\u0004\u0003#R#a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/\u0001\u0004rk\u0016,X\rI\u0001\bK:\fX/Z;f)\rQ\u0017\u0011\f\u0005\b\u00037\u0002\u0002\u0019AA'\u0003\u001d\u0011X-];fgR\f\u0001cZ3oKJ\fG/\u001a*fcV,7\u000f^:\u0015\u0005\u0005\u0005\u0004CBA\u000e\u0003G\ni%\u0003\u0003\u0002f\u0005=\"\u0001C%uKJ\f'\r\\3\u0002\u0011A|G\u000e\\(oG\u0016$2A[A6\u0011\u001d\tiG\u0005a\u0001\u0003_\nA\"\\1y)&lWm\\;u\u001bN\u00042!MA9\u0013\r\t\u0019H\r\u0002\u0005\u0019>tw-A\rUKN$\u0018J\u001c;fe\n\u0013xn[3s'\u0016tG\r\u00165sK\u0006$\u0007C\u0001+\u0015'\t!\u0002\u0007\u0006\u0002\u0002x\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!!+\u0007\u0015\u000b\u0019i\u000b\u0002\u0002\u0006B!\u0011qQAI\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015!C;oG\",7m[3e\u0015\r\tyIM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAJ\u0003\u0013\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0014\u0016\u0005\u0003'\t\u0019)A\u0013tQV$Hm\\<o)\"\u0014X-\u00193TQ>,H\u000e\u001a(pi\u000e\u000bWo]3Fq\u000e,\u0007\u000f^5p]R\t!\u000eK\u0002\u0019\u0003C\u0003B!a)\u000226\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+A\u0002ba&TA!a+\u0002.\u00069!.\u001e9ji\u0016\u0014(bAAX\u0019\u0006)!.\u001e8ji&!\u00111WAS\u0005\u0011!Vm\u001d;\u0002GMDw.\u001e7e\u001d>$8+\u001a8e\u0003:LH\u000f[5oO^CWM\u001c(p%\u0016\fX/Z:ug\"\u001a\u0011$!)\u0002_MDw.\u001e7e\u0007J,\u0017\r^3DY&,g\u000e\u001e*fcV,7\u000f^!oIN+g\u000eZ,iK:tu\u000eZ3JgJ+\u0017\rZ=)\u0007i\t\t+A\"tQ>,H\u000eZ\"bY2\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM],ji\"$\u0015n]2p]:,7\r^3e%\u0016\u001c\bo\u001c8tK^CWM\u001c(pI\u0016tu\u000e\u001e*fC\u0012L\bfA\u000e\u0002\"\u0006QB/Z:u\r\u0006LG.\u001b8h\u000bb\u0004\u0018N]3e%\u0016\fX/Z:ug\"\u001aA$!)\u0003%M#XO\u0019*fcV,7\u000f\u001e\"vS2$WM]\n\u0004;\u0005%\u0007CBAf\u00033\fyN\u0004\u0003\u0002N\u0006UWBAAh\u0015\u0011\t\t.a5\u0002\u0011I,\u0017/^3tiNT!aK%\n\t\u0005]\u0017qZ\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!\u00111\\Ao\u0005\u001d\u0011U/\u001b7eKJTA!a6\u0002PB\u0019\u0011'!9\n\u0007\u0005\r(GA\u0004O_RD\u0017N\\4\u0015\u0005\u0005\u001d\bC\u0001+\u001e\u0003\u0015\u0011W/\u001b7e)\u0011\ty.!<\t\u000f\u0005=x\u00041\u0001\u0002r\u00069a/\u001a:tS>t\u0007cA\u0019\u0002t&\u0019\u0011Q\u001f\u001a\u0003\u000bMCwN\u001d;")
public class InterBrokerSendThreadTest {
    private volatile InterBrokerSendThreadTest$TestInterBrokerSendThread$ TestInterBrokerSendThread$module;
    private final MockTime kafka$common$InterBrokerSendThreadTest$$time = new MockTime();
    private final NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient = (NetworkClient)EasyMock.createMock(NetworkClient.class);
    private final StubCompletionHandler completionHandler = new StubCompletionHandler();
    private final int kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs;

    public InterBrokerSendThreadTest$TestInterBrokerSendThread$ TestInterBrokerSendThread() {
        if (this.TestInterBrokerSendThread$module == null) {
            this.TestInterBrokerSendThread$lzycompute$1();
        }
        return this.TestInterBrokerSendThread$module;
    }

    public MockTime kafka$common$InterBrokerSendThreadTest$$time() {
        return this.kafka$common$InterBrokerSendThreadTest$$time;
    }

    public NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient() {
        return this.kafka$common$InterBrokerSendThreadTest$$networkClient;
    }

    private StubCompletionHandler completionHandler() {
        return this.completionHandler;
    }

    public int kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs() {
        return this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs;
    }

    @Test
    public void shutdownThreadShouldNotCauseException() {
        NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
        Mockito.when((Object)networkClient.poll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenThrow(new Throwable[]{new DisconnectException()});
        ObjectRef exception = ObjectRef.create(null);
        TestInterBrokerSendThread thread = new TestInterBrokerSendThread(this, networkClient, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            exception.elem = e;
            return BoxedUnit.UNIT;
        });
        thread.shutdown();
        thread.pollOnce(100L);
        Assertions.assertNull((Object)((Throwable)exception.elem));
    }

    @Test
    public void shouldNotSendAnythingWhenNoRequests() {
        TestInterBrokerSendThread sendThread = new TestInterBrokerSendThread(this, this.TestInterBrokerSendThread().$lessinit$greater$default$1(), this.TestInterBrokerSendThread().$lessinit$greater$default$2());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assertions.assertFalse((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void shouldCreateClientRequestAndSendWhenNodeIsReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds(), node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        TestInterBrokerSendThread sendThread = new TestInterBrokerSendThread(this, this.TestInterBrokerSendThread().$lessinit$greater$default$1(), this.TestInterBrokerSendThread().$lessinit$greater$default$2());
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.kafka$common$InterBrokerSendThreadTest$$networkClient().send(clientRequest, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.enqueue(handler);
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assertions.assertFalse((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void shouldCallCompletionHandlerWithDisconnectedResponseWhenNodeNotReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds(), node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        TestInterBrokerSendThread sendThread = new TestInterBrokerSendThread(this, this.TestInterBrokerSendThread().$lessinit$greater$default$1(), this.TestInterBrokerSendThread().$lessinit$greater$default$2());
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionFailed(node))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().authenticationException(node)).andReturn((Object)new AuthenticationException(""));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.enqueue(handler);
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assertions.assertTrue((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void testFailingExpiredRequests() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds(), node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        TestInterBrokerSendThread sendThread = new TestInterBrokerSendThread(this, this.TestInterBrokerSendThread().$lessinit$greater$default$1(), this.TestInterBrokerSendThread().$lessinit$greater$default$2());
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds(), true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        this.kafka$common$InterBrokerSendThreadTest$$time().sleep(1500L);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.eq((long)handler.creationTimeMs()), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionFailed(node))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.enqueue(handler);
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assertions.assertFalse((boolean)sendThread.hasUnsentRequests());
        Assertions.assertTrue((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    private final void TestInterBrokerSendThread$lzycompute$1() {
        synchronized (this) {
            if (this.TestInterBrokerSendThread$module == null) {
                this.TestInterBrokerSendThread$module = new InterBrokerSendThreadTest$TestInterBrokerSendThread$(this);
            }
            return;
        }
    }

    public InterBrokerSendThreadTest() {
        this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs = 1000;
    }

    private class StubCompletionHandler
    implements RequestCompletionHandler {
        private boolean executedWithDisconnectedResponse;
        private ClientResponse response;

        public boolean executedWithDisconnectedResponse() {
            return this.executedWithDisconnectedResponse;
        }

        public void executedWithDisconnectedResponse_$eq(boolean x$1) {
            this.executedWithDisconnectedResponse = x$1;
        }

        public ClientResponse response() {
            return this.response;
        }

        public void response_$eq(ClientResponse x$1) {
            this.response = x$1;
        }

        public void onComplete(ClientResponse response) {
            this.executedWithDisconnectedResponse_$eq(response.wasDisconnected());
            this.response_$eq(response);
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubCompletionHandler$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubCompletionHandler() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            this.executedWithDisconnectedResponse = false;
        }
    }

    private class StubRequestBuilder
    extends AbstractRequest.Builder<Nothing$> {
        public Nothing$ build(short version) {
            return Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubRequestBuilder$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubRequestBuilder() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            super(ApiKeys.END_TXN);
        }
    }

    public class TestInterBrokerSendThread
    extends InterBrokerSendThread {
        private final Function1<Throwable, BoxedUnit> exceptionCallback;
        private final Queue<RequestAndCompletionHandler> queue;
        public final /* synthetic */ InterBrokerSendThreadTest $outer;

        private Queue<RequestAndCompletionHandler> queue() {
            return this.queue;
        }

        public void enqueue(RequestAndCompletionHandler request) {
            this.queue().$plus$eq((Object)request);
        }

        public Iterable<RequestAndCompletionHandler> generateRequests() {
            if (this.queue().isEmpty()) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some(this.queue().dequeue()));
        }

        public void pollOnce(long maxTimeoutMs) {
            try {
                super.pollOnce(maxTimeoutMs);
                return;
            }
            catch (Throwable e) {
                this.exceptionCallback.apply((Object)e);
                return;
            }
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$TestInterBrokerSendThread$$$outer() {
            return this.$outer;
        }

        public TestInterBrokerSendThread(InterBrokerSendThreadTest $outer, NetworkClient networkClient, Function1<Throwable, BoxedUnit> exceptionCallback) {
            this.exceptionCallback = exceptionCallback;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("name", (KafkaClient)networkClient, $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), InterBrokerSendThread$.MODULE$.$lessinit$greater$default$5());
            this.queue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

