/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\t\u0013\u0001]AQA\t\u0001\u0005\u0002\rBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u00045\u0001\u0001\u0006Ia\n\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019i\u0004\u0001)A\u0005o!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0003L\u0001\u0011\u0005A\nC\u0003\\\u0001\u0011\u0005A\nC\u0003s\u0001\u0011%1\u000f\u0003\u0004s\u0001\u0011%\u0011Q\u0006\u0005\u0007e\u0002!I!!\u0015\t\r\u0005\u0005\u0004\u0001\"\u0001M\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!!#\u0001\t\u0013\tY\t\u0003\u0004\u00022\u0002!\t\u0001\u0014\u0002\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005\u0019An\\4\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012aB7fiJL7m]\u0005\u0003Cy\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002\u001a\u0001\u0005)1m\u001c3fGV\tq\u0005\u0005\u0002)e5\t\u0011F\u0003\u0002+W\u00051!/Z2pe\u0012T!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t)bF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a*\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017AB2pI\u0016\u001c\u0007%\u0001\u0003uS6,W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0012!B;uS2\u001c\u0018B\u0001\u001f:\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0001\u00032!\u0011#G\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%!B!se\u0006L\bCA$I\u001b\u0005Y\u0013BA%,\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000f\rdW-\u00198vaR\tQ\n\u0005\u0002B\u001d&\u0011qJ\u0011\u0002\u0005+:LG\u000f\u000b\u0002\t#B\u0011!+W\u0007\u0002'*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003\u001dQW\u000f]5uKJT!\u0001\u0017\u0019\u0002\u000b),h.\u001b;\n\u0005i\u001b&!C!gi\u0016\u0014X)Y2i\u0003i\"Xm\u001d;NCJ\\7\u000fU1si&$\u0018n\u001c8t\u0003N|eM\u001a7j]\u0016\fe\u000e\u001a)paVd\u0017\r^3t+:\u001cG.Z1oC\ndW-T3ue&\u001c7\u000f\u000b\u0002\n;B\u0011!KX\u0005\u0003?N\u0013A\u0001V3ti\"2\u0011\"\u00193fM\u001e\u0004\"A\u00152\n\u0005\r\u001c&a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0003ua\rA!\u001e8ji\u0012\n\u0001.\u0003\u0002jU\u0006aQ*\u0013'M\u0013N+5i\u0014(E'*\u00111\u000e\\\u0001\t)&lW-\u00168ji*\u0011QN\\\u0001\u000bG>t7-\u001e:sK:$(BA8q\u0003\u0011)H/\u001b7\u000b\u0003E\fAA[1wC\u0006Aq-\u001a;HCV<W-F\u0002u\u0003\u000b!2!^A\f!\u00111h0!\u0001\u000e\u0003]T!\u0001_=\u0002\t\r|'/\u001a\u0006\u0003?iT!a\u001f?\u0002\re\fW.\\3s\u0015\u0005i\u0018aA2p[&\u0011qp\u001e\u0002\u0006\u000f\u0006,x-\u001a\t\u0005\u0003\u0007\t)\u0001\u0004\u0001\u0005\u000f\u0005\u001d!B1\u0001\u0002\n\t\tA+\u0005\u0003\u0002\f\u0005E\u0001cA!\u0002\u000e%\u0019\u0011q\u0002\"\u0003\u000f9{G\u000f[5oOB\u0019\u0011)a\u0005\n\u0007\u0005U!IA\u0002B]fDq!!\u0007\u000b\u0001\u0004\tY\"\u0001\u0004gS2$XM\u001d\t\b\u0003\u0006u\u0011\u0011EA\u0014\u0013\r\tyB\u0011\u0002\n\rVt7\r^5p]F\u00022A^A\u0012\u0013\r\t)c\u001e\u0002\u000b\u001b\u0016$(/[2OC6,\u0007cA!\u0002*%\u0019\u00111\u0006\"\u0003\u000f\t{w\u000e\\3b]V!\u0011qFA\u001b)\u0011\t\t$a\u000e\u0011\tYt\u00181\u0007\t\u0005\u0003\u0007\t)\u0004B\u0004\u0002\b-\u0011\r!!\u0003\t\u000f\u0005e2\u00021\u0001\u0002<\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0011\t\u0005u\u00121\n\b\u0005\u0003\u007f\t9\u0005E\u0002\u0002B\tk!!a\u0011\u000b\u0007\u0005\u0015c#\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0013\u0012\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002N\u0005=#AB*ue&twMC\u0002\u0002J\t+B!a\u0015\u0002ZQ1\u0011QKA.\u0003;\u0002BA\u001e@\u0002XA!\u00111AA-\t\u001d\t9\u0001\u0004b\u0001\u0003\u0013Aq!!\u000f\r\u0001\u0004\tY\u0004C\u0004\u0002`1\u0001\r!a\u000f\u0002\u00175,GO]5d'\u000e|\u0007/Z\u0001\u0018i\u0016\u001cH/T1y\u0019><7i\\7qC\u000e$\u0018n\u001c8MC\u001eD#!D/\u0002\u0017I,\u0017\r\u001a$s_6dun\u001a\u000b\u0005\u0003S\n\t\t\u0005\u0004\u0002l\u0005E\u0014QO\u0007\u0003\u0003[R1!a\u001cC\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\niG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u001d\t\u0015qOA>\u0003wJ1!!\u001fC\u0005\u0019!V\u000f\u001d7feA\u0019\u0011)! \n\u0007\u0005}$IA\u0002J]RDaa\u0005\bA\u0002\u0005\r\u0005cA\r\u0002\u0006&\u0019\u0011q\u0011\n\u0003\u00071{w-\u0001\u0007xe&$XmS3z\tV\u00048\u000f\u0006\t\u0002\u000e\u0006M\u0015qSAN\u0003;\u000by*!+\u0002.B1\u00111NAH\u0003kJA!!%\u0002n\t\u00191+Z9\t\u000f\u0005Uu\u00021\u0001\u0002|\u00059a.^7LKf\u001c\bbBAM\u001f\u0001\u0007\u00111P\u0001\b]VlG)\u001e9t\u0011\u0019\u0019r\u00021\u0001\u0002\u0004\")Qe\u0004a\u0001O!9\u0011\u0011U\bA\u0002\u0005\r\u0016!\u0003;j[\u0016\u001cH/Y7q!\r\t\u0015QU\u0005\u0004\u0003O\u0013%\u0001\u0002'p]\u001eDq!a+\u0010\u0001\u0004\tY(\u0001\u0006ti\u0006\u0014HOV1mk\u0016Dq!a,\u0010\u0001\u0004\tY(\u0001\u0003ti\u0016\u0004\u0018A\u0005;fgRL5\u000f\u00165sK\u0006$g)Y5mK\u0012D#\u0001E/")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        return (Gauge)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getGauge$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getGauge$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable & scala.Serializable getGauge_filter = (Function1 & Serializable & scala.Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$3(metricName, mName));
        return (Gauge)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getGauge$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getGauge$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getGauge_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$4(metricName, metricScope, k));
        return (Gauge)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getGauge$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getGauge$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, firstBlockCleanableSegmentOffset, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$15 = new TopicPartition("log", 0);
        long x$16 = activeSegAtT1.baseOffset();
        long x$17 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$15, x$16, x$17);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = 100000;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        Log log = (Log)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$3(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$4(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, Log log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, Log log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }

    public LogCleanerIntegrationTest() {
        Logging.$init$((Logging)this);
        KafkaMetricsGroup.$init$((KafkaMetricsGroup)this);
        this.codec = CompressionType.LZ4;
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

