/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u00040\u0001\u0001\u0006I\u0001\n\u0005\na\u0001\u0001\r\u00111A\u0005\u0002EB\u0011B\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001e\t\u0013\u0005\u0003\u0001\u0019!A!B\u0013\u0011\u0004\"\u0002\"\u0001\t\u0013\u0019\u0005bB-\u0001#\u0003%IA\u0017\u0005\bK\u0002\t\n\u0011\"\u0003g\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015)\b\u0001\"\u0001j\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0019\t\t\u0003\u0001C\u0001S\"1\u00111\u0006\u0001\u0005\u0002%Da!a\f\u0001\t\u0003I\u0007BBA\u001a\u0001\u0011\u0005\u0011NA\bM_\u001e\u001cVmZ7f]R\u001cH+Z:u\u0015\t\u0019B#A\u0002m_\u001eT\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003I\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001%!\t)S&D\u0001'\u0015\t9\u0003&\u0001\u0004d_6lwN\u001c\u0006\u0003+%R!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO&\u0011aF\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00027pO\u0012K'/F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0002j_*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011\u0011$P\u0005\u0003}i\u0011A!\u00168ji\"9\u0001)BA\u0001\u0002\u0004\u0011\u0014a\u0001=%c\u00059An\\4ESJ\u0004\u0013!D2sK\u0006$XmU3h[\u0016tG\u000f\u0006\u0003E\u000f2\u000b\u0006CA\u0011F\u0013\t1%C\u0001\u0006M_\u001e\u001cVmZ7f]RDQ\u0001S\u0004A\u0002%\u000baa\u001c4gg\u0016$\bCA\rK\u0013\tY%D\u0001\u0003M_:<\u0007bB'\b!\u0003\u0005\rAT\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000f\u0005\u0002\u001a\u001f&\u0011\u0001K\u0007\u0002\u0004\u0013:$\bb\u0002*\b!\u0003\u0005\raU\u0001\u0005i&lW\r\u0005\u0002U/6\tQK\u0003\u0002WM\u0005)Q\u000f^5mg&\u0011\u0001,\u0016\u0002\u0005)&lW-A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\t1L\u000b\u0002O9.\nQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Ej\t!\"\u00198o_R\fG/[8o\u0013\t!wLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqc\u0019:fCR,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003\u001dT#a\u0015/\u0002\u000bM,G/\u001e9\u0015\u0003qB#AC6\u0011\u00051\u001cX\"A7\u000b\u00059|\u0017aA1qS*\u0011\u0001/]\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00118&A\u0003kk:LG/\u0003\u0002u[\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D#aC<\u0011\u00051D\u0018BA=n\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0006bgN,'\u000f^#oiJLHc\u0001\u001f}}\")Q\u0010\u0004a\u0001\t\u000691/Z4nK:$\bBB@\r\u0001\u0004\t\t!\u0001\u0004uKN$X\r\u001a\t\u0007\u0003\u0007\tY\"\u0013#\u000f\t\u0005\u0015\u0011Q\u0003\b\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAF\u0001\u0007yI|w\u000e\u001e \n\u0003]J1!a\u00057\u0003\u0011)H/\u001b7\n\t\u0005]\u0011\u0011D\u0001\u0004\u001b\u0006\u0004(bAA\nm%!\u0011QDA\u0010\u0005\u0015)e\u000e\u001e:z\u0015\u0011\t9\"!\u0007\u0002'Q,7\u000f\u001e\"bg&\u001cw\n]3sCRLwN\\:)\u00075\t)\u0003E\u0002m\u0003OI1!!\u000bn\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f^*fO6,g\u000e^!dG\u0016\u001c8\u000fK\u0002\u000f\u0003K\t!\u0004^3ti\u000ecwn]3ti6\u000bGo\u00195Pa\u0016\u0014\u0018\r^5p]ND3aDA\u0013\u0003I!Xm\u001d;IS\u001eDWM]*fO6,g\u000e^:)\u0007A\t)\u0003")
public class LogSegmentsTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        return LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
    }

    private int createSegment$default$2() {
        return 10;
    }

    private Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.logDir());
    }

    private void assertEntry(LogSegment segment, Map.Entry<Object, LogSegment> tested) {
        Assertions.assertEquals((long)segment.baseOffset(), (long)BoxesRunTime.unboxToLong((Object)tested.getKey()));
        Assertions.assertEquals((Object)segment, (Object)tested.getValue());
    }

    @Test
    public void testBasicOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        int offset1 = 40;
        LogSegment seg1 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        int offset2 = 80;
        LogSegment seg2 = this.createSegment(offset2, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        segments.add(seg1);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.get((long)offset1));
        segments.add(seg2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset2));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.get((long)offset2));
        segments.add(seg3);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals((Object)new Some((Object)seg3), (Object)segments.get((long)offset1));
        segments.remove((long)offset2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset2));
        segments.clear();
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)0, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset1));
        segments.close();
    }

    @Test
    public void testSegmentAccess() {
        LogSegments segments = new LogSegments(this.topicPartition());
        int offset1 = 1;
        LogSegment seg1 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        int offset2 = 2;
        LogSegment seg2 = this.createSegment(offset2, this.createSegment$default$2(), this.createSegment$default$3());
        int offset3 = 3;
        LogSegment seg3 = this.createSegment(offset3, this.createSegment$default$2(), this.createSegment$default$3());
        int offset4 = 4;
        LogSegment seg4 = this.createSegment(offset4, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            LogSegmentsTest.$anonfun$testSegmentAccess$1(this, segments, seg1, seg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{offset1, offset2, offset3, offset4})), (Object)segments.baseOffsets());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))), (Object)segments.values().toSeq());
        Assertions.assertThrows(IllegalArgumentException.class, () -> segments.values(2L, 1L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)segments.values(1L, 1L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)Nil$.MODULE$), (Object)segments.values(1L, 2L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)Nil$.MODULE$)), (Object)segments.values(1L, 3L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$))), (Object)segments.values(1L, 4L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$)), (Object)segments.values(2L, 4L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg3, (List)Nil$.MODULE$), (Object)segments.values(3L, 4L).toSeq());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)segments.values(4L, 4L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg4, (List)Nil$.MODULE$), (Object)segments.values(4L, 5L).toSeq());
        segments.close();
    }

    @Test
    public void testClosestMatchOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg2 = this.createSegment(3L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(5L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg4 = this.createSegment(7L, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)segment -> segments.add(segment));
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.floorSegment(2L));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.floorSegment(3L));
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.lowerSegment(3L));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.lowerSegment(4L));
        Assertions.assertEquals((Object)new Some((Object)seg3), (Object)segments.higherSegment(4L));
        this.assertEntry(seg3, (Map.Entry)segments.higherEntry(4L).get());
        Assertions.assertEquals((Object)new Some((Object)seg4), (Object)segments.higherSegment(5L));
        this.assertEntry(seg4, (Map.Entry)segments.higherEntry(5L).get());
        segments.close();
    }

    @Test
    public void testHigherSegments() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg2 = this.createSegment(3L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(5L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg4 = this.createSegment(7L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg5 = this.createSegment(9L, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)segment -> segments.add(segment));
        Iterator iterator = segments.higherSegments(0L).iterator();
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$2(iterator, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = segments.higherSegments(1L).iterator();
        new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$3(iterator2, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = segments.higherSegments(8L).iterator();
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((Object)seg5, (Object)iterator3.next());
        Assertions.assertFalse((boolean)iterator3.hasNext());
        Assertions.assertFalse((boolean)segments.higherSegments(9L).iterator().hasNext());
    }

    public static final /* synthetic */ void $anonfun$testSegmentAccess$1(LogSegmentsTest $this, LogSegments segments$1, LogSegment seg1$1, LogSegment seg) {
        segments$1.add(seg);
        $this.assertEntry(seg1$1, (Map.Entry)segments$1.firstEntry().get());
        Assertions.assertEquals((Object)new Some((Object)seg1$1), (Object)segments$1.firstSegment());
        $this.assertEntry(seg, (Map.Entry)segments$1.lastEntry().get());
        Assertions.assertEquals((Object)new Some((Object)seg), (Object)segments$1.lastSegment());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$2(Iterator iterator$1, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Assertions.assertEquals((Object)segment, (Object)iterator$1.next());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$3(Iterator iterator$2, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$2.hasNext());
        Assertions.assertEquals((Object)segment, (Object)iterator$2.next());
    }
}

