/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.LazyIndex;
import kafka.log.LazyIndex$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.ProducerStateManager$;
import kafka.log.TransactionIndex;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class LogTestUtils$ {
    public static LogTestUtils$ MODULE$;

    static {
        new LogTestUtils$();
    }

    public LogSegment createSegment(long offset, File logDir, int indexIntervalBytes, Time time) {
        FileRecords ms = FileRecords.open((File)Log$.MODULE$.logFile(logDir, offset, Log$.MODULE$.logFile$default$3()));
        LazyIndex idx = LazyIndex$.MODULE$.forOffset(Log$.MODULE$.offsetIndexFile(logDir, offset, Log$.MODULE$.offsetIndexFile$default$3()), offset, 1000, LazyIndex$.MODULE$.forOffset$default$4());
        LazyIndex timeIdx = LazyIndex$.MODULE$.forTime(Log$.MODULE$.timeIndexFile(logDir, offset, Log$.MODULE$.timeIndexFile$default$3()), offset, 1500, LazyIndex$.MODULE$.forTime$default$4());
        TransactionIndex txnIndex = new TransactionIndex(offset, Log$.MODULE$.transactionIndexFile(logDir, offset, Log$.MODULE$.transactionIndexFile$default$3()));
        return new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, time);
    }

    public int createSegment$default$3() {
        return 10;
    }

    public Time createSegment$default$4() {
        return Time.SYSTEM;
    }

    public LogConfig createLogConfig(long segmentMs, int segmentBytes, long retentionMs, long retentionBytes, long segmentJitterMs, String cleanupPolicy, int maxMessageBytes, int indexIntervalBytes, int segmentIndexBytes, long fileDeleteDelayMs) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(segmentMs));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentBytes));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(retentionMs));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(retentionBytes));
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), Predef$.MODULE$.long2Long(segmentJitterMs));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageBytes));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(indexIntervalBytes));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(segmentIndexBytes));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.long2Long(fileDeleteDelayMs));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public Log createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile) {
        return Log$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, new LogDirFailureChannel(10), lastShutdownClean, topicId, keepPartitionMetadataFile);
    }

    public long createLogConfig$default$1() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public int createLogConfig$default$2() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public long createLogConfig$default$3() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public long createLogConfig$default$4() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long createLogConfig$default$5() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public String createLogConfig$default$6() {
        return Defaults$.MODULE$.CleanupPolicy();
    }

    public int createLogConfig$default$7() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int createLogConfig$default$8() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int createLogConfig$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public long createLogConfig$default$10() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 3600000;
    }

    public int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public boolean createLog$default$10() {
        return true;
    }

    public Option<Uuid> createLog$default$11() {
        return None$.MODULE$;
    }

    public boolean createLog$default$12() {
        return true;
    }

    public boolean hasOffsetOverflow(Log log) {
        return this.firstOverflowSegment(log).isDefined();
    }

    public Option<LogSegment> firstOverflowSegment(Log log) {
        Object object = new Object();
        try {
            log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LogTestUtils$.$anonfun$firstOverflowSegment$1(object, segment);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public FileRecords rawSegment(File logDir, long baseOffset) {
        return FileRecords.open((File)Log$.MODULE$.logFile(logDir, baseOffset, Log$.MODULE$.logFile$default$3()));
    }

    public void initializeLogDirWithOverflowedSegment(File logDir) {
        long nextOffset = 0L;
        nextOffset = this.writeNormalSegment$1(nextOffset, logDir);
        nextOffset = this.writeOverflowSegment$1(nextOffset, logDir);
        this.writeNormalSegment$1(nextOffset, logDir);
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)logSegment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logSegment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable & scala.Serializable)batch -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).withFilter((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$keysInLog$4(record))).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToLong((long)LogTestUtils$.$anonfun$keysInLog$5(record)), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Log recoverAndCheck(File logDir, LogConfig config, Iterable<Object> expectedKeys, BrokerTopicStats brokerTopicStats, Time time, Scheduler scheduler) {
        boolean x$6 = false;
        long x$7 = this.createLog$default$6();
        long x$8 = this.createLog$default$7();
        int x$9 = this.createLog$default$8();
        int x$10 = this.createLog$default$9();
        Option<Uuid> x$11 = this.createLog$default$11();
        boolean x$12 = this.createLog$default$12();
        Log recoveredLog = this.createLog(logDir, config, brokerTopicStats, scheduler, time, x$7, x$8, x$9, x$10, x$6, x$11, x$12);
        time.sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogTestUtils$.$anonfun$recoverAndCheck$1(file);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(expectedKeys, this.keysInLog(recoveredLog));
        Assertions.assertFalse((boolean)this.hasOffsetOverflow(recoveredLog));
        return recoveredLog;
    }

    public LogAppendInfo appendEndTxnMarkerAsLeader(Log log, long producerId, short producerEpoch, ControlRecordType controlType, long timestamp, int coordinatorEpoch, int leaderEpoch) {
        long x$6 = this.endTxnRecords$default$4();
        int x$7 = this.endTxnRecords$default$6();
        MemoryRecords records = this.endTxnRecords(controlType, producerId, producerEpoch, x$6, coordinatorEpoch, x$7, timestamp);
        AppendOrigin.Coordinator$ x$9 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$11 = log.appendAsLeader$default$4();
        RequestLocal x$12 = log.appendAsLeader$default$5();
        return log.appendAsLeader(records, leaderEpoch, (AppendOrigin)x$9, x$11, x$12);
    }

    public int appendEndTxnMarkerAsLeader$default$6() {
        return 0;
    }

    public int appendEndTxnMarkerAsLeader$default$7() {
        return 0;
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short epoch, long offset, int coordinatorEpoch, int partitionLeaderEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)epoch, (EndTransactionMarker)marker);
    }

    private long endTxnRecords$default$4() {
        return 0L;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    public FetchDataInfo readLog(Log log, long startOffset, int maxLength, FetchIsolation isolation, boolean minOneMessage) {
        return log.read(startOffset, maxLength, isolation, minOneMessage);
    }

    public FetchIsolation readLog$default$4() {
        return FetchLogEnd$.MODULE$;
    }

    public boolean readLog$default$5() {
        return true;
    }

    public Iterable<AbortedTxn> allAbortedTransactions(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.txnIndex().allAbortedTxns(), Iterable$.MODULE$.canBuildFrom());
    }

    public void deleteProducerSnapshotFiles(File logDir) {
        File[] files = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$1(f)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Object> listProducerSnapshotOffsets(File logDir) {
        return (Seq)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(logDir).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$);
    }

    public void assertLeaderEpochCacheEmpty(Log log) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.leaderEpochCache());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        Assertions.assertFalse((boolean)LeaderEpochCheckpointFile$.MODULE$.newFile(log.dir()).exists());
    }

    public void appendNonTransactionalAsLeader(Log log, int numRecords) {
        IndexedSeq simpleRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)seq -> LogTestUtils$.$anonfun$appendNonTransactionalAsLeader$1(BoxesRunTime.unboxToInt((Object)seq)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    public Function1<Object, BoxedUnit> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch, Time time) {
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, time, true);
    }

    public Function1<Object, BoxedUnit> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, Time time, boolean isTransactional) {
        return arg_0 -> LogTestUtils$.$anonfun$appendIdempotentAsLeader$1(IntRef.create((int)0), time, isTransactional, producerId, producerEpoch, log, arg_0);
    }

    public boolean appendIdempotentAsLeader$default$5() {
        return false;
    }

    private static final boolean hasOverflow$1(long baseOffset, RecordBatch batch) {
        return batch.lastOffset() > baseOffset + Integer.MAX_VALUE || batch.baseOffset() < baseOffset;
    }

    public static final /* synthetic */ void $anonfun$firstOverflowSegment$1(Object nonLocalReturnKey1$1, LogSegment segment) {
        if (((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).find((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.hasOverflow$1(segment.baseOffset(), (RecordBatch)batch))).isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)segment));
        }
    }

    private static final SimpleRecord record$1(long offset) {
        byte[] data = Long.toString(offset).getBytes();
        return new SimpleRecord(data, data);
    }

    private static final long writeSampleBatches$1(long baseOffset, FileRecords segment, File logDir$1) {
        segment.append(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{LogTestUtils$.record$1(baseOffset)}));
        segment.append(MemoryRecords.withRecords((long)(baseOffset + 1L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + 1L), LogTestUtils$.record$1(baseOffset + 2L)}));
        segment.append(MemoryRecords.withRecords((long)(baseOffset + Integer.MAX_VALUE - 1L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + Integer.MAX_VALUE - 1L)}));
        Log$.MODULE$.offsetIndexFile(logDir$1, baseOffset, Log$.MODULE$.offsetIndexFile$default$3()).createNewFile();
        Log$.MODULE$.timeIndexFile(logDir$1, baseOffset, Log$.MODULE$.timeIndexFile$default$3()).createNewFile();
        return baseOffset + Integer.MAX_VALUE;
    }

    private final long writeNormalSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1);
        }
        return l;
    }

    private final long writeOverflowSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1), segment, logDir$1);
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$4(Record record) {
        return record.hasValue() && record.hasKey();
    }

    public static final /* synthetic */ long $anonfun$keysInLog$5(Record record) {
        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toLong();
    }

    public static final /* synthetic */ void $anonfun$recoverAndCheck$1(File file) {
        Assertions.assertFalse((boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()), (String)"Unexpected .deleted file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()), (String)"Unexpected .cleaned file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()), (String)"Unexpected .swap file after recovery");
    }

    public static final /* synthetic */ boolean $anonfun$deleteProducerSnapshotFiles$1(File f) {
        return f.isFile() && f.getName().endsWith(Log$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$deleteProducerSnapshotFiles$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendNonTransactionalAsLeader$1(int seq) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(Time time$1, int seq) {
        return new SimpleRecord(time$1.milliseconds(), String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    public static final /* synthetic */ void $anonfun$appendIdempotentAsLeader$1(IntRef sequence$1, Time time$1, boolean isTransactional$1, long producerId$1, short producerEpoch$1, Log log$1, int numRecords) {
        IndexedSeq simpleRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(sequence$1.elem), sequence$1.elem + numRecords).map((Function1 & Serializable & scala.Serializable)seq -> LogTestUtils$.$anonfun$appendIdempotentAsLeader$2(time$1, BoxesRunTime.unboxToInt((Object)seq)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = isTransactional$1 ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)producerEpoch$1, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)producerEpoch$1, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        log$1.appendAsLeader(records, 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        sequence$1.elem += numRecords;
    }

    private LogTestUtils$() {
        MODULE$ = this;
    }
}

