/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.IpConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00021BQA\u000f\u0001\u0005\u0002mBQ!\u0014\u0001\u0005\u0002mBQa\u0014\u0001\u0005\u0002mBQ!\u0015\u0001\u0005\nICQA\u001a\u0001\u0005\u0002mBQ\u0001\u001b\u0001\u0005\u0002mBQA\u001b\u0001\u0005\u0002mBQ\u0001\u001c\u0001\u0005\u0002mBQA\u001c\u0001\u0005\u0002mBQ\u0001\u001d\u0001\u0005\u0002mBQA\u001d\u0001\u0005\u0002mBQ\u0001\u001e\u0001\u0005\u0002mBQA\u001e\u0001\u0005\u0002mBQ\u0001\u001f\u0001\u0005\u0002mBQA\u001f\u0001\u0005\u0002mBQ\u0001 \u0001\u0005\u0002mBQA \u0001\u0005\u0002mBa!!\u0001\u0001\t\u0003Y\u0004BBA\u0003\u0001\u0011\u00051\b\u0003\u0004\u0002\n\u0001!\ta\u000f\u0005\u0007\u0003\u001b\u0001A\u0011A\u001e\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\"a\u0006#z]\u0006l\u0017nY\"p]\u001aLwm\u00115b]\u001e,G+Z:u\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\t!S$A\u0006j]R,wM]1uS>t\u0017B\u0001\u0014$\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u001c\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0017\u0011\u00079*t'D\u00010\u0015\t\u0001\u0014'A\u0005j[6,H/\u00192mK*\u0011!gM\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Yz#\u0001\u0002'jgR\u0004\"A\u000b\u001d\n\u0005eZ\"aC&bM.\f7i\u001c8gS\u001e\f\u0001\u0003^3ti\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0003q\u0002\"!\u0010 \u000e\u0003MJ!aP\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007\u0005\u0003\"AQ&\u000e\u0003\rS!\u0001R#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002G\u000f\u00069!.\u001e9ji\u0016\u0014(B\u0001%J\u0003\u0015QWO\\5u\u0015\u0005Q\u0015aA8sO&\u0011Aj\u0011\u0002\u0005)\u0016\u001cH/\u0001\u000fuKN$H)\u001f8b[&\u001cGk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3)\u0005\u0011\t\u0015A\b;fgRlUm]:bO\u00164uN]7biZ+'o]5p]\u000eC\u0017M\\4fQ\t)\u0011)A\u000buKN$\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u000bq\u001a\u0006M\u00193\t\u000bQ3\u0001\u0019A+\u0002\tU\u001cXM\u001d\t\u0003-vs!aV.\u0011\u0005a\u001bT\"A-\u000b\u0005i{\u0012A\u0002\u001fs_>$h(\u0003\u0002]g\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta6\u0007C\u0003b\r\u0001\u0007Q+\u0001\u0005dY&,g\u000e^%e\u0011\u0015\u0019g\u00011\u0001V\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016DQ!\u001a\u0004A\u0002U\u000b\u0001cY8oM&<WI\u001c;jift\u0015-\\3\u0002;Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#aB!\u00023Q,7\u000f^+tKJ\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003\u0011\u0005\u000b1\u0004^3tiV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018m\u00115b]\u001e,\u0007FA\u0005B\u0003\u0011\"Xm\u001d;EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001\u0006B\u0003\u0001\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u0014\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005-\t\u0015\u0001\u000b;fgR$UMZ1vYR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001\u0007B\u0003]!Xm\u001d;Rk>$\u0018-\u00138ji&\fG.\u001b>bi&|g\u000e\u000b\u0002\u000e\u0003\u0006\u0001C/Z:u\u0013BD\u0015M\u001c3mKJ,fN]3t_24\u0018M\u00197f\u0003\u0012$'/Z:tQ\tq\u0011)A\ruKN$\u0018\n])v_R\f\u0017J\\5uS\u0006d\u0017N_1uS>t\u0007FA\bB\u0003]!Xm\u001d;JaF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u0011\u0003\u0006\u0011C/Z:u\u0007>tg-[4DQ\u0006tw-Z(o\u001d>tW\t_5ti&tw\rV8qS\u000eD#!E!\u0002cQ,7\u000f^\"p]\u001aLwm\u00115b]\u001e,wJ\u001c(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5d/&$\b.\u00113nS:\u001cE.[3oi\"\u0012!#Q\u0001\u0018i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8OT8uS\u001aL7-\u0019;j_:D#aE!\u0002KMDw.\u001e7e!\u0006\u00148/\u001a*fa2L7-\u0019;j_:\fVo\u001c;b!J|\u0007/\u001a:uS\u0016\u001c\bF\u0001\u000bB\u00035\u001a\bn\\;mIB\u000b'o]3XS2$7-\u0019:e%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0004&o\u001c9feRLWm\u001d\u0015\u0003+\u0005\u000b\u0001e\u001d5pk2$\u0007+\u0019:tKJ+\u0007\u000f\\5dCRLwN\\)v_R\f'+Z:fi\"\u0012a#Q\u0001.g\"|W\u000f\u001c3QCJ\u001cXMU3hCJ$G.Z:t\u001f\u001a<\u0006.\u001b;fgB\f7-Z!s_VtGMV1mk\u0016\u001c\bFA\fB\u0003\u0015\u0001\u0018M]:f)\u0019\t)\"a\t\u0002.A1\u0011qCA\r\u0003;i\u0011!M\u0005\u0004\u00037\t$aA*fcB\u0019Q(a\b\n\u0007\u0005\u00052GA\u0002J]RDq!!\n\u0019\u0001\u0004\t9#A\u0007d_:4\u0017n\u001a%b]\u0012dWM\u001d\t\u0004U\u0005%\u0012bAA\u00167\t\u0011Bk\u001c9jG\u000e{gNZ5h\u0011\u0006tG\r\\3s\u0011\u0019\ty\u0003\u0007a\u0001+\u0006)a/\u00197vK\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\u0005\u0005U\u0002\u0003BA\u001c\u0003\u000fj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003\u007f\t\t%A\u0004dY&,g\u000e^:\u000b\u0007y\t\u0019EC\u0002\u0002F%\u000ba!\u00199bG\",\u0017\u0002BA%\u0003s\u0011Q!\u00113nS:\u0004")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigChange() {
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()), (String)"Should contain a ConfigHandler for topics");
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Log log = (Log)qual$2.getLog(tp, x$4).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(newSegmentSize));
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.servers(), tp.topic(), Integer.toString(i), TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertTrue((boolean)log.logSegments().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageFormatVersionChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps);
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Log log = (Log)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)log.config().messageFormatVersion());
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        String compressionType = CompressionType.LZ4.name;
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), compressionType);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)log.config().messageFormatVersion());
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType), (String)new StringBuilder(35).append("Should contain a ConfigHandler for ").append(rootEntityType).toString());
        Properties props = new Properties();
        props.put("producer_byte_rate", "1000");
        props.put("consumer_byte_rate", "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = ConfigType$.MODULE$.Client();
        if (!(string != null ? !string.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
        }
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
        }
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testIpHandlerUnresolvableAddress() {
        IpConfigHandler configHandler = new IpConfigHandler(null);
        Properties props = new Properties();
        props.put("connection_creation_rate", "1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> configHandler.processConfigChanges("illegal-hostname", props));
    }

    @Test
    public void testIpQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties ipOverrideProps = new Properties();
        ipOverrideProps.put("connection_creation_rate", "10");
        Properties ipDefaultProps = new Properties();
        ipDefaultProps.put("connection_creation_rate", "20");
        server.shutdown();
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
        this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        ConnectionQuotas connectionQuotas = server.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    @Test
    public void testIpQuotaConfigChange() {
        Properties ipOverrideProps = new Properties();
        ipOverrideProps.put("connection_creation_rate", "10");
        Properties ipDefaultProps = new Properties();
        ipDefaultProps.put("connection_creation_rate", "20");
        InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
        InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
        this.adminZkClient().changeIpConfig(overrideQuotaIp.getHostAddress(), ipOverrideProps);
        ConnectionQuotas connectionQuotas = ((KafkaServer)this.servers().head()).socketServer().connectionQuotas();
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10), connectionQuotas);
        DynamicConfigChangeTest.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20), connectionQuotas);
        Properties emptyProps = new Properties();
        this.adminZkClient().changeIpConfig(overrideQuotaIp.getHostAddress(), emptyProps);
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20), connectionQuotas);
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), emptyProps);
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), connectionQuotas);
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    @Test
    public void testConfigChangeOnNonExistingTopicWithAdminClient() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @Test
    public void testProcessNotification() {
        new Properties().put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap.elem).asJava()));
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assertions.assertEquals((Object)Nil$.MODULE$, this.parse(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (Long)((Log)logOpt.get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (Long)((Log)qual$2.getLog(tp$1, x$4).get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (Integer)((Log)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, Log log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (Integer)log$1.config().segmentSize());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, String compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        String string = ((Log)qual$3.getLog(tp$3, x$6).get()).config().compressionType();
        return !(string != null ? !string.equals(compressionType$1) : compressionType$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultProducerQuota$1), (Object)producerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultConsumerQuota$1), (Object)consumerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota, ConnectionQuotas connectionQuotas$1) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas$1, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }
}

