/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminOperationException;
import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u001by\u0002BB\u0017\u0001A\u00035\u0001\u0005C\u0004/\u0001\t\u0007IQB\u0010\t\r=\u0002\u0001\u0015!\u0004!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015\u0019\u0005\u0001\"\u00012\u0011\u0015)\u0005\u0001\"\u00012\u0011\u00159\u0005\u0001\"\u00012\u0011\u0015I\u0005\u0001\"\u00012\u0011\u0015Y\u0005\u0001\"\u00012\u0011\u0015i\u0005\u0001\"\u00012\u0005E!\u0015P\\1nS\u000e\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/A\t!A_6\n\u0005e1\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u001d\u0005\tbn\u001c8Fq&\u001cH/\u001a8u\u0007>tg-[4\u0016\u0003\u0001\u0002\"!\t\u0016\u000f\u0005\tB\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0013\u0003\u0019a$o\\8u})\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc%\u0001\no_:,\u00050[:uK:$8i\u001c8gS\u001e\u0004\u0013!C:p[\u00164\u0016\r\\;f\u0003)\u0019x.\\3WC2,X\rI\u0001,g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oO\u000ec\u0017.\u001a8u\u0013\u0012,fn\u001b8po:\u001cuN\u001c4jOR\t!\u0007\u0005\u00024i5\ta%\u0003\u00026M\t!QK\\5uQ\t1q\u0007\u0005\u00029\u00036\t\u0011H\u0003\u0002;w\u0005\u0019\u0011\r]5\u000b\u0005qj\u0014a\u00026va&$XM\u001d\u0006\u0003}}\nQA[;oSRT\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\":\u0005\u0011!Vm\u001d;\u0002OMDw.\u001e7e\r\u0006LGn\u00165f]\u000eC\u0017M\\4j]\u001e,6/\u001a:V].twn\u001e8D_:4\u0017n\u001a\u0015\u0003\u000f]\n\u0001f\u001d5pk2$g)Y5m\u0019\u0016\fG-\u001a:D_:4\u0017nZ:XSRD\u0017J\u001c<bY&$g+\u00197vKND#\u0001C\u001c\u0002UMDw.\u001e7e\r\u0006LGNR8mY><XM]\"p]\u001aLwm],ji\"LeN^1mS\u00124\u0016\r\\;fg\"\u0012\u0011bN\u0001%g\"|W\u000f\u001c3GC&d\u0017\n]\"p]\u001aLwm],ji\"LeN^1mS\u00124\u0016\r\\;fg\"\u0012!bN\u0001)g\"|W\u000f\u001c3GC&d\u0017\n]\"p]\u001aLwm],ji\"LeN^1mS\u0012L\u0005O\u001e\u001bF]RLG/\u001f\u0015\u0003\u0017]\nad\u001d5pk2$g)Y5m\u0013B\u001cuN\u001c4jON<\u0016\u000e\u001e5CC\u0012Dun\u001d;)\u000519\u0004")
public class DynamicConfigTest
extends ZooKeeperTestHarness {
    private final String nonExistentConfig;
    private final String someValue;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    @Test
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.adminZkClient().changeClientIdConfig("ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue())));
    }

    @Test
    public void shouldFailWhenChangingUserUnknownConfig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.adminZkClient().changeUserOrUserClientIdConfig("UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue())));
    }

    @Test
    public void shouldFailLeaderConfigsWithInvalidValues() {
        Assertions.assertThrows(ConfigException.class, () -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100")));
    }

    @Test
    public void shouldFailFollowerConfigsWithInvalidValues() {
        Assertions.assertThrows(ConfigException.class, () -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100")));
    }

    @Test
    public void shouldFailIpConfigsWithInvalidValues() {
        Assertions.assertThrows(ConfigException.class, () -> this.adminZkClient().changeIpConfig("1.2.3.4", CoreUtils$.MODULE$.propsWith("connection_creation_rate", "-1")));
    }

    @Test
    public void shouldFailIpConfigsWithInvalidIpv4Entity() {
        Assertions.assertThrows(AdminOperationException.class, () -> this.adminZkClient().changeIpConfig("1,1.1.1", CoreUtils$.MODULE$.propsWith("connection_creation_rate", "2")));
    }

    @Test
    public void shouldFailIpConfigsWithBadHost() {
        Assertions.assertThrows(AdminOperationException.class, () -> this.adminZkClient().changeIpConfig("ip", CoreUtils$.MODULE$.propsWith("connection_creation_rate", "2")));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

