/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u0019)\u0005\u0001)A\u0005\u007f!9a\t\u0001b\u0001\n\u00039\u0005B\u0002+\u0001A\u0003%\u0001\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\rq\u0003\u0001\u0015!\u0003X\u0011\u001di\u0006A1A\u0005\u0002yCaa\u0019\u0001!\u0002\u0013y\u0006b\u00023\u0001\u0005\u0004%\tA\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B0\t\u000f\u0019\u0004!\u0019!C\u0001O\"9\u0011Q\u0001\u0001!\u0002\u0013A\u0007bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013A1\"!\t\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002$!Y\u0011q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0006\u0011-\t\t\u0004\u0001a\u0001\u0002\u0004%\t!a\r\t\u0017\u0005m\u0002\u00011AA\u0002\u0013\u0005\u0011Q\b\u0005\f\u0003\u0003\u0002\u0001\u0019!A!B\u0013\t)\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005u\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\r\u0001\u0005\u0002\u0005\u0015\u0003bBA3\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003S\u0002A\u0011AA#\u0011\u001d\ti\u0007\u0001C\u0001\u0003_B\u0011\"a$\u0001#\u0003%\t!!%\t\u0013\u0005\u001d\u0006!%A\u0005\u0002\u0005%\u0006bBAW\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003o\u0003A\u0011AA]\u0005a\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003E\r\naa]3sm\u0016\u0014(\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0019\u0001\u001b\u0005\t\u0013aB2p]\u001aLwm]\u000b\u0002gA\u0019AgN\u001d\u000e\u0003UR!AN\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00029k\t\u00191+Z9\u0011\u0005AR\u0014BA\u001e\"\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nA\u0001^5nKV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002CG\u0005)Q\u000f^5mg&\u0011A)\u0011\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#\u0001%\u0011\u0005%\u0013V\"\u0001&\u000b\u0005\u0019[%B\u0001'N\u0003\u0019\u0019w.\\7p]*\u0011AE\u0014\u0006\u0003\u001fB\u000ba!\u00199bG\",'\"A)\u0002\u0007=\u0014x-\u0003\u0002T\u0015\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\rI,7m\u001c:e+\u00059\u0006C\u0001-[\u001b\u0005I&BA+L\u0013\tY\u0016L\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H-A\u0004sK\u000e|'\u000f\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]F*\u0012a\u0018\t\u0003A\u0006l\u0011aS\u0005\u0003E.\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c82A\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t''\u0001\tu_BL7\rU1si&$\u0018n\u001c83A\u0005Ia-\u001a;dQ&sgm\\\u000b\u0002QB\u0019AgN5\u0011\t!Rw\f\\\u0005\u0003W&\u0012a\u0001V;qY\u0016\u0014\u0004CA7\u0000\u001d\tqGP\u0004\u0002pu:\u0011\u0001/\u001f\b\u0003cbt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U,\u0013A\u0002\u001fs_>$h(C\u0001R\u0013\ty\u0005+\u0003\u0002%\u001d&\u0011A*T\u0005\u0003w.\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003{z\fABR3uG\"\u0014V-];fgRT!a_&\n\t\u0005\u0005\u00111\u0001\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\u0005ut\u0018A\u00034fi\u000eD\u0017J\u001c4pA\u0005a\u0011/^8uC6\u000bg.Y4feV\u0011\u00111\u0002\t\u0005\u0003\u001b\tYB\u0004\u0003\u0002\u0010\u0005]a\u0002BA\t\u0003+q1a]A\n\u0013\u0005!\u0013B\u0001\u0012$\u0013\r\tI\"I\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0005\u0003;\tyBA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0004\u00033\t\u0013\u0001E9v_R\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t)#a\u000b\u0011\u0007!\n9#C\u0002\u0002*%\u0012A!\u00168ji\"I\u0011QF\t\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\n\u0014!D9v_R\fW*\u00198bO\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005U\u0002c\u0001\u0019\u00028%\u0019\u0011\u0011H\u0011\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t)#a\u0010\t\u0013\u00055B#!AA\u0002\u0005U\u0012a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002UMDw.\u001e7e\u000bb\u001cG.\u001e3f'V\u00147/Z9vK:$H\u000b\u001b:piRdW\r\u001a)beRLG/[8ogR\u0011\u0011Q\u0005\u0015\u0004-\u0005%\u0003\u0003BA&\u00033j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0004CBL'\u0002BA*\u0003+\nqA[;qSR,'OC\u0002\u0002XA\u000bQA[;oSRLA!a\u0017\u0002N\t!A+Z:u\u0003e\u001a\bn\\;mI\u001e+GOT8NKN\u001c\u0018mZ3t\u0013\u001a\fVo\u001c;bg\u0016C8-Z3eK\u0012|enU;cg\u0016\fX/\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bfA\f\u0002J\u0005\u00113\u000f[8vY\u0012<U\r\u001e\"pi\"lUm]:bO\u0016\u001c\u0018JZ)v_R\f7/\u00117m_^D3\u0001GA%\u0003\u0011\u001a\bn\\;mI&s7\r\\;eK&s7+\u001f8d)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c\bfA\r\u0002J\u0005yC/Z:u\u0007>l\u0007\u000f\\3uK&sG)\u001a7bs\u0016$g)\u001a;dQ^KG\u000f\u001b*fa2L7-\u0019+ie>$H\u000f\\5oO\"\u001a!$!\u0013\u0002\u0015M,G/\u00169N_\u000e\\7\u000f\u0006\u0005\u0002&\u0005E\u00141QAC\u0011\u001917\u00041\u0001\u0002tA)\u0011QOA@S:!\u0011qOA>\u001d\r\u0019\u0018\u0011P\u0005\u0002U%\u0019\u0011QP\u0015\u0002\u000fA\f7m[1hK&\u0019\u0001(!!\u000b\u0007\u0005u\u0014\u0006C\u0004V7A\u0005\t\u0019A,\t\u0013\u0005\u001d5\u0004%AA\u0002\u0005%\u0015A\u00052pi\"\u0014V\r\u001d7jG\u0006\u001c\u0018J\\*z]\u000e\u00042\u0001KAF\u0013\r\ti)\u000b\u0002\b\u0005>|G.Z1o\u0003Q\u0019X\r^+q\u001b>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0013\u0016\u0004/\u0006U5FAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0016&\u0001\u0006b]:|G/\u0019;j_:LA!!*\u0002\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)M,G/\u00169N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYK\u000b\u0003\u0002\n\u0006U\u0015\u0001\u0003;fCJ$un\u001e8)\u0007y\t\t\f\u0005\u0003\u0002L\u0005M\u0016\u0002BA[\u0003\u001b\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u00135|7m[)v_R\fG\u0003BA^\u0003\u0003\u00042\u0001MA_\u0013\r\ty,\t\u0002\r%\u0016\u0004H.[2b#V|G/\u0019\u0005\b\u0003\u0007|\u0002\u0019AAc\u0003\u0015\u0011w.\u001e8e!\rA\u0013qY\u0005\u0004\u0003\u0013L#\u0001\u0002'p]\u001e\u0004")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition1()), (Object)new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition2()), (Object)new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$2))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$3))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$6))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$7))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        boolean x$2 = true;
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, x$2);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$8))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$9))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    public void setUpMocks(Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        AlterIsrManager alterIsrManager = (AlterIsrManager)EasyMock.createMock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, (Scheduler)scheduler, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)MetadataCache$.MODULE$.zkMetadataCache(leaderBrokerId), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), alterIsrManager, ReplicaManager$.MODULE$.$lessinit$greater$default$13()));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getPartitionOrException((TopicPartition)EasyMock.anyObject())).andReturn((Object)partition).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (Partition)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject())))).andReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0)).anyTimes();
        EasyMock.expect((Object)partition.getReplica(1)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{replicaManager, partition});
        TopicPartition tp = new TopicPartition("t1", 0);
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(50L, 0L, 1, Optional.empty()));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, (Seq)new .colon.colon((Object)new Tuple2((Object)tp, (Object)fetchPartitionStatus), (List)Nil$.MODULE$));
        return new DelayedFetch(null, fetchMetadata, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, Log log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicPartition p = (TopicPartition)x$10._1();
            Partition partition = $this.replicaManager().createPartition(p);
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
            return;
        }
        throw new MatchError(null);
    }
}

