/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001\u0002\u00180\u0001YBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004P\u0001\u0001\u0006I!\u0013\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0011\u0019Q\u0006\u0001)A\u0005%\"91\f\u0001b\u0001\n\u0003a\u0006B\u00024\u0001A\u0003%Q\fC\u0004h\u0001\t\u0007I\u0011\u0001/\t\r!\u0004\u0001\u0015!\u0003^\u0011\u001dI\u0007\u00011A\u0005\u0002)Dq!\u001e\u0001A\u0002\u0013\u0005a\u000f\u0003\u0004}\u0001\u0001\u0006Ka\u001b\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0011%\t9\u0002\u0001a\u0001\n\u0003\tI\u0002C\u0004\u0002\u001e\u0001\u0001\u000b\u0015B@\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0002\"CA\u0017\u0001\u0001\u0007I\u0011AA\u0018\u0011!\t\u0019\u0004\u0001Q!\n\u0005\r\u0002bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003\u001b\u0002A\u0011IA\u001c\u0011\u001d\t9\u0006\u0001C\u0001\u0003oAq!!\u0019\u0001\t\u0003\t9\u0004C\u0004\u0002f\u0001!\t!a\u000e\t\u000f\u0005%\u0004\u0001\"\u0001\u00028!9\u0011Q\u000e\u0001\u0005\u0002\u0005]\u0002bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0011%\t\u0019\nAI\u0001\n\u0013\t)\nC\u0004\u0002,\u0002!I!a\u000e\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006BBAd\u0001\u0011%a\u0010C\u0004\u0002J\u0002!I!a3\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9\u0011q\u001e\u0001\u0005\n\u0005E\bbBA{\u0001\u0011%\u0011q\u001f\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011%\u0011i\u0002AI\u0001\n\u0013\t)\nC\u0005\u0003 \u0001\t\n\u0011\"\u0003\u0002\u0016\"9!\u0011\u0005\u0001\u0005\n\t\r\u0002B\u0002B\u0019\u0001\u0011%a\u0010C\u0004\u0002x\u0001!IAa\r\t\u000f\u0005m\u0004\u0001\"\u0003\u00034!9!Q\u0007\u0001\u0005\n\t]\u0002\"\u0003B$\u0001E\u0005I\u0011\u0002B%\u00051*\u0005o\\2i\tJLg/\u001a8SKBd\u0017nY1uS>t\u0007K]8u_\u000e|G.Q2dKB$\u0018M\\2f)\u0016\u001cHO\u0003\u00021c\u0005)Q\r]8dQ*\u0011!gM\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001ou\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u001a\u0002\u0005i\\\u0017B\u0001\u001f:\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iM\u0001\u0006kRLGn]\u0005\u0003\u0005~\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u0011a\tA\u0007\u0002_\u0005Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u001a\u0002\u0007\u0005\u0004\u0018.\u0003\u0002O\u0017\nQ\u0011\t]5WKJ\u001c\u0018n\u001c8\u0002\u0017\u0005\u0004\u0018NV3sg&|g\u000eI\u0001\u0006i>\u0004\u0018nY\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u0004[N<W#A/\u0011\u0007y\u000b7-D\u0001`\u0015\u0005\u0001\u0017!B:dC2\f\u0017B\u00012`\u0005\u0015\t%O]1z!\tqF-\u0003\u0002f?\n!!)\u001f;f\u0003\u0011i7o\u001a\u0011\u0002\u00135\u001cxMQ5hO\u0016\u0014\u0018AC7tO\nKwmZ3sA\u00059!M]8lKJ\u001cX#A6\u0011\u00071|\u0017/D\u0001n\u0015\tqw,\u0001\u0006d_2dWm\u0019;j_:L!\u0001]7\u0003\u0007M+\u0017\u000f\u0005\u0002sg6\t\u0011'\u0003\u0002uc\tY1*\u00194lCN+'O^3s\u0003-\u0011'o\\6feN|F%Z9\u0015\u0005]T\bC\u00010y\u0013\tIxL\u0001\u0003V]&$\bbB>\f\u0003\u0003\u0005\ra[\u0001\u0004q\u0012\n\u0014\u0001\u00032s_.,'o\u001d\u0011\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012a \t\u0007\u0003\u0003\t\u0019\"X/\u000e\u0005\u0005\r!bA?\u0002\u0006)!\u0011qAA\u0005\u0003\u001d\u0019G.[3oiNT1\u0001NA\u0006\u0015\u0011\ti!a\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t\"A\u0002pe\u001eLA!!\u0006\u0002\u0004\ti1*\u00194lCB\u0013x\u000eZ;dKJ\fA\u0002\u001d:pIV\u001cWM]0%KF$2a^A\u000e\u0011\u001dYh\"!AA\u0002}\f\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u0011\r|gn];nKJ,\"!a\t\u0011\r\u0005\u0015\u0012\u0011F/^\u001b\t\t9C\u0003\u0003\u0002 \u0005\u0015\u0011\u0002BA\u0016\u0003O\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\u0018\u0001D2p]N,X.\u001a:`I\u0015\fHcA<\u00022!A10EA\u0001\u0002\u0004\t\u0019#A\u0005d_:\u001cX/\\3sA\u0005)1/\u001a;VaR\tq\u000fK\u0002\u0014\u0003w\u0001B!!\u0010\u0002J5\u0011\u0011q\b\u0006\u0004\u0019\u0006\u0005#\u0002BA\"\u0003\u000b\nqA[;qSR,'O\u0003\u0003\u0002H\u0005=\u0011!\u00026v]&$\u0018\u0002BA&\u0003\u007f\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u000b\u0002RA!\u0011QHA*\u0013\u0011\t)&a\u0010\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001J:i_VdGMR8mY><H*Z1eKJ,\u0005o\\2i\u0005\u0006\u001c\u0018nY,pe.4Gn\\<)\u0007U\tY\u0006\u0005\u0003\u0002>\u0005u\u0013\u0002BA0\u0003\u007f\u0011A\u0001V3ti\u0006Y2\u000f[8vY\u0012tu\u000e^!mY><H)\u001b<fe\u001e,g\u000e\u001e'pOND3AFA.\u0003mygMZ:fiN\u001c\u0006n\\;mI:{GoR8CC\u000e\\w/\u0019:eg\"\u001aq#a\u0017\u0002;MDw.\u001e7e'V\u0014h/\u001b<f\r\u0006\u001cH\u000fT3bI\u0016\u00148\t[1oO\u0016D3\u0001GA.\u00031bwnZ:TQ>,H\u000e\u001a(pi\u0012Kg/\u001a:hK>sWK\\2mK\u0006tG*Z1eKJ,E.Z2uS>t7\u000fK\u0002\u001a\u00037\n1\u0001\\8h)\u00159\u0018QOA=\u0011\u0019\t9H\u0007a\u0001c\u00061A.Z1eKJDa!a\u001f\u001b\u0001\u0004\t\u0018\u0001\u00034pY2|w/\u001a:\u0002%]\f\u0017\u000e\u001e$pe2{wm\u001d+p\u001b\u0006$8\r\u001b\u000b\bo\u0006\u0005\u0015QQAE\u0011\u0019\t\u0019i\u0007a\u0001c\u0006\u0011!-\r\u0005\u0007\u0003\u000f[\u0002\u0019A9\u0002\u0005\t\u0014\u0004\"CAF7A\u0005\t\u0019AAG\u0003%\u0001\u0018M\u001d;ji&|g\u000eE\u0002_\u0003\u001fK1!!%`\u0005\rIe\u000e^\u0001\u001do\u0006LGOR8s\u0019><7\u000fV8NCR\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t9J\u000b\u0003\u0002\u000e\u0006e5FAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015v,\u0001\u0006b]:|G/\u0019;j_:LA!!+\u0002 \n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014\u0018N\u001c;TK\u001elWM\u001c;t\u00035\u0019H/\u0019:u\u0007>t7/^7feR\u0011\u00111E\u0001\u001aI\u0016dW\r^3NKN\u001c\u0018mZ3t\rJ|W\u000eT8h\r&dW\rF\u0004x\u0003k\u000by,a1\t\u000f\u0005]v\u00041\u0001\u0002:\u0006)!-\u001f;fgB\u0019a,a/\n\u0007\u0005uvL\u0001\u0003M_:<\u0007BBAa?\u0001\u0007\u0011/\u0001\u0004ce>\\WM\u001d\u0005\b\u0003\u000b|\u0002\u0019AAG\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002/\r\u0014X-\u0019;f\u0005V4g-\u001a:j]\u001e\u0004&o\u001c3vG\u0016\u0014\u0018AC4fi2{wMR5mKR1\u0011QZAm\u00037\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'4\u0016AA5p\u0013\u0011\t9.!5\u0003\t\u0019KG.\u001a\u0005\u0007\u0003\u0003\f\u0003\u0019A9\t\u000f\u0005-\u0015\u00051\u0001\u0002\u000e\u00061q-\u001a;M_\u001e$b!!9\u0002l\u00065\b\u0003BAr\u0003Ol!!!:\u000b\u0007\u0005E4'\u0003\u0003\u0002j\u0006\u0015(a\u0001'pO\"1\u0011\u0011\u0019\u0012A\u0002EDq!a##\u0001\u0004\ti)\u0001\u0004c_Vt7-\u001a\u000b\u0004o\u0006M\bBBA>G\u0001\u0007\u0011/\u0001\u0006fa>\u001c\u0007nQ1dQ\u0016$B!!?\u0002\u0000B\u0019a)a?\n\u0007\u0005uxF\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a\u0005\u0007\u0003\u0003$\u0003\u0019A9\u0002\u00191\fG/Z:u%\u0016\u001cwN\u001d3\u0015\u0011\t\u0015!Q\u0003B\f\u00057\u0001BAa\u0002\u0003\u00125\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0005\u001f\tI!\u0001\u0004d_6lwN\\\u0005\u0005\u0005'\u0011IAA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007BBA<K\u0001\u0007\u0011\u000fC\u0005\u0003\u001a\u0015\u0002\n\u00111\u0001\u0002\u000e\u00061qN\u001a4tKRD\u0011\"a#&!\u0003\u0005\r!!$\u0002-1\fG/Z:u%\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uII\na\u0003\\1uKN$(+Z2pe\u0012$C-\u001a4bk2$HeM\u0001\tC^\f\u0017\u000e^%T%R\u0019qO!\n\t\u000f\t\u001d\u0002\u00061\u0001\u0003*\u0005\u0011A\u000f\u001d\t\u0005\u0005W\u0011i#\u0004\u0002\u0003\u000e%!!q\u0006B\u0007\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fab\u0019:fCR,\u0007K]8ek\u000e,'/F\u0001r\u00031\u0019'/Z1uK\n\u0013xn[3s)\u0015\t(\u0011\bB\u001f\u0011\u001d\u0011Y\u0004\fa\u0001\u0003\u001b\u000b!!\u001b3\t\u0013\t}B\u0006%AA\u0002\t\u0005\u0013aG3oC\ndW-\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eE\u0002_\u0005\u0007J1A!\u0012`\u0005\u001d\u0011un\u001c7fC:\fac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0017RCA!\u0011\u0002\u001a\u0002")
public class EpochDrivenReplicationProtocolAcceptanceTest
extends ZooKeeperTestHarness {
    private final ApiVersion apiVersion = ApiVersion$.MODULE$.latestVersion();
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Seq<KafkaServer> brokers = null;
    private KafkaProducer<byte[], byte[]> producer = null;
    private KafkaConsumer<byte[], byte[]> consumer = null;

    public ApiVersion apiVersion() {
        return this.apiVersion;
    }

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldFollowLeaderEpochBasicWorkflow() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$1 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$1), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((int)0, (int)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((int)0, (int)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.bounce(this.follower());
        this.awaitISR(tp);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        Assertions.assertEquals((int)1, (int)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((int)1, (int)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        this.bounce(this.leader());
        this.awaitISR(tp);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((int)2, (int)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((int)2, (int)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.follower()).epochEntries());
    }

    @Test
    public void shouldNotAllowDivergentLogs() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)id -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        KafkaServer broker100 = (KafkaServer)this.brokers().apply(0);
        KafkaServer broker101 = (KafkaServer)this.brokers().apply(1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable & scala.Serializable)i -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$2(this, BoxesRunTime.unboxToInt((Object)i)));
        broker101.shutdown();
        broker100.shutdown();
        new File((String)broker100.config().logDirs().head(), Log$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(5 * this.msg().length, broker100, 0);
        broker100.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable & scala.Serializable)i -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$3(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> (RecordMetadata)x$2.get());
        broker101.startup();
        this.waitForLogsToMatch(broker100, broker101, this.waitForLogsToMatch$default$3());
        Assertions.assertEquals((long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length(), (String)"Log files should match Broker0 vs Broker 1");
    }

    @Test
    public void offsetsShouldNotGoBackwards() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$3 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$3), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            b.shutdown();
            return BoxedUnit.UNIT;
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), Log$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length() / 2L, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable & scala.Serializable)x$4 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$4(this, BoxesRunTime.unboxToInt((Object)x$4)));
        this.producer().flush();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable & scala.Serializable)x$5 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$5(this, BoxesRunTime.unboxToInt((Object)x$5)));
        this.producer().flush();
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        this.startConsumer();
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(this.consumer(), 100, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        LongRef prevOffset = LongRef.create((long)-1L);
        records.foreach((Function1 & Serializable & scala.Serializable)r -> {
            EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$6(prevOffset, r);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length(), (String)"Log files should match Broker0 vs Broker 1");
    }

    @Test
    public void shouldSurviveFastLeaderChange() {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$6 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$6), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        IntRef messagesWritten = IntRef.create((int)1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
            KafkaServer leader = (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$3(leaderId, x$7)))).apply(0);
            KafkaServer follower = (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$4(leaderId, x$8)))).apply(0);
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
            ++messagesWritten$1.elem;
            this.bounce(follower);
            this.log(leader, follower);
            this.awaitISR(tp);
            this.bounce(leader);
            this.log(leader, follower);
            this.awaitISR(tp);
            Assertions.assertTrue((boolean)this.brokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$5(this, messagesWritten, broker))));
        });
    }

    @Test
    public void logsShouldNotDivergeOnUncleanLeaderElections() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$9 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$9), true), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers(), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.MinInSyncReplicasProp(), (Object)"1")})));
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        Seq seq = this.crcSeq$1((KafkaServer)this.brokers().apply(0), EpochDrivenReplicationProtocolAcceptanceTest.crcSeq$default$2$1());
        Seq seq2 = this.crcSeq$1((KafkaServer)this.brokers().apply(1), EpochDrivenReplicationProtocolAcceptanceTest.crcSeq$default$2$1());
        Assertions.assertTrue((!(seq != null ? !seq.equals(seq2) : seq2 != null) ? 1 : 0) != 0, (String)"Logs on Broker 100 and Broker 101 should match");
    }

    private void log(KafkaServer leader, KafkaServer follower) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Bounce complete for follower ").append(follower.config().brokerId()).toString());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Leader: leo").append(leader.config().brokerId()).append(": ").append(this.getLog(leader, 0).logEndOffset()).append(" cache: ").append(this.epochCache(leader).epochEntries()).toString());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Follower: leo").append(follower.config().brokerId()).append(": ").append(this.getLog(follower, 0).logEndOffset()).append(" cache: ").append(this.epochCache(follower).epochEntries()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForLogsToMatch(KafkaServer b1, KafkaServer b2, int partition) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$waitForLogsToMatch$1(this, b1, partition, b2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$waitForLogsToMatch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private int waitForLogsToMatch$default$3() {
        return 0;
    }

    private void printSegments() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker0:");
        DumpLogSegments$.MODULE$.main((String[])new .colon.colon((Object)"--files", (List)new .colon.colon((Object)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).getCanonicalPath(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker1:");
        DumpLogSegments$.MODULE$.main((String[])new .colon.colon((Object)"--files", (List)new .colon.colon((Object)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).getCanonicalPath(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private KafkaConsumer<byte[], byte[]> startConsumer() {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        consumerConfig.put("fetch.max.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        consumerConfig.put("max.partition.fetch.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        this.consumer_$eq((KafkaConsumer<byte[], byte[]>)new KafkaConsumer(consumerConfig, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), 0), (List)Nil$.MODULE$)).asJava());
        this.consumer().seek(new TopicPartition(this.topic(), 0), 0L);
        return this.consumer();
    }

    private void deleteMessagesFromLogFile(long bytes, KafkaServer broker, int partitionId) {
        File logFile = this.getLogFile(broker, partitionId);
        RandomAccessFile writable = new RandomAccessFile(logFile, "rwd");
        writable.setLength(logFile.length() - bytes);
        writable.close();
    }

    private KafkaProducer<byte[], byte[]> createBufferingProducer() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = -1;
        int x$3 = 10000;
        int x$4 = this.msg().length * 1000;
        String x$5 = "snappy";
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$11 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$12 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$13 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$1, x$2, x$6, x$7, x$8, x$9, x$3, x$4, x$5, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    private File getLogFile(KafkaServer broker, int partition) {
        Log log = this.getLog(broker, partition);
        log.flush();
        return ((File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])log.dir().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$getLogFile$1(x$11))))[0];
    }

    private Log getLog(KafkaServer broker, int partition) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(this.topic(), partition);
        boolean x$2 = qual$1.getLog$default$2();
        return (Log)qual$1.getLog(x$1, x$2).orNull(Predef$.MODULE$.$conforms());
    }

    private void bounce(KafkaServer follower) {
        follower.shutdown();
        follower.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private LeaderEpochFileCache epochCache(KafkaServer broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache().get();
    }

    private RecordBatch latestRecord(KafkaServer leader, int offset, int partition) {
        LogSegment qual$1 = this.getLog(leader, partition).activeSegment();
        long x$1 = 0L;
        int x$2 = Integer.MAX_VALUE;
        long x$3 = qual$1.read$default$3();
        boolean x$4 = qual$1.read$default$4();
        return (RecordBatch)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(qual$1.read(x$1, x$2, x$3, x$4).records().batches()).asScala()).toSeq().last();
    }

    private int latestRecord$default$2() {
        return -1;
    }

    private int latestRecord$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$awaitISR$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$awaitISR$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
    }

    private KafkaServer leader() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$leader$1(leaderId, x$12)))).head();
    }

    private KafkaServer follower() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leader = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$follower$1(leader, x$13)))).head();
    }

    private KafkaServer createBroker(int id, boolean enableUncleanLeaderElection) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        TestUtils$.MODULE$.setIbpAndMessageFormatVersions(config, this.apiVersion());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(enableUncleanLeaderElection));
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    private boolean createBroker$default$2() {
        return false;
    }

    public static final /* synthetic */ RecordMetadata $anonfun$shouldNotAllowDivergentLogs$2(EpochDrivenReplicationProtocolAcceptanceTest $this, int i) {
        return (RecordMetadata)$this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)$this.msg())).get();
    }

    public static final /* synthetic */ Future $anonfun$shouldNotAllowDivergentLogs$3(EpochDrivenReplicationProtocolAcceptanceTest $this, int i) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$4(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$4) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$5(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$5) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ void $anonfun$offsetsShouldNotGoBackwards$6(LongRef prevOffset$1, ConsumerRecord r) {
        Assertions.assertTrue((r.offset() > prevOffset$1.elem ? 1 : 0) != 0, (String)new StringBuilder(21).append("Offset ").append(prevOffset$1.elem).append(" came before ").append(r.offset()).append(" ").toString());
        prevOffset$1.elem = r.offset();
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$3(int leaderId$1, KafkaServer x$7) {
        return x$7.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$4(int leaderId$1, KafkaServer x$8) {
        return x$8.config().brokerId() != leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$5(EpochDrivenReplicationProtocolAcceptanceTest $this, IntRef messagesWritten$1, KafkaServer broker) {
        return $this.getLog(broker, 0).logEndOffset() == (long)messagesWritten$1.elem;
    }

    private final Seq crcSeq$1(KafkaServer broker, int partition) {
        LogSegment qual$1 = this.getLog(broker, partition).activeSegment();
        long x$1 = 0L;
        int x$2 = Integer.MAX_VALUE;
        long x$3 = qual$1.read$default$3();
        boolean x$4 = qual$1.read$default$4();
        return (Seq)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(qual$1.read(x$1, x$2, x$3, x$4).records().batches()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.checksum()), Seq$.MODULE$.canBuildFrom());
    }

    private static final int crcSeq$default$2$1() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$waitForLogsToMatch$1(EpochDrivenReplicationProtocolAcceptanceTest $this, KafkaServer b1$1, int partition$1, KafkaServer b2$1) {
        return $this.getLog(b1$1, partition$1).logEndOffset() == $this.getLog(b2$1, partition$1).logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitForLogsToMatch$2() {
        return "Logs didn't match.";
    }

    public static final /* synthetic */ boolean $anonfun$getLogFile$1(File x$11) {
        return x$11.getName().endsWith(".log");
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(EpochDrivenReplicationProtocolAcceptanceTest $this, TopicPartition tp$2) {
        return ((Partition)$this.leader().replicaManager().onlinePartition(tp$2).get()).inSyncReplicaIds().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    public static final /* synthetic */ boolean $anonfun$leader$1(int leaderId$2, KafkaServer x$12) {
        return x$12.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$follower$1(int leader$2, KafkaServer x$13) {
        return x$13.config().brokerId() != leader$2;
    }

    public EpochDrivenReplicationProtocolAcceptanceTest() {
        this.topic = "topic1";
    }
}

