/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogTestUtils$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004?\u0001\u0001\u0006IA\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u00016\u0011\u0019\u0001\u0005\u0001)A\u0005m!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB%\u0001A\u0003%1\tC\u0004K\u0001\t\u0007I\u0011A&\t\rY\u0003\u0001\u0015!\u0003M\u0011\u001d9\u0006A1A\u0005\u0002-Ca\u0001\u0017\u0001!\u0002\u0013a\u0005bB-\u0001\u0005\u0004%\ta\u0013\u0005\u00075\u0002\u0001\u000b\u0011\u0002'\t\u000fm\u0003!\u0019!C\u00019\"11\r\u0001Q\u0001\nuCq\u0001\u001a\u0001C\u0002\u0013\u0005Q\r\u0003\u0004r\u0001\u0001\u0006IA\u001a\u0005\ne\u0002\u0001\r\u00111A\u0005\u0002MD\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001>\t\u0015\u0005\u0005\u0001\u00011A\u0001B\u0003&A\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002\u0006!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0017\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003o\u0001A\u0011AA\u0003\u0011\u001d\tY\u0004\u0001C\u0001\u0003\u000bAq!a\u0010\u0001\t\u0003\t)\u0001C\u0004\u0002D\u0001!\t!!\u0002\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\u0006!9\u00111\n\u0001\u0005\n\u00055\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!!'\u0001\t\u0013\t)AA\nEk6\u0004Hj\\4TK\u001elWM\u001c;t)\u0016\u001cHO\u0003\u0002&M\u0005)Ao\\8mg*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u00051A/\u001c9ESJ,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\n!![8\u000b\u0003m\nAA[1wC&\u0011Q\b\u000f\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\n1b]3h[\u0016tGOT1nKV\t1\t\u0005\u0002E\u000f6\tQI\u0003\u0002Gu\u0005!A.\u00198h\u0013\tAUI\u0001\u0004TiJLgnZ\u0001\rg\u0016<W.\u001a8u\u001d\u0006lW\rI\u0001\fY><g)\u001b7f!\u0006$\b.F\u0001M!\tiEK\u0004\u0002O%B\u0011q\nL\u0007\u0002!*\u0011\u0011\u000bK\u0001\u0007yI|w\u000e\u001e \n\u0005Mc\u0013A\u0002)sK\u0012,g-\u0003\u0002I+*\u00111\u000bL\u0001\rY><g)\u001b7f!\u0006$\b\u000eI\u0001\u000eS:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5\u0002\u001d%tG-\u001a=GS2,\u0007+\u0019;iA\u0005\tB/[7f\u0013:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5\u0002%QLW.Z%oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0005i&lW-F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001g%A\u0003vi&d7/\u0003\u0002c?\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004cCR\u001c\u0007.Z:\u0016\u0003\u0019\u00042a\u001a7o\u001b\u0005A'BA5k\u0003\u001diW\u000f^1cY\u0016T!a\u001b\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002nQ\nY\u0011I\u001d:bs\n+hMZ3s!\t\u0019t.\u0003\u0002qI\tI!)\u0019;dQ&sgm\\\u0001\tE\u0006$8\r[3tA\u0005\u0019An\\4\u0016\u0003Q\u0004\"!^<\u000e\u0003YT!A\u001d\u0014\n\u0005a4(a\u0001'pO\u00069An\\4`I\u0015\fHCA>\u007f!\tYC0\u0003\u0002~Y\t!QK\\5u\u0011\u001dy8#!AA\u0002Q\f1\u0001\u001f\u00132\u0003\u0011awn\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0003mD3!FA\u0005!\u0011\tY!!\b\u000e\u0005\u00055!\u0002BA\b\u0003#\t1!\u00199j\u0015\u0011\t\u0019\"!\u0006\u0002\u000f),\b/\u001b;fe*!\u0011qCA\r\u0003\u0015QWO\\5u\u0015\t\tY\"A\u0002pe\u001eLA!a\b\u0002\u000e\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u0005$GmU5na2,'+Z2pe\u0012\u001c\u0018\u0001\u0003;fCJ$un\u001e8)\u0007]\t9\u0003\u0005\u0003\u0002\f\u0005%\u0012\u0002BA\u0016\u0003\u001b\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002AQ,7\u000f\u001e\"bi\u000eD\u0017I\u001c3SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PkR\u0004X\u000f\u001e\u0015\u00041\u0005E\u0002\u0003BA\u0006\u0003gIA!!\u000e\u0002\u000e\t!A+Z:u\u0003A!Xm\u001d;Qe&tG\u000fR1uC2{w\rK\u0002\u001a\u0003c\tq\u0003^3ti\u0012+X\u000e]%oI\u0016DX*[:nCR\u001c\u0007.Z:)\u0007i\t\t$A\fuKN$H)^7q)&lW-\u00138eKb,%O]8sg\"\u001a1$!\r\u0002/Q,7\u000f\u001e#v[BlU\r^1eCR\f'+Z2pe\u0012\u001c\bf\u0001\u000f\u00022\u0005\u0011B/Z:u\tVl\u0007/R7qifLe\u000eZ3yQ\ri\u0012\u0011G\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000fF\u0002M\u0003\u001fBq!!\u0015\u001f\u0001\u0004\t\u0019&\u0001\u0003be\u001e\u001c\b\u0003B\u0016\u0002V1K1!a\u0016-\u0005\u0015\t%O]1z\u0003E\u0011X-\u00193CCR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0005\u0003;\n\u0019\u0007\u0005\u0003,\u0003?b\u0015bAA1Y\t1q\n\u001d;j_:Dq!!\u001a \u0001\u0004\t9'A\u0003mS:,7\u000fE\u0003\u0002j\u0005=D*\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\nYG\u0001\u0007MSN$\u0018\n^3sCR|'/\u0001\tsK\u0006$')\u0019;dQJ+7m\u001c:egR!\u0011qOAE!\u0015\tI(a!M\u001d\u0011\tY(a \u000f\u0007=\u000bi(C\u0001.\u0013\r\t\t\tL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t))a\"\u0003\u0007M+\u0017OC\u0002\u0002\u00022Bq!!\u001a!\u0001\u0004\t9'A\nqCJ\u001cX-T3uC\u0012\fG/\u0019$jK2$7\u000f\u0006\u0003\u0002\u0010\u0006U\u0005#B'\u0002\u00122c\u0015bAAJ+\n\u0019Q*\u00199\t\r\u0005]\u0015\u00051\u0001M\u0003\u0011a\u0017N\\3\u00027\u0005\u001c8/\u001a:u\tVl\u0007\u000fT8h%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0001")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        None$ x$11 = None$.MODULE$;
        boolean x$12 = true;
        boolean x$13 = Log$.MODULE$.apply$default$11();
        this.log_$eq(Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$13, (Option)x$11, x$12));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable & scala.Serializable)batchInfo -> {
            Log qual$1 = this.log();
            MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            int x$2 = 0;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            ApiVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        });
        this.log().flush();
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBatchAndRecordMetadataOutput() {
        Log qual$1 = this.log();
        MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())});
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        Log qual$2 = this.log();
        MemoryRecords x$6 = MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())});
        int x$7 = 3;
        AppendOrigin x$8 = qual$2.appendAsLeader$default$3();
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, x$8, x$9, x$10);
        Log qual$3 = this.log();
        MemoryRecords x$11 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())});
        int x$12 = 3;
        AppendOrigin x$13 = qual$3.appendAsLeader$default$3();
        ApiVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
        Log qual$4 = this.log();
        MemoryRecords x$16 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)29342342L, (short)((short)15), (int)234123, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("h".getBytes())});
        int x$17 = 3;
        AppendOrigin x$18 = qual$4.appendAsLeader$default$3();
        ApiVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
        Log qual$5 = this.log();
        MemoryRecords x$21 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.GZIP, (long)98323L, (short)((short)99), (int)266, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())});
        int x$22 = 5;
        AppendOrigin x$23 = qual$5.appendAsLeader$default$3();
        ApiVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, x$22, x$23, x$24, x$25);
        Log qual$6 = this.log();
        MemoryRecords x$26 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin.Coordinator$ x$27 = AppendOrigin.Coordinator$.MODULE$;
        int x$28 = 7;
        ApiVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, x$28, (AppendOrigin)x$27, x$29, x$30);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpMetadataRecords() {
        MockTime mockTime = new MockTime();
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        Log log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), mockTime.scheduler(), (Time)mockTime, LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12());
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)message -> {
            MetadataRecordSerde serde = new MetadataRecordSerde();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.flush();
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "false", "--files", this.logFilePath()}));
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()}));
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(null, buf.array())}), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()}));
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        Predef$.MODULE$.assert(output.contains("skipping"));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = Map$.MODULE$.empty();
        Iterator tokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$parseMetadataFields$2(x$3))))).iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap(Predef$.MODULE$.$conforms());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = this.log().read(0L, Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()})).split("\n")).listIterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.records().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)recordIndex -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$1) {
        return x$1.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$1)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseMetadataFields$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$3(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$4(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$5(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$6(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$7(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$8(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toLong();
    }

    public static final /* synthetic */ short $anonfun$assertDumpLogRecordMetadata$9(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toShort();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$10(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$12(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$13(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toInt();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$14(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$15(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$16(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$12(x$13))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$13(x$14))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$14(x$15))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$15(x$16))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$16(x$17))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$2(x$4))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$3(x$5))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$4(x$6))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$5(x$7))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$6(x$8))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$7(x$9))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$8(x$10))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToShort((short)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$9(x$11))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$10(x$12))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

