/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.Both$;
import kafka.api.EndToEndAuthorizationTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00044\u0001\u0001\u0006Ia\u000b\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019\u0001\u0005\u0001)A\u0005m!)\u0011\t\u0001C)\u0005\"9!\u000b\u0001b\u0001\n#\u001a\u0006BB/\u0001A\u0003%A\u000bC\u0004_\u0001\t\u0007I\u0011K*\t\r}\u0003\u0001\u0015!\u0003U\u0011\u001d\u0001\u0007A1A\u0005B\u0005Da!\u001a\u0001!\u0002\u0013\u0011\u0007b\u00024\u0001\u0005\u0004%IA\u000b\u0005\u0007O\u0002\u0001\u000b\u0011B\u0016\t\u000f!\u0004!\u0019!C!C\"1\u0011\u000e\u0001Q\u0001\n\tDqA\u001b\u0001C\u0002\u0013%!\u0006\u0003\u0004l\u0001\u0001\u0006Ia\u000b\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019q\u0007\u0001)A\u0005/\")q\u000e\u0001C!a\")A\u000f\u0001C!k\")a\u0010\u0001C!a\")q\u0010\u0001C\u0001a\"9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0002)\t\u0016dWmZ1uS>tGk\\6f]\u0016sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f\u001e\u0006\u0003;y\t1!\u00199j\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003qI!!\n\u000f\u00033\u0015sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"a\t\u0001\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u0015;sS:<\u0017!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\ta\u0007E\u00028{-r!\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\nq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\t!A*[:u\u0015\ta\u0014(\u0001\u000elC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001c\b%\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\t1\t\u0005\u0002E!6\tQI\u0003\u0002G\u000f\u0006!\u0011-\u001e;i\u0015\tA\u0015*\u0001\u0005tK\u000e,(/\u001b;z\u0015\tQ5*\u0001\u0004d_6lwN\u001c\u0006\u0003?1S!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO&\u0011\u0011+\u0012\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\fAc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001cX#\u0001+\u0011\u0007a*v+\u0003\u0002Ws\t!1k\\7f!\tA6,D\u0001Z\u0015\tQv&\u0001\u0003vi&d\u0017B\u0001/Z\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:!\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013aD2mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197\u0016\u0003\t\u0004\"\u0001R2\n\u0005\u0011,%AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u0011G2LWM\u001c;Qe&t7-\u001b9bY\u0002\nab\u00197jK:$\b+Y:to>\u0014H-A\bdY&,g\u000e\u001e)bgN<xN\u001d3!\u00039Y\u0017MZ6b!JLgnY5qC2\fqb[1gW\u0006\u0004&/\u001b8dSB\fG\u000eI\u0001\u000eW\u000647.\u0019)bgN<xN\u001d3\u0002\u001d-\fgm[1QCN\u001cxo\u001c:eA\u0005Y\u0002O]5wS2,w-\u001a3BI6Lgn\u00117jK:$8i\u001c8gS\u001e,\u0012aV\u0001\u001daJLg/\u001b7fO\u0016$\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4!\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012!\u001d\t\u0003qIL!a]\u001d\u0003\tUs\u0017\u000e^\u0001\u001cGJ,\u0017\r^3Qe&4\u0018\u000e\\3hK\u0012\fE-\\5o\u00072LWM\u001c;\u0015\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u000b\u0005$W.\u001b8\u000b\u0005m\\\u0015aB2mS\u0016tGo]\u0005\u0003{b\u0014Q!\u00113nS:\f!eY8oM&<WO]3TK\u000e,(/\u001b;z\u0003\u001a$XM]*feZ,'o]*uCJ$\u0018!\t;fgR\u001c%/Z1uKV\u001bXM],ji\"$U\r\\3hCRLwN\u001c+pW\u0016t\u0007f\u0001\r\u0002\u0004A!\u0011QAA\t\u001b\t\t9AC\u0002\u001e\u0003\u0013QA!a\u0003\u0002\u000e\u00059!.\u001e9ji\u0016\u0014(bAA\b\u001d\u0006)!.\u001e8ji&!\u00111CA\u0004\u0005\u0011!Vm\u001d;\u0002\u000bM,G/\u00169\u0015\u0007E\fI\u0002C\u0004\u0002\u001ce\u0001\r!!\b\u0002\u0011Q,7\u000f^%oM>\u0004B!!\u0002\u0002 %!\u0011\u0011EA\u0004\u0005!!Vm\u001d;J]\u001a|\u0007fA\r\u0002&A!\u0011QAA\u0014\u0013\u0011\tI#a\u0002\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\fde\u0016\fG/\u001a#fY\u0016<\u0017\r^5p]R{7.\u001a8t)\t\ty\u0003E\u00049\u0003c\t)$!\u000e\n\u0007\u0005M\u0012H\u0001\u0004UkBdWM\r\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003)!W\r\\3hCRLwN\u001c\u0006\u0004\u0003\u007f9\u0015!\u0002;pW\u0016t\u0017\u0002BA\"\u0003s\u0011q\u0002R3mK\u001e\fG/[8o)>\\WM\u001c")
public class DelegationTokenEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ScramMechanism.mechanismNames()).asScala()).toList();
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    private final KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser());
    private final String clientPassword = JaasTestUtils$.MODULE$.KafkaScramPassword();
    private final KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramAdmin());
    private final String kafkaPassword = JaasTestUtils$.MODULE$.KafkaScramAdminPassword();
    private final Properties privilegedAdminClientConfig = new Properties();

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public KafkaPrincipal clientPrincipal() {
        return this.clientPrincipal;
    }

    private String clientPassword() {
        return this.clientPassword;
    }

    @Override
    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    private String kafkaPassword() {
        return this.kafkaPassword;
    }

    private Properties privilegedAdminClientConfig() {
        return this.privilegedAdminClientConfig;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), this.kafkaPrincipal().getName(), this.kafkaPassword());
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());
    }

    @Override
    public void configureSecurityAfterServersStart() {
        super.configureSecurityAfterServersStart();
        this.createScramCredentialsViaPrivilegedAdminClient(this.clientPrincipal().getName(), this.clientPassword());
        this.waitForUserScramCredentialToAppearOnAllBrokers(this.clientPrincipal().getName(), this.kafkaClientSaslMechanism());
        Tuple2<DelegationToken, DelegationToken> tokens = this.createDelegationTokens();
        DelegationToken token = (DelegationToken)tokens._1();
        DelegationToken privilegedToken = (DelegationToken)tokens._2();
        this.privilegedAdminClientConfig().putAll((Map<?, ?>)this.adminClientConfig());
        String clientLoginContext = JaasTestUtils$.MODULE$.tokenClientLoginModule(token.tokenInfo().tokenId(), token.hmacAsBase64String());
        this.producerConfig().put("sasl.jaas.config", clientLoginContext);
        this.consumerConfig().put("sasl.jaas.config", clientLoginContext);
        this.adminClientConfig().put("sasl.jaas.config", clientLoginContext);
        String privilegedClientLoginContext = JaasTestUtils$.MODULE$.tokenClientLoginModule(privilegedToken.tokenInfo().tokenId(), privilegedToken.hmacAsBase64String());
        this.privilegedAdminClientConfig().put("sasl.jaas.config", privilegedClientLoginContext);
    }

    @Test
    public void testCreateUserWithDelegationToken() {
        try (Admin privilegedAdminClient = Admin.create((Properties)this.privilegedAdminClientConfig());){
            String user = "user";
            AlterUserScramCredentialsResult results = privilegedAdminClient.alterUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UserScramCredentialUpsertion(user, new ScramCredentialInfo(org.apache.kafka.clients.admin.ScramMechanism.SCRAM_SHA_256, 4096), "password"), (List)Nil$.MODULE$)).asJava());
            Assertions.assertEquals((int)1, (int)results.values().size());
            ((KafkaFuture)results.values().get(user)).get();
        }
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        super.setUp(testInfo);
        this.privilegedAdminClientConfig().put("bootstrap.servers", this.brokerList());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<DelegationToken, DelegationToken> createDelegationTokens() {
        Tuple2 tuple2;
        try (Admin adminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.clientPrincipal().getName(), this.clientPassword());
             Admin privilegedAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());){
            DelegationToken token = (DelegationToken)adminClient.createDelegationToken().delegationToken().get();
            DelegationToken privilegedToken = (DelegationToken)privilegedAdminClient.createDelegationToken().delegationToken().get();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$1(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            tuple2 = new Tuple2((Object)token, (Object)privilegedToken);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$createDelegationTokens$2(KafkaServer server) {
        return server.tokenCache().tokens().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$createDelegationTokens$1(DelegationTokenEndToEndAuthorizationTest $this) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$2(server)));
    }

    public static final /* synthetic */ String $anonfun$createDelegationTokens$3() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public DelegationTokenEndToEndAuthorizationTest() {
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), "testKey");
    }
}

