/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r}g\u0001\u0002,X\u0001qCQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001a\u0001\u0005\u0002\u00154q\u0001\u001f\u0001\u0011\u0002\u0007\u0005\u0011\u0010\u0003\u0004\u0002(\r!\t!\u001a\u0005\n\u0003S\u0019\u0001\u0019!C\u0001\u0003WA\u0011\"a\r\u0004\u0001\u0004%\t!!\u000e\t\u000f\u0005m2\u0001\"\u0011\u0002>!9\u0011QN\u0002\u0005B\u0005=\u0004BBAR\u0007\u0011\u0005S\rC\u0004\u0002<\r!\t%!*\u0007\u0013\u0005-\u0006\u0001%A\u0002\u0002\u00055\u0006BBA\u0014\u0017\u0011\u0005Q\rC\u0005\u00026.\u0001\r\u0011\"\u0001\u00028\"I\u0011qX\u0006A\u0002\u0013\u0005\u0011\u0011\u0019\u0005\b\u0003\u000b\\A\u0011IAd\u0011\u001d\tig\u0003C!\u0003\u001fDa!a)\f\t\u0003*\u0007bBAc\u0017\u0011\u0005\u0013q\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u0019\ti\u000f\u0001C\u0001K\"1!\u0011\u0001\u0001\u0005\u0002\u0015DaA!\u0002\u0001\t\u0003)\u0007B\u0002B\u0005\u0001\u0011\u0005Q\r\u0003\u0004\u0003\u000e\u0001!\t!\u001a\u0005\u0007\u0005#\u0001A\u0011A3\t\r\tU\u0001\u0001\"\u0001f\u0011\u0019\u0011I\u0002\u0001C\u0001K\"1!Q\u0004\u0001\u0005\u0002\u0015DaA!\t\u0001\t\u0003)\u0007B\u0002B\u0013\u0001\u0011\u0005Q\r\u0003\u0004\u0003*\u0001!\t!\u001a\u0005\u0007\u0005[\u0001A\u0011A3\t\r\tE\u0002\u0001\"\u0001f\u0011\u0019\u0011)\u0004\u0001C\u0001K\"1!\u0011\b\u0001\u0005\u0002\u0015DaA!\u0010\u0001\t\u0003)\u0007B\u0002B!\u0001\u0011\u0005Q\r\u0003\u0004\u0003F\u0001!\t!\u001a\u0005\u0007\u0005\u0013\u0002A\u0011A3\t\r\t5\u0003\u0001\"\u0001f\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'BaAa\u001b\u0001\t\u0003)\u0007B\u0002B8\u0001\u0011\u0005Q\r\u0003\u0004\u0003t\u0001!\t!\u001a\u0005\u0007\u0005o\u0002A\u0011A3\t\u000f\tm\u0004\u0001\"\u0003\u0003~!1!1\u0011\u0001\u0005\u0002\u0015DqAa\"\u0001\t\u0013\u0011I\t\u0003\u0004\u0003\u0010\u0002!\t!\u001a\u0005\u0007\u0005'\u0003A\u0011A3\t\r\t]\u0005\u0001\"\u0001f\u0011\u0019\u0011Y\n\u0001C\u0001K\"1!q\u0014\u0001\u0005\u0002\u0015DaAa)\u0001\t\u0003)\u0007B\u0002BT\u0001\u0011\u0005Q\r\u0003\u0004\u0003,\u0002!\t!\u001a\u0005\u0007\u0005_\u0003A\u0011A3\t\r\tM\u0006\u0001\"\u0001f\u0011\u0019\u00119\f\u0001C\u0001K\"1!1\u0018\u0001\u0005\u0002\u0015DaAa0\u0001\t\u0003)\u0007B\u0002Bb\u0001\u0011\u0005Q\r\u0003\u0004\u0003H\u0002!\t!\u001a\u0005\u0007\u0005\u0017\u0004A\u0011A3\t\r\t=\u0007\u0001\"\u0001f\u0011\u0019\u0011\u0019\u000e\u0001C\u0001K\"1!q\u001b\u0001\u0005\u0002\u0015DaAa7\u0001\t\u0003)\u0007B\u0002Bp\u0001\u0011\u0005Q\r\u0003\u0004\u0003d\u0002!\t!\u001a\u0005\u0007\u0005O\u0004A\u0011A3\t\r\t-\b\u0001\"\u0001f\u0011\u0019\u0011y\u000f\u0001C\u0001K\"1!1\u001f\u0001\u0005\u0002\u0015DaAa>\u0001\t\u0003)\u0007B\u0002B~\u0001\u0011\u0005Q\rC\u0004\u0003\u0000\u0002!\ta!\u0001\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!911\u000b\u0001\u0005\u0002\rU\u0003bBB7\u0001\u0011\u00051q\u000e\u0005\b\u0007s\u0002A\u0011AB>\u0011\u001d\u0019\u0019\u000b\u0001C\u0005\u0007KCqaa0\u0001\t\u0013\u0019\t\r\u0003\u0004\u0004X\u0002!\t!\u001a\u0005\u0007\u00077\u0004A\u0011A3\u0003+Ac\u0017-\u001b8uKb$8i\u001c8tk6,'\u000fV3ti*\u0011\u0001,W\u0001\u0004CBL'\"\u0001.\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0018\t\u0003=~k\u0011aV\u0005\u0003A^\u0013\u0001CQ1tK\u000e{gn];nKJ$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0019\u0007C\u00010\u0001\u0003-!Xm\u001d;IK\u0006$WM]:\u0015\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014A!\u00168ji\"\u0012!!\u001c\t\u0003]Zl\u0011a\u001c\u0006\u00031BT!!\u001d:\u0002\u000f),\b/\u001b;fe*\u00111\u000f^\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002k\u0006\u0019qN]4\n\u0005]|'\u0001\u0002+fgR\u0014abU3sS\u0006d\u0017N_3s\u00136\u0004Hn\u0005\u0003\u0004u\u0006\u0015\u0001cA>\u0002\u00025\tAP\u0003\u0002~}\u0006!A.\u00198h\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001}\u0005\u0019y%M[3diB1\u0011qAA\f\u00037i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\u0005=\u0011\u0011C\u0001\u0007G>lWn\u001c8\u000b\u0007i\u000b\u0019BC\u0002\u0002\u0016Q\fa!\u00199bG\",\u0017\u0002BA\r\u0003\u0013\u0011!bU3sS\u0006d\u0017N_3s!\u00159\u0017QDA\u0011\u0013\r\ty\u0002\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004O\u0006\r\u0012bAA\u0013Q\n!!)\u001f;f\u0003\u0019!\u0013N\\5uI\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u0005\u00055\u0002\u0003BA\u0004\u0003_IA!!\r\u0002\n\t\u0019\")\u001f;f\u0003J\u0014\u0018-_*fe&\fG.\u001b>fe\u0006q1/\u001a:jC2L'0\u001a:`I\u0015\fHc\u00014\u00028!I\u0011\u0011\b\u0004\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0014!C:fe&\fG.\u001b>f)!\tY\"a\u0010\u0002Z\u0005%\u0004bBA!\u000f\u0001\u0007\u00111I\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003cAA%Q6\u0011\u00111\n\u0006\u0004\u0003\u001bZ\u0016A\u0002\u001fs_>$h(C\u0002\u0002R!\fa\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)Q\"9\u00111L\u0004A\u0002\u0005u\u0013a\u00025fC\u0012,'o\u001d\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u0007\u0003\u0019AW-\u00193fe&!\u0011qMA1\u0005\u001dAU-\u00193feNDq!a\u001b\b\u0001\u0004\tY\"\u0001\u0003eCR\f\u0017!C2p]\u001aLw-\u001e:f)\u00151\u0017\u0011OAM\u0011\u001d\t\u0019\b\u0003a\u0001\u0003k\nqaY8oM&<7\u000f\r\u0003\u0002x\u0005\u001d\u0005\u0003CA=\u0003\u007f\n\u0019%a!\u000e\u0005\u0005m$bAA?}\u0006!Q\u000f^5m\u0013\u0011\t\t)a\u001f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0006\u0006\u001dE\u0002\u0001\u0003\r\u0003\u0013\u000b\t(!A\u0001\u0002\u000b\u0005\u00111\u0012\u0002\u0004?\u0012\n\u0014\u0003BAG\u0003'\u00032aZAH\u0013\r\t\t\n\u001b\u0002\b\u001d>$\b.\u001b8h!\r9\u0017QS\u0005\u0004\u0003/C'aA!os\"9\u00111\u0014\u0005A\u0002\u0005u\u0015!B5t\u0017\u0016L\bcA4\u0002 &\u0019\u0011\u0011\u00155\u0003\u000f\t{w\u000e\\3b]\u0006)1\r\\8tKR1\u00111DAT\u0003SCq!!\u0011\u000b\u0001\u0004\t\u0019\u0005C\u0004\u0002l)\u0001\r!a\u0007\u0003!\u0011+7/\u001a:jC2L'0\u001a:J[Bd7\u0003B\u0006{\u0003_\u0003b!a\u0002\u00022\u0006m\u0011\u0002BAZ\u0003\u0013\u0011A\u0002R3tKJL\u0017\r\\5{KJ\fA\u0002Z3tKJL\u0017\r\\5{KJ,\"!!/\u0011\t\u0005\u001d\u00111X\u0005\u0005\u0003{\u000bIAA\u000bCsR,\u0017I\u001d:bs\u0012+7/\u001a:jC2L'0\u001a:\u0002!\u0011,7/\u001a:jC2L'0\u001a:`I\u0015\fHc\u00014\u0002D\"I\u0011\u0011\b\b\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0005\u0002\u001c\u0005%\u00171ZAg\u0011\u001d\t\te\u0004a\u0001\u0003\u0007Bq!a\u0017\u0010\u0001\u0004\ti\u0006C\u0004\u0002l=\u0001\r!a\u0007\u0015\u000b\u0019\f\t.!8\t\u000f\u0005M\u0004\u00031\u0001\u0002TB\"\u0011Q[Am!!\tI(a \u0002D\u0005]\u0007\u0003BAC\u00033$A\"a7\u0002R\u0006\u0005\t\u0011!B\u0001\u0003\u0017\u00131a\u0018\u00133\u0011\u001d\tY\n\u0005a\u0001\u0003;#b!a\u0007\u0002b\u0006\r\bbBA!%\u0001\u0007\u00111\t\u0005\b\u0003W\u0012\u0002\u0019AA\u000e\u0003}!Xm\u001d;IK\u0006$WM]:TKJL\u0017\r\\5{K\u0012+7/\u001a:jC2L'0\u001a\u000b\u0006M\u0006%\u00181\u001e\u0005\b\u0003S\u0019\u0002\u0019AA\u0003\u0011\u001d\t)l\u0005a\u0001\u0003_\u000bQ\u0005^3ti\u0012+\u0007O]3dCR,G\rU8mY\ncwnY6t\r>\u0014\u0018i]:jO:lWM\u001c;)\u0005Qi\u0007f\u0002\u000b\u0002t\u0006e\u0018Q \t\u0004O\u0006U\u0018bAA|Q\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005m\u0018!\t9pY2DC)\u001e:bi&|g.\u000b\u0011jg\u0002\"\b.\u001a\u0011sKBd\u0017mY3nK:$\u0018EAA\u0000\u0003\r\u0011d\u0006M\u0001\"i\u0016\u001cH\u000fS3bI\u0016\u00148oU3sS\u0006d\u0017N_3s\t\u0016\u001cXM]5bY&TXM\u001d\u0015\u0003+5\f!\u0003^3ti6\u000b\u0007\u0010U8mYJ+7m\u001c:eg\"\u0012a#\\\u0001\u0016i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'tQ\t9R.\u0001\u0014uKN$X*\u0019=Q_2d\u0017J\u001c;feZ\fG.T:EK2\f\u00170\u00138SKZ|7-\u0019;j_:D#\u0001G7\u0002MQ,7\u000f^'bqB{G\u000e\\%oi\u0016\u0014h/\u00197Ng\u0012+G.Y=J]\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002\u001a[\u0006)B/Z:u\u0003V$xnQ8n[&$xJ\\\"m_N,\u0007F\u0001\u000en\u0003\u0001\"Xm\u001d;BkR|7i\\7nSR|en\u00117pg\u0016\fe\r^3s/\u0006\\W-\u001e9)\u0005mi\u0017a\u0005;fgR\fU\u000f^8PM\u001a\u001cX\r\u001e*fg\u0016$\bF\u0001\u000fn\u0003Q!Xm\u001d;He>,\boQ8ogVl\u0007\u000f^5p]\"\u0012Q$\\\u0001\u0018i\u0016\u001cH\u000fU1ui\u0016\u0014hnU;cg\u000e\u0014\u0018\u000e\u001d;j_:D#AH7\u0002CQ,7\u000f^*vEN,\u0017/^3oiB\u000bG\u000f^3s]N+(m]2sSB$\u0018n\u001c8)\u0005}i\u0017!\u0007;fgR\u0004\u0016\r\u001e;fe:,fn];cg\u000e\u0014\u0018\u000e\u001d;j_:D#\u0001I7\u0002%Q,7\u000f^\"p[6LG/T3uC\u0012\fG/\u0019\u0015\u0003C5\fq\u0002^3ti\u0006\u001b\u0018P\\2D_6l\u0017\u000e\u001e\u0015\u0003E5\fq\u0004^3ti\u0016C\b/\u00198eS:<Gk\u001c9jGN+(m]2sSB$\u0018n\u001c8tQ\t\u0019S.A\u0010uKN$8\u000b\u001b:j].Lgn\u001a+pa&\u001c7+\u001e2tGJL\u0007\u000f^5p]ND#\u0001J7\u0002#Q,7\u000f\u001e)beRLG/[8og\u001a{'\u000f\u000b\u0002&[\u0006YB/Z:u!\u0006\u0014H/\u001b;j_:\u001chi\u001c:BkR|7I]3bi\u0016D#AJ7\u0002;Q,7\u000f\u001e)beRLG/[8og\u001a{'/\u00138wC2LG\rV8qS\u000eD#aJ7\u0002\u0011Q,7\u000f^*fK.D#\u0001K7\u0002-M,g\u000eZ\"p[B\u0014Xm]:fI6+7o]1hKN$RA\u001aB+\u0005?BqAa\u0016*\u0001\u0004\u0011I&\u0001\u0006ok6\u0014VmY8sIN\u00042a\u001aB.\u0013\r\u0011i\u0006\u001b\u0002\u0004\u0013:$\bb\u0002B1S\u0001\u0007!1M\u0001\u0003iB\u0004BA!\u001a\u0003h5\u0011\u0011QB\u0005\u0005\u0005S\niA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002+Q,7\u000f\u001e)pg&$\u0018n\u001c8B]\u0012\u001cu.\\7ji\"\u0012!&\\\u0001\u001ci\u0016\u001cH\u000fU1si&$\u0018n\u001c8QCV\u001cX-\u00118e%\u0016\u001cX/\\3)\u0005-j\u0017A\u0006;fgR4U\r^2i\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;)\u00051j\u0017A\n;fgR4U\r^2i%\u0016\u001cwN\u001d3MCJ<WM\u001d+iC:4U\r^2i\u001b\u0006D()\u001f;fg\"\u0012Q&\\\u0001\u0011G\",7m\u001b'be\u001e,'+Z2pe\u0012$2A\u001aB@\u0011\u001d\u0011\tI\fa\u0001\u00053\n!\u0003\u001d:pIV\u001cWM\u001d*fG>\u0014HmU5{K\u0006qC/Z:u\r\u0016$8\r\u001b%p]>,(o\u001d$fi\u000eD7+\u001b>f\u0013\u001ad\u0015M]4f%\u0016\u001cwN\u001d3O_R4\u0015N]:uQ\tyS.\u0001\u0016dQ\u0016\u001c7NR3uG\"DuN\\8veN\u001c\u0016N_3JM2\u000b'oZ3SK\u000e|'\u000f\u001a(pi\u001aK'o\u001d;\u0015\u0007\u0019\u0014Y\tC\u0004\u0003\u000eB\u0002\rA!\u0017\u0002/1\f'oZ3Qe>$WoY3s%\u0016\u001cwN\u001d3TSj,\u0017a\u000f;fgR4U\r^2i\u0011>tw.\u001e:t\u001b\u0006D\b+\u0019:uSRLwN\u001c$fi\u000eD')\u001f;fg&3G*\u0019:hKJ+7m\u001c:e\u001d>$h)\u001b:ti\"\u0012\u0011'\\\u00010i\u0016\u001cHOR3uG\"\u0014VmY8sI2\u000b'oZ3s)\"\fg.T1y!\u0006\u0014H/\u001b;j_:4U\r^2i\u0005f$Xm\u001d\u0015\u0003e5\f\u0011\u0006^3ti2{w/T1y\r\u0016$8\r[*ju\u00164uN\u001d*fcV,7\u000f^!oIB\u000b'\u000f^5uS>t\u0007FA\u001an\u0003a!Xm\u001d;S_VtGMU8cS:\f5o]5h]6,g\u000e\u001e\u0015\u0003i5\f1\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s%>,h\u000e\u001a*pE&t\u0017i]:jO:|'\u000f\u000b\u00026[\u0006yB/Z:u\u001bVdG/[\"p]N,X.\u001a:Ti&\u001c7._!tg&<gn\u001c:)\u0005Yj\u0017\u0001\t;fgRlU\u000f\u001c;j\u0007>t7/^7fe\u0012+g-Y;mi\u0006\u001b8/[4o_JD#aN7\u0002gQ,7\u000f^'vYRL7i\u001c8tk6,'\u000fR3gCVdG/Q:tS\u001etwN]!oIZ+'/\u001b4z\u0003N\u001c\u0018n\u001a8nK:$\bF\u0001\u001dn\u00031\"Xm\u001d;Nk2$\u0018nQ8ogVlWM]*fgNLwN\u001c+j[\u0016|W\u000f^(o'R|\u0007\u000fU8mY&tw\r\u000b\u0002:[\u00061C/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]\u000ecwn]3)\u0005ij\u0017\u0001\u0005;fgRLe\u000e^3sG\u0016\u0004Ho\u001c:tQ\tYT.A\fuKN$\u0018)\u001e;p\u0007>lW.\u001b;J]R,'oY3qi\"\u0012A(\\\u0001\"i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peN<\u0016\u000e\u001e5Xe>twmS3z-\u0006dW/\u001a\u0015\u0003{5\f\u0011\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016D#AP7\u0002IQ,7\u000f^\"p]N,X.Z'fgN\fw-Z:XSRDGj\\4BaB,g\u000e\u001a+j[\u0016D#aP7\u0002\u001dQ,7\u000f\u001e'jgR$v\u000e]5dg\"\u0012\u0001)\\\u0001\u0015i\u0016\u001cH/\u00168tk\n\u001c8M]5cKR{\u0007/[2)\u0005\u0005k\u0017!\n;fgR\u0004\u0016-^:f'R\fG/\u001a(piB\u0013Xm]3sm\u0016$')\u001f*fE\u0006d\u0017M\\2fQ\t\u0011U.\u0001\u000euKN$8i\\7nSR\u001c\u0006/Z2jM&,Gm\u00144gg\u0016$8\u000f\u000b\u0002D[\u0006IB/Z:u\u0003V$xnQ8n[&$xJ\u001c*fE\u0006d\u0017M\\2fQ\t!U.A\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2+\u0017\rZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\u001cVOY:de&\u0014W\r\u000b\u0002F[\u0006qC/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO6+GO]5dg\u000ecW-\u00198Va^KG\u000f[*vEN\u001c'/\u001b2fQ\t1U.\u0001\u0017uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2+\u0017\rZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\f5o]5h]\"\u0012q)\\\u0001,i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\f5o]5h]\"\u0012\u0001*\\\u0001,i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ'fiJL7m],iK:\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\"\u0012\u0011*\\\u0001'i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:dU-\u00193XSRDW*\u0019=Q_2d'+Z2pe\u0012\u001c\bF\u0001&n\u0003\u0015\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT1h/&$\b.T1y!>dGNU3d_J$7\u000f\u000b\u0002L[\u0006qC/Z:u#V|G/Y'fiJL7m\u001d(pi\u000e\u0013X-\u0019;fI&3gj\\)v_R\f7oQ8oM&<WO]3eQ\taU.\u0001\u0012sk:lU\u000f\u001c;j\u0007>t7/^7feN+7o]5p]RKW.Z8viR+7\u000f\u001e\u000b\u0004M\u000e\r\u0001bBB\u0003\u001b\u0002\u0007\u0011QT\u0001\u000eG2|7/Z\"p]N,X.\u001a:\u0002%M,(m]2sS\n,7i\u001c8tk6,'o\u001d\u000b\u0007\u0007\u0017\u00199c!\u0010\u0011\r\r51qCB\u000e\u001b\t\u0019yA\u0003\u0003\u0004\u0012\rM\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0007+A\u0017AC2pY2,7\r^5p]&!1\u0011DB\b\u0005\u0019\u0011UO\u001a4feB!1QDB\u0010\u001b\u0005\u0001\u0011\u0002BB\u0011\u0007G\u0011\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s\u0013\r\u0019)c\u0016\u0002\u0015\u0003\n\u001cHO]1di\u000e{gn];nKJ$Vm\u001d;\t\u000f\r%b\n1\u0001\u0004,\u0005i1m\u001c8tk6,'o\u0012:pkB\u0004ba!\u0004\u0004\u0018\r5\u0002\u0003CB\u0018\u0007s\tY\"a\u0007\u000e\u0005\rE\"\u0002BB\u001a\u0007k\t\u0001bY8ogVlWM\u001d\u0006\u0005\u0007o\t\t\"A\u0004dY&,g\u000e^:\n\t\rm2\u0011\u0007\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\t\u000f\r}b\n1\u0001\u0004B\u0005\tBo\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\u0011\r\r\r3QJA\"\u001d\u0011\u0019)e!\u0013\u000f\t\u0005%3qI\u0005\u0002S&\u001911\n5\u0002\u000fA\f7m[1hK&!1qJB)\u0005\u0011a\u0015n\u001d;\u000b\u0007\r-\u0003.A\u0014de\u0016\fG/Z\"p]N,X.\u001a:He>,\b/\u00118e/\u0006LGOR8s\u0003N\u001c\u0018n\u001a8nK:$H\u0003CB,\u0007;\u001a\tga\u0019\u0011\u000f\u001d\u001cIfa\u000b\u0004\f%\u001911\f5\u0003\rQ+\b\u000f\\33\u0011\u001d\u0019yf\u0014a\u0001\u00053\nQbY8ogVlWM]\"pk:$\bbBB \u001f\u0002\u00071\u0011\t\u0005\b\u0007Kz\u0005\u0019AB4\u00035\u0019XOY:de&\u0004H/[8ogB1\u0011QIB5\u0005GJAaa\u001b\u0002X\t\u00191+\u001a;\u0002i\rD\u0017M\\4f\u0007>t7/^7fe\u001e\u0013x.\u001e9Tk\n\u001c8M]5qi&|g.\u00118e-\u0006d\u0017\u000eZ1uK\u0006\u001b8/[4o[\u0016tG\u000fF\u0004g\u0007c\u001a)ha\u001e\t\u000f\rM\u0004\u000b1\u0001\u0004\f\u0005y1m\u001c8tk6,'\u000fU8mY\u0016\u00148\u000fC\u0004\u0004@A\u0003\ra!\u0011\t\u000f\r\u0015\u0004\u000b1\u0001\u0004h\u0005y3\r[1oO\u0016\u001cuN\\:v[\u0016\u00148+\u001e2tGJL\u0007\u000f^5p]\u0006sGMV1mS\u0012\fG/Z!tg&<g.\\3oiV11QPBE\u0007\u001f#\u0012BZB@\u0007'\u001b)j!'\t\u000f\rM\u0012\u000b1\u0001\u0004\u0002BA1qFBB\u0007\u000f\u001bi)\u0003\u0003\u0004\u0006\u000eE\"\u0001C\"p]N,X.\u001a:\u0011\t\u0005\u00155\u0011\u0012\u0003\b\u0007\u0017\u000b&\u0019AAF\u0005\u0005Y\u0005\u0003BAC\u0007\u001f#qa!%R\u0005\u0004\tYIA\u0001W\u0011\u001d\u0019y$\u0015a\u0001\u0007\u0003Bqaa&R\u0001\u0004\u00199'\u0001\nfqB,7\r^3e\u0003N\u001c\u0018n\u001a8nK:$\bbBBN#\u0002\u00071QT\u0001\u0012e\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\b\u0003BB\u0018\u0007?KAa!)\u00042\tI2i\u001c8tk6,'OU3cC2\fgnY3MSN$XM\\3s\u0003Q\tw/Y5u\u001d>tW)\u001c9usJ+7m\u001c:egV11qUBY\u0007k#ba!+\u00048\u000em\u0006\u0003CB\u0018\u0007W\u001byka-\n\t\r56\u0011\u0007\u0002\u0010\u0007>t7/^7feJ+7m\u001c:egB!\u0011QQBY\t\u001d\u0019YI\u0015b\u0001\u0003\u0017\u0003B!!\"\u00046\u001291\u0011\u0013*C\u0002\u0005-\u0005bBB\u001a%\u0002\u00071\u0011\u0018\t\t\u0007_\u0019\u0019ia,\u00044\"91Q\u0018*A\u0002\t\r\u0014!\u00039beRLG/[8o\u0003=\tw/Y5u\u0003N\u001c\u0018n\u001a8nK:$H#\u00024\u0004D\u000eU\u0007bBB\u001a'\u0002\u00071Q\u0019\u0019\u0007\u0007\u000f\u001cYm!5\u0011\u0011\r=21QBe\u0007\u001f\u0004B!!\"\u0004L\u0012a1QZBb\u0003\u0003\u0005\tQ!\u0001\u0002\f\n\u0019q\fJ\u001a\u0011\t\u0005\u00155\u0011\u001b\u0003\r\u0007'\u001c\u0019-!A\u0001\u0002\u000b\u0005\u00111\u0012\u0002\u0004?\u0012\"\u0004bBBL'\u0002\u00071qM\u0001\u001di\u0016\u001cHoQ8ogVl\u0017N\\4XSRDg*\u001e7m\u000fJ|W\u000f]%eQ\t!V.A\u000fuKN$8i\u001c8tk6LgnZ,ji\",U\u000e\u001d;z\u000fJ|W\u000f]%eQ\t)V\u000e")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @Test
    public void testDeprecatedPollBlocksForAssignment() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$3 = 0;
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$3, x$6, startingTimestamp, x$7, x$8, maxPollRecords);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final LongRef committedPosition$1;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"otherTopic", (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 1;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 1;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4());
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        assignment = (scala.collection.immutable.Set)assignment.$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assertions.assertEquals((Object)syncMetadata, consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)asyncMetadata)}))));
        Assertions.assertEquals((Object)asyncMetadata, consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)nullMetadata)}))).asJava());
        Assertions.assertEquals((Object)nullMetadata, consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAsyncCommit() {
        void pollUntilTrue_action;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback callback = new AbstractConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> consumer.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)callback));
        long l = 10000L;
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> callback.successCount() >= count || callback.lastError().isDefined();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testAsyncCommit$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
        Assertions.assertEquals((Object)None$.MODULE$, callback.lastError());
        Assertions.assertEquals((int)count, (int)callback.successCount());
        Assertions.assertEquals((Object)new OffsetAndMetadata((long)count), consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Set expandedAssignment = (scala.collection.immutable.Set)initialAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expandedAssignment);
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        scala.collection.immutable.Set shrunkenAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)shrunkenAssignment);
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        Assertions.assertFalse((boolean)consumer.partitionsFor("non-exist-topic").isEmpty());
    }

    @Test
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        int x$2 = 1;
        int x$3 = 0;
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, x$4, x$6, x$7, x$8);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        int x$10 = 1;
        int x$11 = 0;
        TopicPartition x$12 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$10, x$11, x$13, x$14, x$15, x$12, x$16);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$18 = 1;
        int x$19 = (int)mid;
        int x$20 = (int)mid;
        TopicPartition x$22 = this.tp2();
        TimestampType x$23 = this.consumeAndVerifyRecords$default$6();
        int x$24 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$18, x$19, x$20, mid, x$23, x$22, x$24);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes())));
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertNull(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava()).get(topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.position(topicPartition));
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()), (String)"position() on a partition that we are subscribed to should reset the offset");
        consumer.commitSync();
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertEquals((long)5L, (long)consumer.position(this.tp()), (String)"After consuming 5 records, position should be 5");
        consumer.commitSync();
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset(), (String)"Committed offset should be returned");
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        otherConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$10 = 1;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        int x$10 = 5;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp(), this.sendRecords$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ofMillis(15000L)));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        java.util.Map outOfRangePartitions = ((OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> consumer.poll(Duration.ofMillis(20000L)))).offsetOutOfRangePartitions();
        Assertions.assertNotNull((Object)outOfRangePartitions);
        Assertions.assertEquals((int)1, (int)outOfRangePartitions.size());
        Assertions.assertEquals((long)outOfRangePos, (Long)((Long)outOfRangePartitions.get(this.tp())));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(20000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        .colon.colon topics = new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)));
        topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5()));
        Seq partitions = (Seq)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable & scala.Serializable)x$1 -> PlaintextConsumerTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2, this.sendRecords$default$4()), Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())), ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerRoundRobinAssignor() {
        void var7_7;
        void var6_6;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        void consumerGroup2 = var6_6;
        void consumerPollers2 = var7_7;
        try {
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        finally {
            consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerStickyAssignor() {
        void var7_7;
        void var6_6;
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        void consumerGroup2 = var6_6;
        void consumerPollers2 = var7_7;
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        scala.collection.immutable.Map prePartition2PollerId = PlaintextConsumerTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, "sticky-group");
        scala.collection.immutable.Map postPartition2PollerId = PlaintextConsumerTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            PlaintextConsumerTest.$anonfun$testMultiConsumerStickyAssignor$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rand, (int)changes.elem, (String)"Expected only two topic partitions that have switched to other consumers.");
    }

    @Test
    public void testMultiConsumerDefaultAssignor() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerDefaultAssignorAndVerifyAssignment() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        TopicPartition tp1_2 = new TopicPartition(topic1, 2);
        TopicPartition tp2_0 = new TopicPartition(topic2, 0);
        TopicPartition tp2_1 = new TopicPartition(topic2, 1);
        TopicPartition tp2_2 = new TopicPartition(topic2, 2);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp1_2, tp2_0, tp2_1, tp2_2}));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)));
        Buffer expectedAssignment = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{(scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp2_0, tp2_1})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_2, tp2_2}))}));
        try {
            Option<String> x$4 = this.validateGroupAssignment$default$3();
            long x$5 = this.validateGroupAssignment$default$4();
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, x$4, x$5, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                x$9.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (RecordMetadata)x$10.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(i).append(appendStr).toString().toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$11 -> (RecordMetadata)x$11.get());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        TopicPartition x$11 = this.tp2();
        int x$12 = 0;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$12, x$13, x$14, x$15, x$11, x$16);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps, this.createTopic$default$5());
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)).asJava());
        int x$4 = 0;
        int x$5 = 0;
        TimestampType x$7 = TimestampType.LOG_APPEND_TIME;
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$4, x$5, startTime, x$7, tp1, x$8);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$12 = 0;
        int x$13 = 0;
        TimestampType x$15 = TimestampType.LOG_APPEND_TIME;
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$12, x$13, startTime, x$15, tp2, x$16);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)).asJava());
        int x$10 = 0;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 7, this.tp2(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$))).asJava());
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertNull(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2()));
        Assertions.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assertions.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)new OffsetAndMetadata(7L))}))));
        Assertions.assertEquals((long)7L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, consumer){
            private final KafkaConsumer consumer$6;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$6.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$6 = consumer$6;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), rebalanceListener);
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newAssignment);
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName(new StringBuilder(12).append(this.tp().toString()).append(".records-lag").toString(), "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString());
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(numMessages - records.count()).toString());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$12, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$13, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$14, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$15, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$16, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$17, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$18, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$19, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            PlaintextConsumerTest.assertNoExemptRequestMetric$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringBuilder(68).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" after one consumer left").toString()), 3L * this.groupMaxSessionTimeoutMs(), this.validateGroupAssignment$default$5());
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, topicsToSubscribe, this.subscribeConsumerAndStartPolling$default$3())));
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assertions.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1 & Serializable & scala.Serializable)_ -> consumerGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4())));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    /*
     * WARNING - void declaration
     */
    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.subscribe((List<String>)topicsToSubscribe);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!consumerPollers.forall((Function1 & Serializable & scala.Serializable)poller -> BoxesRunTime.boxToBoolean((boolean)poller.isSubscribeRequestProcessed()))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(subscriptions));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.validateGroupAssignment(consumerPollers, subscriptions, (Option<String>)new Some((Object)new StringBuilder(74).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()).append(" after we changed subscription").toString()), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> expectedAssignment, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, expectedAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> ConsumerRecords<K, V> awaitNonEmptyRecords(Consumer<K, V> consumer, TopicPartition partition) {
        Object object = new Object();
        try {
            void pollRecordsUntilTrue_action;
            long l = TestUtils$.MODULE$.pollRecordsUntilTrue$default$4();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$1(partition, object, polledRecords));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long pollRecordsUntilTrue_x$3 = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, (Function1)pollRecordsUntilTrue_action)) {
                void pollRecordsUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + pollRecordsUntilTrue_waitTimeMs) {
                    Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$2(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollRecordsUntilTrue_waitTimeMs), pollRecordsUntilTrue_x$3));
            }
            throw new IllegalStateException("Should have timed out before reaching here");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ConsumerRecords)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void awaitAssignment(Consumer<?, ?> consumer, scala.collection.immutable.Set<TopicPartition> expectedAssignment) {
        void pollUntilTrue_action;
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Set set = consumer.assignment();
            Object object = CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        };
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitAssignment$2(expectedAssignment, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumingWithNullGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithNullGroupId$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testConsumingWithNullGroupId$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        KafkaConsumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        .colon.colon x$6 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        KafkaConsumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        .colon.colon x$10 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        KafkaConsumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumingWithEmptyGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithEmptyGroupId$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testConsumingWithEmptyGroupId$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("client.id", "consumer1");
        consumer1Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$2, x$3, consumer1Config, x$4);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("group.id", "");
        consumer2Config.put("client.id", "consumer2");
        consumer2Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$6, x$7, consumer2Config, x$8);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        ConsumerRecords records1 = consumer1.poll(Duration.ofMillis(5000L));
        consumer1.commitSync();
        ConsumerRecords records2 = consumer2.poll(Duration.ofMillis(5000L));
        consumer2.commitSync();
        consumer1.close();
        consumer2.close();
        Assertions.assertTrue((records1.count() == 1 && ((ConsumerRecord)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(records1.records(tp)).asScala()).head()).offset() == 0L ? 1 : 0) != 0, (String)"Expected consumer1 to consume one message from offset 0");
        Assertions.assertTrue((records2.count() == 1 && ((ConsumerRecord)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(records2.records(tp)).asScala()).head()).offset() == 1L ? 1 : 0) != 0, (String)"Expected consumer2 to consume one message from offset 1, which is the committed offset of consumer1");
    }

    public static final /* synthetic */ String $anonfun$testAsyncCommit$3() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    private static final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, ((IterableLike)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> ((SetLike)m.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains(v))).head()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignor$5(scala.collection.immutable.Map prePartition2PollerId$1, scala.collection.immutable.Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
                return;
            }
        } else {
            ++changes$1.elem;
        }
    }

    private static final void assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    private static final void assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    public static final /* synthetic */ String $anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(scala.collection.immutable.Set subscriptions$1) {
        return new StringBuilder(72).append("Failed to call subscribe on all consumers in the group for subscription ").append(subscriptions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitNonEmptyRecords$1(TopicPartition partition$1, Object nonLocalReturnKey1$1, ConsumerRecords polledRecords) {
        if (((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(polledRecords.records(partition$1)).asScala()).nonEmpty()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)polledRecords);
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitNonEmptyRecords$2(TopicPartition partition$1) {
        return new StringBuilder(68).append("Consumer did not consume any messages for partition ").append(partition$1).append(" before timeout.").toString();
    }

    public static final /* synthetic */ String $anonfun$awaitAssignment$2(scala.collection.immutable.Set expectedAssignment$1, Consumer consumer$7) {
        return new StringBuilder(73).append("Timed out while awaiting expected assignment ").append(expectedAssignment$1).append(". ").append("The current assignment is ").append(consumer$7.assignment()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithNullGroupId$1(PlaintextConsumerTest $this, String topic$2) {
        return $this.zkClient().topicExists(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithNullGroupId$2() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithEmptyGroupId$1(PlaintextConsumerTest $this, String topic$3) {
        return $this.zkClient().topicExists(topic$3);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithEmptyGroupId$2() {
        return "Failed to create topic";
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        public void deserializer_$eq(ByteArrayDeserializer var1);

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.deserialize(topic, headers, data);
        }

        default public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public static /* synthetic */ void configure$(DeserializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(DeserializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.deserializer().close();
        }

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, byte[] data) {
            return $this.deserialize(topic, data);
        }

        default public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();

        public static void $init$(DeserializerImpl $this) {
            $this.deserializer_$eq(new ByteArrayDeserializer());
        }
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        public void serializer_$eq(ByteArraySerializer var1);

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.serialize(topic, headers, data);
        }

        default public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public static /* synthetic */ void configure$(SerializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(SerializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.serializer().close();
        }

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, byte[] data) {
            return $this.serialize(topic, data);
        }

        default public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();

        public static void $init$(SerializerImpl $this) {
            $this.serializer_$eq(new ByteArraySerializer());
        }
    }
}

