/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00041\u0001\u0001\u0006IA\u000b\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u0019!\u0005\u0001)A\u0005g!)Q\t\u0001C\u0001\r\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!!!\u0001\t\u0013\t\u0019\tC\u0004\u00024\u0002!I!!.\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u00111\u001f\u0001\u0005\n\u0005U\bbBA}\u0001\u0011%\u00111 \u0005\n\u0005/\u0001\u0011\u0013!C\u0005\u000539QaY\u000e\t\u0002\u00114QAG\u000e\t\u0002\u0015DQ!\n\n\u0005\u0002%4AA\u001b\n\u0001W\")Q\u0005\u0006C\u0001o\")!\u0010\u0006C!w\u001a1\u0011Q\u0007\n\u0001\u0003oAa!J\f\u0005\u0002\u0005e\u0002B\u0002>\u0018\t\u0003\niD\u0001\u0014M_\u001e\u001cE.Z1oKJ\u0004\u0016M]1nKR,'/\u001b>fI&sG/Z4sCRLwN\u001c+fgRT!\u0001H\u000f\u0002\u00071|wMC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t\u001aS\"A\u000e\n\u0005\u0011Z\"!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001(!\t\u0011\u0003!\u0001\u0003uS6,W#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00055j\u0012!B;uS2\u001c\u0018BA\u0018-\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003M\u00022\u0001N\u001c:\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$!B!se\u0006L\bC\u0001\u001eC\u001b\u0005Y$B\u0001\u001f>\u0003\u0019\u0019w.\\7p]*\u0011aD\u0010\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014x-\u0003\u0002Dw\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u0005\u001dS\u0005C\u0001\u001bI\u0013\tIUG\u0001\u0003V]&$\b\"B&\u0007\u0001\u0004a\u0015!B2pI\u0016\u001c\u0007CA'Q\u001b\u0005q%BA(<\u0003\u0019\u0011XmY8sI&\u0011\u0011K\u0014\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"\"aaU0a!\t!V,D\u0001V\u0015\t1v+\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tA\u0016,\u0001\u0004qCJ\fWn\u001d\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002]\u0001\u0006)!.\u001e8ji&\u0011a,\u0016\u0002\u0010\u0003J<W/\\3oiN\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\n\u0011\r\u0005\u0002c)9\u0011!%E\u0001'\u0019><7\t\\3b]\u0016\u0014\b+\u0019:b[\u0016$XM]5{K\u0012Le\u000e^3he\u0006$\u0018n\u001c8UKN$\bC\u0001\u0012\u0013'\t\u0011b\r\u0005\u00025O&\u0011\u0001.\u000e\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0011\u0014q\"\u00117m\u0007>l\u0007O]3tg&|gn]\n\u0004)1$\bCA7s\u001b\u0005q'BA8q\u0003\u0011a\u0017M\\4\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005Q+\u0018B\u0001<V\u0005E\t%oZ;nK:$8\u000f\u0015:pm&$WM\u001d\u000b\u0002qB\u0011\u0011\u0010F\u0007\u0002%\u0005\u0001\u0002O]8wS\u0012,\u0017I]4v[\u0016tGo\u001d\u000b\u0004y\u0006\u0005\u0002gA?\u0002\u0010A)a0a\u0002\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AB:ue\u0016\fWNC\u0002\u0002\u0006A\fA!\u001e;jY&\u0019\u0011\u0011B@\u0003\rM#(/Z1n!\u0011\ti!a\u0004\r\u0001\u0011Y\u0011\u0011\u0003\f\u0002\u0002\u0003\u0005)\u0011AA\n\u0005\ryF%M\t\u0005\u0003+\tY\u0002E\u00025\u0003/I1!!\u00076\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001VA\u000f\u0013\r\ty\"\u0016\u0002\n\u0003J<W/\\3oiNDq!a\t\u0017\u0001\u0004\t)#A\u0004d_:$X\r\u001f;\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u0004\u0003_I\u0016aA1qS&!\u00111GA\u0015\u0005A)\u0005\u0010^3og&|gnQ8oi\u0016DHOA\u0006Fq\u000edW\u000fZ3[gR$7cA\fmiR\u0011\u00111\b\t\u0003s^!B!a\u0010\u0002JA\"\u0011\u0011IA#!\u0015q\u0018qAA\"!\u0011\ti!!\u0012\u0005\u0017\u0005\u001d\u0013$!A\u0001\u0002\u000b\u0005\u00111\u0003\u0002\u0004?\u0012\u0012\u0004bBA\u00123\u0001\u0007\u0011Q\u0005\u0015\u0004\r\u00055\u0003\u0003BA(\u0003#j\u0011aV\u0005\u0004\u0003':&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u00069C/Z:u\u00072,\u0017M\\:D_6\u0014\u0017N\\3e\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016$v\u000e]5d)\r9\u0015\u0011\f\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014\u0015\u0005\u000fM{\u0006\rK\u0002\b\u0003\u001b\na\u0004^3ti\u000ecW-\u00198fe^KG\u000f['fgN\fw-\u001a$pe6\fGO\u0016\u0019\u0015\u0007\u001d\u000b\u0019\u0007C\u0003L\u0011\u0001\u0007A\nK\u0003\t'~\u000b9g\t\u0002\u0002jA\u0011!m\u0006\u0015\u0004\u0011\u00055\u0013!\n;fgR\u001cE.Z1oS:<g*Z:uK\u0012lUm]:bO\u0016\u001cx+\u001b;i-B\ne\u000e\u001a,2)\r9\u0015\u0011\u000f\u0005\u0006\u0017&\u0001\r\u0001\u0014\u0015\u0006\u0013M{\u0016q\r\u0015\u0004\u0013\u00055\u0013aF2mK\u0006tWM]\"p]\u001aLw-\u00169eCR,G+Z:u)\r9\u00151\u0010\u0005\u0006\u0017*\u0001\r\u0001\u0014\u0015\u0005\u0015M{\u0006\rK\u0002\u000b\u0003\u001b\n\u0001c\u00195fG.d\u0015m\u001d;DY\u0016\fg.\u001a3\u0015\u000f\u001d\u000b))a(\u0002*\"9\u0011qQ\u0006A\u0002\u0005%\u0015!\u0002;pa&\u001c\u0007\u0003BAF\u00033sA!!$\u0002\u0016B\u0019\u0011qR\u001b\u000e\u0005\u0005E%bAAJ?\u00051AH]8pizJ1!a&6\u0003\u0019\u0001&/\u001a3fM&!\u00111TAO\u0005\u0019\u0019FO]5oO*\u0019\u0011qS\u001b\t\u000f\u0005\u00056\u00021\u0001\u0002$\u0006Y\u0001/\u0019:uSRLwN\\%e!\r!\u0014QU\u0005\u0004\u0003O+$aA%oi\"9\u00111V\u0006A\u0002\u00055\u0016A\u00034jeN$H)\u001b:usB\u0019A'a,\n\u0007\u0005EVG\u0001\u0003M_:<\u0017AG2iK\u000e\\Gj\\4BMR,'/\u00119qK:$\u0017N\\4EkB\u001cHcB$\u00028\u0006}\u00161\u0019\u0005\u000791\u0001\r!!/\u0011\u0007\t\nY,C\u0002\u0002>n\u0011!\"\u00168jM&,G\rT8h\u0011\u001d\t\t\r\u0004a\u0001\u0003[\u000b\u0011b\u001d;beR\u001c\u0016N_3\t\u000f\u0005\u0015G\u00021\u0001\u0002H\u00069\u0011\r\u001d9f]\u0012\u001c\bCBAe\u0003\u001f\f\u0019.\u0004\u0002\u0002L*\u0019\u0011QZ\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0006-'aA*fcBIA'!6\u0002$\u0006%\u0015QV\u0005\u0004\u0003/,$A\u0002+va2,7'A\u0003u_6\u000b\u0007\u000f\u0006\u0003\u0002^\u0006%\b\u0003CAe\u0003?\f\u0019+a9\n\t\u0005\u0005\u00181\u001a\u0002\u0004\u001b\u0006\u0004\bc\u0002\u001b\u0002f\u0006%\u0015QV\u0005\u0004\u0003O,$A\u0002+va2,'\u0007C\u0004\u0002l6\u0001\r!!<\u0002\u00115,7o]1hKN\u0004b!!3\u0002p\u0006M\u0017\u0002BAy\u0003\u0017\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\fe\u0016\fGM\u0012:p[2{w\r\u0006\u0003\u0002n\u0006]\bB\u0002\u000f\u000f\u0001\u0004\tI,A\rxe&$X\rR;qgNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$HCDAd\u0003{\u0014\tA!\u0002\u0003\b\t%!Q\u0002\u0005\b\u0003\u007f|\u0001\u0019AAR\u0003\u001dqW/\\&fsNDqAa\u0001\u0010\u0001\u0004\t\u0019+A\u0004ok6$U\u000f]:\t\rqy\u0001\u0019AA]\u0011\u0015Yu\u00021\u0001M\u0011%\u0011Ya\u0004I\u0001\u0002\u0004\t\u0019+\u0001\u0005ti\u0006\u0014HoS3z\u0011\u001d\u0011ya\u0004a\u0001\u0005#\t!\"\\1hS\u000e4\u0016\r\\;f!\r!$1C\u0005\u0004\u0005+)$\u0001\u0002\"zi\u0016\f1e\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fi\u0012\"WMZ1vYR$S'\u0006\u0002\u0003\u001c)\"\u00111\u0015B\u000fW\t\u0011y\u0002\u0005\u0003\u0003\"\t-RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0015k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5\"1\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType codec) {
        void var5_5;
        void var4_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        void largeMessageValue2 = var4_4;
        void largeMessageSet2 = var5_5;
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = ((LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset();
        int x$12 = largeMessageKey + 1;
        int x$13 = 100;
        int x$14 = 3;
        byte x$17 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$13, x$14, log, codec, x$12, x$17);
        Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read().contains((Object)this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType codec) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        long endOffset = var5_5.logEndOffset();
        var5_5.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$3((UnifiedLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)var5_5.numberOfSegments());
        this.cleaner().shutdown();
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, codec);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log2 = (UnifiedLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        void log22 = var9_11;
        void messages2 = var10_12;
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((UnifiedLog)log22);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0(CompressionType codec) {
        void var6_5;
        void var5_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        void largeMessageValue2 = var5_4;
        void largeMessageSet2 = var6_5;
        int n = CompressionType.NONE.equals(codec) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$72 = this.makeCleaner$default$7();
        int x$82 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, n, x$6, x$72, x$82, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$13 = this.logConfigProperties$default$1();
        float x$14 = this.logConfigProperties$default$3();
        long x$15 = this.logConfigProperties$default$4();
        int x$16 = this.logConfigProperties$default$5();
        int x$17 = this.logConfigProperties$default$6();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$13, n, x$14, x$15, x$16, x$17, x$18);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$19 = 100;
        int x$20 = 3;
        byte x$23 = 0;
        int x$24 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$19, x$20, log, codec, x$24, x$23);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$25 = 40;
        int x$26 = 3;
        byte x$29 = 0;
        int x$30 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$25, x$26, log, codec, x$30, x$29);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())).get());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$31 = 30;
        int x$32 = 40;
        int x$33 = 3;
        byte x$36 = 1;
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$32, x$33, log, codec, x$31, x$36);
        int x$37 = 15;
        int x$38 = 5;
        int x$39 = 3;
        byte x$42 = 2;
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$38, x$39, log, codec, x$37, x$42);
        Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0AndV1(CompressionType codec) {
        int maxMessageSize = 192;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$3 = 256;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        long x$92 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$8, x$3, x$92, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$13 = 256;
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, maxMessageSize, x$15, x$16, x$17, x$13, x$18);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$19 = 2;
        int x$20 = 3;
        byte x$23 = 0;
        int x$24 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$19, x$20, log, codec, x$24, x$23);
        int x$25 = 2;
        int x$26 = 3;
        int x$27 = 2;
        byte x$30 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$25, x$27, log, codec, x$26, x$30), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$31 = 4;
        int x$32 = 2;
        int x$33 = 2;
        byte x$36 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$32, x$33, log, codec, x$31, x$36);
        int x$37 = 4;
        int x$38 = 2;
        int x$39 = 2;
        byte x$42 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$38, x$39, log, codec, x$37, x$42), Seq$.MODULE$.canBuildFrom());
        int x$43 = 6;
        int x$44 = 2;
        int x$45 = 2;
        byte x$48 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$44, x$45, log, codec, x$43, x$48), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType codec) {
        void var4_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String cfr_ignored_0 = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var4_4.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$2 = 1L;
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$112 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, x$2, maxMessageSize, x$7, x$8, x$9, x$10, (Option<Object>)x$4, x$112));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString());
    }

    private void checkLogAfterAppendingDups(UnifiedLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
            String value = (String)x0$1._2();
            long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, UnifiedLog log, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = x0$1._1$mcI$sp();
            String payload = (String)x0$1._2();
            SimpleRecord simpleRecord = new SimpleRecord(Integer.toString(key).getBytes(), payload.toString().getBytes());
            return simpleRecord;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(((LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Tuple2 kv = (Tuple2)x0$2._1();
            long offset = x0$2._2$mcJ$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            return tuple3;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType codec$1) {
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        long x$32 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$32, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, codec$1, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$3(UnifiedLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$4() {
        return "Timed out waiting for deletion of old segments";
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), Integer.toString(cleanerConfig.numThreads()));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), Long.toString(cleanerConfig.dedupeBufferSize()));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), Double.toString(cleanerConfig.dedupeBufferLoadFactor()));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), Integer.toString(cleanerConfig.ioBufferSize()));
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(cleanerConfig.maxMessageSize()));
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), Long.toString(cleanerConfig.backOffMs()));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), Double.toString(cleanerConfig.maxIoBytesPerSecond()));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values())).map((Function1 & Serializable & scala.Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Arguments.class))));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values())).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$12))))).map((Function1 & Serializable & scala.Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Arguments.class))));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$12) {
            CompressionType compressionType = x$12;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

