/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011ec\u0001\u00026l\u0001ADQa\u001e\u0001\u0005\u0002aDqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B?\t\u0011\u00055\u0001A1A\u0005\u0002qDq!a\u0004\u0001A\u0003%Q\u0010C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001\u0002\u0014!A\u0011\u0011\u0005\u0001!\u0002\u0013\t)\u0002C\u0005\u0002$\u0001\u0011\r\u0011\"\u0001\u0002&!A\u0011Q\u0006\u0001!\u0002\u0013\t9\u0003C\u0005\u00020\u0001\u0011\r\u0011\"\u0001\u00022!A\u0011q\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002B\u0001\u0011\r\u0011\"\u0001\u0002D!A\u00111\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0001\u0002P!A\u0011q\u000b\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0001\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0004\u0002f\u0001!\t!a\u001a\t\u000f\u0005%\u0005\u0001\"\u0001\u0002h!9\u00111\u0013\u0001\u0005\u0002\u0005\u001d\u0004bBAL\u0001\u0011\u0005\u0011q\r\u0005\b\u00037\u0003A\u0011AA4\u0011\u001d\ty\n\u0001C\u0001\u0003OBq!a)\u0001\t\u0003\t9\u0007C\u0004\u0002(\u0002!\t!a\u001a\t\u000f\u0005-\u0006\u0001\"\u0001\u0002h!9\u0011q\u0016\u0001\u0005\u0002\u0005\u001d\u0004bBAZ\u0001\u0011\u0005\u0011q\r\u0005\b\u0003o\u0003A\u0011AA4\u0011\u001d\tY\f\u0001C\u0001\u0003OBq!a0\u0001\t\u0003\t9\u0007C\u0004\u0002D\u0002!\t!a\u001a\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002h!9\u00111\u001a\u0001\u0005\u0002\u0005\u001d\u0004bBAh\u0001\u0011\u0005\u0011q\r\u0005\b\u0003'\u0004A\u0011AA4\u0011\u001d\t9\u000e\u0001C\u0001\u0003OBq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002v\u0002!\t!a\u001a\t\u000f\u0005e\b\u0001\"\u0001\u0002h!9\u0011Q \u0001\u0005\u0002\u0005\u001d\u0004b\u0002B\u0001\u0001\u0011\u0005\u0011q\r\u0005\b\u0005\u000b\u0001A\u0011AA4\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003OBqA!\u0004\u0001\t\u0003\t9\u0007C\u0004\u0003\u0012\u0001!\t!a\u001a\t\u000f\tU\u0001\u0001\"\u0001\u0002h!9!\u0011\u0004\u0001\u0005\u0002\tm\u0001b\u0002B\u0016\u0001\u0011\u0005!Q\u0006\u0005\b\u0005o\u0001A\u0011\u0001B\u001d\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007fAqAa\u0011\u0001\t\u0003\u0011)\u0005C\u0004\u0003^\u0001!\t!a\u001a\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002h!9!Q\r\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B5\u0001\u0011\u0005\u0011q\r\u0005\b\u0005[\u0002A\u0011AA4\u0011\u001d\u0011\t\b\u0001C\u0005\u0005gBqAa\"\u0001\t\u0003\t9\u0007C\u0004\u0003\f\u0002!\t!a\u001a\t\u000f\t=\u0005\u0001\"\u0001\u0002h!9!1\u0013\u0001\u0005\u0002\u0005\u001d\u0004b\u0002BL\u0001\u0011\u0005\u0011q\r\u0005\b\u00057\u0003A\u0011AA4\u0011\u001d\u0011y\n\u0001C\u0001\u0003OBqAa)\u0001\t\u0003\t9\u0007C\u0004\u0003(\u0002!\t!a\u001a\t\u000f\t-\u0006\u0001\"\u0001\u0002h!9!q\u0016\u0001\u0005\n\tE\u0006b\u0002Ba\u0001\u0011%!1\u0019\u0005\n\u0005C\u0004\u0011\u0013!C\u0005\u0005GDqA!?\u0001\t\u0013\u0011Y\u0010C\u0004\u0003z\u0002!Ia!\u0006\t\u000f\ru\u0001\u0001\"\u0003\u0004 !I11\u0006\u0001\u0012\u0002\u0013%1Q\u0006\u0005\n\u0007c\u0001\u0011\u0013!C\u0005\u0007gA\u0011ba\u000e\u0001#\u0003%Ia!\u000f\t\u000f\ru\u0002\u0001\"\u0003\u0004@!I1\u0011\f\u0001\u0012\u0002\u0013%11\f\u0005\n\u0007?\u0002\u0011\u0013!C\u0005\u0007CBqAa,\u0001\t\u0013\u0019)\u0007C\u0004\u0003\u0000\u0002!Ia!\u001c\t\u000f\t-\u0007\u0001\"\u0003\u0004\u0000!I11\u0014\u0001\u0012\u0002\u0013%1\u0011\b\u0005\n\u0007;\u0003\u0011\u0013!C\u0005\u0007?C\u0011ba)\u0001#\u0003%Ia!\u0019\t\u0013\r\u0015\u0006!%A\u0005\n\r\u0005\u0004bBBT\u0001\u0011%1\u0011\u0016\u0005\n\u0007\u0013\u0004\u0011\u0013!C\u0005\u0007CB\u0011ba3\u0001#\u0003%Ia!4\t\u000f\rE\u0007\u0001\"\u0003\u0004T\"I1\u0011\u001e\u0001\u0012\u0002\u0013%11\u001e\u0005\n\u0007_\u0004\u0011\u0013!C\u0005\u0007CB\u0011b!=\u0001#\u0003%Ia!4\t\u000f\rM\b\u0001\"\u0003\u0004v\"I1q \u0001\u0012\u0002\u0013%1\u0011\b\u0005\b\t\u0003\u0001A\u0011\u0002C\u0002\u0011%!Y\u0001AI\u0001\n\u0013\u0019I\u0004C\u0004\u0005\u000e\u0001!I\u0001b\u0004\t\u000f\t-\u0007\u0001\"\u0003\u0005$!9A\u0011\u0006\u0001\u0005\n\u0011-\u0002b\u0002C\u0018\u0001\u0011%A\u0011\u0007\u0005\b\tk\u0001A\u0011\u0002C\u001c\u0011\u001d!y\u0004\u0001C\u0005\t\u0003B\u0011\u0002b\u0016\u0001#\u0003%Ia!\u000f\u0003\u001d1{wm\u00117fC:,'\u000fV3ti*\u0011A.\\\u0001\u0004Y><'\"\u00018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0002i\u0006)1oY1mC&\u0011ao\u001d\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\bC\u0001>\u0001\u001b\u0005Y\u0017A\u0002;na\u0012L'/F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\tIwN\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\u0005\r&dW-A\u0004u[B$\u0017N\u001d\u0011\u0002\u0007\u0011L'/\u0001\u0003eSJ\u0004\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\t\u0005m\u00111A\u0001\u0005kRLG.\u0003\u0003\u0002 \u0005e!A\u0003)s_B,'\u000f^5fg\u0006IAn\\4Qe>\u00048\u000fI\u0001\nY><7i\u001c8gS\u001e,\"!a\n\u0011\u0007i\fI#C\u0002\u0002,-\u0014\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0003uS6,WCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d[\u0006)Q\u000f^5mg&!\u0011QHA\u001c\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!\u0003;ie>$H\u000f\\3s+\t\t)\u0005\u0005\u0003\u00026\u0005\u001d\u0013\u0002BA%\u0003o\u0011\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%\u0001\u000bu_6\u00147\u000f^8oKJ+G/\u001a8uS>tWj]\u000b\u0003\u0003#\u00022A]A*\u0013\r\t)f\u001d\u0002\u0004\u0013:$\u0018!\u0006;p[\n\u001cHo\u001c8f%\u0016$XM\u001c;j_:l5\u000fI\u0001\u000fY\u0006\u0014x-\u001a+j[\u0016\u001cH/Y7q+\t\ti\u0006E\u0002s\u0003?J1!!\u0019t\u0005\u0011auN\\4\u0002\u001f1\f'oZ3US6,7\u000f^1na\u0002\n\u0001\u0002^3be\u0012|wO\u001c\u000b\u0003\u0003S\u00022A]A6\u0013\r\tig\u001d\u0002\u0005+:LG\u000fK\u0002\u0013\u0003c\u0002B!a\u001d\u0002\u00066\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0002ba&TA!a\u001f\u0002~\u00059!.\u001e9ji\u0016\u0014(\u0002BA@\u0003\u0003\u000bQA[;oSRT!!a!\u0002\u0007=\u0014x-\u0003\u0003\u0002\b\u0006U$!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0004'\u00055\u0005\u0003BA:\u0003\u001fKA!!%\u0002v\t!A+Z:u\u00039\"Xm\u001d;DY\u0016\fgnU3h[\u0016tGo],ji\"\u001cuN\\2veJ,g\u000e^*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8)\u0007Q\ti)A\u0018uKN$8+\u001b>f)JLW.\\3e\r>\u0014\bK]3bY2|7-\u0019;fI\u0006sGmQ8na\u0006\u001cG/\u001a3U_BL7\rK\u0002\u0016\u0003\u001b\u000bq\u0004^3ti\u0012+\b\u000f\\5dCR,7\t[3dW\u00063G/\u001a:DY\u0016\fg.\u001b8hQ\r1\u0012QR\u0001\"i\u0016\u001cHOQ1tS\u000e$&/\u00198tC\u000e$\u0018n\u001c8Bo\u0006\u0014Xm\u00117fC:Lgn\u001a\u0015\u0004/\u00055\u0015!\u000b;fgR\u001cE.Z1o/&$\b\u000e\u0016:b]N\f7\r^5p]N\u001c\u0006/\u00198oS:<7+Z4nK:$8\u000fK\u0002\u0019\u0003\u001b\u000bq\u0003^3ti\u000e{W.\\5u\u001b\u0006\u00148.\u001a:SK6|g/\u00197)\u0007e\ti)\u0001\u0013uKN$H)\u001a7fi\u0016$')\u0019;dQ\u0016\u001cx+\u001b;i\u001d>lUm]:bO\u0016\u001c(+Z1eQ\rQ\u0012QR\u0001(i\u0016\u001cHoQ8n[&$X*\u0019:lKJ\u0014V\r^3oi&|gnV5uQ\u0016k\u0007\u000f^=CCR\u001c\u0007\u000eK\u0002\u001c\u0003\u001b\u000b!\u0004^3ti\u000ecW-\u00198F[B$\u0018pQ8oiJ|GNQ1uG\"D3\u0001HAG\u0003!\"Xm\u001d;D_6l\u0017\u000e\u001e;fIR\u0013\u0018M\\:bGRLwN\\*qC:t\u0017N\\4TK\u001elWM\u001c;tQ\ri\u0012QR\u0001'i\u0016\u001cH/\u00112peR,G\r\u0016:b]N\f7\r^5p]N\u0003\u0018M\u001c8j]\u001e\u001cVmZ7f]R\u001c\bf\u0001\u0010\u0002\u000e\u00061B/Z:u\u0003\n|'\u000f^'be.,'OU3n_Z\fG\u000eK\u0002 \u0003\u001b\u000ba\u0005^3ti\u0016k\u0007\u000f^=CCR\u001c\u0007NU3n_Z\fGnV5uQN+\u0017/^3oG\u0016\u0014V-^:fQ\r\u0001\u0013QR\u0001'i\u0016\u001cH/\u00112peRl\u0015M]6feJ+G/\u001a8uS>tw+\u001b;i\u000b6\u0004H/\u001f\"bi\u000eD\u0007fA\u0011\u0002\u000e\u0006\u0001B/Z:u\u0019\u0006\u0014x-Z'fgN\fw-\u001a\u0015\u0004E\u00055\u0015a\t;fgRlUm]:bO\u0016d\u0015M]4feRC\u0017M\\'bq6+7o]1hKNK'0\u001a\u0015\u0004G\u00055\u0015\u0001\u000e;fgRlUm]:bO\u0016d\u0015M]4feRC\u0017M\\'bq6+7o]1hKNK'0Z,ji\"\u001cuN\u001d:vaRDU-\u00193fe\"\u001aA%!$\u0002]Q,7\u000f^\"peJ,\b\u000f^'fgN\fw-Z*ju\u0016d\u0015M]4feRC\u0017M\u001c\"zi\u0016\u001c\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0004K\u00055\u0015AJ2sK\u0006$X\rT8h/&$\b.T3tg\u0006<Wm\u001d'be\u001e,'\u000f\u00165b]6\u000b\u0007pU5{KR!\u0011q\\Ay!\u001d\u0011\u0018\u0011]As\u0003WL1!a9t\u0005\u0019!V\u000f\u001d7feA\u0019!0a:\n\u0007\u0005%8N\u0001\u0006V]&4\u0017.\u001a3M_\u001e\u00042A_Aw\u0013\r\tyo\u001b\u0002\u000e\r\u0006\\Wm\u00144gg\u0016$X*\u00199\t\u000f\u0005Mh\u00051\u0001\u0002R\u0005\u0001B.\u0019:hK6+7o]1hKNK'0Z\u0001\u0018i\u0016\u001cHo\u00117fC:LgnZ,ji\"$U\r\\3uKND3aJAG\u0003M!Xm\u001d;M_\u001e\u001cE.Z1oKJ\u001cF/\u0019;tQ\rA\u0013QR\u0001*i\u0016\u001cH\u000fT8h\u00072,\u0017M\\3s%\u0016$\u0018-\u001b8t!J|G-^2fe2\u000b7\u000f^*fcV,gnY3)\u0007%\ni)A\u001duKN$Hj\\4DY\u0016\fg.\u001a:SKR\f\u0017N\\:MCN$8+Z9vK:\u001cW-\u0012<f]&3GK]1og\u0006\u001cG/[8o\u0003\n|'\u000f^3eQ\rQ\u0013QR\u0001\u0018i\u0016\u001cH\u000fU1si&\fGnU3h[\u0016tGo\u00117fC:D3aKAG\u0003\t\"Xm\u001d;DY\u0016\fg.\u001b8h/&$\b.\u00168dY\u0016\fg.\u00192mKN+7\r^5p]\"\u001aA&!$\u0002\u001dQ,7\u000f\u001e'pOR{7\t\\3b]\"\u001aQ&!$\u0002IQ,7\u000f\u001e'pOR{7\t\\3b]^KG\u000f[+oG2,\u0017M\\1cY\u0016\u001cVm\u0019;j_:D3ALAG\u0003}!Xm\u001d;DY\u0016\fg.\u001b8h/&$\b.\u00168lKf,G-T3tg\u0006<Wm\u001d\u0015\u0004_\u00055\u0015\u0001\u00077bgR|eMZ:fiN\u0004VM\u001d\"bi\u000eD\u0017J\u001c'pOR!!Q\u0004B\u0015!\u0019\u0011yB!\n\u0002^5\u0011!\u0011\u0005\u0006\u0004\u0005G\u0019\u0018AC2pY2,7\r^5p]&!!q\u0005B\u0011\u0005!IE/\u001a:bE2,\u0007B\u000271\u0001\u0004\t)/\u0001\nmCN$8+Z9vK:\u001cWm]%o\u0019><G\u0003\u0002B\u0018\u0005k\u0001\u0002Ba\b\u00032\u0005u\u0013\u0011K\u0005\u0005\u0005g\u0011\tCA\u0002NCBDa\u0001\\\u0019A\u0002\u0005\u0015\u0018\u0001D8gMN,Go]%o\u0019><G\u0003\u0002B\u000f\u0005wAa\u0001\u001c\u001aA\u0002\u0005\u0015\u0018\u0001G;oW\u0016LX\rZ'fgN\fw-Z\"pk:$\u0018J\u001c'pOR!\u0011\u0011\u000bB!\u0011\u0019a7\u00071\u0001\u0002f\u0006q\u0011MY8si\u000eCWmY6E_:,G\u0003BA5\u0005\u000fBqA!\u00135\u0001\u0004\u0011Y%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\t5#\u0011L\u0007\u0003\u0005\u001fRAA!\u0015\u0003T\u000511m\\7n_:T1A\u001cB+\u0015\u0011\u00119&!!\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011YFa\u0014\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006QB/Z:u\u00072,\u0017M\\*fO6,g\u000e^:XSRD\u0017IY8si\"\u001aQ'!$\u0002'Q,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4)\u0007Y\ni)\u0001\u001buKN$8+Z4nK:$xI]8va&twmV5uQN\u0003\u0018M]:f\u001f\u001a47/\u001a;t\u0003:$W)\u001c9usN+w-\\3oiND3aNAG\u0003\u0011\"Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8h/&$\bn\u00159beN,wJ\u001a4tKR\u001c\bf\u0001\u001d\u0002\u000e\u0006YC/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO\u001a{G\u000e\\8xS:<Gj\\1e\u001f\u001aTVM]8J]\u0012,\u0007\u0010K\u0002:\u0003\u001b\u000b\u0011c\u00195fG.\u001cVmZ7f]R|%\u000fZ3s)\u0011\tIG!\u001e\t\u000f\t]$\b1\u0001\u0003z\u00051qM]8vaN\u0004bAa\b\u0003|\t}\u0014\u0002\u0002B?\u0005C\u00111aU3r!\u0019\u0011yBa\u001f\u0003\u0002B\u0019!Pa!\n\u0007\t\u00155N\u0001\u0006M_\u001e\u001cVmZ7f]R\f!\u0003^3ti\n+\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\"\u001a1(!$\u0002;Q,7\u000f^*fO6,g\u000e^,ji\"|eMZ:fi>3XM\u001d4m_^D3\u0001PAG\u0003Y!Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCND\u0007fA\u001f\u0002\u000e\u0006YB/Z:u\u0005VLG\u000eZ(gMN,G/T1q\r\u0006\\W\rT1sO\u0016D3APAG\u0003e!Xm\u001d;Ck&dG\rU1si&\fGn\u00144gg\u0016$X*\u00199)\u0007}\ni)\u0001\u000euKN$8\t\\3b]\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002A\u0003\u001b\u000bQ\u0005^3ti\u000ec\u0017.\u001a8u\u0011\u0006tG\r\\5oO>37i\u001c:skB$X*Z:tC\u001e,7+\u001a;)\u0007\u0005\u000bi)\u0001\nuKN$8\t\\3b]R{WNY:u_:,\u0007f\u0001\"\u0002\u000e\u0006\u0001C/Z:u\u00072,\u0017M\\5oO\n+\u0017p\u001c8e\u001b&\u001c8/\u001b8h\u001f\u001a47/\u001a;tQ\r\u0019\u0015QR\u0001\u0015i\u0016\u001cH/T1y\u00072,\u0017M\u001c+j[\u0016\u001cVmY:)\u0007\u0011\u000bi)\u0001\u0006xe&$X\rV8M_\u001e$\u0002B!\b\u00034\nU&Q\u0018\u0005\u0007Y\u0016\u0003\r!!:\t\u000f\t]V\t1\u0001\u0003:\u0006i1.Z=t\u0003:$g+\u00197vKN\u0004bAa\b\u0003&\tm\u0006c\u0002:\u0002b\u0006E\u0013\u0011\u000b\u0005\b\u0005\u007f+\u0005\u0019\u0001B\u000f\u0003%ygMZ:fiN+\u0017/A\u000bj]Z\fG.\u001b3DY\u0016\fg.\u001a3NKN\u001c\u0018mZ3\u0015\u0011\t\u0015'\u0011\u001bBk\u0005/\u0004BAa2\u0003N6\u0011!\u0011\u001a\u0006\u0005\u0005\u0017\u0014y%\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005\u001f\u0014IMA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0005'4\u0005\u0019AA/\u00035Ig.\u001b;jC2|eMZ:fi\"9!q\u0017$A\u0002\te\u0006\"\u0003Bm\rB\u0005\t\u0019\u0001Bn\u0003\u0015\u0019w\u000eZ3d!\u0011\u00119M!8\n\t\t}'\u0011\u001a\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\u0006y\u0012N\u001c<bY&$7\t\\3b]\u0016$W*Z:tC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0015(\u0006\u0002Bn\u0005O\\#A!;\u0011\t\t-(Q_\u0007\u0003\u0005[TAAa<\u0003r\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005g\u001c\u0018AC1o]>$\u0018\r^5p]&!!q\u001fBw\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012[\u0016\u001c8/Y4f/&$\bn\u00144gg\u0016$H\u0003\u0003Bc\u0005{\u001cia!\u0005\t\u000f\t}\b\n1\u0001\u0004\u0002\u0005\u00191.Z=\u0011\u000bI\u001c\u0019aa\u0002\n\u0007\r\u00151OA\u0003BeJ\f\u0017\u0010E\u0002s\u0007\u0013I1aa\u0003t\u0005\u0011\u0011\u0015\u0010^3\t\u000f\r=\u0001\n1\u0001\u0004\u0002\u0005)a/\u00197vK\"911\u0003%A\u0002\u0005u\u0013AB8gMN,G\u000f\u0006\u0005\u0003F\u000e]1\u0011DB\u000e\u0011\u001d\u0011y0\u0013a\u0001\u0003#Bqaa\u0004J\u0001\u0004\t\t\u0006C\u0004\u0004\u0014%\u0003\r!!\u0018\u0002\u000f5\f7.\u001a'pORA\u0011Q]B\u0011\u0007G\u00199\u0003\u0003\u0005\u0002\u000e)\u0003\n\u00111\u0001~\u0011%\u0019)C\u0013I\u0001\u0002\u0004\t9#\u0001\u0004d_:4\u0017n\u001a\u0005\n\u0007SQ\u0005\u0013!a\u0001\u0003;\nQB]3d_Z,'/\u001f)pS:$\u0018!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\u0006\u0016\u0004{\n\u001d\u0018!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0007\u0016\u0005\u0003O\u00119/A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIM*\"aa\u000f+\t\u0005u#q]\u0001\f[\u0006\\Wm\u00117fC:,'\u000f\u0006\u0005\u0004B\r\u001d31JB+!\rQ81I\u0005\u0004\u0007\u000bZ'aB\"mK\u0006tWM\u001d\u0005\b\u0007\u0013r\u0005\u0019AA)\u0003!\u0019\u0017\r]1dSRL\b\"CB'\u001dB\u0005\t\u0019AB(\u0003%\u0019\u0007.Z2l\t>tW\rE\u0004s\u0007#\u0012Y%!\u001b\n\u0007\rM3OA\u0005Gk:\u001cG/[8oc!I1q\u000b(\u0011\u0002\u0003\u0007\u0011\u0011K\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uII*\"a!\u0018+\t\r=#q]\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\u0019G\u000b\u0003\u0002R\t\u001dHC\u0002B\u000f\u0007O\u001aI\u0007\u0003\u0004m#\u0002\u0007\u0011Q\u001d\u0005\b\u0007W\n\u0006\u0019\u0001B]\u0003\r\u0019X-\u001d\u000b\u0005\u0007_\u001aY\b\u0005\u0003\u0004r\r]TBAB:\u0015\u0011\u0019)(a\u0001\u0002\u00079Lw.\u0003\u0003\u0004z\rM$A\u0003\"zi\u0016\u0014UO\u001a4fe\"91Q\u0010*A\u0002\u0005u\u0013AA5e)9\u0011)m!!\u0004\u0004\u000e\u00155\u0011RBJ\u0007/CqAa@T\u0001\u0004\t\t\u0006C\u0004\u0004\u0010M\u0003\r!!\u0015\t\u0013\r\u001d5\u000b%AA\u0002\u0005u\u0013A\u00039s_\u0012,8-\u001a:JI\"I11R*\u0011\u0002\u0003\u00071QR\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007I\u001cy)C\u0002\u0004\u0012N\u0014Qa\u00155peRD\u0011b!&T!\u0003\u0005\r!!\u0015\u0002\u0011M,\u0017/^3oG\u0016D\u0011b!'T!\u0003\u0005\r!!\u0015\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$3'\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111\u0011\u0015\u0016\u0005\u0007\u001b\u00139/\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0001\"/Z2pe\u0012$C-\u001a4bk2$HEN\u0001\u001cCB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:\u0015\u0019\r-6QWB\\\u0007s\u001bYla0\u0011\u000fI\u001c\tf!,\u00040B1!q\u0004B>\u0003#\u00022A_BY\u0013\r\u0019\u0019l\u001b\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\r1D\u0006\u0019AAs\u0011\u001d\u00199\t\u0017a\u0001\u0003;Bqaa#Y\u0001\u0004\u0019i\tC\u0005\u0004>b\u0003\n\u00111\u0001\u0002R\u0005YA.Z1eKJ,\u0005o\\2i\u0011%\u0019\t\r\u0017I\u0001\u0002\u0004\u0019\u0019-\u0001\u0004pe&<\u0017N\u001c\t\u0004u\u000e\u0015\u0017bABdW\na\u0011\t\u001d9f]\u0012|%/[4j]\u0006)\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u001bH*Z1eKJ$C-\u001a4bk2$H\u0005N\u0001&CB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uIU*\"aa4+\t\r\r'q]\u0001\u0019CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014HCDBV\u0007+\u001c9n!7\u0004\\\u000e\u00158q\u001d\u0005\u0007Yn\u0003\r!!:\t\u000f\r\u001d5\f1\u0001\u0002^!911R.A\u0002\r5\u0005\"CBo7B\u0005\t\u0019ABp\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007c\u0001:\u0004b&\u001911]:\u0003\u000f\t{w\u000e\\3b]\"I1QX.\u0011\u0002\u0003\u0007\u0011\u0011\u000b\u0005\n\u0007\u0003\\\u0006\u0013!a\u0001\u0007\u0007\f!%\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\"TCABwU\u0011\u0019yNa:\u0002E\u0005\u0004\b/\u001a8e\u0013\u0012,W\u000e]8uK:$\u0018i\u001d'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\t\n\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005a1m\\7nSRl\u0015M]6feRA!QYB|\u0007s\u001cY\u0010C\u0004\u0004\b~\u0003\r!!\u0018\t\u000f\r-u\f1\u0001\u0004\u000e\"I1Q`0\u0011\u0002\u0003\u0007\u0011QL\u0001\ni&lWm\u001d;b[B\facY8n[&$X*\u0019:lKJ$C-\u001a4bk2$HeM\u0001\fC\n|'\u000f^'be.,'\u000f\u0006\u0005\u0003F\u0012\u0015Aq\u0001C\u0005\u0011\u001d\u00199)\u0019a\u0001\u0003;Bqaa#b\u0001\u0004\u0019i\tC\u0005\u0004~\u0006\u0004\n\u00111\u0001\u0002^\u0005)\u0012MY8si6\u000b'o[3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D3oIRCh.T1sW\u0016\u0014H\u0003\u0004Bc\t#!\u0019\u0002\"\u0006\u0005 \u0011\u0005\u0002bBBDG\u0002\u0007\u0011Q\f\u0005\b\u0007\u0017\u001b\u0007\u0019ABG\u0011\u001d!9b\u0019a\u0001\t3\t\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\u00119\rb\u0007\n\t\u0011u!\u0011\u001a\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007bBB\nG\u0002\u0007\u0011Q\f\u0005\b\u0007{\u001c\u0007\u0019AA/)\u0019\u0011)\r\"\n\u0005(!9!q 3A\u0002\u0005E\u0003bBB\bI\u0002\u00071\u0011A\u0001\u000ek:\\W-_3e%\u0016\u001cwN\u001d3\u0015\t\t\u0015GQ\u0006\u0005\b\u0007\u001f)\u0007\u0019AA)\u0003=!x.\u001c2ti>tWMU3d_J$G\u0003\u0002Bc\tgAqAa@g\u0001\u0004\t\t&A\bsK\u000e|g/\u001a:B]\u0012\u001c\u0005.Z2l)\u0019\t)\u000f\"\u000f\u0005<!91QE4A\u0002\u0005\u001d\u0002b\u0002C\u001fO\u0002\u0007!QD\u0001\rKb\u0004Xm\u0019;fI.+\u0017p]\u0001\u0010eVtGk^8QCN\u001c8\t\\3b]RQ\u0011Q\fC\"\t\u000f\"\t\u0006\"\u0016\t\u000f\u0011\u0015\u0003\u000e1\u0001\u0004B\u000591\r\\3b]\u0016\u0014\bb\u0002C%Q\u0002\u0007A1J\u0001\u000bY><Gk\\\"mK\u0006t\u0007c\u0001>\u0005N%\u0019AqJ6\u0003\u00151{w\rV8DY\u0016\fg\u000eC\u0004\u0005T!\u0004\r!!\u0018\u0002\u0017\r,(O]3oiRKW.\u001a\u0005\n\u0003\u001bB\u0007\u0013!a\u0001\u0003;\n\u0011D];o)^|\u0007+Y:t\u00072,\u0017M\u001c\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class LogCleanerTest {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;
    private final int tombstoneRetentionMs;
    private final long largeTimestamp;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public int tombstoneRetentionMs() {
        return this.tombstoneRetentionMs;
    }

    public long largeTimestamp() {
        return this.largeTimestamp;
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$22, x$12, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Seq segments = ((TraversableOnce)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Iterable shouldRemain = (Iterable)LogTestUtils$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$2)));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata(), -1L);
        Assertions.assertEquals((Object)shouldRemain, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.dir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        int maxProducerIdExpirationMs = 3600000;
        LogSegments logSegments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.dir(), topicPartition, logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.dir(), topicPartition, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, logSegments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        LocalLog localLog = new LocalLog(this.dir(), config, logSegments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time().scheduler(), (Time)this.time(), topicPartition, logDirFailureChannel);
        UnifiedLog log = new UnifiedLog(null, offsets, localLog, leaderEpochCache, producerStateManager, deleteStartLatch, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments) {
                this.deleteStartLatch$1.countDown();
                if (!this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Log segment deletion timed out");
                }
                super.replaceSegments(newSegments, oldSegments);
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super(offsets$1.logStartOffset(), localLog$1, new BrokerTopicStats(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), leaderEpochCache$1, producerStateManager$1, (Option)None$.MODULE$, true);
            }
        };
        new Thread(null, deleteStartLatch, log, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final UnifiedLog log$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset(), (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.log$1 = log$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
            }
        }.start();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record(0, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            log.roll(log.roll$default$1());
        }
        Assertions.assertEquals((int)3, (int)log.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", UnifiedLog$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Seq segments = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 0L, log.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log, segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata(), -1L);
        Assertions.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assertions.assertEquals((int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertTrue((((LogSegment)log.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0, (String)"Cleaned segment file should be trimmed to its real size.");
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        ObjectRef log = ObjectRef.create((Object)this.makeLog(x$2, x$1, x$3));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        UnifiedLog qual$1 = (UnifiedLog)log.elem;
        Option x$4 = qual$1.roll$default$1();
        qual$1.roll(x$4);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (UnifiedLog)log.elem, 0L, ((UnifiedLog)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((UnifiedLog)log.elem));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((UnifiedLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((UnifiedLog)log.elem));
        this.reloadLog$1(log, logProps);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assertions.assertEquals((long)6L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assertions.assertEquals((long)3L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        UnifiedLog qual$2 = (UnifiedLog)log.elem;
        Option x$5 = qual$2.roll$default$1();
        qual$2.roll(x$5);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (UnifiedLog)log.elem, 0L, ((UnifiedLog)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((UnifiedLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((UnifiedLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((UnifiedLog)log.elem));
        this.reloadLog$1(log, logProps);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((UnifiedLog)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()))._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTestUtils$.MODULE$.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTestUtils$.MODULE$.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 100;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$5, x$4, x$6);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log));
        this.runTwoPassClean(cleaner, new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log, 1L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log, 2L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        producer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.roll(log.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
        this.runTwoPassClean(cleaner, new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = this.runTwoPassClean(cleaner, new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        this.runTwoPassClean(cleaner, new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        this.runTwoPassClean(cleaner, new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        int x$8 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$8, (AppendOrigin)x$7).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        AppendOrigin.Replication$ x$12 = AppendOrigin.Replication$.MODULE$;
        int x$13 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$13, (AppendOrigin)x$12).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
        this.runTwoPassClean(cleaner, new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = this.runTwoPassClean(cleaner, new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp())._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        this.runTwoPassClean(cleaner, new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), this.largeTimestamp(), this.runTwoPassClean$default$4());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((int)0, (int)log.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$32 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$32, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$5, x$4, x$6);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)((LogSegment)log.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata(), -1L);
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$3)))), LogTestUtils$.MODULE$.keysInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSize() {
        void var3_3;
        void var2_2;
        Tuple2<UnifiedLog, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        this.makeCleaner(x$1, x$3, x$2).cleanSegments((UnifiedLog)log2, (Seq)new .colon.colon((Object)((LogSegment)log2.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2).filter((Function1)((JFunction1.mcZJ.sp & Serializable & scala.Serializable)arg_0 -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSize$1((FakeOffsetMap)offsetMap2, arg_0)))), LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        void var3_3;
        void var2_2;
        Tuple2<UnifiedLog, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.logSegments().head()).log().file(), "rw");
        file.seek(16L);
        file.write(255);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(cleaner, (UnifiedLog)log2, (FakeOffsetMap)offsetMap2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        void var3_3;
        void var2_2;
        Tuple2<UnifiedLog, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.logSegments().head()).log().file(), "rw");
        file.setLength(1024L);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(cleaner, (UnifiedLog)log2, (FakeOffsetMap)offsetMap2));
    }

    public Tuple2<UnifiedLog, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log.updateConfig(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        return new Tuple2((Object)log, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1 & Serializable & scala.Serializable)key -> log.appendAsLeader(this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Set keys = LogTestUtils$.MODULE$.keysInLog(log).toSet();
        Assertions.assertTrue((boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$7))), (String)"None of the keys we deleted should still exist.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerStats() {
        void var13_10;
        void var11_9;
        Cleaner cleaner = this.makeCleaner(4, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((long)5L, (long)var11_9);
        Assertions.assertEquals((long)5L, (long)var13_10.messagesRead());
        Assertions.assertEquals((long)initialLogSize, (long)var13_10.bytesRead());
        Assertions.assertEquals((long)2L, (long)var13_10.messagesWritten());
        Assertions.assertEquals((long)log.size(), (long)var13_10.bytesWritten());
        Assertions.assertEquals((long)0L, (long)var13_10.invalidMessagesRead());
        Assertions.assertTrue((var13_10.endTime() >= var13_10.startTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 > N), (String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.");
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))), (String)"The cleanable segments should have fewer number of values after cleaning");
        Assertions.assertTrue((boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))), (String)"The uncleanable segments should have the same number of values after cleaning");
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        Assertions.assertEquals((long)new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()).totalBytes(), (long)(log.size() - (long)log.activeSegment().size()), (String)"Total bytes of LogToClean should equal size of all segments excluding the active segment");
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset(), LogToClean$.MODULE$.apply$default$5());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertEquals((long)logToClean.cleanBytes(), (long)expectedCleanSize, (String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty");
        Assertions.assertEquals((long)logToClean.cleanableBytes(), (long)expectedCleanableSize, (String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset");
        Assertions.assertEquals((long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize), (String)"Total bytes should be the sum of the clean and cleanable segments");
        Assertions.assertEquals((double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6, (String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithUnkeyedMessages() {
        void var14_11;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((int)0, (int)this.unkeyedMessageCountInLog(log), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)expectedSizeAfterCleaning, (long)log.size(), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)numInvalidMessages, (long)var14_11.invalidMessagesRead(), (String)"Cleaner should have seen %d invalid messages.");
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(UnifiedLog log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(UnifiedLog log) {
        return ((TraversableOnce)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable & scala.Serializable)batch -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(UnifiedLog log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)s -> (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.hasValue()))).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.hasKey()))).map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)m.offset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(UnifiedLog log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegmentsWithAbort() {
        void makeCleaner_checkDone;
        void makeCleaner_maxMessageSize;
        int n = this.makeCleaner$default$3();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
        int makeCleaner_capacity = Integer.MAX_VALUE;
        Cleaner cleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(makeCleaner_capacity), (int)makeCleaner_maxMessageSize, (int)makeCleaner_maxMessageSize, 0.75, this.throttler(), (Time)this.time(), (Function1)makeCleaner_checkDone);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keys = LogTestUtils$.MODULE$.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$15))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$16))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$18))), (String)"All but the last group should be the target size.");
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$19)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$20))), (String)"All but the last group should be the target size.");
    }

    @Test
    public void testSegmentGroupingWithSparseOffsetsAndEmptySegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        byte[] k = "key".getBytes();
        byte[] v = "val".getBytes();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(v, k, TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            MemoryRecords records = this.messageWithOffset(k, v, ((long)i + 1L) * 0x80000000L - 1L);
            log.appendAsFollower(records);
            Assertions.assertEquals((int)(i + 1), (int)log.numberOfSegments());
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(v, k, TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        int totalSegments = 4;
        long firstUncleanableOffset = log.logEndOffset() - 1L;
        int notCleanableSegments = 1;
        Assertions.assertEquals((int)totalSegments, (int)log.numberOfSegments());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, firstUncleanableOffset);
        Assertions.assertEquals((int)(totalSegments - notCleanableSegments), (int)groups.size());
        cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((int)totalSegments, (int)log.numberOfSegments());
        Assertions.assertEquals((int)0, (int)((LogSegment)log.logSegments().head()).size());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, firstUncleanableOffset);
        Assertions.assertEquals((int)(1 + 1), (int)groups.size());
        cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((int)(totalSegments - 1), (int)log.numberOfSegments());
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)(log.numberOfSegments() - 1), (int)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, x$1, x$3);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assertions.assertTrue((log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Actual offset range should be > Int.MaxValue");
        Assertions.assertTrue((((LogSegment)log.logSegments().last()).offsetIndex().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"index.lastOffset is reporting the wrong last offset");
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> (Seq)x$21.map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)x$22.baseOffset()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets, (String)"Offsets should be in increasing order.");
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        UnifiedLog log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), cleaner, log);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        long x$2 = Long.MAX_VALUE;
        File x$3 = this.makeLog$default$1();
        UnifiedLog log = this.makeLog(x$3, config, x$2);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        int numSegmentsInitial = log.logSegments().size();
        List allKeys = LogTestUtils$.MODULE$.keysInLog(log).toList();
        ArrayBuffer expectedKeysAfterCleaning = new ArrayBuffer();
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            expectedKeysAfterCleaning.$plus$eq(allKeys.apply(k - 1));
            offsetMap.put(this.key(BoxesRunTime.unboxToLong((Object)allKeys.apply(k))), Long.MAX_VALUE);
        });
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentWithOverflow, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)log.logSegments().size());
        Assertions.assertEquals((Object)allKeys, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTestUtils$.MODULE$.hasOffsetOverflow(log));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segmentToClean -> {
            cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentToClean, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)expectedKeysAfterCleaning, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTestUtils$.MODULE$.hasOffsetOverflow(log));
        log.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, config, x$3);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$4 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$5 = 0;
            AppendOrigin x$6 = log.appendAsLeader$default$3();
            ApiVersion x$7 = log.appendAsLeader$default$4();
            RequestLocal x$8 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$4, x$5, x$6, x$7, x$8);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTestUtils$.MODULE$.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        this.time().scheduler().clear();
        LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        this.time().scheduler().clear();
        LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        ((LogSegment)log.logSegments().head()).log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.logSegments().head()).log().file().getPath(), UnifiedLog$.MODULE$.CleanedFileSuffix(), UnifiedLog$.MODULE$.SwapFileSuffix())));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$6(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$7(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$9 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$10 = 0;
            AppendOrigin x$11 = log.appendAsLeader$default$3();
            ApiVersion x$12 = log.appendAsLeader$default$4();
            RequestLocal x$13 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$9, x$10, x$11, x$12, x$13);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$14 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$15 = 0;
            AppendOrigin x$16 = log.appendAsLeader$default$3();
            ApiVersion x$17 = log.appendAsLeader$default$4();
            RequestLocal x$18 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$14, x$15, x$16, x$17, x$18);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).timeIndex().file().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.logSegments().head()).timeIndex().file().getPath(), "", UnifiedLog$.MODULE$.SwapFileSuffix())));
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$19 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$20 = 0;
            AppendOrigin x$21 = log.appendAsLeader$default$3();
            ApiVersion x$22 = log.appendAsLeader$default$4();
            RequestLocal x$23 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$19, x$20, x$21, x$22, x$23);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        log = this.recoverAndCheck(config, cleanedKeys);
        log.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((long)offsetEnd, (long)map.latestOffset(), (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(keyEnd - keyStart), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        Assertions.assertEquals((long)0L, (long)map.get(this.key(0L)), (String)"Map should contain first value");
        Assertions.assertEquals((long)offsetEnd, (long)map.get(this.key(1L)), (String)"Map should contain second value");
    }

    @Test
    public void testBuildPartialOffsetMap() {
        UnifiedLog log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        OffsetMap map = cleaner.offsetMap();
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(4, 4, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, map, stats);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(0L)));
        Assertions.assertEquals((long)2L, (long)map.get(this.key(2L)));
        Assertions.assertEquals((long)3L, (long)map.get(this.key(3L)));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(4L)));
        Assertions.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3()).buffer());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        UnifiedLog log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$4 = "0".getBytes();
        byte[] x$5 = "0".getBytes();
        long x$6 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$7 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$8 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$4, x$5, x$7, x$6, x$8), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        byte[] x$10 = "0".getBytes();
        long x$11 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$12 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$13 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$10, x$12, x$11, x$13), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
        byte[] x$14 = "1".getBytes();
        byte[] x$15 = "1".getBytes();
        long x$16 = this.time().milliseconds();
        CompressionType x$17 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$18 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$14, x$15, x$17, x$16, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningBeyondMissingOffsets() {
        void var10_9;
        void var6_6;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(0x100000));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        UnifiedLog log = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)11L)));
        log.appendAsFollower(this.messageWithOffset(1015, 1015, 11L));
        Tuple2 tuple2 = cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)var6_6, (String)"Cleaning point should pass offset gap");
        UnifiedLog log2 = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)15L)));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(15), 24).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(15), 24), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(15L)).to((Object)BoxesRunTime.boxToLong((long)24L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)30L)));
        log2.appendAsFollower(this.messageWithOffset(1015, 1015, 30L));
        Tuple2 tuple22 = cleaner.clean(new LogToClean(log2.topicPartition(), log2, 0L, log2.activeSegment().baseOffset(), true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)log2.activeSegment().baseOffset(), (long)var10_9, (String)"Cleaning point should pass offset gap in multiple segments");
    }

    @Test
    public void testMaxCleanTimeSecs() {
        LogCleaner logCleaner = new LogCleaner(new CleanerConfig(CleanerConfig$.MODULE$.$lessinit$greater$default$1(), CleanerConfig$.MODULE$.$lessinit$greater$default$2(), CleanerConfig$.MODULE$.$lessinit$greater$default$3(), CleanerConfig$.MODULE$.$lessinit$greater$default$4(), CleanerConfig$.MODULE$.$lessinit$greater$default$5(), CleanerConfig$.MODULE$.$lessinit$greater$default$6(), CleanerConfig$.MODULE$.$lessinit$greater$default$7(), CleanerConfig$.MODULE$.$lessinit$greater$default$8(), CleanerConfig$.MODULE$.$lessinit$greater$default$9()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir()}), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()), new LogDirFailureChannel(1), (Time)this.time());
        try {
            this.checkGauge$1("max-buffer-utilization-percent", logCleaner);
            this.checkGauge$1("max-clean-time-secs", logCleaner);
            this.checkGauge$1("max-compaction-delay-secs", logCleaner);
        }
        finally {
            logCleaner.shutdown();
        }
    }

    private Iterable<Object> writeToLog(UnifiedLog log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && (Tuple2)check$ifrefutable$1._1() != null))).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$23)), Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable & scala.Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])Integer.toString(kv._1$mcI$sp()).getBytes(), (byte[])Integer.toString(kv._2$mcI$sp()).getBytes()), Iterable$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.sizeInBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(Integer.toString(key).getBytes(), Integer.toString(value).getBytes(), offset);
    }

    private UnifiedLog makeLog(File dir, LogConfig config, long recoveryPoint) {
        long x$3 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        None$ x$11 = None$.MODULE$;
        boolean x$12 = true;
        boolean x$13 = UnifiedLog$.MODULE$.apply$default$11();
        return UnifiedLog$.MODULE$.apply(dir, config, x$3, recoveryPoint, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$13, (Option)x$11, x$12);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$25 -> {
            LogCleanerTest.$anonfun$makeCleaner$default$2$1(x$25);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(UnifiedLog log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).map((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$26)), Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBuffer key(long id) {
        return ByteBuffer.wrap(Long.toString(id).getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(UnifiedLog log, long producerId, short producerEpoch, int leaderEpoch, AppendOrigin origin) {
        boolean x$4 = true;
        int x$6 = this.appendIdempotentAsLeader$default$5();
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, x$4, x$6, origin);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private AppendOrigin appendTransactionalAsLeader$default$5() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(UnifiedLog log, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, AppendOrigin origin) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable & scala.Serializable)keys -> {
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable & scala.Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)), Seq$.MODULE$.canBuildFrom());
            MemoryRecords records = isTransactional ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, leaderEpoch, origin, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private AppendOrigin appendIdempotentAsLeader$default$6() {
        return AppendOrigin.Client$.MODULE$;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$1 = Integer.toString(key).getBytes();
        CompressionType x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(value, x$1, x$3, x$4, x$5);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(Integer.toString(value).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private UnifiedLog recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler());
    }

    private long runTwoPassClean(Cleaner cleaner, LogToClean logToClean, long currentTime, long tombstoneRetentionMs) {
        cleaner.doClean(logToClean, currentTime);
        return cleaner.doClean(logToClean, currentTime + tombstoneRetentionMs + 1L)._1$mcJ$sp();
    }

    private long runTwoPassClean$default$4() {
        return 86400000L;
    }

    private final void reloadLog$1(ObjectRef log$2, Properties logProps$1) {
        ((UnifiedLog)log$2.elem).close();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$2 = 0L;
        File x$3 = this.makeLog$default$1();
        log$2.elem = this.makeLog(x$3, x$1, x$2);
    }

    private static final void assertAbortedTransactionIndexed$1(UnifiedLog log$3, long producerId$1) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        Assertions.assertEquals((long)producerId$1, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assertions.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testMessageLargerThanMaxMessageSize$1(FakeOffsetMap offsetMap$1, long k) {
        return !offsetMap$1.map().containsKey(Long.toString(k));
    }

    public static final /* synthetic */ void $anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(Cleaner cleaner$1, UnifiedLog log$4, FakeOffsetMap offsetMap$2) {
        cleaner$1.cleanSegments(log$4, (Seq)new .colon.colon((Object)((LogSegment)log$4.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
    }

    public static final /* synthetic */ void $anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(Cleaner cleaner$2, UnifiedLog log$5, FakeOffsetMap offsetMap$3) {
        cleaner$2.cleanSegments(log$5, (Seq)new .colon.colon((Object)((LogSegment)log$5.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata(), -1L);
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom())).toSet().size();
    }

    private static final Seq distinctValuesBySegment$1(UnifiedLog log$7) {
        return ((TraversableOnce)log$7.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int before = x0$1._1$mcI$sp();
        boolean bl = x0$1._2$mcI$sp() < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    private static final MemoryRecords createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private static final MemoryRecords createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.hasValue()))).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$15) {
        return x$15.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$16) {
        return x$16.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$18) {
        return x$18.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$19) {
        return x$19.offsetIndex().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$20) {
        return x$20.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Cleaner cleaner$4, UnifiedLog log$12) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$4.buildOffsetMap(log$12, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assertions.assertEquals((long)end, (long)endOffset, (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(end - start), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i)), (String)"Should find all the keys"));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(start - 1)), (String)"Should not find a value too small");
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(end)), (String)"Should not find a value too large");
        Assertions.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$4(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$5(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$6(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$7(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assertions.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assertions.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assertions.assertEquals((long)offset, (long)value);
    }

    public static final /* synthetic */ int kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1() {
        return 999;
    }

    private final void checkGauge$1(String name, LogCleaner logCleaner$1) {
        Gauge gauge = logCleaner$1.newGauge(name, (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerTest $outer;

            public final int value() {
                return LogCleanerTest.kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, logCleaner$1.newGauge$default$3());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, UnifiedLog log$14, Tuple2 x$23) {
        long offset;
        Tuple2 tuple2;
        block3: {
            block2: {
                if (x$23 == null) break block2;
                tuple2 = (Tuple2)x$23._1();
                offset = x$23._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)x$23);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$14.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$makeCleaner$default$2$1(TopicPartition x$25) {
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, UnifiedLog log$15, Tuple2 x$26) {
        if (x$26 == null) {
            throw new MatchError(null);
        }
        int key = x$26._1$mcI$sp();
        int value = x$26._2$mcI$sp();
        long l = ((LogOffsetMetadata)log$15.appendAsLeader($this.record(key, value, $this.record$default$3(), $this.record$default$4(), $this.record$default$5(), $this.record$default$6()), 0, log$15.appendAsLeader$default$3(), log$15.appendAsLeader$default$4(), log$15.appendAsLeader$default$5()).firstOffset().get()).messageOffset();
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = Integer.toString(key).getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$1 = Double.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        MockTime x$3 = this.time();
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$1, x$2, x$4, x$5, x$6, (Time)x$3);
        this.tombstoneRetentionMs = 86400000;
        this.largeTimestamp = Long.MAX_VALUE - (long)this.tombstoneRetentionMs() - 1L;
    }
}

