/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotasTest$ListenerDesc$;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011%a\u0001\u00021b\u0001\u0019DQ!\u001c\u0001\u0005\u00029D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002:\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u0001\u0003\u0006\u0002\u000e\u0001\u0001\r\u0011!Q!\nMD1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012!Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0015\u0011-\ti\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0005\t\u0017\u0005=\u0002\u00011AA\u0002\u0013%\u0011\u0011\u0007\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0004C\u0006\u0002@\u0001\u0001\r\u0011!Q!\n\u0005M\u0002bCA!\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007B1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002T!Y\u0011q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA#\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0003*\u0001\u0001\u000b\u0011BA/\u0011%\u0011Y\u0003\u0001b\u0001\n\u0013\u0011i\u0003\u0003\u0005\u0003P\u0001\u0001\u000b\u0011\u0002B\u0018\u0011%\u0011\t\u0006\u0001b\u0001\n\u0013\tY\n\u0003\u0005\u0003T\u0001\u0001\u000b\u0011BAO\u0011%\u0011)\u0006\u0001b\u0001\n\u0013\tY\n\u0003\u0005\u0003X\u0001\u0001\u000b\u0011BAO\u0011%\u0011I\u0006\u0001b\u0001\n\u0013\t)\u0010\u0003\u0005\u0003\\\u0001\u0001\u000b\u0011BA|\u0011%\u0011i\u0006\u0001b\u0001\n\u0013\t)\u0010\u0003\u0005\u0003`\u0001\u0001\u000b\u0011BA|\u0011%\u0011\t\u0007\u0001b\u0001\n\u0013\u0011\u0019\u0007\u0003\u0005\u0003l\u0001\u0001\u000b\u0011\u0002B3\r\u0019\tI\b\u0001!\u0002|!Q\u0011\u0011\u0012\u000f\u0003\u0016\u0004%\t!a#\t\u0015\u0005]ED!E!\u0002\u0013\ti\t\u0003\u0006\u0002\u001ar\u0011)\u001a!C\u0001\u00037C!\"!+\u001d\u0005#\u0005\u000b\u0011BAO\u0011\u0019iG\u0004\"\u0001\u0002,\"9\u0011\u0011\u0017\u000f\u0005B\u0005M\u0006\"CAe9\u0005\u0005I\u0011AAf\u0011%\t\t\u000eHI\u0001\n\u0003\t\u0019\u000eC\u0005\u0002jr\t\n\u0011\"\u0001\u0002l\"I\u0011q\u001e\u000f\u0002\u0002\u0013\u0005\u0013\u0011\u001f\u0005\n\u0003gd\u0012\u0011!C\u0001\u0003kD\u0011\"!@\u001d\u0003\u0003%\t!a@\t\u0013\t%A$!A\u0005B\t-\u0001\"\u0003B\n9\u0005\u0005I\u0011\u0001B\u000b\u0011%\u0011y\u0002HA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003$q\t\t\u0011\"\u0011\u0003&\u001dI!Q\u000e\u0001\u0002\u0002#\u0005!q\u000e\u0004\n\u0003s\u0002\u0011\u0011!E\u0001\u0005cBa!\u001c\u0018\u0005\u0002\t}\u0004\"CAY]\u0005\u0005IQ\tBA\u0011%\u0011\u0019ILA\u0001\n\u0003\u0013)\tC\u0005\u0003\f:\n\t\u0011\"!\u0003\u000e\"9!q\u0014\u0001\u0005\u0002\t\u0005\u0006b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005_\u0003A\u0011\u0001BW\u0011\u001d\u00119\r\u0001C\u0001\u0005[CqA!5\u0001\t\u0003\u0011i\u000bC\u0004\u0003\\\u0002!\tA!,\t\u000f\t}\u0007\u0001\"\u0001\u0003.\"9!1\u001d\u0001\u0005\u0002\t5\u0006b\u0002Bt\u0001\u0011\u0005!Q\u0016\u0005\b\u0005W\u0004A\u0011\u0001BW\u0011\u001d\u0011y\u000f\u0001C\u0001\u0005[CqAa=\u0001\t\u0003\u0011i\u000bC\u0004\u0003x\u0002!\tA!,\t\u000f\tm\b\u0001\"\u0001\u0003.\"9!q \u0001\u0005\u0002\t5\u0006bBB\u0002\u0001\u0011\u0005!Q\u0016\u0005\b\u0007\u000f\u0001A\u0011\u0001BW\u0011\u001d\u0019Y\u0001\u0001C\u0001\u0005[Cqaa\u0004\u0001\t\u0003\u0011i\u000bC\u0004\u0004\u0014\u0001!\tA!,\t\u000f\r]\u0001\u0001\"\u0001\u0003.\"911\u0004\u0001\u0005\u0002\t5\u0006bBB\u0010\u0001\u0011\u0005!Q\u0016\u0005\b\u0007G\u0001A\u0011\u0001BW\u0011\u001d\u00199\u0003\u0001C\u0005\u0007SAqaa\n\u0001\t\u0013\u0019i\u0004C\u0004\u0004^\u0001!IA!,\t\u000f\r}\u0003\u0001\"\u0003\u0003.\"91\u0011\r\u0001\u0005\n\r\r\u0004bBB7\u0001\u0011%!Q\u0016\u0005\b\u0007_\u0002A\u0011BB9\u0011\u001d\u0019I\b\u0001C\u0005\u0007wBqa!\"\u0001\t\u0013\u00199\tC\u0004\u0004\f\u0002!Ia!$\t\u000f\rE\u0005\u0001\"\u0003\u0004\u0014\"91Q\u0013\u0001\u0005\n\r]\u0005bBBO\u0001\u0011%1q\u0014\u0005\b\u0007K\u0003A\u0011BBT\u0011\u001d\u0019y\u000b\u0001C\u0005\u0007cC\u0011ba3\u0001#\u0003%Ia!4\t\u0013\rE\u0007!%A\u0005\n\rM\u0007bBBl\u0001\u0011%1\u0011\u001c\u0005\n\u0007[\u0004\u0011\u0013!C\u0005\u0007'Dqaa,\u0001\t\u0013\u0019y\u000fC\u0004\u0004\u0000\u0002!I\u0001\"\u0001\u0003)\r{gN\\3di&|g.U;pi\u0006\u001cH+Z:u\u0015\t\u00117-A\u0004oKR<xN]6\u000b\u0003\u0011\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001OB\u0011\u0001n[\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A8\u0011\u0005A\u0004Q\"A1\u0002\u000f5,GO]5dgV\t1\u000f\u0005\u0002u{6\tQO\u0003\u0002rm*\u0011q\u000f_\u0001\u0007G>lWn\u001c8\u000b\u0005\u0011L(B\u0001>|\u0003\u0019\t\u0007/Y2iK*\tA0A\u0002pe\u001eL!A`;\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\u0011\t\u0019!!\u0003\u0011\u0007!\f)!C\u0002\u0002\b%\u0014A!\u00168ji\"A\u00111B\u0002\u0002\u0002\u0003\u00071/A\u0002yIE\n\u0001\"\\3ue&\u001c7\u000fI\u0001\tKb,7-\u001e;peV\u0011\u00111\u0003\t\u0005\u0003+\t\u0019#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003;\ty\"\u0001\u0003vi&d'BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0012q\u0003\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006aQ\r_3dkR|'o\u0018\u0013fcR!\u00111AA\u0016\u0011%\tYABA\u0001\u0002\u0004\t\u0019\"A\u0005fq\u0016\u001cW\u000f^8sA\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0003\u0003g\u00012\u0001]A\u001b\u0013\r\t9$\u0019\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\fAcY8o]\u0016\u001cG/[8o#V|G/Y:`I\u0015\fH\u0003BA\u0002\u0003{A\u0011\"a\u0003\n\u0003\u0003\u0005\r!a\r\u0002#\r|gN\\3di&|g.U;pi\u0006\u001c\b%\u0001\u0003uS6,WCAA#!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&m\u0006)Q\u000f^5mg&!\u0011qJA%\u0005\u0011!\u0016.\\3\u0002\u0011QLW.Z0%KF$B!a\u0001\u0002V!I\u00111\u0002\u0007\u0002\u0002\u0003\u0007\u0011QI\u0001\u0006i&lW\rI\u0001\nY&\u001cH/\u001a8feN,\"!!\u0018\u0011\u0011\u0005}\u0013QMA5\u0003kj!!!\u0019\u000b\u0007\u0005\r\u0014.\u0001\u0006d_2dWm\u0019;j_:LA!a\u001a\u0002b\t\u0019Q*\u00199\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[RA!a\u001c\u0002 \u0005!A.\u00198h\u0013\u0011\t\u0019(!\u001c\u0003\rM#(/\u001b8h!\r\t9\bH\u0007\u0002\u0001\taA*[:uK:,'\u000fR3tGN1AdZA?\u0003\u0007\u00032\u0001[A@\u0013\r\t\t)\u001b\u0002\b!J|G-^2u!\rA\u0017QQ\u0005\u0004\u0003\u000fK'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00047jgR,g.\u001a:OC6,WCAAG!\u0011\ty)a%\u000e\u0005\u0005E%B\u00012w\u0013\u0011\t)*!%\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u001b1L7\u000f^3oKJt\u0015-\\3!\u0003%!WMZ1vYRL\u0005/\u0006\u0002\u0002\u001eB!\u0011qTAS\u001b\t\t\tK\u0003\u0003\u0002$\u0006}\u0011a\u00018fi&!\u0011qUAQ\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002\u0015\u0011,g-Y;mi&\u0003\b\u0005\u0006\u0004\u0002v\u00055\u0016q\u0016\u0005\b\u0003\u0013\u000b\u0003\u0019AAG\u0011\u001d\tI*\ta\u0001\u0003;\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\u0003B!a.\u0002F:!\u0011\u0011XAa!\r\tY,[\u0007\u0003\u0003{S1!a0f\u0003\u0019a$o\\8u}%\u0019\u00111Y5\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(a2\u000b\u0007\u0005\r\u0017.\u0001\u0003d_BLHCBA;\u0003\u001b\fy\rC\u0005\u0002\n\u000e\u0002\n\u00111\u0001\u0002\u000e\"I\u0011\u0011T\u0012\u0011\u0002\u0003\u0007\u0011QT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)N\u000b\u0003\u0002\u000e\u0006]7FAAm!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r\u0018.\u0001\u0006b]:|G/\u0019;j_:LA!a:\u0002^\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001e\u0016\u0005\u0003;\u000b9.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003S\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a>\u0011\u0007!\fI0C\u0002\u0002|&\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0001\u0003\bA\u0019\u0001Na\u0001\n\u0007\t\u0015\u0011NA\u0002B]fD\u0011\"a\u0003)\u0003\u0003\u0005\r!a>\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0004\u0011\r\u0005}#q\u0002B\u0001\u0013\u0011\u0011\t\"!\u0019\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005/\u0011i\u0002E\u0002i\u00053I1Aa\u0007j\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0003+\u0003\u0003\u0005\rA!\u0001\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a>\u0002\r\u0015\fX/\u00197t)\u0011\u00119Ba\n\t\u0013\u0005-A&!AA\u0002\t\u0005\u0011A\u00037jgR,g.\u001a:tA\u0005!\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feN,\"Aa\f\u0011\u0011\tE\"qGA[\u0005si!Aa\r\u000b\t\tU\u0012\u0011M\u0001\b[V$\u0018M\u00197f\u0013\u0011\t9Ga\r\u0011\t\tm\"1J\u0007\u0003\u0005{QAAa\u0010\u0003B\u0005!1m\u001c:f\u0015\r\t(1\t\u0006\u0005\u0005\u000b\u00129%\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005\u0013\n1aY8n\u0013\u0011\u0011iE!\u0010\u0003\u000b5+G/\u001a:\u0002+\tdwnY6fIB+'oY3oi6+G/\u001a:tA\u0005I1N\\8x]\"{7\u000f^\u0001\u000bW:|wO\u001c%pgR\u0004\u0013aC;oW:|wO\u001c%pgR\fA\"\u001e8l]><h\u000eS8ti\u0002\nqB\\;n#V|G/Y*b[BdWm]\u0001\u0011]Vl\u0017+^8uCN\u000bW\u000e\u001d7fg\u0002\na#];pi\u0006<\u0016N\u001c3poNK'0Z*fG>tGm]\u0001\u0018cV|G/Y,j]\u0012|woU5{KN+7m\u001c8eg\u0002\n1!\u001a9t+\t\u0011)\u0007E\u0002i\u0005OJ1A!\u001bj\u0005\u0019!u.\u001e2mK\u0006!Q\r]:!\u00031a\u0015n\u001d;f]\u0016\u0014H)Z:d!\r\t9HL\n\u0006]\tM\u00141\u0011\t\u000b\u0005k\u0012Y(!$\u0002\u001e\u0006UTB\u0001B<\u0015\r\u0011I([\u0001\beVtG/[7f\u0013\u0011\u0011iHa\u001e\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003pQ\u0011\u0011\u0011N\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003k\u00129I!#\t\u000f\u0005%\u0015\u00071\u0001\u0002\u000e\"9\u0011\u0011T\u0019A\u0002\u0005u\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001f\u0013Y\nE\u0003i\u0005#\u0013)*C\u0002\u0003\u0014&\u0014aa\u00149uS>t\u0007c\u00025\u0003\u0018\u00065\u0015QT\u0005\u0004\u00053K'A\u0002+va2,'\u0007C\u0005\u0003\u001eJ\n\t\u00111\u0001\u0002v\u0005\u0019\u0001\u0010\n\u0019\u0002M\t\u0014xn[3s!J|\u0007o],ji\"$UMZ1vYR\u001cuN\u001c8fGRLwN\u001c'j[&$8/\u0006\u0002\u0003$B!!Q\u0015BT\u001b\t\tY\"\u0003\u0003\u0003*\u0006m!A\u0003)s_B,'\u000f^5fg\u0006i1/\u001a;va6{7m\u001b+j[\u0016$\"!a\u0001\u0002\u000bM,G/\u00169)\u0007U\u0012\u0019\f\u0005\u0003\u00036\n\rWB\u0001B\\\u0015\u0011\u0011ILa/\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003>\n}\u0016a\u00026va&$XM\u001d\u0006\u0004\u0005\u0003\\\u0018!\u00026v]&$\u0018\u0002\u0002Bc\u0005o\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u001c\u0003LB!!Q\u0017Bg\u0013\u0011\u0011yMa.\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0006;fgR4\u0015-\u001b7XQ\u0016tgj\u001c'jgR,g.\u001a:tQ\r9$Q\u001b\t\u0005\u0005k\u00139.\u0003\u0003\u0003Z\n]&\u0001\u0002+fgR\fQ\u0004^3ti\u001a\u000b\u0017\u000e\u001c#fGJ,W.\u001a8u\r>\u0014XK\\6o_^t\u0017\n\u001d\u0015\u0004q\tU\u0017a\b;fgRtunQ8o]\u0016\u001cG/[8o\u0019&l\u0017\u000e^:Cs\u0012+g-Y;mi\"\u001a\u0011H!6\u0002/Q,7\u000f^'bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\bf\u0001\u001e\u0003V\u0006\u0001C/Z:u\u001b\u0006D(I]8lKJ<\u0016\u000eZ3D_:tWm\u0019;j_:d\u0015.\\5uQ\rY$Q[\u0001 i\u0016\u001cH/T1y\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|g\u000eT5nSR\u001c\bf\u0001\u001f\u0003V\u0006)D/Z:u\u0005J|7.\u001a:D_:tWm\u0019;j_:\u0014\u0016\r^3MS6LGo\u00165f]\u0006\u001bG/^1m%\u0006$XMQ3m_^d\u0015.\\5uQ\ri$Q[\u00016i\u0016\u001cHO\u0011:pW\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,G*[7ji^CWM\\!diV\fGNU1uK\u0006\u0013wN^3MS6LG\u000fK\u0002?\u0005+\fq\u0007^3ti2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016d\u0015.\\5u/\",g.Q2uk\u0006d'+\u0019;f\u0005\u0016dwn\u001e'j[&$\bfA \u0003V\u00069D/Z:u\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|gNU1uK2KW.\u001b;XQ\u0016t\u0017i\u0019;vC2\u0014\u0016\r^3BE>4X\rT5nSRD3\u0001\u0011Bk\u00031\"Xm\u001d;Ja\u000e{gN\\3di&|gNU1uK^CWM\\!diV\fGNU1uK\n+Gn\\<MS6LG\u000fK\u0002B\u0005+\fA\u0006^3ti&\u00038i\u001c8oK\u000e$\u0018n\u001c8SCR,w\u000b[3o\u0003\u000e$X/\u00197SCR,\u0017IY8wK2KW.\u001b;)\u0007\t\u0013).\u0001\u0018uKN$\u0018\n]\"p]:,7\r^5p]J\u000bG/Z,ji\"d\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0007fA\"\u0003V\u0006QD/Z:u%\u0016TWm\u0019;fI&\u00038i\u001c8oK\u000e$\u0018n\u001c8V]J,7m\u001c:eK\u00124%o\\7D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018m\u001d\u0015\u0004\t\nU\u0017\u0001\r;fgRl\u0015\r\u001f'jgR,g.\u001a:D_:tWm\u0019;j_:d\u0015n\u001d;f]\u0016\u0014X*^:u\u0005\u0016\f%m\u001c<f5\u0016\u0014x\u000eK\u0002F\u0005+\fA\u0006^3ti6\u000b\u0007\u0010T5ti\u0016tWM]\"p]:,7\r^5p]J\u000bG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8)\u0007\u0019\u0013).\u0001\u0016uKN$X*\u0019=Ce>\\WM]\"p]:,7\r^5p]J\u000bG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8)\u0007\u001d\u0013).\u0001\u0011uKN$\u0018\n]\"p]:,7\r^5p]J\u000bG/Z'fiJL7-\u00169eCR,\u0007f\u0001%\u0003V\u00069C/Z:u\u000b:4wN]2fI&\u00038i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uCV\u0003H-\u0019;fQ\rI%Q[\u0001/i\u0016\u001cHOT8o\t\u00164\u0017-\u001e7u\u0007>tg.Z2uS>t7i\\;oi2KW.\u001b;B]\u0012\u0014\u0016\r^3MS6LG\u000fK\u0002K\u0005+\fQ#\u00193e\u0019&\u001cH/\u001a8feN\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0004\u0002\u0004\r-21\b\u0005\b\u0007[Y\u0005\u0019AB\u0018\u0003\u0019\u0019wN\u001c4jOB!1\u0011GB\u001c\u001b\t\u0019\u0019DC\u0002\u00046\r\faa]3sm\u0016\u0014\u0018\u0002BB\u001d\u0007g\u00111bS1gW\u0006\u001cuN\u001c4jO\"9\u0011qF&A\u0002\u0005MB\u0003CA\u0002\u0007\u007f\u0019\tea\u0017\t\u000f\r5B\n1\u0001\u00040!911\t'A\u0002\r\u0015\u0013A\u00047jgR,g.\u001a:D_:4\u0017n\u001a\u0019\u0005\u0007\u000f\u001ay\u0005\u0005\u0005\u0003&\u000e%\u0013QWB&\u0013\u0011\t9'a\u0007\u0011\t\r53q\n\u0007\u0001\t1\u0019\tf!\u0011\u0002\u0002\u0003\u0005)\u0011AB*\u0005\ryF%M\t\u0005\u0007+\u0012\t\u0001E\u0002i\u0007/J1a!\u0017j\u0005\u001dqu\u000e\u001e5j]\u001eDq!a\fM\u0001\u0004\t\u0019$\u0001\u0017wKJLg-\u001f(p\u00052|7m[3e!\u0016\u00148-\u001a8u%\u0016\u001cwN\u001d3fI>s\u0017\t\u001c7MSN$XM\\3sg\u0006Ad/\u001a:jMftuN\u001c.fe>\u0014En\\2lK\u0012\u0004VM]2f]R\fe\u000e\u001a+ie>$H\u000f\\3US6,wJ\\!mY2K7\u000f^3oKJ\u001c\u0018A\b<fe&4\u00170\u00139UQJ|G\u000f\u001e7f)&lWm\u00148MSN$XM\\3s)\u0019\t\u0019a!\u001a\u0004j!91qM(A\u0002\u00055\u0015\u0001\u00037jgR,g.\u001a:\t\u000f\r-t\n1\u0001\u0003\u0018\u0005qQ\r\u001f9fGR$\u0006N]8ui2,\u0017a\u000e<fe&4\u0017p\u00148ms:{g.\u00138uKJ\u0014%o\\6fe2K7\u000f^3oKJ\u001c(\t\\8dW\u0016$\u0007+\u001a:dK:$(+Z2pe\u0012,G-\u0001\u0013wKJLg-_\"p]:,7\r^5p]\u000e{WO\u001c;P]\u00163XM]=MSN$XM\\3s)\u0019\t\u0019aa\u001d\u0004v!9\u0011qF)A\u0002\u0005M\u0002bBB<#\u0002\u0007\u0011q_\u0001\u0018Kb\u0004Xm\u0019;fI\u000e{gN\\3di&|gnQ8v]R\f!\u0004\\5ti\u0016tWM]\"p]:$\u0006N]8ui2,W*\u001a;sS\u000e$Ba! \u0004\u0004B\u0019Aoa \n\u0007\r\u0005UOA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007bBB4%\u0002\u0007\u0011QW\u0001\u0015SB\u001cuN\u001c8UQJ|G\u000f\u001e7f\u001b\u0016$(/[2\u0015\t\ru4\u0011\u0012\u0005\b\u0007O\u001a\u0006\u0019AA[\u0003Ya\u0017n\u001d;f]\u0016\u00148i\u001c8o%\u0006$X-T3ue&\u001cG\u0003BB?\u0007\u001fCqaa\u001aU\u0001\u0004\t),\u0001\u000bce>\\WM]\"p]:\u0014\u0016\r^3NKR\u0014\u0018n\u0019\u000b\u0003\u0007{\n\u0001#\u001b9D_:t'+\u0019;f\u001b\u0016$(/[2\u0015\t\ru4\u0011\u0014\u0005\b\u000773\u0006\u0019AA[\u0003\tI\u0007/A\u0006nKR\u0014\u0018n\u0019,bYV,G\u0003\u0002B3\u0007CCqaa)X\u0001\u0004\u0019i(\u0001\u0004nKR\u0014\u0018nY\u0001\u0018m\u0016\u0014\u0018NZ=Ja\u000e{gN\\3di&|g.U;pi\u0006$b!a\u0001\u0004*\u000e-\u0006bBBN1\u0002\u0007\u0011Q\u0014\u0005\b\u0007[C\u0006\u0019AA|\u0003\u0015\tXo\u001c;b\u0003E\t7mY3qi\u000e{gN\\3di&|gn\u001d\u000b\r\u0003\u0007\u0019\u0019l!.\u0004:\u000e\r7q\u0019\u0005\b\u0003_I\u0006\u0019AA\u001a\u0011\u001d\u00199,\u0017a\u0001\u0003k\nA\u0002\\5ti\u0016tWM\u001d#fg\u000eDqaa/Z\u0001\u0004\u0019i,\u0001\bok6\u001cuN\u001c8fGRLwN\\:\u0011\u0007!\u001cy,C\u0002\u0004B&\u0014A\u0001T8oO\"I1QY-\u0011\u0002\u0003\u00071QX\u0001\u000fi&lW-\u00138uKJ4\u0018\r\\'t\u0011%\u0019I-\u0017I\u0001\u0002\u0004\u00119\"\u0001\tfqB,7\r^%q)\"\u0014x\u000e\u001e;mK\u0006Y\u0012mY2faR\u001cuN\u001c8fGRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"aa4+\t\ru\u0016q[\u0001\u001cC\u000e\u001cW\r\u001d;D_:tWm\u0019;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\rU'\u0006\u0002B\f\u0003/\fa$Y2dKB$8i\u001c8oK\u000e$\u0018n\u001c8t\u0003:$g+\u001a:jMf\u0014\u0016\r^3\u0015!\u0005\r11\\Bo\u0007?\u001c\toa9\u0004h\u000e-\bbBA\u00189\u0002\u0007\u00111\u0007\u0005\b\u0007oc\u0006\u0019AA;\u0011\u001d\u0019Y\f\u0018a\u0001\u0007{Cqa!2]\u0001\u0004\u0019i\fC\u0004\u0004fr\u0003\r!a>\u0002\u0019\u0015D\b/Z2uK\u0012\u0014\u0016\r^3\t\u000f\r%H\f1\u0001\u0002x\u00069Q\r]:jY>t\u0007\"CBe9B\u0005\t\u0019\u0001B\f\u0003!\n7mY3qi\u000e{gN\\3di&|gn]!oIZ+'/\u001b4z%\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00138)9\u00119b!=\u0004t\u000eU8\u0011`B~\u0007{Dq!a\f_\u0001\u0004\t\u0019\u0004C\u0004\u0002\nz\u0003\r!!$\t\u000f\r]h\f1\u0001\u0002\u001e\u00069\u0011\r\u001a3sKN\u001c\bbBB^=\u0002\u00071Q\u0018\u0005\b\u0007\u000bt\u0006\u0019AB_\u0011\u001d\u0019IM\u0018a\u0001\u0005/\tQ$Y2dKB$8i\u001c8oK\u000e$\u0018n\u001c8t\u0003\n|g/Z%q\u0019&l\u0017\u000e\u001e\u000b\t\u0003\u0007!\u0019\u0001\"\u0002\u0005\b!9\u0011qF0A\u0002\u0005M\u0002bBB\\?\u0002\u0007\u0011Q\u000f\u0005\b\u0007w{\u0006\u0019AB_\u0001")
public class ConnectionQuotasTest {
    private volatile ConnectionQuotasTest$ListenerDesc$ ListenerDesc$module;
    private Metrics metrics;
    private ExecutorService executor;
    private ConnectionQuotas connectionQuotas;
    private Time time;
    private final Map<String, ListenerDesc> listeners = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)new ListenerDesc(this, new ListenerName("EXTERNAL"), InetAddress.getByName("192.168.1.1"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ADMIN"), (Object)new ListenerDesc(this, new ListenerName("ADMIN"), InetAddress.getByName("192.168.1.2"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REPLICATION"), (Object)new ListenerDesc(this, new ListenerName("REPLICATION"), InetAddress.getByName("192.168.1.3")))}));
    private final scala.collection.mutable.Map<String, Meter> blockedPercentMeters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final InetAddress knownHost = InetAddress.getByName("192.168.10.0");
    private final InetAddress unknownHost = InetAddress.getByName("192.168.2.0");
    private final int numQuotaSamples;
    private final int quotaWindowSizeSeconds;
    private final double eps;

    public ConnectionQuotasTest$ListenerDesc$ ListenerDesc() {
        if (this.ListenerDesc$module == null) {
            this.ListenerDesc$lzycompute$1();
        }
        return this.ListenerDesc$module;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private Map<String, ListenerDesc> listeners() {
        return this.listeners;
    }

    private scala.collection.mutable.Map<String, Meter> blockedPercentMeters() {
        return this.blockedPercentMeters;
    }

    private InetAddress knownHost() {
        return this.knownHost;
    }

    private InetAddress unknownHost() {
        return this.unknownHost;
    }

    private int numQuotaSamples() {
        return this.numQuotaSamples;
    }

    private int quotaWindowSizeSeconds() {
        return this.quotaWindowSizeSeconds;
    }

    private double eps() {
        return this.eps;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithDefaultConnectionLimits() {
        void var1_21;
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 0;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), Integer.toString(this.numQuotaSamples()));
        props.put(KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp(), Integer.toString(this.quotaWindowSizeSeconds()));
        return var1_21;
    }

    private void setupMockTime() {
        this.metrics().close();
        this.time_$eq((Time)new MockTime());
        this.metrics_$eq(new Metrics(this.time()));
    }

    @BeforeEach
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.listeners().keys().foreach((Function1 & Serializable & scala.Serializable)name -> this.blockedPercentMeters().put(name, (Object)KafkaMetricsGroup$.MODULE$.newMeter(new StringBuilder(14).append((String)name).append("BlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), name)})))));
        this.time_$eq(Time.SYSTEM);
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), this.time()));
        this.executor_$eq(Executors.newFixedThreadPool(this.listeners().size()));
    }

    @AfterEach
    public void tearDown() {
        this.executor().shutdownNow();
        if (this.connectionQuotas() != null) {
            this.connectionQuotas().close();
        }
        this.metrics().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        this.blockedPercentMeters().clear();
    }

    @Test
    public void testFailWhenNoListeners() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> Assertions.assertThrows(RuntimeException.class, () -> this.connectionQuotas().inc(listener.listenerName(), listener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")))).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testFailDecrementForUnknownIp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), this.unknownHost()));
    }

    @Test
    public void testNoConnectionLimitsByDefault() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int numConnections = 10000;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, numConnections, this.acceptConnections$default$4(), this.acceptConnections$default$5())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((this.metricValue(this.brokerConnRateMetric()) > 0.0 ? 1 : 0) != 0, (String)"Expected broker-connection-accept-rate metric to get recorded");
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testNoConnectionLimitsByDefault$4(this, numConnections, listener);
            return BoxedUnit.UNIT;
        });
        this.verifyNoBlockedPercentRecordedOnAllListeners();
    }

    @Test
    public void testMaxConnectionsPerIp() {
        int maxConnectionsPerIp = 17;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), Integer.toString(maxConnectionsPerIp));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, maxConnectionsPerIp, this.acceptConnections$default$4(), this.acceptConnections$default$5())).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnectionsPerIp, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.executor().submit(() -> this.acceptConnectionsAboveIpLimit(this.connectionQuotas(), externalListener, 2L)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)(maxConnectionsPerIp + 2), (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener.listenerName(), this.knownHost(), maxConnectionsPerIp, 0L, false)).get(5L, TimeUnit.SECONDS);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> this.connectionQuotas().dec(externalListener.listenerName(), externalListener.defaultIp()));
        Assertions.assertEquals((int)(maxConnectionsPerIp - 2), (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, 2L, this.acceptConnections$default$4(), this.acceptConnections$default$5())).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnectionsPerIp, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
    }

    @Test
    public void testMaxBrokerWideConnectionLimit() {
        int maxConnections = 800;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), Integer.toString(maxConnections));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), maxConnections, this.acceptConnections$default$4(), this.acceptConnections$default$5())).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString());
        Assertions.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
        Assertions.assertFalse((boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()), (String)"Total number of connections is exactly the maximum.");
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, this.acceptConnections$default$4(), this.acceptConnections$default$5()));
        Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString());
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric to be recorded");
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, this.acceptConnections$default$4(), this.acceptConnections$default$5())).get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()), (String)"Expected the number of connections to exceed the maximum.");
        Future<?> future1 = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"ADMIN"), 1L, this.acceptConnections$default$4(), this.acceptConnections$default$5()));
        Assertions.assertThrows(TimeoutException.class, () -> future1.get(1L, TimeUnit.SECONDS));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, this.acceptConnections$default$4(), this.acceptConnections$default$5())).get(5L, TimeUnit.SECONDS);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
        Assertions.assertThrows(TimeoutException.class, () -> future1.get(100L, TimeUnit.MILLISECONDS));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future1.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testMaxListenerConnectionLimits() {
        int maxConnections = 800;
        int listenerMaxConnections = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), Integer.toString(maxConnections));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionsProp()), (Object)Integer.toString(listenerMaxConnections))}))).asJava();
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$1(this, listenerConfig, listener);
            return BoxedUnit.UNIT;
        });
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, listenerMaxConnections, this.acceptConnections$default$4(), this.acceptConnections$default$5())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(5L, TimeUnit.SECONDS));
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$5(this, listenerMaxConnections, listener);
            return BoxedUnit.UNIT;
        });
        Iterable overLimitFutures = (Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, 1L, this.acceptConnections$default$4(), this.acceptConnections$default$5())), Iterable$.MODULE$.canBuildFrom());
        overLimitFutures.foreach((Function1 & Serializable & scala.Serializable)future -> (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> future.get(1L, TimeUnit.SECONDS)));
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$10(this, listener);
            return BoxedUnit.UNIT;
        });
        overLimitFutures.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(5L, TimeUnit.SECONDS));
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), listenerMaxConnections);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateBelowLimit() {
        int brokerRateLimit = 125;
        int connCreateIntervalMs = 25;
        int connectionsPerListener = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, this.acceptConnections$default$5())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateAboveLimit() {
        int brokerRateLimit = 90;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int connCreateIntervalMs = 10;
        int connectionsPerListener = 400;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, this.acceptConnections$default$5())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get(20L, TimeUnit.SECONDS));
        this.verifyOnlyNonInterBrokerListenersBlockedPercentRecorded();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testListenerConnectionRateLimitWhenActualRateBelowLimit() {
        int brokerRateLimit = 125;
        int listenerRateLimit = 50;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 200;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, this.acceptConnections$default$5())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testListenerConnectionRateLimitWhenActualRateAboveLimit() {
        int brokerRateLimit = 125;
        int listenerRateLimit = 30;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 600;
        ((Iterable)this.listeners().values().map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, listenerRateLimit, 7, this.acceptConnectionsAndVerifyRate$default$7())), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(30L, TimeUnit.SECONDS));
        this.verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testIpConnectionRateWhenActualRateBelowLimit() {
        int ipConnectionRateLimit = 30;
        int connCreateIntervalMs = 40;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.setupMockTime();
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        int numConnections = 200;
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), externalListener, numConnections, connCreateIntervalMs, 25, 0, this.acceptConnectionsAndVerifyRate$default$7());
        Assertions.assertEquals((int)numConnections, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        int unthrottledConnectionCreateInterval = 20;
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), adminListener, numConnections, unthrottledConnectionCreateInterval, 50, 0, this.acceptConnectionsAndVerifyRate$default$7());
        Assertions.assertEquals((int)numConnections, (int)this.connectionQuotas().get(adminListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(adminListener).append(":").toString());
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        ((IterableLike)this.listeners().values().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.listenerName(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            this.verifyIpThrottleTimeOnListener(x$9, false);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIpConnectionRateWhenActualRateAboveLimit() {
        int ipConnectionRateLimit = 20;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.setupMockTime();
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        int numConnections = 80;
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), externalListener, numConnections, connCreateIntervalMs, ipConnectionRateLimit, 1, true);
        this.verifyIpThrottleTimeOnListener(externalListener.listenerName(), true);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        this.verifyIpThrottleTimeOnListener(adminListener.listenerName(), false);
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), adminListener, numConnections, connCreateIntervalMs, ipConnectionRateLimit, 1, true);
        this.verifyIpThrottleTimeOnListener(adminListener.listenerName(), true);
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyIpThrottleTimeOnListener(((ListenerDesc)this.listeners().apply((Object)"REPLICATION")).listenerName(), false);
    }

    @Test
    public void testIpConnectionRateWithListenerConnectionRate() {
        int ipConnectionRateLimit = 25;
        int listenerRateLimit = 35;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        ListenerName listener = ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName();
        int numConnections = 35;
        List throttledIps = (List)((List)new .colon.colon(this.executor().submit(() -> BoxesRunTime.boxToBoolean((boolean)this.acceptConnections(this.connectionQuotas(), listener, this.knownHost(), numConnections, 0L, true))), (List)new .colon.colon(this.executor().submit(() -> BoxesRunTime.boxToBoolean((boolean)this.acceptConnections(this.connectionQuotas(), listener, this.unknownHost(), numConnections, 0L, true))), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConnectionQuotasTest.$anonfun$testIpConnectionRateWithListenerConnectionRate$3(x$10)), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ConnectionQuotasTest.$anonfun$testIpConnectionRateWithListenerConnectionRate$4(BoxesRunTime.unboxToBoolean((Object)x))));
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
        Assertions.assertTrue((throttledIps.size() < 2 ? 1 : 0) != 0, (String)"Expect at most one IP to get throttled");
    }

    @Test
    public void testRejectedIpConnectionUnrecordedFromConnectionRateQuotas() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, (Time)new MockTime(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        ListenerDesc protectedListener = (ListenerDesc)this.listeners().apply((Object)"REPLICATION");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)protectedListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.connectionQuotas().inc(externalListener.listenerName(), externalListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")));
        KafkaMetric brokerRateMetric = this.brokerConnRateMetric();
        Assertions.assertEquals((double)0.0, (double)this.metricValue(this.ipConnRateMetric(externalListener.defaultIp().getHostAddress())), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)this.metricValue(this.listenerConnRateMetric(externalListener.listenerName().value())), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)this.metricValue(brokerRateMetric), (double)this.eps());
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.connectionQuotas().inc(protectedListener.listenerName(), protectedListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"REPLICATION")));
        Assertions.assertEquals((double)0.0, (double)this.metricValue(this.ipConnRateMetric(protectedListener.defaultIp().getHostAddress())), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)this.metricValue(this.listenerConnRateMetric(protectedListener.listenerName().value())), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)this.metricValue(brokerRateMetric), (double)this.eps());
    }

    @Test
    public void testMaxListenerConnectionListenerMustBeAboveZero() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int maxListenerConnectionRate = 0;
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(maxListenerConnectionRate))}))).asJava();
        Assertions.assertThrows(ConfigException.class, () -> ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).validateReconfiguration(listenerConfig));
    }

    @Test
    public void testMaxListenerConnectionRateReconfiguration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int listenerRateLimit = 20;
        java.util.Map listenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).configure(listenerConfig);
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.empty()).asJava());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1000L, this.acceptConnections$default$4(), this.acceptConnections$default$5())).get(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count(), (String)"BlockedPercentMeter metric for EXTERNAL listener");
        int newMaxListenerConnectionRate = 10;
        java.util.Map newListenerConfig = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(newMaxListenerConnectionRate))}))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure(newListenerConfig);
        int connectionsPerListener = 200;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), connectionsPerListener, 5L, newMaxListenerConnectionRate, 3, this.acceptConnectionsAndVerifyRate$default$7())).get(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
    }

    @Test
    public void testMaxBrokerConnectionRateReconfiguration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        int maxBrokerConnectionRate = 50;
        this.connectionQuotas().updateBrokerMaxConnectionRate(maxBrokerConnectionRate);
        int totalConnections = 400;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), totalConnections, 5L, maxBrokerConnectionRate, 20, this.acceptConnectionsAndVerifyRate$default$7())).get(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
    }

    @Test
    public void testIpConnectionRateMetricUpdate() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"ADMIN")).listenerName());
        int defaultIpRate = 50;
        int defaultOverrideRate = 20;
        int overrideIpRate = 30;
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)defaultIpRate)));
        this.connectionQuotas().inc(externalListener.listenerName(), externalListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL"));
        this.connectionQuotas().inc(adminListener.listenerName(), adminListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"ADMIN"));
        this.verifyIpConnectionQuota(externalListener.defaultIp(), defaultIpRate);
        this.verifyIpConnectionQuota(adminListener.defaultIp(), defaultIpRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)overrideIpRate)));
        this.verifyIpConnectionQuota(externalListener.defaultIp(), overrideIpRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)defaultOverrideRate)));
        this.verifyIpConnectionQuota(externalListener.defaultIp(), overrideIpRate);
        this.verifyIpConnectionQuota(adminListener.defaultIp(), defaultOverrideRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)None$.MODULE$);
        this.verifyIpConnectionQuota(adminListener.defaultIp(), Integer.MAX_VALUE);
        this.verifyIpConnectionQuota(externalListener.defaultIp(), overrideIpRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)None$.MODULE$);
        this.verifyIpConnectionQuota(externalListener.defaultIp(), Integer.MAX_VALUE);
    }

    @Test
    public void testEnforcedIpConnectionRateQuotaUpdate() {
        int ipConnectionRateLimit = 20;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.setupMockTime();
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        int connectionRate = 40;
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.acceptConnections(this.connectionQuotas(), externalListener, connectionRate, this.acceptConnections$default$4(), this.acceptConnections$default$5()));
        Assertions.assertEquals((int)ipConnectionRateLimit, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        int updatedRateLimit = 30;
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)updatedRateLimit)));
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.acceptConnections(this.connectionQuotas(), externalListener, connectionRate, this.acceptConnections$default$4(), this.acceptConnections$default$5()));
        Assertions.assertEquals((int)updatedRateLimit, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)None$.MODULE$);
        this.acceptConnections(this.connectionQuotas(), externalListener, connectionRate, this.acceptConnections$default$4(), this.acceptConnections$default$5());
        Assertions.assertEquals((int)(connectionRate + updatedRateLimit), (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        this.acceptConnections(this.connectionQuotas(), adminListener, connectionRate, this.acceptConnections$default$4(), this.acceptConnections$default$5());
        Assertions.assertEquals((int)connectionRate, (int)this.connectionQuotas().get(adminListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(adminListener).append(":").toString());
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.acceptConnections(this.connectionQuotas(), adminListener, connectionRate, this.acceptConnections$default$4(), this.acceptConnections$default$5()));
        Assertions.assertEquals((int)(connectionRate + ipConnectionRateLimit), (int)this.connectionQuotas().get(adminListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(adminListener).append(":").toString());
        this.verifyNoBlockedPercentRecordedOnAllListeners();
    }

    @Test
    public void testNonDefaultConnectionCountLimitAndRateLimit() {
        int brokerRateLimit = 25;
        int maxConnections = 350;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), Integer.toString(maxConnections));
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), listener, maxConnections, 10L, brokerRateLimit, 8, this.acceptConnectionsAndVerifyRate$default$7())).get(20L, TimeUnit.SECONDS);
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(listener.defaultIp()), (String)"Number of connections on EXTERNAL listener:");
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, this.acceptConnections$default$4(), this.acceptConnections$default$5()));
        Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
        this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(listener.defaultIp()), (String)"Number of connections on EXTERNAL listener:");
    }

    private void addListenersAndVerify(KafkaConfig config, ConnectionQuotas connectionQuotas) {
        this.addListenersAndVerify(config, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.empty()).asJava(), connectionQuotas);
    }

    /*
     * WARNING - void declaration
     */
    private void addListenersAndVerify(KafkaConfig config, java.util.Map<String, ?> listenerConfig, ConnectionQuotas connectionQuotas) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Assertions.assertNotNull((Object)this.brokerConnRateMetric(), (String)"Expected broker-connection-accept-rate metric to exist");
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, listener) -> {
            ConnectionQuotasTest.$anonfun$addListenersAndVerify$1(this, connectionQuotas, config, listenerConfig, name, listener);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(this.listeners());
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        Assertions.assertEquals((double)0.0, (double)this.metricValue(this.brokerConnRateMetric()), (double)this.eps(), (String)"Broker-wide connection acceptance rate metric");
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNoBlockedPercentRecordedOnAllListeners() {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, meter) -> {
            ConnectionQuotasTest.$anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(name, meter);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(this.blockedPercentMeters());
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners() {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, meter) -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(name, meter);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(this.blockedPercentMeters());
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyIpThrottleTimeOnListener(ListenerName listener, boolean expectThrottle) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectThrottle), (Object)BoxesRunTime.boxToBoolean(((long)this.metricValue(this.ipConnThrottleMetric(listener.value())) > 0L ? 1 : 0) != 0), (String)new StringBuilder(45).append("IP connection throttle recorded for listener ").append(listener.value()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyOnlyNonInterBrokerListenersBlockedPercentRecorded() {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, meter) -> {
            ConnectionQuotasTest.$anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(name, meter);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(this.blockedPercentMeters());
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    private void verifyConnectionCountOnEveryListener(ConnectionQuotas connectionQuotas, int expectedConnectionCount) {
        this.listeners().values().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyConnectionCountOnEveryListener$1(expectedConnectionCount, connectionQuotas, listener);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaMetric listenerConnThrottleMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric ipConnThrottleMetric(String listener) {
        MetricName metricName = this.metrics().metricName("ip-connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric listenerConnRateMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-rate", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric brokerConnRateMetric() {
        MetricName metricName = this.metrics().metricName("broker-connection-accept-rate", SocketServer$.MODULE$.MetricsGroup());
        return this.metrics().metric(metricName);
    }

    private KafkaMetric ipConnRateMetric(String ip) {
        MetricName metricName = this.metrics().metricName("connection-accept-rate", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap("ip", ip));
        return this.metrics().metric(metricName);
    }

    private double metricValue(KafkaMetric metric) {
        return BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    private void verifyIpConnectionQuota(InetAddress ip, int quota) {
        Assertions.assertEquals((int)quota, (int)this.connectionQuotas().connectionRateForIp(ip));
        Option option = Option$.MODULE$.apply((Object)this.ipConnRateMetric(ip.getHostAddress()));
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((double)quota, (double)metric.config().quota().bound(), (double)0.1);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(46).append("Expected ").append(ip).append(" connection rate metric to be defined").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs, boolean expectIpThrottle) {
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs, expectIpThrottle);
    }

    private void acceptConnectionsAndVerifyRate(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs, int expectedRate, int epsilon, boolean expectIpThrottle) {
        long startTimeMs = this.time().milliseconds();
        int startNumConnections = connectionQuotas.get(listenerDesc.defaultIp());
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs, expectIpThrottle);
        double elapsedSeconds = MetricsUtils.convert((long)(this.time().milliseconds() - startTimeMs), (TimeUnit)TimeUnit.SECONDS);
        int createdConnections = connectionQuotas.get(listenerDesc.defaultIp()) - startNumConnections;
        double actualRate = (double)createdConnections / elapsedSeconds;
        Assertions.assertEquals((double)expectedRate, (double)actualRate, (double)epsilon, (String)new StringBuilder(52).append("Expected rate (").append(expectedRate).append(" +- ").append(epsilon).append("), but got ").append(actualRate).append(" (").append(createdConnections).append(" connections / ").append(elapsedSeconds).append(" sec)").toString());
    }

    private boolean acceptConnections(ConnectionQuotas connectionQuotas, ListenerName listenerName, InetAddress address, long numConnections, long timeIntervalMs, boolean expectIpThrottle) {
        LongRef nextSendTime = LongRef.create((long)(this.time().milliseconds() + timeIntervalMs));
        BooleanRef ipThrottled = BooleanRef.create((boolean)false);
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
            try {
                connectionQuotas.inc(listenerName, address, (Meter)this.blockedPercentMeters().apply((Object)listenerName.value()));
            }
            catch (ConnectionThrottledException e) {
                if (!expectIpThrottle) {
                    throw e;
                }
                ipThrottled$1.elem = true;
            }
            long sleepMs = scala.math.package$.MODULE$.max(nextSendTime$1.elem - this.time().milliseconds(), 0L);
            if (sleepMs > 0L) {
                this.time().sleep(sleepMs);
            }
            nextSendTime$1.elem += timeIntervalMs;
        });
        return ipThrottled.elem;
    }

    private long acceptConnections$default$4() {
        return 0L;
    }

    private boolean acceptConnections$default$5() {
        return false;
    }

    private boolean acceptConnectionsAndVerifyRate$default$7() {
        return false;
    }

    private void acceptConnectionsAboveIpLimit(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections) {
        ListenerName listenerName = listenerDesc.listenerName();
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1 & Serializable & scala.Serializable)i -> ConnectionQuotasTest.$anonfun$acceptConnectionsAboveIpLimit$1(this, connectionQuotas, listenerName, listenerDesc, BoxesRunTime.unboxToLong((Object)i)));
    }

    private final void ListenerDesc$lzycompute$1() {
        synchronized (this) {
            if (this.ListenerDesc$module == null) {
                this.ListenerDesc$module = new ConnectionQuotasTest$ListenerDesc$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testNoConnectionLimitsByDefault$4(ConnectionQuotasTest $this, int numConnections$1, ListenerDesc listener) {
        Assertions.assertEquals((int)numConnections$1, (int)$this.connectionQuotas().get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
        Assertions.assertTrue(($this.metricValue($this.listenerConnRateMetric(listener.listenerName().value())) > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(68).append("Expected connection-accept-rate metric to get recorded for listener ").append(listener).toString());
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        Assertions.assertEquals((int)(numConnections$1 - 1), (int)$this.connectionQuotas().get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$1(ConnectionQuotasTest $this, java.util.Map listenerConfig$1, ListenerDesc listener) {
        ((ConnectionQuotas.ListenerConnectionQuota)$this.connectionQuotas().maxConnectionsPerListener().apply((Object)listener.listenerName())).configure(listenerConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$5(ConnectionQuotasTest $this, int listenerMaxConnections$1, ListenerDesc listener) {
        Assertions.assertEquals((int)listenerMaxConnections$1, (int)$this.connectionQuotas().get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
        Assertions.assertFalse((boolean)$this.connectionQuotas().maxConnectionsExceeded(listener.listenerName()), (String)new StringBuilder(62).append("Total number of connections on ").append(listener).append(" should be exactly the maximum.").toString());
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$10(ConnectionQuotasTest $this, ListenerDesc listener) {
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
    }

    public static final /* synthetic */ boolean $anonfun$testIpConnectionRateWithListenerConnectionRate$3(Future x$10) {
        return BoxesRunTime.unboxToBoolean(x$10.get(3L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ boolean $anonfun$testIpConnectionRateWithListenerConnectionRate$4(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ void $anonfun$addListenersAndVerify$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$1, KafkaConfig config$1, java.util.Map listenerConfig$3, String name, ListenerDesc listener) {
        ListenerName listenerName = listener.listenerName();
        connectionQuotas$1.addListener(config$1, listenerName);
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas$1.maxConnectionsPerListener().apply((Object)listenerName)).configure(listenerConfig$3);
        Assertions.assertFalse((boolean)connectionQuotas$1.maxConnectionsExceeded(listenerName), (String)new StringBuilder(72).append("Should not exceed max connection limit on ").append(name).append(" listener after initialization").toString());
        Assertions.assertEquals((int)0, (int)connectionQuotas$1.get(listener.defaultIp()), (String)new StringBuilder(35).append("Number of connections on ").append(listener).append(" listener:").toString());
        Assertions.assertNotNull((Object)$this.listenerConnRateMetric(listenerName.value()), (String)new StringBuilder(61).append("Expected connection-accept-rate metric to exist for listener ").append(listenerName.value()).toString());
        Assertions.assertEquals((double)0.0, (double)$this.metricValue($this.listenerConnRateMetric(listenerName.value())), (double)$this.eps(), (String)new StringBuilder(47).append("Connection acceptance rate metric for listener ").append(listenerName.value()).toString());
        Assertions.assertNotNull((Object)$this.listenerConnThrottleMetric(listenerName.value()), (String)new StringBuilder(70).append("Expected connection-accept-throttle-time metric to exist for listener ").append(listenerName.value()).toString());
        Assertions.assertEquals((long)0L, (long)((long)$this.metricValue($this.listenerConnThrottleMetric(listenerName.value()))), (String)new StringBuilder(49).append("Listener connection throttle metric for listener ").append(listenerName.value()).toString());
        Assertions.assertEquals((long)0L, (long)((long)$this.metricValue($this.ipConnThrottleMetric(listenerName.value()))), (String)new StringBuilder(43).append("Ip connection throttle metric for listener ").append(listenerName.value()).toString());
    }

    public static final /* synthetic */ void $anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(String name, Meter meter) {
        Assertions.assertEquals((long)0L, (long)meter.count(), (String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString());
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(String name, Meter meter) {
        Assertions.assertTrue((meter.count() > 0L ? 1 : 0) != 0, (String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString());
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(ConnectionQuotasTest $this, ListenerDesc listener) {
        Assertions.assertTrue(((long)$this.metricValue($this.listenerConnThrottleMetric(listener.listenerName().value())) > 0L ? 1 : 0) != 0, (String)new StringBuilder(40).append("Connection throttle metric for listener ").append(listener.listenerName().value()).toString());
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(String name, Meter meter) {
        if ("REPLICATION".equals(name)) {
            Assertions.assertEquals((long)0L, (long)meter.count(), (String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString());
            return;
        }
        Assertions.assertTrue((meter.count() > 0L ? 1 : 0) != 0, (String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString());
    }

    public static final /* synthetic */ void $anonfun$verifyConnectionCountOnEveryListener$1(int expectedConnectionCount$1, ConnectionQuotas connectionQuotas$2, ListenerDesc listener) {
        Assertions.assertEquals((int)expectedConnectionCount$1, (int)connectionQuotas$2.get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
    }

    public static final /* synthetic */ TooManyConnectionsException $anonfun$acceptConnectionsAboveIpLimit$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$4, ListenerName listenerName$2, ListenerDesc listenerDesc$1, long i) {
        return (TooManyConnectionsException)Assertions.assertThrows(TooManyConnectionsException.class, () -> connectionQuotas$4.inc(listenerName$2, listenerDesc$1.defaultIp(), (Meter)$this.blockedPercentMeters().apply((Object)listenerName$2.value())));
    }

    public ConnectionQuotasTest() {
        this.numQuotaSamples = 2;
        this.quotaWindowSizeSeconds = 1;
        this.eps = 0.01;
    }

    public class ListenerDesc
    implements Product,
    scala.Serializable {
        private final ListenerName listenerName;
        private final InetAddress defaultIp;
        public final /* synthetic */ ConnectionQuotasTest $outer;

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public InetAddress defaultIp() {
            return this.defaultIp;
        }

        public String toString() {
            return new StringBuilder(20).append("(listener=").append(this.listenerName().value()).append(", client=").append(this.defaultIp().getHostAddress()).append(")").toString();
        }

        public ListenerDesc copy(ListenerName listenerName, InetAddress defaultIp) {
            return new ListenerDesc(this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer(), listenerName, defaultIp);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public InetAddress copy$default$2() {
            return this.defaultIp();
        }

        public String productPrefix() {
            return "ListenerDesc";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.defaultIp();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ListenerDesc;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ListenerDesc)) return false;
            if (((ListenerDesc)x$1).kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() != this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ListenerDesc listenerDesc = (ListenerDesc)x$1;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = listenerDesc.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            InetAddress inetAddress = this.defaultIp();
            InetAddress inetAddress2 = listenerDesc.defaultIp();
            if (inetAddress == null) {
                if (inetAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetAddress).equals(inetAddress2)) return false;
            if (!listenerDesc.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConnectionQuotasTest kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() {
            return this.$outer;
        }

        public ListenerDesc(ConnectionQuotasTest $outer, ListenerName listenerName, InetAddress defaultIp) {
            this.listenerName = listenerName;
            this.defaultIp = defaultIp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

