/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.SegmentDeletion$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u001f?\u0005\rCQA\u0013\u0001\u0005\u0002-C\u0011B\u0014\u0001A\u0002\u0003\u0007I\u0011A(\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0003I\u0006\"C0\u0001\u0001\u0004\u0005\t\u0015)\u0003Q\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da\u0001\u001b\u0001!\u0002\u0013\u0011\u0007\"B5\u0001\t\u0003Q\u0007\"\u0002=\u0001\t\u0003Q\u0007\"B?\u0001\t\u0003Q\u0007BBA\u0003\u0001\u0011\u0005!\u000e\u0003\u0004\u0002\n\u0001!\tA\u001b\u0005\u0007\u0003\u001b\u0001A\u0011\u00016\t\r\u0005E\u0001\u0001\"\u0001k\u0011\u0019\t)\u0002\u0001C\u0001U\"1\u0011\u0011\u0004\u0001\u0005\u0002)Da!!\b\u0001\t\u0003Q\u0007BBA\u0011\u0001\u0011\u0005!\u000e\u0003\u0004\u0002&\u0001!\tA\u001b\u0005\u0007\u0003S\u0001A\u0011\u00016\t\r\u00055\u0002\u0001\"\u0001k\u0011\u0019\t\t\u0004\u0001C\u0001U\"1\u0011Q\u0007\u0001\u0005\u0002)Da!!\u000f\u0001\t\u0003Q\u0007BBA\u001f\u0001\u0011\u0005!\u000e\u0003\u0004\u0002B\u0001!\tA\u001b\u0005\u0007\u0003\u000b\u0002A\u0011\u00016\t\r\u0005%\u0003\u0001\"\u0001k\u0011\u0019\ti\u0005\u0001C\u0001U\"1\u0011\u0011\u000b\u0001\u0005\u0002)Da!!\u0016\u0001\t\u0003Q\u0007bBA-\u0001\u0011%\u00111\f\u0005\u0007\u0003\u000b\u0003A\u0011\u00016\t\r\u0005%\u0005\u0001\"\u0001k\u0011\u0019\ti\t\u0001C\u0001U\"1\u0011\u0011\u0013\u0001\u0005\u0002)Da!!&\u0001\t\u0003Q\u0007BBAM\u0001\u0011\u0005!\u000e\u0003\u0004\u0002\u001e\u0002!\tA\u001b\u0005\u0007\u0003C\u0003A\u0011\u00016\t\r\u0005\u0015\u0006\u0001\"\u0001k\u0011\u0019\tI\u000b\u0001C\u0001U\"1\u0011Q\u0016\u0001\u0005\u0002)Da!!-\u0001\t\u0003QwaBA[}!\u0005\u0011q\u0017\u0004\u0007{yB\t!!/\t\r)kC\u0011AA^\r\u0019\ti,\f\u0001\u0002@\"1!j\fC\u0001\u0003WDq!a 0\t\u0003\n\t\u0010C\u0004\u0003\b=\"\tE!\u0003\t\u000f\teq\u0006\"\u0011\u0003\u001c!I!1F\u0017C\u0002\u0013\u0005!Q\u0006\u0005\t\u0005ki\u0003\u0015!\u0003\u00030!9!qG\u0017\u0005\u0002\te\u0002\"\u0003B1[E\u0005I\u0011\u0001B2\u0011\u001d\u0011I(\fC\u0001\u0005wB\u0011Ba!.#\u0003%\tAa\u0019\t\u000f\t\u0015U\u0006\"\u0001\u0003\b\"9!QQ\u0017\u0005\u0002\t\u0015\u0006b\u0002B][\u0011%!1\u0018\u0002\u0015\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e$Vm\u001d;\u000b\u0005}\u0002\u0015\u0001\u0002:bMRT\u0011!Q\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\t\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0003\"!\u0014\u0001\u000e\u0003y\nq\u0001^3na\u0012K'/F\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0002j_*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u00111\u0015\u000e\\3\u0002\u0017Q,W\u000e\u001d#je~#S-\u001d\u000b\u00035v\u0003\"!R.\n\u0005q3%\u0001B+oSRDqAX\u0002\u0002\u0002\u0003\u0007\u0001+A\u0002yIE\n\u0001\u0002^3na\u0012K'\u000fI\u0001\t[>\u001c7\u000eV5nKV\t!\r\u0005\u0002dM6\tAM\u0003\u0002f\u0001\u0006)Q\u000f^5mg&\u0011q\r\u001a\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00025\"\u0012q\u0001\u001c\t\u0003[Zl\u0011A\u001c\u0006\u0003_B\f1!\u00199j\u0015\t\t(/A\u0004kkBLG/\u001a:\u000b\u0005M$\u0018!\u00026v]&$(\"A;\u0002\u0007=\u0014x-\u0003\u0002x]\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001\u0003>\u0011\u00055\\\u0018B\u0001?o\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0006uKN$8i\u001c8gS\u001eD#!C@\u0011\u00075\f\t!C\u0002\u0002\u00049\u0014A\u0001V3ti\u0006QB/Z:u+:,\u0007\u0010]3di\u0016$\u0017\t\u001d9f]\u0012|eMZ:fi\"\u0012!b`\u0001\u0013i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G\u000f\u000b\u0002\f\u007f\u0006yB/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\rJ|W.\u00128e\u001f\u001a47/\u001a;)\u00051y\u0018\u0001\u000b;fgR\u001c%/Z1uKNs\u0017\r]:i_Rd\u0015\r^3s)\"\fg\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0007FA\u0007\u0000\u0003\u0001\"Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;Nk\u000eDG*\u0019;fe\u0016\u0003xn\u00195)\u00059y\u0018A\n;fgR\u001c%/Z1uKNs\u0017\r]:i_R\u0014UMZ8sK2{wm\u0015;beR|eMZ:fi\"\u0012qb`\u0001!i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G\u000fR5wKJ<\u0017N\\4Fa>\u001c\u0007\u000e\u000b\u0002\u0011\u007f\u0006aB/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u001f2$WM]#q_\u000eD\u0007FA\t\u0000\u0003\t\"Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;XSRDW*[:tS:<W\t]8dQ\"\u0012!c`\u0001\u001bi\u0016\u001cHo\u0011:fCR,W\t_5ti&twm\u00158baNDw\u000e\u001e\u0015\u0003'}\f1\u0002^3tiR{\u0007/[2JI\"\u0012Ac`\u0001\u0018i\u0016\u001cHOU3bI6K7o]5oONs\u0017\r]:i_RD#!F@\u0002;Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^3oiNs\u0017\r]:i_RD#AF@\u0002CQ,7\u000f\u001e+sk:\u001c\u0017\r^3Gk2d\u0017\u0010V8MCR,7\u000f^*oCB\u001c\bn\u001c;)\u0005]y\u0018a\t;fgR$&/\u001e8dCR,w+\u001b7m%\u0016lwN^3PY\u0012,'o\u00158baNDw\u000e\u001e\u0015\u00031}\fq\u0003^3ti\u0012{Wm\u001d8u)J,hnY1uK\u001a+H\u000e\\=)\u0005ey\u0018a\u0007;fgR\u001cE.Z1okB\u0004\u0016M\u001d;jC2\u001cf.\u00199tQ>$8\u000f\u000b\u0002\u001b\u007f\u0006IB/Z:u\u00072,\u0017M\\;q\u001f2$WM]*oCB\u001c\bn\u001c;tQ\tYr0A\u0013uKN$8I]3bi\u0016\u0014V\r\u001d7jG\u0006$X\r\u001a'pOR\u0013XO\\2bi\u0016\u001ch)\u001e7ms\"\u0012Ad`\u0001\u0011i\u0016\u001cH/T1y\u0005\u0006$8\r[*ju\u0016D#!H@\u0002=Q,7\u000f\u001e+sk:\u001c\u0017\r^3CK2|w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007F\u0001\u0010\u0000\u00039\u0011W/\u001b7e\rVdGNQ1uG\"$\u0002\"!\u0018\u0002t\u0005u\u0014\u0011\u0011\t\u0005\u0003?\ny'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0019\u0011XmY8sI*!\u0011qMA5\u0003\u0019\u0019w.\\7p]*\u0019\u0011)a\u001b\u000b\u0007\u00055D/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003c\n\tGA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003kz\u0002\u0019AA<\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0007\u0015\u000bI(C\u0002\u0002|\u0019\u00131!\u00138u\u0011\u001d\tyh\ba\u0001\u0003o\n!B]3d_J$7+\u001b>f\u0011\u001d\t\u0019i\ba\u0001\u0003o\n1#\\1y\u0005\u0006$8\r[*ju\u0016LeNQ=uKN\f!\u0006^3tiZ\u000bG.\u001b3bi\u0016,\u0005o\\2i\u000fJ,\u0017\r^3s)\"\fg\u000eT1ti.swn\u001e8Fa>\u001c\u0007\u000e\u000b\u0002!\u007f\u0006aC/Z:u-\u0006d\u0017\u000eZ1uK\u0016\u0003xn\u00195MKN\u001cH\u000b[1o\u001f2$Wm\u001d;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b\u0015\u0003C}\fa\u0006^3tiZ\u000bG.\u001b3bi\u0016|eMZ:fi2+7o\u001d+iC:|E\u000eZ3tiNs\u0017\r]:i_R|eMZ:fi\"\u0012!e`\u0001.i\u0016\u001cHOV1mS\u0012\fG/Z(gMN,G/R9vC2$vn\u00147eKN$8K\\1qg\"|Go\u00144gg\u0016$\bFA\u0012\u0000\u0003\t#Xm\u001d;WC2LG-\u0019;f+:\\gn\\<o\u000bB|7\r\u001b'fgN$\u0006.\u00198MCN$8J\\8x]\u001e\u0013X-\u0019;feRC\u0017M\\(mI\u0016\u001cHo\u00158baNDw\u000e\u001e\u0015\u0003I}\f\u0001\u0006^3tiZ\u000bG.\u001b3bi\u0016,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007.\u00138M_\u001eD#!J@\u0002IQ,7\u000f\u001e,bY&$\u0017\r^3PM\u001a\u001cX\r^$sK\u0006$H\u000b[1o\u000b:$wJ\u001a4tKRD#AJ@\u0002;Q,7\u000f\u001e,bY&$\u0017\r^3PM\u001a\u001cX\r\u001e'fgN$\u0006.\u00198M\u000b>C#aJ@\u0002?Q,7\u000f\u001e,bY&$\u0017\r^3WC2LG-\u00129pG\"\fe\u000eZ(gMN,G\u000f\u000b\u0002)\u007f\u00061C/Z:u\u0003\u00124\u0018M\\2f\u0019><7\u000b^1si>3gm]3u\u0003\u001a$XM]\"mK\u0006t\u0017N\\4)\u0005%z\u0018a\u0005;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c\bF\u0001\u0016\u0000\u0003Y!Xm\u001d;T_\u001a$(+\u001a;f]RLwN\u001c'j[&$\bFA\u0016\u0000\u0003QY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rV3tiB\u0011Q*L\n\u0003[\u0011#\"!a.\u0003\u001d\tKH/Z!se\u0006L8+\u001a:eKN)q&!1\u0002NB!\u00111YAe\u001b\t\t)MC\u0002\u0002HR\u000bA\u0001\\1oO&!\u00111ZAc\u0005\u0019y%M[3diB1\u0011qZAn\u0003?l!!!5\u000b\t\u0005M\u0017Q[\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\u0005\u001d\u0014q\u001b\u0006\u0005\u00033\fI'\u0001\u0004tKJ4XM]\u0005\u0005\u0003;\f\tNA\u0006SK\u000e|'\u000fZ*fe\u0012,\u0007#B#\u0002b\u0006\u0015\u0018bAAr\r\n)\u0011I\u001d:bsB\u0019Q)a:\n\u0007\u0005%hI\u0001\u0003CsR,GCAAw!\r\tyoL\u0007\u0002[Q1\u0011qOAz\u0003oDq!!>2\u0001\u0004\ty.\u0001\u0003eCR\f\u0007bBA}c\u0001\u0007\u00111`\u0001\u0013g\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8DC\u000eDW\r\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\u0011\u0011\t!!\u001a\u0002\u0011A\u0014x\u000e^8d_2LAA!\u0002\u0002\u0000\nArJ\u00196fGR\u001cVM]5bY&T\u0018\r^5p]\u000e\u000b7\r[3\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000fi\u0013YA!\u0004\u0003\u0010!9\u0011Q\u001f\u001aA\u0002\u0005}\u0007bBA}e\u0001\u0007\u00111 \u0005\b\u0005#\u0011\u0004\u0019\u0001B\n\u0003\ryW\u000f\u001e\t\u0005\u0003{\u0014)\"\u0003\u0003\u0003\u0018\u0005}(\u0001C,sSR\f'\r\\3\u0002\tI,\u0017\r\u001a\u000b\u0007\u0003?\u0014iBa\n\t\u000f\t}1\u00071\u0001\u0003\"\u0005)\u0011N\u001c9viB!\u0011Q B\u0012\u0013\u0011\u0011)#a@\u0003\u0011I+\u0017\rZ1cY\u0016DqA!\u000b4\u0001\u0004\t9(\u0001\u0003tSj,\u0017\u0001\u0007#fM\u0006,H\u000e^'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jOV\u0011!q\u0006\t\u0004\u001b\nE\u0012b\u0001B\u001a}\t\tR*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u00023\u0011+g-Y;mi6+G/\u00193bi\u0006dunZ\"p]\u001aLw\rI\u0001\u0017EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e\fe\u000e\u001a#jeRA!1\bB,\u00053\u0012i\u0006E\u0005F\u0005{\u0011\tE!\u0015\u00030%\u0019!q\b$\u0003\rQ+\b\u000f\\34!\u0011\u0011\u0019E!\u0014\u000e\u0005\t\u0015#\u0002\u0002B$\u0005\u0013\nAAZ5mK*\u0019!1\n+\u0002\u00079Lw.\u0003\u0003\u0003P\t\u0015#\u0001\u0002)bi\"\u00042!\u0014B*\u0013\r\u0011)F\u0010\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001eDQA\u0014\u001cA\u0002ACaAa\u00177\u0001\u0004\u0011\u0017\u0001\u0002;j[\u0016D\u0011Ba\u00187!\u0003\u0005\rAa\f\u0002#5,G/\u00193bi\u0006dunZ\"p]\u001aLw-\u0001\u0011ck&dG-T3uC\u0012\fG/\u0019'pO\u0006sG\rR5sI\u0011,g-Y;mi\u0012\u001aTC\u0001B3U\u0011\u0011yCa\u001a,\u0005\t%\u0004\u0003\u0002B6\u0005kj!A!\u001c\u000b\t\t=$\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u001dG\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005o\u0012iGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001CY;jY\u0012lU\r^1eCR\fGj\\4\u0015\u0011\tE#Q\u0010B@\u0005\u0003CQA\u0014\u001dA\u0002ACaAa\u00179\u0001\u0004\u0011\u0007\"\u0003B0qA\u0005\t\u0019\u0001B\u0018\u0003i\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0019\t\u0007\u000f]3oIRA!\u0011\u0012BJ\u0005;\u0013\t\u000b\u0005\u0003\u0003\f\n=UB\u0001BG\u0015\ry\u0014\u0011N\u0005\u0005\u0005#\u0013iIA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0005+S\u0004\u0019\u0001BL\u0003\rawn\u001a\t\u0005\u0005\u0017\u0013I*\u0003\u0003\u0003\u001c\n5%!\u0004*fa2L7-\u0019;fI2{w\rC\u0004\u0003 j\u0002\r!a\u001e\u0002\u001f9,XNY3s\u001f\u001a\u0014VmY8sINDqAa);\u0001\u0004\t9(A\u0003fa>\u001c\u0007\u000eF\u0003[\u0005O\u00139\fC\u0004\u0003*n\u0002\rAa+\u0002\u001dMt\u0017\r]:i_R<&/\u001b;feB!!Q\u0016BZ\u001b\t\u0011yK\u0003\u0003\u00032\u0006%\u0014\u0001C:oCB\u001c\bn\u001c;\n\t\tU&q\u0016\u0002\u0012%\u0006<8K\\1qg\"|Go\u0016:ji\u0016\u0014\bb\u0002BPw\u0001\u0007\u0011qO\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010F\u0003Q\u0005{\u0013\t\r\u0003\u0004\u0003@r\u0002\r\u0001U\u0001\u0007Y><G)\u001b:\t\u000f\t\rG\b1\u0001\u0003F\u0006QAn\\4ESJt\u0015-\\3\u0011\t\t\u001d'Q\u001b\b\u0005\u0005\u0013\u0014\t\u000eE\u0002\u0003L\u001ak!A!4\u000b\u0007\t=')\u0001\u0004=e>|GOP\u0005\u0004\u0005'4\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003X\ne'AB*ue&twMC\u0002\u0003T\u001a\u0003")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter rawSnapshotWriter, int n) {
        KafkaMetadataLogTest$.MODULE$.append(rawSnapshotWriter, n);
    }

    public static LogAppendInfo append(ReplicatedLog replicatedLog, int n, int n2) {
        return KafkaMetadataLogTest$.MODULE$.append(replicatedLog, n, n2);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3();
    }

    public static KafkaMetadataLog buildMetadataLog(File file, MockTime mockTime, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(file, mockTime, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File file, MockTime mockTime, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(file, mockTime, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), Arrays.asList((Object[])new String[]{"broker"}));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9093");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), BoxesRunTime.boxToInteger((int)2));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMillisProp(), BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    @Test
    public void testUnexpectedAppendOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch));
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsFollower((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset(snapshotId.offset - 1L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset - 2L, snapshotId.epoch)));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId$1.offset, snapshotId$1.epoch - 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotOlderEpoch() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId$2.offset, snapshotId$2.epoch - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateExistingSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateFullyToLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(sameEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(greaterEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertNotEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        Assertions.assertTrue((boolean)log2.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        log2.close();
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$2 -> x$2.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)log2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDoesntTruncateFully() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(olderEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(olderOffsetSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void resource_resource;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig cfr_ignored_0 = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)log2.startOffset());
        Assertions.assertEquals((int)epoch, (int)log2.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)log2.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$4 -> x$4.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$6 -> x$6.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)log2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch, (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7();
        int x$8 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9));
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset((long)offset, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().maxFetchSizeInBytes(), Defaults$.MODULE$.FileDeleteDelayMs(), 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2((RawSnapshotWriter)resource_resource2);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3((RawSnapshotWriter)resource_resource);
        }
        finally {
            resource_resource.close();
        }
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            void resource_resource;
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3((RawSnapshotWriter)resource_resource);
            }
            finally {
                resource_resource.close();
            }
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSoftRetentionLimit() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2((RawSnapshotWriter)resource_resource2);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3((RawSnapshotWriter)resource_resource);
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$7, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset < log$7.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$8, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset < log$8.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$13, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$13.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$13, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset, (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$13.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$13, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotBeforeLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotOlderEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateExistingSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupPartialSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanOldestSnapshotEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetLessThanOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetEqualToOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanFirstEpochInLog$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$2$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$2$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        /*
         * WARNING - void declaration
         */
        public byte[] read(Readable input, int size) {
            void var3_3;
            byte[] array = new byte[size];
            input.readArray(array);
            return var3_3;
        }
    }
}

