/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00055!)\u0001\t\u0001C\u0001\u0003\")\u0001\u000b\u0001C\u0001\u0003\")!\u000b\u0001C\u0001\u0003\")A\u000b\u0001C\u0001\u0003\")a\u000b\u0001C\u0001\u0003\ny!+\u00194u\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u000b\u0017\u0005!!/\u00194u\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\n\u0003\u0005Jgn\u001d;b]RL\u0017\r^3SC\u001a$X*\u00198bO\u0016\u0014x+\u001b;i\u0007>tg-[4t)\u0011YB%\r \u0011\u0007aab$\u0003\u0002\u001e\u0013\t\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u0004!}\t\u0013B\u0001\u0011\u0012\u0005\u0015\t%O]1z!\t\u0001\"%\u0003\u0002$#\t!!)\u001f;f\u0011\u0015)#\u00011\u0001'\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aJ\u0018\u000e\u0003!R!!\u000b\u0016\u0002\r\r|W.\\8o\u0015\ta1F\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019)\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQA\r\u0002A\u0002M\nA\u0002\u001d:pG\u0016\u001c8OU8mKN\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c\u0012\u001b\u00059$B\u0001\u001d\u000e\u0003\u0019a$o\\8u}%\u0011!(E\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;#!)qH\u0001a\u0001g\u00051an\u001c3f\u0013\u0012\f!\u0005^3tiN+g\u000e^5oK2tu\u000eZ3JI&3'I]8lKJ\u0014v\u000e\\3P]2LH#\u0001\"\u0011\u0005A\u0019\u0015B\u0001#\u0012\u0005\u0011)f.\u001b;)\u0005\r1\u0005CA$O\u001b\u0005A%BA%K\u0003\r\t\u0007/\u001b\u0006\u0003\u00172\u000bqA[;qSR,'O\u0003\u0002N[\u0005)!.\u001e8ji&\u0011q\n\u0013\u0002\u0005)\u0016\u001cH/A\u0013uKN$hj\u001c3f\u0013\u0012\u0004&/Z:f]RLemQ8oiJ|G\u000e\\3s%>dWm\u00148ms\"\u0012AAR\u0001\u001di\u0016\u001cHOT8eK&#\u0007K]3tK:$\u0018JZ\"pY>\u001c\u0017\r^3eQ\t)a)\u0001\u000buKN$8\u000b[;uI><h.S8UQJ,\u0017\r\u001a\u0015\u0003\r\u0019\u000bq\u0004^3tiVs7-Y;hQR,\u0005pY3qi&|g.\u00138J_RC'/Z1eQ\t9a\t")
public class RaftManagerTest {
    private KafkaRaftManager<byte[]> instantiateRaftManagerWithConfigs(TopicPartition topicPartition, String processRoles, String nodeId) {
        File logDir = TestUtils.tempDirectory();
        KafkaConfig config = RaftManagerTest.configWithProcessRolesAndNodeId$1(processRoles, nodeId, logDir);
        Uuid topicId = new Uuid(0L, 2L);
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), config.nodeId());
        return new KafkaRaftManager(metaProperties, config, (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), Option$.MODULE$.empty(), CompletableFuture.completedFuture(RaftConfig.parseVoterConnections((List)config.quorumVoters())));
    }

    @Test
    public void testSentinelNodeIdIfBrokerRoleOnly() {
        KafkaRaftManager<byte[]> raftManager = this.instantiateRaftManagerWithConfigs(new TopicPartition("__raft_id_test", 0), "broker", "1");
        Assertions.assertFalse((boolean)raftManager.client().nodeId().isPresent());
        raftManager.shutdown();
    }

    @Test
    public void testNodeIdPresentIfControllerRoleOnly() {
        KafkaRaftManager<byte[]> raftManager = this.instantiateRaftManagerWithConfigs(new TopicPartition("__raft_id_test", 0), "controller", "1");
        Assertions.assertTrue((raftManager.client().nodeId().getAsInt() == 1 ? 1 : 0) != 0);
        raftManager.shutdown();
    }

    @Test
    public void testNodeIdPresentIfColocated() {
        KafkaRaftManager<byte[]> raftManager = this.instantiateRaftManagerWithConfigs(new TopicPartition("__raft_id_test", 0), "controller,broker", "1");
        Assertions.assertTrue((raftManager.client().nodeId().getAsInt() == 1 ? 1 : 0) != 0);
        raftManager.shutdown();
    }

    @Test
    public void testShutdownIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        CompletableFuture<Object> shutdownFuture = new CompletableFuture<Object>();
        Mockito.when((Object)raftClient.shutdown(5000)).thenReturn(shutdownFuture);
        ioThread.initiateShutdown();
        Assertions.assertTrue((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownInitiated());
        ((KafkaRaftClient)Mockito.verify((Object)raftClient)).shutdown(5000);
        shutdownFuture.complete(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ioThread.run();
        Assertions.assertFalse((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
    }

    @Test
    public void testUncaughtExceptionInIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        raftClient.poll();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException()});
        ioThread.run();
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
        Assertions.assertTrue((boolean)ioThread.isThreadFailed());
        Assertions.assertFalse((boolean)ioThread.isRunning());
    }

    private static final KafkaConfig configWithProcessRolesAndNodeId$1(String processRoles, String nodeId, File logDir) {
        Properties props = new Properties();
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), logDir.getPath());
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), processRoles);
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), nodeId);
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        if (processRoles.contains("broker")) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            if (processRoles.contains("controller")) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            } else {
                int voterId = new StringOps(Predef$.MODULE$.augmentString(nodeId)).toInt() + 1;
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(voterId).append("@localhost:9093").toString());
            }
        } else if (processRoles.contains("controller")) {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9093");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        }
        return new KafkaConfig((Map)props);
    }
}

