/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiVersionManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerApis;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestLocal$;
import kafka.server.SimpleApiVersionManager;
import kafka.test.MockController;
import kafka.utils.MockTime;
import kafka.utils.NotNothing;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013%!\u000b\u0003\u0004W\u0001\u0001\u0006Ia\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019\t\u0007\u0001)A\u00053\"9!\r\u0001b\u0001\n\u0013A\u0006BB2\u0001A\u0003%\u0011\fC\u0004e\u0001\t\u0007I\u0011B3\t\rA\u0004\u0001\u0015!\u0003g\u0011\u001d\t\bA1A\u0005\nIDaA\u001e\u0001!\u0002\u0013\u0019\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0005\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0002\u0002CA\u0018\u0001\u0001\u0006I!!\u000b\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA-\u0001\u0001\u0006I!!\u000e\t\u0013\u0005m\u0003A1A\u0005\n\u0005u\u0003\u0002CA>\u0001\u0001\u0006I!a\u0018\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!I\u0011\u0011\u0018\u0001\u0012\u0002\u0013%\u00111\u0018\u0005\b\u0003#\u0004A\u0011BAj\u0011%\u0011I\u0001AI\u0001\n\u0013\u0011Y\u0001C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!q\u0007\u0001\u0005\u0002\te\u0001b\u0002B\u001e\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005\u007f\u0001A\u0011\u0001B\r\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u00053AqAa\u0012\u0001\t\u0003\u0011I\u0002C\u0004\u0003L\u0001!\tA!\u0007\t\u000f\t=\u0003\u0001\"\u0001\u0003\u001a!9!1\u000b\u0001\u0005\u0002\te\u0001b\u0002B,\u0001\u0011\u0005!\u0011\u0004\u0005\b\u00057\u0002A\u0011\u0001B\r\u0011\u001d\u0011y\u0006\u0001C\u0001\u00053AqAa\u0019\u0001\t\u0003\u0011I\u0002C\u0004\u0003h\u0001!\tA!\u0007\t\u000f\t-\u0004\u0001\"\u0001\u0003\u001a!9!q\u000e\u0001\u0005\u0002\te\u0001b\u0002B:\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005o\u0002A\u0011\u0001B\r\u0011\u001d\u0011Y\b\u0001C\u0001\u00053AqAa \u0001\t\u0003\u0011I\u0002C\u0004\u0003\u0004\u0002!\tA!\u0007\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\u001a!9!1\u0012\u0001\u0005\u0002\te\u0001b\u0002BH\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005'\u0003A\u0011\u0001B\r\u0011\u001d\u00119\n\u0001C\u0001\u00053AqAa'\u0001\t\u0003\u0011I\u0002C\u0004\u0003 \u0002!\tA!\u0007\t\u000f\t\r\u0006\u0001\"\u0001\u0003\u001a!9!q\u0015\u0001\u0005\u0002\te\u0001b\u0002BV\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011)\u000f\u0001C\u0001\u00053\u0011!cQ8oiJ|G\u000e\\3s\u0003BL7\u000fV3ti*\u0011!iQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0011\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u000fB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A(\u0011\u0005A\u0003Q\"A!\u0002\r9|G-Z%e+\u0005\u0019\u0006C\u0001%U\u0013\t)\u0016JA\u0002J]R\fqA\\8eK&#\u0007%\u0001\u0006ce>\\WM\u001d*bG.,\u0012!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000bA\u0001\\1oO*\ta,\u0001\u0003kCZ\f\u0017B\u00011\\\u0005\u0019\u0019FO]5oO\u0006Y!M]8lKJ\u0014\u0016mY6!\u0003!\u0019G.[3oi&#\u0015!C2mS\u0016tG/\u0013#!\u0003U\u0011X-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGN,\u0012A\u001a\t\u0003O6t!\u0001[6\u000e\u0003%T!A[\"\u0002\u000f9,Go^8sW&\u0011A.[\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\tqwNA\u0004NKR\u0014\u0018nY:\u000b\u00051L\u0017A\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m\u001d\u0011\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\t1\u000f\u0005\u0002ii&\u0011Q/\u001b\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003y\u000e\u000bQ!\u001e;jYNL!A`>\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n!c\u00197jK:$\u0018+^8uC6\u000bg.Y4feV\u0011\u0011Q\u0001\t\u0004!\u0006\u001d\u0011bAA\u0005\u0003\n\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003M\u0019G.[3oiF+x\u000e^1NC:\fw-\u001a:!\u0003e\u0019G.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:\u0016\u0005\u0005E\u0001c\u0001)\u0002\u0014%\u0019\u0011QC!\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\u0001\u001bG2LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'\u000fI\u0001\u001dG2LWM\u001c;D_:$(o\u001c7mKJ\fVo\u001c;b\u001b\u0006t\u0017mZ3s+\t\ti\u0002E\u0002Q\u0003?I1!!\tB\u0005y\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/A\u000fdY&,g\u000e^\"p]R\u0014x\u000e\u001c7feF+x\u000e^1NC:\fw-\u001a:!\u0003M\u0011X\r\u001d7jG\u0006\fVo\u001c;b\u001b\u0006t\u0017mZ3s+\t\tI\u0003E\u0002Q\u0003WI1!!\fB\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\u000bsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'\u000fI\u0001\fe\u00064G/T1oC\u001e,'/\u0006\u0002\u00026A1\u0011qGA\u001f\u0003\u0003j!!!\u000f\u000b\u0007\u0005m2)\u0001\u0003sC\u001a$\u0018\u0002BA \u0003s\u00111BU1gi6\u000bg.Y4feB!\u00111IA+\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013AB2p[6|gNC\u0002C\u0003\u0017R1\u0001RA'\u0015\u0011\ty%!\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019&A\u0002pe\u001eLA!a\u0016\u0002F\t!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fAB]1gi6\u000bg.Y4fe\u0002\na!];pi\u0006\u001cXCAA0!\u0011\t\t'!\u001e\u000f\t\u0005\r\u0014\u0011\u000f\b\u0005\u0003K\nyG\u0004\u0003\u0002h\u00055TBAA5\u0015\r\tY'R\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!AQ\"\n\u0007\u0005M\u0014)\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002x\u0005e$!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002t\u0005\u000bq!];pi\u0006\u001c\b%\u0001\u000bde\u0016\fG/Z\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u000b\t\u0003\u0003\u000b9)a'\u0002*B\u0019\u0001+a!\n\u0007\u0005\u0015\u0015I\u0001\bD_:$(o\u001c7mKJ\f\u0005/[:\t\u000f\u0005%%\u00041\u0001\u0002\f\u0006Q\u0011-\u001e;i_JL'0\u001a:\u0011\u000b!\u000bi)!%\n\u0007\u0005=\u0015J\u0001\u0004PaRLwN\u001c\t\u0005\u0003'\u000b9*\u0004\u0002\u0002\u0016*!\u0011\u0011RA%\u0013\u0011\tI*!&\u0003\u0015\u0005+H\u000f[8sSj,'\u000fC\u0004\u0002\u001ej\u0001\r!a(\u0002\u0015\r|g\u000e\u001e:pY2,'\u000f\u0005\u0003\u0002\"\u0006\u0015VBAAR\u0015\u0011\ti*a\u0013\n\t\u0005\u001d\u00161\u0015\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b\"CAV5A\u0005\t\u0019AAW\u0003\u0015\u0001(o\u001c9t!\u0011\ty+!.\u000e\u0005\u0005E&bAAZ;\u0006!Q\u000f^5m\u0013\u0011\t9,!-\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0010de\u0016\fG/Z\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0018\u0016\u0005\u0003[\u000byl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tY-S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00031\u0011W/\u001b7e%\u0016\fX/Z:u+\u0011\t).!@\u0015\r\u0005]\u0017Q\\Ax!\r9\u0017\u0011\\\u0005\u0004\u00037|'a\u0002*fcV,7\u000f\u001e\u0005\b\u0003?d\u0002\u0019AAq\u0003\u001d\u0011X-];fgR\u0004B!a9\u0002l6\u0011\u0011Q\u001d\u0006\u0005\u0003O\fI/\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t9%a\u0013\n\t\u00055\u0018Q\u001d\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\"I\u0011\u0011\u001f\u000f\u0011\u0002\u0003\u0007\u00111_\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003k\fI0\u0004\u0002\u0002x*\u0019!.!;\n\t\u0005m\u0018q\u001f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0003\b\u0003\u007fd\"\u0019\u0001B\u0001\u0005\u0005!\u0016\u0003\u0002B\u0002\u0003C\u00042\u0001\u0013B\u0003\u0013\r\u00119!\u0013\u0002\b\u001d>$\b.\u001b8h\u0003Y\u0011W/\u001b7e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\u0007\u0005#)\"Aa\u0004+\t\u0005M\u0018q\u0018\u0003\b\u0003\u007fl\"\u0019\u0001B\u0001\u0003]\u0019'/Z1uK\u0012+g._!mY\u0006+H\u000f[8sSj,'\u000f\u0006\u0002\u0002\u0012\u0006)B/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a$fi\u000eDGC\u0001B\u000e!\rA%QD\u0005\u0004\u0005?I%\u0001B+oSRD3a\bB\u0012!\u0011\u0011)Ca\r\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\t1!\u00199j\u0015\u0011\u0011iCa\f\u0002\u000f),\b/\u001b;fe*!!\u0011GA)\u0003\u0015QWO\\5u\u0013\u0011\u0011)Da\n\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cHOR3uG\"\u001cVM\u001c;U_.\u0013\u0016M\u001a;)\u0007\u0001\u0012\u0019#A\u000fuKN$XK\\1vi\"|'/\u001b>fI\u001a+Go\u00195T]\u0006\u00048\u000f[8uQ\r\t#1E\u0001\u001di\u0016\u001cHOR3uG\"\u001cf.\u00199tQ>$8+\u001a8u)>\\%+\u00194uQ\r\u0011#1E\u0001\u0015i\u0016\u001cH/\u00168bkRDwN]5{K\u00124v\u000e^3)\u0007\r\u0012\u0019#\u0001\u0012uKN$\b*\u00198eY\u0016dUmZ1ds\u0006cG/\u001a:D_:4\u0017nZ:FeJ|'o\u001d\u0015\u0004I\t\r\u0012\u0001\t;fgR,f.Y;uQ>\u0014\u0018N_3e\u0005\u0016<\u0017N\\)v_J,X.\u00129pG\"D3!\nB\u0012\u0003y!Xm\u001d;V]\u0006,H\u000f[8sSj,G-\u00128e#V|'/^7Fa>\u001c\u0007\u000eK\u0002'\u0005G\ta\u0004^3tiVs\u0017-\u001e;i_JL'0\u001a3EKN\u001c'/\u001b2f#V|'/^7)\u0007\u001d\u0012\u0019#A\u0013uKN$XK\\1vi\"|'/\u001b>fI\"\u000bg\u000e\u001a7f\u00032$XM]%teJ+\u0017/^3ti\"\u001a\u0001Fa\t\u0002YQ,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016\u0014%o\\6fe\"+\u0017M\u001d;CK\u0006$(+Z9vKN$\bfA\u0015\u0003$\u00051C/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a%b]\u0012dW-\u00168sK\u001eL7\u000f^3s\u0005J|7.\u001a:)\u0007)\u0012\u0019#A\u0005uKN$8\t\\8tK\"\u001a1Fa\t\u0002EQ,7\u000f^+oCV$\bn\u001c:ju\u0016$'I]8lKJ\u0014VmZ5tiJ\fG/[8oQ\ra#1E\u0001(i\u0016\u001cH/\u00168bkRDwN]5{K\u0012D\u0015M\u001c3mK\u0006cG/\u001a:DY&,g\u000e^)v_R\f7\u000fK\u0002.\u0005G\tQ\u0006^3tiVs\u0017-\u001e;i_JL'0\u001a3IC:$G.Z%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4tQ\rq#1E\u0001,i\u0016\u001cH/\u00138wC2LG-\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:SKN|WO]2fg\"\u001aqFa\t\u0002cQ,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8ug\"\u001a\u0001Ga\t\u0002SQ,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016\fE\u000e\\8dCR,\u0007K]8ek\u000e,'/\u00133tQ\r\t$1E\u00011i\u0016\u001cH/\u00168bkRDwN]5{K\u0012D\u0015M\u001c3mK2K7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^:)\u0007I\u0012\u0019#\u0001\tuKN$8I]3bi\u0016$v\u000e]5dg\"\u001a1Ga\t\u0002-Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001c()\u001f(b[\u0016D3\u0001\u000eB\u0012\u0003Q!Xm\u001d;EK2,G/\u001a+pa&\u001c7OQ=JI\"\u001aQGa\t\u0002=Q,7\u000f^%om\u0006d\u0017\u000e\u001a#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\bf\u0001\u001c\u0003$\u0005QC/Z:u\u001d>$\u0018)\u001e;i_JL'0\u001a3U_\u0012+G.\u001a;f/&$\b\u000eV8qS\u000e,\u00050[:uS:<\u0007fA\u001c\u0003$\u0005iC/Z:u\u001d>$\u0018)\u001e;i_JL'0\u001a3U_\u0012+G.\u001a;f/&$\b\u000eV8qS\u000etu\u000e^#ySN$\u0018N\\4)\u0007a\u0012\u0019#\u0001\u0017uKN$hj\u001c;D_:$(o\u001c7mKJ,%O]8s!J,g/\u001a8ug\u0012+G.\u001a;j]\u001e$v\u000e]5dg\"\u001a\u0011Ha\t\u00021Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001cH)[:bE2,G\rK\u0002;\u0005G\t1\u0004^3ti\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c(+Z9vKN$\bfA\u001e\u0003$\u0005iB/Z:u\u000b2,7\r\u001e'fC\u0012,'o]!vi\"|'/\u001b>bi&|g\u000eK\u0002=\u0005G\t1\u0005^3ti\u0016cWm\u0019;MK\u0006$WM]:IC:$G.\u001a3Cs\u000e{g\u000e\u001e:pY2,'\u000fK\u0002>\u0005G\tQ\u0002[1oI2,'+Z9vKN$X\u0003\u0002BZ\u0005w#bA!.\u0003`\n\u0005HC\u0002B\\\u0005\u000b\u0014)\u000e\u0005\u0003\u0003:\nmF\u0002\u0001\u0003\b\u0003\u007ft$\u0019\u0001B_#\u0011\u0011\u0019Aa0\u0011\t\u0005\r(\u0011Y\u0005\u0005\u0005\u0007\f)O\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\"9!q\u0019 A\u0004\t%\u0017\u0001C2mCN\u001cH+Y4\u0011\r\t-'\u0011\u001bB\\\u001b\t\u0011iMC\u0002\u0003P&\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0003T\n5'\u0001C\"mCN\u001cH+Y4\t\u000f\t]g\bq\u0001\u0003Z\u0006\u0011aN\u001c\t\u0006u\nm'qW\u0005\u0004\u0005;\\(A\u0003(pi:{G\u000f[5oO\"9\u0011q\u001c A\u0002\u0005\u0005\bb\u0002Br}\u0001\u0007\u0011\u0011Q\u0001\u000fG>tGO]8mY\u0016\u0014\u0018\t]5t\u0003!!X-\u0019:E_^t\u0007fA \u0003jB!!Q\u0005Bv\u0013\u0011\u0011iOa\n\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007")
public class ControllerApisTest {
    private final int nodeId;
    private final String brokerRack;
    private final String clientID;
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
    private final MockTime time = new MockTime();
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private final ControllerMutationQuotaManager clientControllerQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private final RaftManager<ApiMessageAndVersion> raftManager = (RaftManager)Mockito.mock(RaftManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.clientControllerQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);

    private int nodeId() {
        return this.nodeId;
    }

    private String brokerRack() {
        return this.brokerRack;
    }

    private String clientID() {
        return this.clientID;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ControllerMutationQuotaManager clientControllerQuotaManager() {
        return this.clientControllerQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private ControllerApis createControllerApis(Option<Authorizer> authorizer, Controller controller, Properties props) {
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Predef$.MODULE$.int2Integer(this.nodeId()));
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(this.nodeId()).append("@localhost:9092").toString());
        return new ControllerApis(this.requestChannel(), authorizer, this.quotas(), (Time)this.time(), Predef$.MODULE$.Map().empty(), controller, this.raftManager(), new KafkaConfig((Map)props), new MetaProperties("JgxuGe9URy-E-ceaL04lEw", this.nodeId()), (Seq)Nil$.MODULE$, (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER));
    }

    private Properties createControllerApis$default$3() {
        return new Properties();
    }

    private <T extends AbstractRequest> RequestChannel.Request buildRequest(AbstractRequest request, ListenerName listenerName) {
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(request.apiKey(), request.version(), this.clientID(), 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    /*
     * WARNING - void declaration
     */
    public Authorizer createDenyAllAuthorizer() {
        void var1_1;
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(AuthorizableRequestContext.class), (List)ArgumentMatchers.any(List.class))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        return var1_1;
    }

    @Test
    public void testUnauthorizedFetch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), this.buildRequest$default$2())));
    }

    @Test
    public void testFetchSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), this.buildRequest$default$2()));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedFetchSnapshot() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), this.buildRequest$default$2())));
    }

    @Test
    public void testFetchSnapshotSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), this.buildRequest$default$2()));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedVote() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleVote(this.buildRequest((AbstractRequest)new VoteRequest.Builder(new VoteRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testHandleLegacyAlterConfigsErrors() {
        AlterConfigsRequestData requestData = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("baz").setResourceType((byte)123).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new AlterConfigsRequest(requestData, 0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleLegacyAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        AlterConfigsResponse response = (AlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 123.").setResourceName("baz").setResourceType((byte)123), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("Cluster authorization failed.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id())})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testUnauthorizedBeginQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleBeginQuorumEpoch(this.buildRequest((AbstractRequest)new BeginQuorumEpochRequest.Builder(new BeginQuorumEpochRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedEndQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleEndQuorumEpoch(this.buildRequest((AbstractRequest)new EndQuorumEpochRequest.Builder(new EndQuorumEpochRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedDescribeQuorum() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleDescribeQuorum(this.buildRequest((AbstractRequest)new DescribeQuorumRequest.Builder(new DescribeQuorumRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleAlterIsrRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterIsrRequest(this.buildRequest((AbstractRequest)new AlterIsrRequest.Builder(new AlterIsrRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleBrokerHeartBeatRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleBrokerHeartBeatRequest(this.buildRequest((AbstractRequest)new BrokerHeartbeatRequest.Builder(new BrokerHeartbeatRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleUnregisterBroker() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleUnregisterBroker(this.buildRequest((AbstractRequest)new UnregisterBrokerRequest.Builder(new UnregisterBrokerRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testClose() {
        ControllerApis apis = this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), this.createControllerApis$default$3());
        apis.close();
        Assertions.assertTrue((boolean)apis.isClosed());
    }

    @Test
    public void testUnauthorizedBrokerRegistration() {
        BrokerRegistrationRequest brokerRegistrationRequest = (BrokerRegistrationRequest)new BrokerRegistrationRequest.Builder(new BrokerRegistrationRequestData().setBrokerId(this.nodeId()).setRack(this.brokerRack())).build();
        RequestChannel.Request request = this.buildRequest((AbstractRequest)brokerRegistrationRequest, this.buildRequest$default$2());
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), this.createControllerApis$default$3()).handle(request, RequestLocal$.MODULE$.withThreadConfinedCaching());
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        BrokerRegistrationResponse brokerRegistrationResponse = (BrokerRegistrationResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.CLUSTER_AUTHORIZATION_FAILED), (Object)BoxesRunTime.boxToInteger((int)1))})), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(brokerRegistrationResponse.errorCounts()).asScala());
    }

    @Test
    public void testUnauthorizedHandleAlterClientQuotas() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterClientQuotas(this.buildRequest((AbstractRequest)new AlterClientQuotasRequest(new AlterClientQuotasRequestData(), 0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleIncrementalAlterConfigs() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("flush.ms").setValue("1000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()).setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id())})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testInvalidIncrementalAlterConfigsResources() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("kafka.server.KafkaConfig").setValue("TRACE").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType((byte)124).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Unexpected resource type BROKER_LOGGER.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 124.").setResourceName("foo").setResourceType((byte)124)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testUnauthorizedHandleAlterPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterPartitionReassignments(this.buildRequest(new AlterPartitionReassignmentsRequest.Builder(new AlterPartitionReassignmentsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleAllocateProducerIds() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAllocateProducerIdsRequest(this.buildRequest(new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleListPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleListPartitionReassignments(this.buildRequest(new ListPartitionReassignmentsRequest.Builder(new ListPartitionReassignmentsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testCreateTopics() {
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        CreateTopicsRequestData request = new CreateTopicsRequestData().setTopics(new CreateTopicsRequestData.CreatableTopicCollection(Arrays.asList((Object[])new CreateTopicsRequestData.CreatableTopic[]{new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(1).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("baz").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("quux").setNumPartitions(2).setReplicationFactor((short)3)}).iterator()));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateTopicsResponseData.CreatableTopicResult[]{new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("baz").setErrorCode(Errors.NONE.code()).setTopicId(new Uuid(0L, 1L)), new CreateTopicsResponseData.CreatableTopicResult().setName("quux").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((CreateTopicsResponseData)controllerApis.createTopics(request, false, (Function1 & Serializable & scala.Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz"}))).get()).topics()).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsByName() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"foo", "bar", "quux", "quux"}));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("This server does not host this topic-partition."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$2 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$3 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsById() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid quuxId = Uuid.fromString((String)"ObXkLhL_S5W62FAE67U3MQ");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(quuxId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage("This server does not host this topic ID."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$4 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$5 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testInvalidDeleteTopicsRequest() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"YOS4oQ3UT9eSAZahN1ysSA");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Neither topic name nor id were specified."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("You may not specify both topic name and topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setTopicId(barId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("The provided topic name maps to an ID that was already supplied."), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(bazId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id.")}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)names -> names.toSet(), (Function1 & Serializable & scala.Serializable)names -> names.toSet()).get()).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicExisting() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w");
        Uuid quuxId = Uuid.fromString((String)"5URoQzW_RJiERVZXJgUVLg");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).newInitialTopic("baz", bazId).newInitialTopic("quux", quuxId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("baz").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("baz").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$6 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "baz"})), (Function1 & Serializable & scala.Serializable)x$7 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicNotExisting() {
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_ID.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$8 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Function1 & Serializable & scala.Serializable)x$9 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testNotControllerErrorPreventsDeletingTopics() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        controller.setActive(false);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals(NotControllerException.class, Assertions.assertThrows(ExecutionException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$10 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$11 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).getCause().getClass());
    }

    @Test
    public void testDeleteTopicsDisabled() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "false");
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, props);
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$12 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$13 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        Assertions.assertThrows(InvalidRequestException.class, () -> controllerApis.deleteTopics(request, 1, false, (Function1 & Serializable & scala.Serializable)x$14 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$15 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
    }

    @Test
    public void testCreatePartitionsRequest() {
        MockController controller = new MockController.Builder().newInitialTopic("foo", Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).newInitialTopic("bar", Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw")).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        CreatePartitionsRequestData request = new CreatePartitionsRequestData();
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("baz").setAssignments(null).setCount(5));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsResponseData.CreatePartitionsTopicResult[]{new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("foo").setErrorCode(Errors.NONE.code()).setErrorMessage(null), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("baz").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(null)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.createPartitions(request, false, (Function1 & Serializable & scala.Serializable)x$16 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).asScala()).toSet());
    }

    @Test
    public void testElectLeadersAuthorization() {
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)new Some((Object)authorizer), controller, this.createControllerApis$default$3());
        ElectLeadersRequest request = (ElectLeadersRequest)new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 30000).build();
        ResourcePattern resource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        List<Action> actions = Collections.singletonList(new Action(AclOperation.ALTER, resource, 1, true, true));
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(actions))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        ElectLeadersResponse response = (ElectLeadersResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(ElectLeadersResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)Errors.forCode((short)response.data().errorCode()));
    }

    @Test
    public void testElectLeadersHandledByController() {
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        ElectLeadersRequest request = (ElectLeadersRequest)new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 30000).build();
        ElectLeadersResponseData responseData = new ElectLeadersResponseData().setErrorCode(Errors.NOT_CONTROLLER.code());
        Mockito.when((Object)controller.electLeaders(request.data())).thenReturn(CompletableFuture.completedFuture(responseData));
        ElectLeadersResponse response = (ElectLeadersResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(ElectLeadersResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)response.data().errorCode()));
    }

    private <T extends AbstractResponse> T handleRequest(AbstractRequest request, ControllerApis controllerApis, ClassTag<T> classTag, NotNothing<T> nn) {
        RequestChannel.Request req = this.buildRequest(request, this.buildRequest$default$2());
        controllerApis.handle(req, RequestLocal$.MODULE$.NoCaching());
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)req), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        AbstractResponse abstractResponse = (AbstractResponse)capturedResponse.getValue();
        Option option = classTag.unapply((Object)abstractResponse);
        if (option.isEmpty() || option.get() == null) {
            throw new ClassCastException(new StringBuilder(40).append("Expected response with type ").append(classTag.runtimeClass()).append(", ").append("but found ").append(abstractResponse.getClass()).toString());
        }
        return (T)abstractResponse;
    }

    @AfterEach
    public void tearDown() {
        this.quotas().shutdown();
    }

    public ControllerApisTest() {
        this.nodeId = 1;
        this.brokerRack = "Rack1";
        this.clientID = "Client1";
    }
}

