/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rB\u0001\"\n\u0001\t\u0006\u0004%IA\n\u0005\u0006[\u0001!\tE\f\u0005\u0006k\u0001!\tF\u000e\u0005\u0006s\u0001!\tF\u000f\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006?\u0002!\t!\u0013\u0005\u0006E\u0002!\t!\u0013\u0005\u0006I\u0002!\t!\u0013\u0005\u0006M\u0002!\t!\u0013\u0005\u0006Q\u0002!\t!\u0013\u0005\u0006U\u0002!\t!\u0013\u0005\u0006Y\u0002!\t!\u0013\u0005\u0006c\u0002!\t!\u0013\u0005\u0006i\u0002!\t!\u0013\u0005\u0006m\u0002!\t!\u0013\u0005\u00063\u0001!I\u0001\u001f\u0005\u0006y\u0002!I! \u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!a#\u0001\t\u0013\ti\tC\u0004\u0002:\u0002!I!a/\u0003\u001b1{wm\u00144gg\u0016$H+Z:u\u0015\tI\"$\u0001\u0004tKJ4XM\u001d\u0006\u00027\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0019\u0013\t\t\u0003DA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002 \u0001\u0005!A/[7f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ta\u0013F\u0001\u0005N_\u000e\\G+[7f\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u00121!\u00138u\u0003)\u0011'o\\6feRKW.\u001a\u000b\u0003O]BQ\u0001\u000f\u0003A\u0002=\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"a\u000f \u0011\u0005Ab\u0014BA\u001f2\u0005\u0011)f.\u001b;\t\u000b}*\u0001\u0019\u0001!\u0002\u000bA\u0014x\u000e]:\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001B;uS2T\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0005\nQ\u0001K]8qKJ$\u0018.Z:\u0002;Q,7\u000f^$fi>3gm]3ug\u001a{'/\u00168l]><h\u000eV8qS\u000e$\u0012a\u000f\u0015\u0003\r-\u0003\"\u0001T+\u000e\u00035S!AT(\u0002\u0007\u0005\u0004\u0018N\u0003\u0002Q#\u00069!.\u001e9ji\u0016\u0014(B\u0001*T\u0003\u0015QWO\\5u\u0015\u0005!\u0016aA8sO&\u0011a+\u0014\u0002\u0005)\u0016\u001cH\u000f\u000b\u0003\u00071nk\u0006C\u0001\u0019Z\u0013\tQ\u0016G\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013\u0001X\u0001\u0016\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000f\t,1C\u0005q\u0016\u0001A\u0001!i\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000f\u000b\u0002\b\u0017\"\"q\u0001W.^\u0003Y\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7q\r>\u0014X*\u0019=US6,7\u000f^1na\u00063G/\u001a:UeVt7-\u0019;fQ\tA1*\u0001!uKN$h)\u001a;dQ>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007OR8s\u001b\u0006DH+[7fgR\fW\u000e],ji\",fn\u001c:eKJ,G\rV5nKN$\u0018-\u001c9tQ\tI1*\u0001\u0010uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a'bi\u0016\u001cH\u000fV5nK\"\u0012!bS\u0001\u0018i\u0016\u001cH/R7qifdunZ:HKR|eMZ:fiND#aC&\u0002kQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q/&$\b.R7qifdun\u001a\u0015\u0003\u0019-\u000bq\u0003^3ti\u001e+Go\u00144gg\u0016$8OQ3g_J,gj\\<)\u00055Y\u0005\u0006B\u0007Y_v\u000b\u0013\u0001]\u0001\u0019Y\u0016<\u0017mY=GKR\u001c\u0007n\u00144gg\u0016$8OQ3g_J,\u0017\u0001\t;fgR<U\r^(gMN,Go\u001d\"fM>\u0014X-R1sY&,7\u000f\u001e+j[\u0016D#AD&)\t9Av.X\u0001.i\u0016\u001cHOR3uG\"|eMZ:fiN\u0014UMZ8sK^KG\u000f[\"iC:<\u0017N\\4TK\u001elWM\u001c;TSj,\u0007FA\bL\u0003)\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8OQ3g_J,w+\u001b;i\u0007\"\fgnZ5oON+w-\\3oiND#\u0001E&\u0016\u0003e\u0004\"a\b>\n\u0005mD\"aC&bM.\f7+\u001a:wKJ\fac]3oI2K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u000b\u0004}\u0006M\u0001cA@\u0002\u00105\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t9!!\u0003\u0002\r\r|W.\\8o\u0015\rY\u00121\u0002\u0006\u0004\u0003\u001b\u0019\u0016AB1qC\u000eDW-\u0003\u0003\u0002\u0012\u0005\u0005!a\u0005'jgR|eMZ:fiN\u0014Vm\u001d9p]N,\u0007bBA\u000b%\u0001\u0007\u0011qC\u0001\be\u0016\fX/Z:u!\ry\u0018\u0011D\u0005\u0005\u00037\t\tA\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$\u0018\u0001E:f]\u00124U\r^2i%\u0016\fX/Z:u)\u0011\t\t#a\n\u0011\u0007}\f\u0019#\u0003\u0003\u0002&\u0005\u0005!!\u0004$fi\u000eD'+Z:q_:\u001cX\rC\u0004\u0002\u0016M\u0001\r!!\u000b\u0011\u0007}\fY#\u0003\u0003\u0002.\u0005\u0005!\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0001\u00052vS2$G+\u0019:hKR$\u0016.\\3t)!\t\u0019$!\u001d\u0002~\u0005\u001d\u0005CBA\u001b\u0003\u000b\nYE\u0004\u0003\u00028\u0005\u0005c\u0002BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uB$\u0001\u0004=e>|GOP\u0005\u0002e%\u0019\u00111I\u0019\u0002\u000fA\f7m[1hK&!\u0011qIA%\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r\u0013\u0007\u0005\u0003\u0002N\u0005-d\u0002BA(\u0003KrA!!\u0015\u0002b9!\u00111KA0\u001d\u0011\t)&!\u0018\u000f\t\u0005]\u00131\f\b\u0005\u0003s\tI&C\u0001U\u0013\r\tiaU\u0005\u00047\u0005-\u0011\u0002BA\u0004\u0003\u0013IA!a\u0019\u0002\u0006\u00059Q.Z:tC\u001e,\u0017\u0002BA4\u0003S\na\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0003G\n)!\u0003\u0003\u0002n\u0005=$\u0001\u0005'jgR|eMZ:fiN$v\u000e]5d\u0015\u0011\t9'!\u001b\t\u000f\u0005MD\u00031\u0001\u0002v\u0005\u0011A\u000f\u001d\t\u0005\u0003o\nI(\u0004\u0002\u0002\u0006%!\u00111PA\u0003\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a \u0015\u0001\u0004\t\t)A\u0005uS6,7\u000f^1naB\u0019\u0001'a!\n\u0007\u0005\u0015\u0015G\u0001\u0003M_:<\u0007BBAE)\u0001\u0007q&A\u0007nCbtU/\\(gMN,Go]\u0001\u000eM&tG\rU1si&$\u0018n\u001c8\u0015\r\u0005=\u0015QTA\\!\u0011\t\t*a&\u000f\t\u0005=\u00131S\u0005\u0005\u0003+\u000bI'A\fMSN$xJ\u001a4tKR\u001c(+Z:q_:\u001cX\rR1uC&!\u0011\u0011TAN\u0005qa\u0015n\u001d;PM\u001a\u001cX\r^:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TA!!&\u0002j!9\u0011qT\u000bA\u0002\u0005\u0005\u0016A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002$\u00065\u0016\u0011W\u0007\u0003\u0003KSA!a*\u0002*\u00069Q.\u001e;bE2,'bAAVc\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0016Q\u0015\u0002\u0007\u0005V4g-\u001a:\u0011\t\u0005E\u00151W\u0005\u0005\u0003k\u000bYJ\u0001\rMSN$xJ\u001a4tKR\u001cHk\u001c9jGJ+7\u000f]8og\u0016Dq!a\u001d\u0016\u0001\u0004\t)(\u0001\u000bde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3HKRdun\u001a\u000b\u0007\u0003{\u000bI-!8\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1\u001b\u0003\rawnZ\u0005\u0005\u0003\u000f\f\tM\u0001\u0006V]&4\u0017.\u001a3M_\u001eDq!a3\u0017\u0001\u0004\ti-A\u0003u_BL7\r\u0005\u0003\u0002P\u0006]g\u0002BAi\u0003'\u00042!!\u000f2\u0013\r\t).M\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00171\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\u0017\u0007C\u0004\u0002`Z\u0001\r!!\u001e\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), (KafkaBroker)this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).timestamp);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L})).foreach((Function1 & Serializable & scala.Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.getTopicIds()).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, (KafkaBroker)this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava())).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala()).head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), (KafkaBroker)this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeNow$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), (KafkaBroker)this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeEarliestTime$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        UnifiedLog log = (UnifiedLog)EasyMock.niceMock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        UnifiedLog log = (UnifiedLog)EasyMock.niceMock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.companion$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.thisCollection$((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.foreach$((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.forall$((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.exists$((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.find$((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.isEmpty$((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.foldRight$((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.reduceRight$((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.toIterable$((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.toIterator$((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.head$((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.take$((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.drop$((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableLike.grouped$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableLike.sliding$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.takeRight$((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.dropRight$((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zip$((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.sameElements$((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.toStream$((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.canEqual$((IterableLike)this, (Object)that);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view() {
                        return IterableLike.view$((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.repr$((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.isTraversableAgain$((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.parCombiner$((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
                    }

                    public Object filterImpl(Function1 p, boolean isFlipped) {
                        return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.filter$((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.partition$((TraversableLike)this, p);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.groupBy$((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.headOption$((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.tail$((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.last$((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.lastOption$((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.init$((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.span$((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.tails$((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.inits$((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.toTraversable$((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.toString$((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.stringPrefix$((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.withFilter$((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.par$((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return new .colon.colon((Object)this.$outer.logSegment$1, (List)Nil$.MODULE$).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Parallelizable.$init$((Parallelizable)this);
                        TraversableLike.$init$((TraversableLike)this);
                        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                        GenTraversable.$init$((GenTraversable)this);
                        Traversable.$init$((Traversable)this);
                        GenIterable.$init$((GenIterable)this);
                        IterableLike.$init$((IterableLike)this);
                        Iterable.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$2))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$3))).get();
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$createTopicAndGetLog$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$2) {
        String string = x$2.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$3) {
        return x$3.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

