/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.Configuration;
import kafka.raft.KafkaRaftManager;
import kafka.raft.RaftManager;
import kafka.server.ControllerServer;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t=c!\u0002\u0017.\u0003\u0003\u0011\u0004\"B \u0001\t\u0003\u0001\u0005bB\"\u0001\u0005\u0004%\t\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\u000f%\u0003!\u0019!C\u0001\t\"1!\n\u0001Q\u0001\n\u0015Cqa\u0013\u0001C\u0002\u0013\u0005A\t\u0003\u0004M\u0001\u0001\u0006I!\u0012\u0005\u0006\u001b\u0002!\tB\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u00191\u0007\u0001)A\u0005/\")q\r\u0001C\tQ\"9q\u000f\u0001a\u0001\n\u0013A\bb\u0002?\u0001\u0001\u0004%I! \u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003z\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0012\u0001!\t!a\u0004\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\t\t\u0005\u0001C\u0001\u0003sAq!a\u0011\u0001\t\u0003\t)\u0005\u0003\u0004\u0002N\u0001!\t\u0001\u0012\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\tI\u0007\u0001C\u0001\u0003#Bq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"I\u00111\u0018\u0001\u0012\u0002\u0013\u0005\u0011Q\u0018\u0005\b\u0003'\u0004A\u0011AA\b\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0002x\u0002!I!!\u0006\t\u000f\u0005e\b\u0001\"\u0001\u0002\u0010!9!1\u0001\u0001\u0005\u0002\t\u0015qa\u0002B\u0012[!\u0005!Q\u0005\u0004\u0007Y5B\tAa\n\t\r}2C\u0011\u0001B\u0015\u0011%\u0011YC\nb\u0001\n\u0003\u0011i\u0003\u0003\u0005\u0003:\u0019\u0002\u000b\u0011\u0002B\u0018\u0011\u001d\u0011YD\nC\u0001\u0003\u001fAqA!\u0012'\t\u0003\tyAA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgNT!AL\u0018\u0002\rM,'O^3s\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0004\u0001MJ\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g\r\u0005\u0002;{5\t1H\u0003\u0002=_\u0005)Q\u000f^5mg&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\t\u0005\u0002C\u00015\tQ&A\n{W\u000e{gN\\3di&|g\u000eV5nK>,H/F\u0001F!\t!d)\u0003\u0002Hk\t\u0019\u0011J\u001c;\u0002)i\\7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;!\u0003AQ8nU3tg&|g\u000eV5nK>,H/A\t{WN+7o]5p]RKW.Z8vi\u0002\nQC_6NCbLeN\u00127jO\"$(+Z9vKN$8/\u0001\f{W6\u000b\u00070\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^:!\u00035Q8.Q2mg\u0016s\u0017M\u00197fIV\tq\nE\u00025!JK!!U\u001b\u0003\r=\u0003H/[8o!\t!4+\u0003\u0002Uk\t9!i\\8mK\u0006t\u0017AI2p]R\u0014x\u000e\u001c7fe2K7\u000f^3oKJ\u001cVmY;sSRL\bK]8u_\u000e|G.F\u0001X!\tAF-D\u0001Z\u0015\tQ6,\u0001\u0003bkRD'B\u0001/^\u0003!\u0019XmY;sSRL(B\u00010`\u0003\u0019\u0019w.\\7p]*\u0011\u0001\u0007\u0019\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014x-\u0003\u0002f3\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001$G>tGO]8mY\u0016\u0014H*[:uK:,'oU3dkJLG/\u001f)s_R|7m\u001c7!\u0003YY'/\u00194u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u001cH#A5\u0011\u0007)lw.D\u0001l\u0015\taW'\u0001\u0006d_2dWm\u0019;j_:L!A\\6\u0003\u0007M+\u0017\u000f\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!Q\u000f^5m\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\bj[BdW-\\3oi\u0006$\u0018n\u001c8\u0016\u0003e\u0004\"A\u0011>\n\u0005ml#\u0001F)v_J,X.S7qY\u0016lWM\u001c;bi&|g.\u0001\nj[BdW-\\3oi\u0006$\u0018n\u001c8`I\u0015\fHc\u0001@\u0002\u0004A\u0011Ag`\u0005\u0004\u0003\u0003)$\u0001B+oSRD\u0001\"!\u0002\u000e\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\n\u0014aD5na2,W.\u001a8uCRLwN\u001c\u0011\u0002\u0017%\u001c8JU1giR+7\u000f\u001e\u000b\u0002%\u0006i1\r[3dW&\u001b(l\u0013+fgR$\u0012A`\u0001\u0011G\",7m[%t\u0017J\u000bg\r\u001e+fgR\fA!Y:[WR\u0011\u0011q\u0003\t\u0004\u0005\u0006e\u0011bAA\u000e[\ti\"l\\8LK\u0016\u0004XM])v_J,X.S7qY\u0016lWM\u001c;bi&|g.A\u0004bg.\u0013\u0016M\u001a;\u0015\u0005\u0005\u0005\u0002c\u0001\"\u0002$%\u0019\u0011QE\u0017\u00033-\u0013\u0016M\u001a;Rk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\nu>|7.Z3qKJ,\"!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r0\u0003\tQ8.\u0003\u0003\u00026\u0005=\"!E#nE\u0016$G-\u001a3[_>\\W-\u001a9fe\u0006A!p[\"mS\u0016tG/\u0006\u0002\u0002<A!\u0011QFA\u001f\u0013\u0011\ty$a\f\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u00039Q8n\u00117jK:$xJ\u001d(vY2\fQ\"\u00193nS:T6n\u00117jK:$XCAA$!\u0011\ti#!\u0013\n\t\u0005-\u0013q\u0006\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\ri\\\u0007k\u001c:u\u0003%Q8nQ8o]\u0016\u001cG/\u0006\u0002\u0002TA!\u0011QKA2\u001d\u0011\t9&a\u0018\u0011\u0007\u0005eS'\u0004\u0002\u0002\\)\u0019\u0011QL\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\t\t'N\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0014q\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005T'A\b{W\u000e{gN\\3di>\u0013h*\u001e7m\u0003A\u0019wN\u001c;s_2dWM]*feZ,'/\u0006\u0002\u0002pA\u0019!)!\u001d\n\u0007\u0005MTF\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006)1/\u001a;VaR\u0019a0!\u001f\t\u000f\u0005mD\u00041\u0001\u0002~\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\u0000\u00055UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\b\u0006%\u0015a\u00026va&$XM\u001d\u0006\u0004\u0003\u0017\u0013\u0017!\u00026v]&$\u0018\u0002BAH\u0003\u0003\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u00049\u0005M\u0005\u0003BA@\u0003+KA!a&\u0002\u0002\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002)\r\u0014X-\u0019;f\u0003:$7\u000b^1si\n\u0013xn[3s)\u0019\ti*a)\u0002.B\u0019!)a(\n\u0007\u0005\u0005VFA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\bbBAS;\u0001\u0007\u0011qU\u0001\u0007G>tg-[4\u0011\u0007\t\u000bI+C\u0002\u0002,6\u00121bS1gW\u0006\u001cuN\u001c4jO\"I\u0011qV\u000f\u0011\u0002\u0003\u0007\u0011\u0011W\u0001\u0005i&lW\r\u0005\u0003\u00024\u0006]VBAA[\u0015\taT,\u0003\u0003\u0002:\u0006U&\u0001\u0002+j[\u0016\fad\u0019:fCR,\u0017I\u001c3Ti\u0006\u0014HO\u0011:pW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}&\u0006BAY\u0003\u0003\\#!a1\u0011\t\u0005\u0015\u0017qZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b,\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011[Ad\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012g\",H\u000fZ8x]j{wnS3fa\u0016\u0014\u0018!\u00054pe6\fG\u000fR5sK\u000e$xN]5fgR)a0!7\u0002h\"9\u00111\u001c\u0011A\u0002\u0005u\u0017a\u00033je\u0016\u001cGo\u001c:jKN\u0004b!a8\u0002f\u0006MSBAAq\u0015\r\t\u0019o[\u0001\nS6lW\u000f^1cY\u0016L1A\\Aq\u0011\u001d\tI\u000f\ta\u0001\u0003W\fa\"\\3uCB\u0013x\u000e]3si&,7\u000fE\u0002C\u0003[L1!a<.\u00059iU\r^1Qe>\u0004XM\u001d;jKN\faB\\3x\u0017J\u000bg\r^)v_J,X\u000e\u0006\u0003\u0002\"\u0005U\bbBA>C\u0001\u0007\u0011QP\u0001\u0013]\u0016<(l\\8LK\u0016\u0004XM])v_J,X.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0019\u0013Q \t\u0005\u0003\u007f\ny0\u0003\u0003\u0003\u0002\u0005\u0005%!C!gi\u0016\u0014X)Y2i\u0003-\u001a'/Z1uKj{wnS3fa\u0016\u00148\t\\5f]R$v\u000e\u0016:jO\u001e,'oU3tg&|g.\u0012=qSJLH\u0003\u0002B\u0004\u0005#\u0001BA!\u0003\u0003\u000e5\u0011!1\u0002\u0006\u0004\u0003O\u0001\u0017\u0002\u0002B\b\u0005\u0017\u0011\u0011BW8p\u0017\u0016,\u0007/\u001a:\t\u000f\tMA\u00051\u0001\u0003\b\u0005I!p\\8LK\u0016\u0004XM\u001d\u0015\b\u0001\t]!Q\u0004B\u0010!\u0011\tyH!\u0007\n\t\tm\u0011\u0011\u0011\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017E\u0001B\u0011\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0002#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002CMM\u0011ae\r\u000b\u0003\u0005K\t\u0011DW6DY&,g\u000e^#wK:$H\u000b\u001b:fC\u0012\u001cVO\u001a4jqV\u0011!q\u0006\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!QG:\u0002\t1\fgnZ\u0005\u0005\u0003K\u0012\u0019$\u0001\u000e[W\u000ec\u0017.\u001a8u\u000bZ,g\u000e\u001e+ie\u0016\fGmU;gM&D\b%\u0001\u0006tKR,\u0006o\u00117bgND3A\u000bB !\u0011\tyH!\u0011\n\t\t\r\u0013\u0011\u0011\u0002\n\u0005\u00164wN]3BY2\fQ\u0002^3be\u0012{wO\\\"mCN\u001c\bfA\u0016\u0003JA!\u0011q\u0010B&\u0013\u0011\u0011i%!!\u0003\u0011\u00053G/\u001a:BY2\u0004")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private final SecurityProtocol controllerListenerSecurityProtocol;
    private QuorumImplementation implementation;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    private SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public boolean isKRaftTest() {
        return this.implementation() instanceof KRaftQuorumImplementation;
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        String name;
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String string = name = testInfo.getTestMethod().isPresent() ? ((Method)testInfo.getTestMethod().get()).toString() : "[unspecified]";
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createAndStartBroker(KafkaConfig config, Time time) {
        return this.implementation().createAndStartBroker(config, time);
    }

    public Time createAndStartBroker$default$2() {
        return Time.SYSTEM;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        String clusterId = Uuid.randomUuid().toString();
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(clusterId, 0);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        Metrics controllerMetrics = new Metrics();
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(1).append(proto).append(":").append(proto).toString());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(14).append(proto).append("://localhost:0").toString());
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), proto);
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1000@localhost:0");
        KafkaConfig config = new KafkaConfig((Map)props);
        String threadNamePrefix = new StringBuilder(11).append("Controller_").append(testInfo.getDisplayName()).toString();
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        KafkaRaftManager raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)MetadataRecordSerde.INSTANCE, new TopicPartition(KafkaRaftServer$.MODULE$.MetadataTopic(), 0), KafkaRaftServer$.MODULE$.MetadataTopicId(), Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(metaProperties, config, (RaftManager)raftManager, Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(1000), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
            raftManager.startup();
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raftManager.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw e2;
        }
        return new KRaftQuorumImplementation((KafkaRaftManager<ApiMessageAndVersion>)raftManager, (ControllerServer)controllerServer.elem, metadataDir, controllerQuorumVotersFuture, clusterId, this);
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
        this.implementation = null;
    }
}

