/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerState;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00113Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!9Q\u0002\u0001a\u0001\n\u0013I\u0002bB\u000f\u0001\u0001\u0004%IA\b\u0005\u0007O\u0001\u0001\u000b\u0015\u0002\u000e\t\u000b!\u0002A\u0011I\u0015\t\u000b]\u0002A\u0011A\u0015\t\u000bq\u0002A\u0011A\u0015\t\u000by\u0002A\u0011A\u0015\t\u000b\u0001\u0003A\u0011A\u0015\t\u000b\t\u0003A\u0011A\u0015\u0003#M+'O^3s'R\f'\u000f^;q)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0002CA\n\u0001+\u0005Q\u0002CA\n\u001c\u0013\taBBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000fC\u0004'\u0007\u0005\u0005\t\u0019\u0001\u000e\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\b\u0015\u0003\u000b-\u0002\"\u0001L\u001b\u000e\u00035R!AL\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00021c\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001a4\u0003\u0015QWO\\5u\u0015\u0005!\u0014aA8sO&\u0011a'\f\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\u0004^3ti\n\u0013xn[3s\u0007J,\u0017\r^3t5.\u001b\u0005N]8pi\"\u0012a!\u000f\t\u0003YiJ!aO\u0017\u0003\tQ+7\u000f^\u0001&i\u0016\u001cHoQ8oM2L7\r\u001e\"s_.,'o\u0015;beR,\boV5uQN\u000bW.\u001a)peRD#aB\u001d\u0002=Q,7\u000f^\"p]\u001ad\u0017n\u0019;Ce>\\WM\u001d*fO&\u001cHO]1uS>t\u0007F\u0001\u0005:\u0003M!Xm\u001d;Ce>\\WM]*fY\u001a\fu/\u0019:fQ\tI\u0011(A\u000fuKN$(I]8lKJ\u001cF/\u0019;f%Vtg.\u001b8h\u0003\u001a$XM\u001d.LQ\tQ\u0011\b")
public class ServerStartupTest
extends QuorumTestHarness {
    private KafkaServer server = null;

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.server() != null) {
            TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)this.server(), (List)Nil$.MODULE$));
        }
        super.tearDown();
    }

    @Test
    public void testBrokerCreatesZKChroot() {
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", new StringBuilder(0).append(zooKeeperConnect.toString()).append(zookeeperChroot).toString());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Assertions.assertTrue((boolean)this.zkClient().pathExists(zookeeperChroot));
    }

    @Test
    public void testConflictBrokerStartupWithSamePort() {
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), TestUtils$.MODULE$.createServer$default$2()));
        int port = TestUtils$.MODULE$.boundPort((KafkaBroker)this.server(), TestUtils$.MODULE$.boundPort$default$2());
        int brokerId2 = 1;
        String x$2 = this.zkConnect();
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId2, x$2, x$4, x$5, port, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        Assertions.assertThrows(KafkaException.class, () -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Test
    public void testConflictBrokerRegistration() {
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerRegistration = (Broker)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"broker doesn't exists"));
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), TestUtils$.MODULE$.createServer$default$2()));
        Assertions.assertEquals((Object)brokerRegistration, (Object)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"broker doesn't exists")));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerSelfAware() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerSelfAware$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ServerStartupTest.$anonfun$testBrokerSelfAware$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)this.server().metadataCache().getAliveBrokers().size());
        Assertions.assertEquals((int)brokerId, (int)((BrokerMetadata)this.server().metadataCache().getAliveBrokers().head()).id());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerStateRunningAfterZK() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(new KafkaServer(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4()));
        this.server().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerStateRunningAfterZK$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ServerStartupTest.$anonfun$testBrokerStateRunningAfterZK$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Seq brokers = this.zkClient().getAllBrokersInCluster();
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)brokerId, (int)((Broker)brokers.head()).id());
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerSelfAware$1(ServerStartupTest $this) {
        return $this.server().metadataCache().getAliveBrokers().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testBrokerSelfAware$2() {
        return "Wait for cache to update";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateRunningAfterZK$1(ServerStartupTest $this) {
        BrokerState brokerState = $this.server().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerStateRunningAfterZK$2() {
        return "waiting for the broker state to become RUNNING";
    }
}

