/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Arrays;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import kafka.utils.Exit$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001m3Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003B\u0002\u001b\u0001A\u0003%a\u0005C\u00046\u0001\t\u0007I\u0011A\u0013\t\rY\u0002\u0001\u0015!\u0003'\u0011\u001d9\u0004A1A\u0005\u0002\u0015Ba\u0001\u000f\u0001!\u0002\u00131\u0003bB\u001d\u0001\u0005\u0004%\t!\n\u0005\u0007u\u0001\u0001\u000b\u0011\u0002\u0014\t\u000fm\u0002!\u0019!C\u0001K!1A\b\u0001Q\u0001\n\u0019BQ!\u0010\u0001\u0005\u0002yBQa\u0014\u0001\u0005\u0002yBQ!\u0015\u0001\u0005\u0002yBQa\u0015\u0001\u0005\u0002yBQ!\u0016\u0001\u0005\u0002yBQa\u0016\u0001\u0005\u0002yBQ!\u0017\u0001\u0005\u0002y\u00121cQ8og>dW\r\u0015:pIV\u001cWM\u001d+fgRT!!\u0006\f\u0002\u000bQ|w\u000e\\:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u000b\u0002'\t\u0014xn[3s\u0019&\u001cHOV1mS\u0012\f%oZ:\u0016\u0003\u0019\u00022aG\u0014*\u0013\tACDA\u0003BeJ\f\u0017\u0010\u0005\u0002+c9\u00111f\f\t\u0003Yqi\u0011!\f\u0006\u0003]a\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ab\u0012\u0001\u00062s_.,'\u000fT5tiZ\u000bG.\u001b3Be\u001e\u001c\b%\u0001\rc_>$8\u000f\u001e:baN+'O^3s-\u0006d\u0017\u000eZ!sON\f\u0011DY8piN$(/\u00199TKJ4XM\u001d,bY&$\u0017I]4tA\u0005Y\u0011N\u001c<bY&$\u0017I]4t\u00031IgN^1mS\u0012\f%oZ:!\u0003]\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014xJ^3se&$W-\u0001\rc_>$8\u000f\u001e:baN+'O^3s\u001fZ,'O]5eK\u0002\n\u0001c\u00197jK:$\u0018\nZ(wKJ\u0014\u0018\u000eZ3\u0002#\rd\u0017.\u001a8u\u0013\u0012|e/\u001a:sS\u0012,\u0007%\u0001\u000euKN$h+\u00197jI\u000e{gNZ5hg\n\u0013xn[3s\u0019&\u001cH\u000fF\u0001@!\tY\u0002)\u0003\u0002B9\t!QK\\5uQ\ta1\t\u0005\u0002E\u001b6\tQI\u0003\u0002G\u000f\u0006\u0019\u0011\r]5\u000b\u0005!K\u0015a\u00026va&$XM\u001d\u0006\u0003\u0015.\u000bQA[;oSRT\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(F\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e\u001c(i\\8ugR\u0014\u0018\r]*feZ,'\u000f\u000b\u0002\u000e\u0007\u0006\u0011B/Z:u\u0013:4\u0018\r\\5e\u0007>tg-[4tQ\tq1)\u0001\tuKN$\b+\u0019:tK.+\u0017\u0010\u0015:pa\"\u0012qbQ\u0001\u001ci\u0016\u001cHOQ8piN$(/\u00199TKJ4XM](wKJ\u0014\u0018\u000eZ3)\u0005A\u0019\u0015\u0001\u0006;fgR\u001cE.[3oi&#wJ^3se&$W\r\u000b\u0002\u0012\u0007\u0006\u0019B/Z:u\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JI\"\u0012!c\u0011")
public class ConsoleProducerTest {
    private final String[] brokerListValidArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] bootstrapServerValidArgs = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1003,localhost:1004", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});
    private final String[] bootstrapServerOverride = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"});
    private final String[] clientIdOverride = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--topic", "t3", "--producer-property", "client.id=producer-1"});

    public String[] brokerListValidArgs() {
        return this.brokerListValidArgs;
    }

    public String[] bootstrapServerValidArgs() {
        return this.bootstrapServerValidArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    public String[] bootstrapServerOverride() {
        return this.bootstrapServerOverride;
    }

    public String[] clientIdOverride() {
        return this.clientIdOverride;
    }

    @Test
    public void testValidConfigsBrokerList() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1001", "localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testValidConfigsBootstrapServer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1003", "localhost:1004"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidConfigs() {
        void setExitProcedure_exitProcedure;
        Function2 & java.io.Serializable & Serializable intersect = (Function2 & java.io.Serializable & Serializable)(x$1, message) -> ConsoleProducerTest.$anonfun$testInvalidConfigs$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleProducer.ProducerConfig(this.invalidArgs()));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(string != null && string.equals(string2));
        Predef$.MODULE$.assert(reader.parseKey());
    }

    @Test
    public void testBootstrapServerOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testClientIdOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.clientIdOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"producer-1", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"console-producer", (Object)producerConfig.getString("client.id"));
    }

    public static final /* synthetic */ Nothing$ $anonfun$testInvalidConfigs$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

