/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tools.GetOffsetShell$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u000f\u001f\u0001\rBQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00036\u0011\u0019q\u0004\u0001)A\u0005m!)q\b\u0001C!\u0001\")Q\n\u0001C!\u001d\")A\r\u0001C\u0001K\")!\u000e\u0001C\u0001K\")A\u000e\u0001C\u0001K\")a\u000e\u0001C\u0001K\")\u0001\u000f\u0001C\u0001K\")!\u000f\u0001C\u0001K\")A\u000f\u0001C\u0001K\")a\u000f\u0001C\u0001K\")\u0001\u0010\u0001C\u0001K\")!\u0010\u0001C\u0001K\")A\u0010\u0001C\u0001K\")a\u0010\u0001C\u0001K\"1\u0011\u0011\u0001\u0001\u0005\u0002\u0015Dq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002D\u0001!I!a\u0002\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!\u001c\u0001\t\u0013\tyG\u0001\nHKR|eMZ:fiNCW\r\u001c7UKN$(BA\u0010!\u0003\u0015!xn\u001c7t\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#BA\u0014!\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005%2#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\u0002\u0013!B;uS2\u001c\u0018BA\u0018-\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001a\u0011\u0005M\u0002Q\"\u0001\u0010\u0002\u0015Q|\u0007/[2D_VtG/F\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\rIe\u000e^\u0001\fi>\u0004\u0018nY\"pk:$\b%A\rpM\u001a\u001cX\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\u0018AG8gMN,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\u0005\u00032AQ#H\u001b\u0005\u0019%B\u0001#9\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\r\u000e\u00131aU3r!\tA5*D\u0001J\u0015\tQ\u0005%\u0001\u0004tKJ4XM]\u0005\u0003\u0019&\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006)1/\u001a;VaR\u0011qJ\u0015\t\u0003oAK!!\u0015\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006'\u001e\u0001\r\u0001V\u0001\ti\u0016\u001cH/\u00138g_B\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\u0004CBL'BA-[\u0003\u001dQW\u000f]5uKJT!a\u0017/\u0002\u000b),h.\u001b;\u000b\u0003u\u000b1a\u001c:h\u0013\tyfK\u0001\u0005UKN$\u0018J\u001c4pQ\t9\u0011\r\u0005\u0002VE&\u00111M\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\u0005;fgRtuNR5mi\u0016\u0014x\n\u001d;j_:\u001cH#A()\u0005!9\u0007CA+i\u0013\tIgK\u0001\u0003UKN$\u0018\u0001\u0006;fgRLe\u000e^3s]\u0006dW\t_2mk\u0012,G\r\u000b\u0002\nO\u0006\u0001B/Z:u)>\u0004\u0018n\u0019(b[\u0016\f%o\u001a\u0015\u0003\u0015\u001d\f1\u0003^3tiR{\u0007/[2QCR$XM\u001d8Be\u001eD#aC4\u0002#Q,7\u000f\u001e)beRLG/[8og\u0006\u0013x\r\u000b\u0002\rO\u0006!C/Z:u)>\u0004\u0018n\u0019)biR,'O\\!sO^KG\u000f\u001b)beRLG/[8og\u0006\u0013x\r\u000b\u0002\u000eO\u00061B/Z:u)>\u0004\u0018n\u0019)beRLG/[8og\u0006\u0013x\r\u000b\u0002\u000fO\u0006QC/Z:u)>\u0004\u0018n\u0019)beRLG/[8og\u0006\u0013xmV5uQ&sG/\u001a:oC2,\u0005p\u00197vI\u0016$\u0007FA\bh\u00039\"Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8t\u001d>$hi\\;oI\u001a{'OT8o\u000bbL7\u000f^3oiR{\u0007/[2)\u0005A9\u0017a\r;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001chj\u001c;G_VtGMR8s\u000bb\u001cG.\u001e3fI&sG/\u001a:oC2$v\u000e]5dQ\t\tr-\u0001 uKN$Hk\u001c9jGB\u000b'\u000f^5uS>t7OT8u\r>,h\u000e\u001a$pe:{g.T1uG\"Lgn\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c)biR,'O\u001c\u0015\u0003%\u001d\fQ\u0006^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]N4E.Y4XSRDGk\u001c9jG\u001ac\u0017mZ\"bkN,W\t_5uQ\t\u0019r-\u0001\u001auKN$Hk\u001c9jGB\u000b'\u000f^5uS>t7O\u00127bO^KG\u000f\u001b)beRLG/[8og\u001ac\u0017mZ\"bkN,W\t_5uQ\t!r-A\u000efqB,7\r^3e\u001f\u001a47/\u001a;t/&$\b.\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003\u0013\u0001b!a\u0003\u0002\u001c\u0005\u0005b\u0002BA\u0007\u0003/qA!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\u0011\u0013A\u0002\u001fs_>$h(C\u0001:\u0013\r\tI\u0002O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\t1K7\u000f\u001e\u0006\u0004\u00033A\u0004\u0003C\u001c\u0002$\u0005\u001db'a\u000e\n\u0007\u0005\u0015\u0002H\u0001\u0004UkBdWm\r\t\u0005\u0003S\t\tD\u0004\u0003\u0002,\u00055\u0002cAA\bq%\u0019\u0011q\u0006\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019$!\u000e\u0003\rM#(/\u001b8h\u0015\r\ty\u0003\u000f\t\u0006o\u0005e\u0012QH\u0005\u0004\u0003wA$AB(qi&|g\u000eE\u00028\u0003\u007fI1!!\u00119\u0005\u0011auN\\4\u00021\u0015D\b/Z2uK\u0012$Vm\u001d;U_BL7m\u00144gg\u0016$8/A\ffqB,7\r^3e\u001f\u001a47/\u001a;t\r>\u0014Hk\u001c9jGR!\u0011\u0011BA%\u0011\u0019\tYe\u0006a\u0001m\u0005\t\u0011.A\u0005u_BL7MT1nKR!\u0011qEA)\u0011\u0019\tY\u0005\u0007a\u0001m\u0005\u0019\u0012m]:feR,\u00050\u001b;D_\u0012,\u0017j](oKR\u0019q*a\u0016\t\u000f\u0005e\u0013\u00041\u0001\u0002\\\u0005!\u0011M]4t!\u00159\u0014QLA\u0014\u0013\r\ty\u0006\u000f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0010Kb,7-\u001e;f\u0003:$\u0007+\u0019:tKR!\u0011\u0011BA3\u0011\u001d\tIF\u0007a\u0001\u00037\nA#\u001a=fGV$X-\u00118e\u000fJ\f'mT;uaV$H\u0003BA\u0014\u0003WBq!!\u0017\u001c\u0001\u0004\tY&\u0001\nbI\u0012\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u0014H\u0003BA.\u0003cBq!!\u0017\u001d\u0001\u0004\tY\u0006")
public class GetOffsetShellTest
extends KafkaServerTestHarness {
    private final int topicCount;
    private final int offsetTopicPartitionCount;

    private int topicCount() {
        return this.topicCount;
    }

    private int offsetTopicPartitionCount() {
        return this.offsetTopicPartitionCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)p -> {
            p.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), BoxesRunTime.boxToInteger((int)this.offsetTopicPartitionCount()));
            return p;
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach((Function1 & Serializable & scala.Serializable)i -> this.createTopic(this.topicName(BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.unboxToInt((Object)i), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5()));
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        KafkaProducer producer = new KafkaProducer(props);
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> package$.MODULE$.Range().apply(0, i * i).foreach((Function1 & Serializable & scala.Serializable)msgCount -> producer.send(new ProducerRecord(this.topicName(i), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)msgCount) % i), null, (Object)new StringBuilder(3).append("val").append(BoxesRunTime.unboxToInt((Object)msgCount)).toString()))));
        producer.close();
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testNoFilterOptions() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals(this.expectedOffsetsWithInternal(), offsets);
    }

    @Test
    public void testInternalExcluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--exclude-internal-topics"}));
        Assertions.assertEquals(this.expectedTestTopicOffsets(), offsets);
    }

    @Test
    public void testTopicNameArg() {
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic", this.topicName(i)}));
            Assertions.assertEquals(this.expectedOffsetsForTopic(i), offsets, () -> new StringBuilder(32).append("Offset output did not match for ").append(this.topicName(i)).toString());
        });
    }

    @Test
    public void testTopicPatternArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic", "topic.*"}));
        Assertions.assertEquals(this.expectedTestTopicOffsets(), offsets);
    }

    @Test
    public void testPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--partitions", "0,1"}));
        Assertions.assertEquals((Object)this.expectedOffsetsWithInternal().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$testPartitionsArg$1(x0$1))), offsets);
    }

    @Test
    public void testTopicPatternArgWithPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic", "topic.*", "--partitions", "0,1"}));
        Assertions.assertEquals((Object)this.expectedTestTopicOffsets().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$testTopicPatternArgWithPartitionsArg$1(x0$1))), offsets);
    }

    @Test
    public void testTopicPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic-partitions", "topic1:0,topic2:1,topic(3|4):2,__.*:3"}));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), (List)new .colon.colon((Object)new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), (List)new .colon.colon((Object)new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), (List)new .colon.colon((Object)new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (List)new .colon.colon((Object)new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4))), (List)Nil$.MODULE$))))), offsets);
    }

    @Test
    public void testTopicPartitionsArgWithInternalExcluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic-partitions", "topic1:0,topic2:1,topic(3|4):2,__.*:3", "--exclude-internal-topics"}));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), (List)new .colon.colon((Object)new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), (List)new .colon.colon((Object)new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (List)new .colon.colon((Object)new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4))), (List)Nil$.MODULE$)))), offsets);
    }

    @Test
    public void testTopicPartitionsNotFoundForNonExistentTopic() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic", "some_nonexistent_topic"}));
    }

    @Test
    public void testTopicPartitionsNotFoundForExcludedInternalTopic() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic", "some_nonexistent_topic:*"}));
    }

    @Test
    public void testTopicPartitionsNotFoundForNonMatchingTopicPartitionPattern() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic-partitions", "__consumer_offsets", "--exclude-internal-topics"}));
    }

    @Test
    public void testTopicPartitionsFlagWithTopicFlagCauseExit() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic-partitions", "__consumer_offsets", "--topic", "topic1"}));
    }

    @Test
    public void testTopicPartitionsFlagWithPartitionsFlagCauseExit() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic-partitions", "__consumer_offsets", "--partitions", "0"}));
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedOffsetsWithInternal() {
        return (List)((TraversableOnce)package$.MODULE$.Range().apply(0, this.offsetTopicPartitionCount()).map((Function1 & Serializable & scala.Serializable)i -> GetOffsetShellTest.$anonfun$expectedOffsetsWithInternal$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList().$plus$plus(this.expectedTestTopicOffsets(), List$.MODULE$.canBuildFrom());
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedTestTopicOffsets() {
        return ((TraversableOnce)package$.MODULE$.Range().apply(1, this.topicCount() + 1).flatMap((Function1 & Serializable & scala.Serializable)i -> this.expectedOffsetsForTopic(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedOffsetsForTopic(int i) {
        String name = this.topicName(i);
        return ((TraversableOnce)package$.MODULE$.Range().apply(0, i).map((Function1 & Serializable & scala.Serializable)p -> GetOffsetShellTest.$anonfun$expectedOffsetsForTopic$1(name, i, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
    }

    private String topicName(int i) {
        return new StringBuilder(5).append("topic").append(i).toString();
    }

    /*
     * WARNING - void declaration
     */
    private void assertExitCodeIsOne(String[] args) {
        void setExitProcedure_exitProcedure;
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> GetOffsetShellTest.$anonfun$assertExitCodeIsOne$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            try {
                GetOffsetShell$.MODULE$.main(this.addBootstrapServer(args));
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    private List<Tuple3<String, Object, Option<Object>>> executeAndParse(String[] args) {
        String output = this.executeAndGrabOutput(args);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.split(System.lineSeparator()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$executeAndParse$2(x$3))))).map((Function1 & Serializable & scala.Serializable)line -> {
            String topic = line[0];
            int partition = new StringOps(Predef$.MODULE$.augmentString(line[1])).toInt();
            None$ timestamp = ((String[])line).length == 2 || line[2].isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(line[2])).toLong()));
            return new Tuple3((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partition), (Object)timestamp);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).toList();
    }

    /*
     * WARNING - void declaration
     */
    private String executeAndGrabOutput(String[] args) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> GetOffsetShell$.MODULE$.main(this.addBootstrapServer(args));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private String[] addBootstrapServer(String[] args) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.brokerList()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionsArg$1(Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToInt((Object)x0$1._2()) <= 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicPatternArgWithPartitionsArg$1(Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToInt((Object)x0$1._2()) <= 1;
        return bl;
    }

    public static final /* synthetic */ Tuple3 $anonfun$expectedOffsetsWithInternal$1(int i) {
        return new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)i), (Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    public static final /* synthetic */ Tuple3 $anonfun$expectedOffsetsForTopic$1(String name$1, int i$3, int p) {
        return new Tuple3((Object)name$1, (Object)BoxesRunTime.boxToInteger((int)p), (Object)new Some((Object)BoxesRunTime.boxToLong((long)i$3)));
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertExitCodeIsOne$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$executeAndParse$2(String[] x$3) {
        return x$3.length >= 2;
    }

    public GetOffsetShellTest() {
        this.topicCount = 4;
        this.offsetTopicPartitionCount = 4;
    }
}

