/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogConfig;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogSegments$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class UnifiedLog$
implements Logging {
    public static UnifiedLog$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String ProducerSnapshotFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final long UnknownOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new UnifiedLog$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return this.ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public UnifiedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile) {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        Option<LeaderEpochFileCache> leaderEpochCache = this.maybeCreateLeaderEpochCache(dir, topicPartition, logDirFailureChannel, config.recordVersion(), new StringBuilder(30).append("[UnifiedLog partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs, ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(dir, topicPartition, config, scheduler, time, logDirFailureChannel, lastShutdownClean, segments, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), scheduler, time, topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset(), localLog, brokerTopicStats, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager, topicId, keepPartitionMetadataFile);
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public boolean apply$default$11() {
        return true;
    }

    public File logFile(File dir, long offset, String suffix) {
        return LocalLog$.MODULE$.logFile(dir, offset, suffix);
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDeleteDirName(topicPartition);
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logFutureDirName(topicPartition);
    }

    public String logDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDirName(topicPartition);
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return LocalLog$.MODULE$.offsetIndexFile(dir, offset, suffix);
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return LocalLog$.MODULE$.timeIndexFile(dir, offset, suffix);
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset) {
        return new File(dir, new StringBuilder(0).append(LocalLog$.MODULE$.filenamePrefixFromOffset(offset)).append(this.ProducerSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return LocalLog$.MODULE$.transactionIndexFile(dir, offset, suffix);
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        return LocalLog$.MODULE$.offsetFromFileName(filename);
    }

    public long offsetFromFile(File file) {
        return LocalLog$.MODULE$.offsetFromFile(file);
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return LogSegments$.MODULE$.sizeInBytes(segments);
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        return LocalLog$.MODULE$.parseTopicPartitionName(dir);
    }

    public boolean isIndexFile(File file) {
        return LocalLog$.MODULE$.isIndexFile(file);
    }

    public boolean isLogFile(File file) {
        return LocalLog$.MODULE$.isLogFile(file);
    }

    private void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records) {
        Map loadedProducers = Map$.MODULE$.empty();
        ListBuffer completedTxns = (ListBuffer)ListBuffer$.MODULE$.empty();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                MODULE$.kafka$log$UnifiedLog$$updateProducers(producerStateManager, (RecordBatch)batch, (Map<Object, ProducerAppendInfo>)loadedProducers, (Option<LogOffsetMetadata>)None$.MODULE$, AppendOrigin$Replication$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)x$28 -> completedTxns.$plus$eq(x$28));
            }
        });
        loadedProducers.values().foreach((Function1 & Serializable & scala.Serializable)appendInfo -> {
            producerStateManager.update(appendInfo);
            return BoxedUnit.UNIT;
        });
        completedTxns.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            producerStateManager.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CompletedTxn> kafka$log$UnifiedLog$$updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Object, ProducerAppendInfo> producers, Option<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin) {
        long producerId = batch.producerId();
        return ((ProducerAppendInfo)producers.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> producerStateManager.prepareUpdate(producerId, origin))).append(batch, firstOffsetMetadata);
    }

    public Option<LeaderEpochFileCache> maybeCreateLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, RecordVersion recordVersion, String logPrefix) {
        File leaderEpochFile = LeaderEpochCheckpointFile$.MODULE$.newFile(dir);
        if (recordVersion.precedes(RecordVersion.V2)) {
            if ((leaderEpochFile.exists() ? new Some((Object)UnifiedLog$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition)) : None$.MODULE$).exists((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.nonEmpty())) && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(UnifiedLog$.$anonfun$maybeCreateLeaderEpochCache$2(logPrefix, recordVersion)));
            }
            Files.deleteIfExists(leaderEpochFile.toPath());
            return None$.MODULE$;
        }
        return new Some((Object)UnifiedLog$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition));
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        return LocalLog$.MODULE$.replaceSegments(existingSegments, newSegments, oldSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, isRecoveredSwapFile);
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        LocalLog$.MODULE$.deleteSegmentFiles(segmentsToDelete, asyncDelete, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, RecordVersion recordVersion, Time time, boolean reloadFromCleanShutdown, String logPrefix) {
        .colon.colon offsetsToSnapshot;
        .colon.colon colon2;
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = ((LogSegment)segments.lastSegment().get()).baseOffset();
            Option nextLatestSegmentBaseOffset = segments.lowerSegment(lastSegmentBaseOffset).map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToLong((long)x$30.baseOffset()));
            colon2 = new .colon.colon((Object)nextLatestSegmentBaseOffset, (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastSegmentBaseOffset)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$)));
        } else {
            colon2 = offsetsToSnapshot = new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(UnifiedLog$.$anonfun$rebuildProducerState$2(logPrefix, lastOffset, recordVersion)));
        }
        if (recordVersion.value < 2 || producerStateManager.latestSnapshotOffset().isEmpty() && reloadFromCleanShutdown) {
            ((IterableLike)offsetsToSnapshot.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> {
                producerStateManager.updateMapEndOffset(offset);
                producerStateManager.takeSnapshot();
            });
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(UnifiedLog$.$anonfun$rebuildProducerState$5(logPrefix, lastOffset)));
        }
        boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
        long producerStateLoadStart = time.milliseconds();
        producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
        long segmentRecoveryStart = time.milliseconds();
        if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
            Option<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
            segments.values(producerStateManager.mapEndOffset(), lastOffset).foreach(arg_0 -> UnifiedLog$.$anonfun$rebuildProducerState$6$adapted(producerStateManager, logStartOffset, (Seq)offsetsToSnapshot, segmentOfLastOffset, lastOffset, arg_0));
        }
        producerStateManager.updateMapEndOffset(lastOffset);
        producerStateManager.takeSnapshot();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(UnifiedLog$.$anonfun$rebuildProducerState$9(logPrefix, segmentRecoveryStart, producerStateLoadStart, time, lastOffset)));
            return;
        }
    }

    public SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        return LocalLog$.MODULE$.splitOverflowedSegment(segment, existingSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void deleteProducerSnapshots(Iterable<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition) {
        Iterable snapshotsToDelete = (Iterable)segments.flatMap((Function1 & Serializable & scala.Serializable)segment -> Option$.MODULE$.option2Iterable(producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset())), Iterable$.MODULE$.canBuildFrom());
        if (asyncDelete) {
            scheduler.schedule("delete-producer-snapshot", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> UnifiedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete), Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()), scheduler.schedule$default$4(), scheduler.schedule$default$5());
            return;
        }
        UnifiedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        return LocalLog$.MODULE$.createNewCleanedSegment(dir, logConfig, baseOffset);
    }

    private static final LeaderEpochFileCache newLeaderEpochFileCache$1(File leaderEpochFile$1, LogDirFailureChannel logDirFailureChannel$1, TopicPartition topicPartition$1) {
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile$1, logDirFailureChannel$1);
        return new LeaderEpochFileCache(topicPartition$1, checkpointFile);
    }

    public static final /* synthetic */ String $anonfun$maybeCreateLeaderEpochCache$2(String logPrefix$1, RecordVersion recordVersion$1) {
        return new StringBuilder(73).append(logPrefix$1).append("Deleting non-empty leader epoch cache due to incompatible message format ").append(recordVersion$1).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$2(String logPrefix$2, long lastOffset$2, RecordVersion recordVersion$2) {
        return new StringBuilder(64).append(logPrefix$2).append("Loading producer state till offset ").append(lastOffset$2).append(" with message format version ").append(recordVersion$2.value).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$5(String logPrefix$2, long lastOffset$2) {
        return new StringBuilder(75).append(logPrefix$2).append("Reloading from producer snapshot and rebuilding producer state from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ void $anonfun$rebuildProducerState$6(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        int maxPosition;
        FetchDataInfo fetchDataInfo;
        long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager$3.mapEndOffset(), logStartOffset$1});
        producerStateManager$3.updateMapEndOffset(startOffset);
        if (offsetsToSnapshot$1.contains((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment.baseOffset())))) {
            producerStateManager$3.takeSnapshot();
        }
        if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition = segmentOfLastOffset$1.contains((Object)segment) ? BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)segment.translateOffset(lastOffset$2, segment.translateOffset$default$2())).map((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToInteger((int)x$31.position)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> segment.size())) : segment.size(), segment.read$default$4())) != null) {
            MODULE$.loadProducersFromRecords(producerStateManager$3, fetchDataInfo.records());
        }
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$9(String logPrefix$2, long segmentRecoveryStart$1, long producerStateLoadStart$1, Time time$1, long lastOffset$2) {
        return new StringBuilder(90).append(logPrefix$2).append("Producer state recovery took ").append(segmentRecoveryStart$1 - producerStateLoadStart$1).append("ms for snapshot load ").append("and ").append(time$1.milliseconds() - segmentRecoveryStart$1).append("ms for segment recovery from offset ").append(lastOffset$2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final void deleteProducerSnapshots$1(LogDirFailureChannel logDirFailureChannel$2, String parentDir$1, TopicPartition topicPartition$2, Iterable snapshotsToDelete$1) {
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Error while deleting producer state snapshots for ").append(topicPartition$2).append(" in dir ").append(parentDir$1).toString();
        if (LocalLog$.MODULE$ == null) {
            throw null;
        }
        if (logDirFailureChannel$2.hasOfflineLogDir(parentDir$1)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir$1).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            snapshotsToDelete$1.foreach((Function1 & Serializable & scala.Serializable)snapshot -> BoxesRunTime.boxToBoolean((boolean)snapshot.deleteIfExists()));
            return;
        }
        catch (IOException maybeHandleIOException_e) {
            void maybeHandleIOException_errorMsg;
            logDirFailureChannel$2.maybeAddOfflineLogDir(parentDir$1, (Function0<String>)maybeHandleIOException_errorMsg, maybeHandleIOException_e);
            throw new KafkaStorageException(UnifiedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), (Throwable)maybeHandleIOException_e);
        }
    }

    private UnifiedLog$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.LogFileSuffix = LocalLog$.MODULE$.LogFileSuffix();
        this.IndexFileSuffix = LocalLog$.MODULE$.IndexFileSuffix();
        this.TimeIndexFileSuffix = LocalLog$.MODULE$.TimeIndexFileSuffix();
        this.ProducerSnapshotFileSuffix = ".snapshot";
        this.TxnIndexFileSuffix = LocalLog$.MODULE$.TxnIndexFileSuffix();
        this.DeletedFileSuffix = LocalLog$.MODULE$.DeletedFileSuffix();
        this.CleanedFileSuffix = LocalLog$.MODULE$.CleanedFileSuffix();
        this.SwapFileSuffix = LocalLog$.MODULE$.SwapFileSuffix();
        this.DeleteDirSuffix = LocalLog$.MODULE$.DeleteDirSuffix();
        this.FutureDirSuffix = LocalLog$.MODULE$.FutureDirSuffix();
        this.DeleteDirPattern = LocalLog$.MODULE$.DeleteDirPattern();
        this.FutureDirPattern = LocalLog$.MODULE$.FutureDirPattern();
        this.UnknownOffset = LocalLog$.MODULE$.UnknownOffset();
    }

    public static final /* synthetic */ Object $anonfun$rebuildProducerState$6$adapted(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        UnifiedLog$.$anonfun$rebuildProducerState$6(producerStateManager$3, logStartOffset$1, offsetsToSnapshot$1, segmentOfLastOffset$1, lastOffset$2, segment);
        return BoxedUnit.UNIT;
    }
}

