/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\u000e\u001c\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)!\t\u0001C\u0001\u0007\"9\u0001\n\u0001b\u0001\n\u0013I\u0005B\u0002,\u0001A\u0003%!\nC\u0004X\u0001\t\u0007I\u0011\u0002-\t\r\r\u0004\u0001\u0015!\u0003Z\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015!\u0007\u0001\"\u0003p\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015I\b\u0001\"\u0003{\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA&\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u001b\u0002A\u0011AA\u001f\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u00111\u000f\u0001\u0005\u0002\u0005E\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003s\u0002A\u0011BA9\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK*\u0011A$H\u0001\u0006KB|7\r\u001b\u0006\u0003=}\taa]3sm\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQS&D\u0001,\u0015\tas$A\u0003vi&d7/\u0003\u0002/W\t9Aj\\4hS:<\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003cej\u0011A\r\u0006\u0003gQ\naaY8n[>t'B\u0001\u00116\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\u0012$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000bG\",7m\u001b9pS:$\bCA\u001fA\u001b\u0005q$BA \u001e\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\u0005\u0005s$!\u0006'fC\u0012,'/\u00129pG\"\u001c\u0005.Z2la>Lg\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00113u\t\u0005\u0002F\u00015\t1\u0004C\u00030\u0007\u0001\u0007\u0001\u0007C\u0003<\u0007\u0001\u0007A(\u0001\u0003m_\u000e\\W#\u0001&\u0011\u0005-#V\"\u0001'\u000b\u00055s\u0015!\u00027pG.\u001c(BA(Q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003#J\u000bA!\u001e;jY*\t1+\u0001\u0003kCZ\f\u0017BA+M\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017!\u00027pG.\u0004\u0013AB3q_\u000eD7/F\u0001Z!\u0011Q6,\u00181\u000e\u0003AK!\u0001\u0018)\u0003\u000fQ\u0013X-Z'baB\u0011AEX\u0005\u0003?\u0016\u00121!\u00138u!\t)\u0015-\u0003\u0002c7\tQQ\t]8dQ\u0016sGO]=\u0002\u000f\u0015\u0004xn\u00195tA\u00051\u0011m]:jO:$2AZ5k!\t!s-\u0003\u0002iK\t!QK\\5u\u0011\u0015a\u0002\u00021\u0001^\u0011\u0015Y\u0007\u00021\u0001m\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0011\u0005\u0011j\u0017B\u00018&\u0005\u0011auN\\4\u0015\u0005A\u001c\bC\u0001\u0013r\u0013\t\u0011XEA\u0004C_>dW-\u00198\t\u000bQL\u0001\u0019\u00011\u0002\u000b\u0015tGO]=\u0002A5\f\u0017PY3UeVt7-\u0019;f\u001d>tWj\u001c8pi>t\u0017nY#oiJLWm\u001d\u000b\u0003M^DQ\u0001\u001f\u0006A\u0002\u0001\f\u0001B\\3x\u000b:$(/_\u0001\u000ee\u0016lwN^3Ge>lWI\u001c3\u0015\u0007m\f\u0019\u0001E\u0002}\u007f\u0002l\u0011! \u0006\u0003}\u0016\n!bY8mY\u0016\u001cG/[8o\u0013\r\t\t! \u0002\u0004'\u0016\f\bbBA\u0003\u0017\u0001\u0007\u0011qA\u0001\naJ,G-[2bi\u0016\u0004R\u0001JA\u0005ABL1!a\u0003&\u0005%1UO\\2uS>t\u0017'A\bsK6|g/\u001a$s_6\u001cF/\u0019:u)\rY\u0018\u0011\u0003\u0005\b\u0003\u000ba\u0001\u0019AA\u0004\u0003M\u0011X-\\8wK^C\u0017\u000e\\3NCR\u001c\u0007.\u001b8h)\u0015Y\u0018qCA\u001b\u0011\u001d\tI\"\u0004a\u0001\u00037\t\u0001\"\u001b;fe\u0006$xN\u001d\t\u00065\u0006u\u0011\u0011E\u0005\u0004\u0003?\u0001&\u0001C%uKJ\fGo\u001c:\u0011\r\u0005\r\u0012qF/a\u001d\u0011\t)#a\u000b\u000f\t\u0005\u001d\u0012\u0011F\u0007\u0002%&\u0011\u0011KU\u0005\u0004\u0003[\u0001\u0016aA'ba&!\u0011\u0011GA\u001a\u0005\u0015)e\u000e\u001e:z\u0015\r\ti\u0003\u0015\u0005\b\u0003\u000bi\u0001\u0019AA\u0004\u0003!qwN\\#naRLX#\u00019\u0002\u00171\fG/Z:u\u000b:$(/_\u000b\u0003\u0003\u007f\u0001B\u0001JA!A&\u0019\u00111I\u0013\u0003\r=\u0003H/[8o\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0016\u0005\u0005%\u0003\u0003\u0002\u0013\u0002Bu\u000bQ\u0002\u001d:fm&|Wo]#q_\u000eD\u0017!D3be2LWm\u001d;F]R\u0014\u00180\u0001\u0007f]\u0012|eMZ:fi\u001a{'\u000f\u0006\u0004\u0002T\u0005e\u0013Q\f\t\u0006I\u0005US\f\\\u0005\u0004\u0003/*#A\u0002+va2,'\u0007\u0003\u0004\u0002\\M\u0001\r!X\u0001\u000fe\u0016\fX/Z:uK\u0012,\u0005o\\2i\u0011\u0019\tyf\u0005a\u0001Y\u0006aAn\\4F]\u0012|eMZ:fi\u0006yAO];oG\u0006$XM\u0012:p[\u0016sG\rF\u0002g\u0003KBa!a\u001a\u0015\u0001\u0004a\u0017!C3oI>3gm]3u\u0003E!(/\u001e8dCR,gI]8n'R\f'\u000f\u001e\u000b\u0004M\u00065\u0004\"B6\u0016\u0001\u0004a\u0017!D2mK\u0006\u0014\u0018I\u001c3GYV\u001c\b\u000eF\u0001g\u0003\u0015\u0019G.Z1s\u00031)\u0007o\\2i\u000b:$(/[3t+\u0005Y\u0018!\u00024mkND\u0007")
public class LeaderEpochFileCache
implements Logging {
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private final TreeMap<Object, EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private TreeMap<Object, EpochEntry> epochs() {
        return this.epochs;
    }

    public void assign(int epoch, long startOffset) {
        EpochEntry entry = new EpochEntry(epoch, startOffset);
        if (this.assign(entry)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entry).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
            this.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean assign(EpochEntry entry) {
        boolean bl;
        void inWriteLock_lock;
        if (entry.epoch() < 0 || entry.startOffset() < 0L) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        if (!this.isUpdateNeeded$1(entry)) {
            return false;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$assign$2(this, entry);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void maybeTruncateNonMonotonicEntries(EpochEntry newEntry) {
        void var3_3;
        EpochEntry removeFromEnd_removeWhileMatching_entry;
        EpochEntry epochEntry;
        Iterator removeFromEnd_removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry, epochEntry = (removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue()))) {
            removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
            removeFromEnd_removeWhileMatching_iterator.remove();
        }
        if (var3_3.size() > 1 || var3_3.nonEmpty() && ((EpochEntry)var3_3.head()).startOffset() != newEntry.startOffset()) {
            this.warn((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$2(this, newEntry, (Seq)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromEnd(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        Iterator removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = (EpochEntry)removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromStart(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        Iterator<Map.Entry<Object, EpochEntry>> removeWhileMatching_iterator = this.epochs().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeWhileMatching(Iterator<Map.Entry<Object, EpochEntry>> iterator, Function1<EpochEntry, Object> predicate) {
        void var3_3;
        ListBuffer removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (iterator.hasNext()) {
            EpochEntry entry = iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)entry))) {
                removedEpochs.$plus$eq((Object)entry);
                iterator.remove();
                continue;
            }
            return removedEpochs;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean nonEmpty() {
        boolean bl;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$nonEmpty$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> latestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$latestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<Object> latestEpoch() {
        return this.latestEntry().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch()));
    }

    /*
     * WARNING - void declaration
     */
    public Option<Object> previousEpoch() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$previousEpoch$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> earliestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$earliestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch, long logEndOffset) {
        Tuple2 tuple2;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            tuple2 = LeaderEpochFileCache.$anonfun$endOffsetFor$1(this, requestedEpoch, logEndOffset);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromEnd(long endOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromEnd$1(this, endOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromStart(long startOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromStart$1(this, startOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clearAndFlush() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clearAndFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clear() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clear$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Seq<EpochEntry> epochEntries() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.epochs().values()).asScala()).toSeq();
    }

    private void flush() {
        this.checkpoint.write((Iterable<EpochEntry>)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.epochs().values()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$new$1(LeaderEpochFileCache $this) {
        $this.checkpoint.read().foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)$this.assign(entry)));
    }

    private final boolean isUpdateNeeded$1(EpochEntry entry$2) {
        boolean bl;
        Option<EpochEntry> option = this.latestEntry();
        if (option instanceof Some) {
            EpochEntry lastEntry = (EpochEntry)((Some)option).value();
            bl = entry$2.epoch() != lastEntry.epoch() || entry$2.startOffset() < lastEntry.startOffset();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$assign$2(LeaderEpochFileCache $this, EpochEntry entry$2) {
        if ($this.isUpdateNeeded$1(entry$2)) {
            $this.maybeTruncateNonMonotonicEntries(entry$2);
            $this.epochs().put(BoxesRunTime.boxToInteger((int)entry$2.epoch()), entry$2);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateNonMonotonicEntries$1(EpochEntry newEntry$1, EpochEntry entry) {
        return entry.epoch() >= newEntry$1.epoch() || entry.startOffset() >= newEntry$1.startOffset();
    }

    public static final /* synthetic */ String $anonfun$maybeTruncateNonMonotonicEntries$2(LeaderEpochFileCache $this, EpochEntry newEntry$1, Seq removedEpochs$1) {
        return new StringBuilder(88).append("New epoch entry ").append(newEntry$1).append(" caused truncation of conflicting entries ").append(removedEpochs$1).append(". ").append("Cache now contains ").append($this.epochs().size()).append(" entries.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$nonEmpty$1(LeaderEpochFileCache $this) {
        return !$this.epochs().isEmpty();
    }

    public static final /* synthetic */ Option $anonfun$latestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$1 -> (EpochEntry)x$1.getValue());
    }

    public static final /* synthetic */ int $anonfun$previousEpoch$3(Map.Entry x$3) {
        return BoxesRunTime.unboxToInt(x$3.getKey());
    }

    public static final /* synthetic */ Option $anonfun$previousEpoch$1(LeaderEpochFileCache $this) {
        return $this.latestEntry().flatMap((Function1 & Serializable & scala.Serializable)entry -> Option$.MODULE$.apply($this.epochs().lowerEntry(BoxesRunTime.boxToInteger((int)entry.epoch())))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)LeaderEpochFileCache.$anonfun$previousEpoch$3(x$3)));
    }

    public static final /* synthetic */ Option $anonfun$earliestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> (EpochEntry)x$4.getValue());
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$2(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$endOffsetFor$1(LeaderEpochFileCache $this, int requestedEpoch$1, long logEndOffset$1) {
        Map.Entry<Object, EpochEntry> floorEntry;
        Map.Entry<Object, EpochEntry> higherEntry;
        Tuple2.mcIJ.sp epochAndOffset = requestedEpoch$1 == -1 ? new Tuple2.mcIJ.sp(-1, -1L) : ($this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch$1)) ? new Tuple2.mcIJ.sp(requestedEpoch$1, logEndOffset$1) : ((higherEntry = $this.epochs().higherEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(-1, -1L) : ((floorEntry = $this.epochs().floorEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(requestedEpoch$1, higherEntry.getValue().startOffset()) : new Tuple2.mcIJ.sp(floorEntry.getValue().epoch(), higherEntry.getValue().startOffset()))));
        $this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$2($this, requestedEpoch$1, (Tuple2)epochAndOffset)));
        return epochAndOffset;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$5) {
        return x$5.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$6) {
        return x$6.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$truncateFromEnd$4(LeaderEpochFileCache $this, Seq removedEntries$1, long endOffset$1) {
        return new StringBuilder(97).append("Cleared entries ").append(removedEntries$1).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset$1).append(", leaving ").append($this.epochs().size()).append(" entries in the cache.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromEnd$1(LeaderEpochFileCache $this, long endOffset$1) {
        if (endOffset$1 >= 0L && $this.latestEntry().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, x$5)))) {
            void var4_3;
            EpochEntry removeFromEnd_removeWhileMatching_entry;
            EpochEntry epochEntry;
            Iterator removeFromEnd_removeWhileMatching_iterator = $this.epochs().descendingMap().entrySet().iterator();
            ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
            while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, epochEntry = (removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue()))) {
                removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
                removeFromEnd_removeWhileMatching_iterator.remove();
            }
            $this.flush();
            $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$truncateFromEnd$4($this, (Seq)var4_3, endOffset$1)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$1, EpochEntry entry) {
        return entry.startOffset() <= startOffset$1;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$1);
        $this.epochs().put(BoxesRunTime.boxToInteger((int)updatedFirstEntry.epoch()), updatedFirstEntry);
        $this.flush();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(removedEntries$2).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$1).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromStart$1(LeaderEpochFileCache $this, long startOffset$1) {
        void var4_3;
        EpochEntry removeFromStart_removeWhileMatching_entry;
        EpochEntry epochEntry;
        Iterator<Map.Entry<Object, EpochEntry>> removeFromStart_removeWhileMatching_iterator = $this.epochs().entrySet().iterator();
        ListBuffer removeFromStart_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeFromStart_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, epochEntry = (removeFromStart_removeWhileMatching_entry = removeFromStart_removeWhileMatching_iterator.next().getValue()))) {
            removeFromStart_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromStart_removeWhileMatching_entry);
            removeFromStart_removeWhileMatching_iterator.remove();
        }
        var4_3.lastOption().foreach(arg_0 -> LeaderEpochFileCache.$anonfun$truncateFromStart$3$adapted($this, startOffset$1, (Seq)var4_3, arg_0));
    }

    public static final /* synthetic */ void $anonfun$clearAndFlush$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.flush();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
    }

    /*
     * WARNING - void declaration
     */
    public LeaderEpochFileCache(TopicPartition topicPartition, LeaderEpochCheckpoint checkpoint) {
        void inWriteLock_lock;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = new TreeMap();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$new$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ Object $anonfun$maybeTruncateNonMonotonicEntries$1$adapted(EpochEntry newEntry$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$3$adapted(long endOffset$1, EpochEntry x$6) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, x$6));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$2$adapted(long startOffset$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$3$adapted(LeaderEpochFileCache $this, long startOffset$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$1, removedEntries$2, firstBeforeStartOffset);
        return BoxedUnit.UNIT;
    }
}

