/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.TransactionalIdNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0019\u0005\u0001)A\u0005{!9A\t\u0001b\u0001\n\u0003a\u0004BB#\u0001A\u0003%Q\bC\u0004G\u0001\t\u0007I\u0011A$\t\rM\u0003\u0001\u0015!\u0003I\u0011\u001d!\u0006A1A\u0005\u0002UCa\u0001\u0018\u0001!\u0002\u00131\u0006\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0001_\u0011%a\u0007\u00011AA\u0002\u0013\u0005Q\u000eC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005?\"IA\u000f\u0001a\u0001\u0002\u0004%\t!\u001e\u0005\nw\u0002\u0001\r\u00111A\u0005\u0002qD\u0011B \u0001A\u0002\u0003\u0005\u000b\u0015\u0002<\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0003\t\t\u0001C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\u0002\u0005=\u0001bCA\n\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002r\u0002!I!!\u0016\t\u000f\u0005M\b\u0001\"\u0003\u0002v\nA\u0002K]8ek\u000e,'/\u00133FqBL'/\u0019;j_:$Vm\u001d;\u000b\u0005\u0005\u0012\u0013aA1qS*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#BA\u0015#\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005-B#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005\u0001\u0013A\u0002;pa&\u001c\u0017'F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003mC:<'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u00121!\u00138u\u00039qW/\u001c)beRLG/[8og\u0002\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003I\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u0007Q\u0004\b'F\u0001I!\tI\u0015+D\u0001K\u0015\tYE*\u0001\u0004d_6lwN\u001c\u0006\u0003G5S!AT(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0016aA8sO&\u0011!K\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0011!\b\u000f\r\u0011\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z\u0015\u000611m\u001c8gS\u001eL!a\u0017-\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\u0006y1m\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007%\u0001\u0005qe>$WoY3s+\u0005y\u0006\u0003\u00021eM\u001al\u0011!\u0019\u0006\u0003;\nT!a\u0019'\u0002\u000f\rd\u0017.\u001a8ug&\u0011Q-\u0019\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0007y:\u0017.\u0003\u0002i\u007f\t)\u0011I\u001d:bsB\u0011aH[\u0005\u0003W~\u0012AAQ=uK\u0006a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u0011a.\u001d\t\u0003}=L!\u0001] \u0003\tUs\u0017\u000e\u001e\u0005\be6\t\t\u00111\u0001`\u0003\rAH%M\u0001\naJ|G-^2fe\u0002\n\u0001bY8ogVlWM]\u000b\u0002mB!q/\u001f4g\u001b\u0005A(B\u0001;c\u0013\tQ\bPA\u0007LC\u001a\\\u0017mQ8ogVlWM]\u0001\rG>t7/^7fe~#S-\u001d\u000b\u0003]vDqA\u001d\t\u0002\u0002\u0003\u0007a/A\u0005d_:\u001cX/\\3sA\u0005)\u0011\rZ7j]V\u0011\u00111\u0001\t\u0005\u0003\u000b\tI!\u0004\u0002\u0002\b)\u0011qPY\u0005\u0005\u0003\u0017\t9AA\u0003BI6Lg.A\u0005bI6Lgn\u0018\u0013fcR\u0019a.!\u0005\t\u0011I\u001c\u0012\u0011!a\u0001\u0003\u0007\ta!\u00193nS:\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0005\u0005e\u0001CBA\u000e\u0003C\t)#\u0004\u0002\u0002\u001e)\u0019\u0011qD \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002$\u0005u!aA*fcB!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\t\naa]3sm\u0016\u0014\u0018\u0002BA\u0018\u0003S\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006)1/\u001a;VaR\u0019a.!\u000e\t\u000f\u0005]b\u00031\u0001\u0002:\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002<\u0005\u001dSBAA\u001f\u0015\r\t\u0013q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0015s*A\u0003kk:LG/\u0003\u0003\u0002J\u0005u\"\u0001\u0003+fgRLeNZ8)\u0007Y\ti\u0005\u0005\u0003\u0002<\u0005=\u0013\u0002BA)\u0003{\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u00018)\u0007]\tI\u0006\u0005\u0003\u0002<\u0005m\u0013\u0002BA/\u0003{\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002UQ,7\u000f\u001e)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|gnV5uQ:{GK]1og\u0006\u001cG/[8ogR\u0019a.a\u0019\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002h\u00051\u0011/^8sk6\u0004B!!\u001b\u0002x9!\u00111NA:!\r\tigP\u0007\u0003\u0003_R1!!\u001d%\u0003\u0019a$o\\8u}%\u0019\u0011QO \u0002\rA\u0013X\rZ3g\u0013\rI\u0014\u0011\u0010\u0006\u0004\u0003kz\u0004f\u0002\r\u0002~\u00055\u0015q\u0012\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BAD\u0003\u007f\ta\u0001]1sC6\u001c\u0018\u0002BAF\u0003\u0003\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BAI\u0003+\u000b#!a%\u0002\u0005i\\\u0017EAAL\u0003\u0015Y'/\u00194uQ\u001dA\u00121TAR\u0003K\u0003B!!(\u0002 6\u0011\u0011QQ\u0005\u0005\u0003C\u000b)IA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011qU\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018\u0001\u0010;fgR$&/\u00198tC\u000e$\u0018n\u001c8BMR,'\u000f\u0016:b]N\f7\r^5p]&#W\t\u001f9je\u0016\u001c()\u001e;Qe>$WoY3s\u0013\u0012\u0014V-\\1j]N$2A\\AW\u0011\u001d\t)'\u0007a\u0001\u0003OBs!GA?\u0003\u001b\u000b\t\f\f\u0003\u0002\u0012\u0006U\u0005fB\r\u0002\u001c\u0006\r\u0016QU\u0001\"i\u0016\u001cH\u000fR=oC6L7\r\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u000b\u0004]\u0006e\u0006bBA35\u0001\u0007\u0011q\r\u0015\b5\u0005u\u0014QRA_Y\u0011\t\t*!&)\u000fi\tY*a)\u0002&\u0006i\u0001O]8ek\u000e,'o\u0015;bi\u0016,\"!!2\u0011\r\u0005\u001d\u0017QZAi\u001b\t\tIMC\u0002\u0002LZ\nA!\u001e;jY&!\u0011qZAe\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0015\u00111[\u0005\u0005\u0003+\f9AA\u0007Qe>$WoY3s'R\fG/Z\u0001\u001baJ|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8D_:4\u0017n\u001a\u000b\u0005\u00037\fi\u000fE\u0004\u0002H\u0006ug+!9\n\t\u0005}\u0017\u0011\u001a\u0002\u0004\u001b\u0006\u0004\bCBAd\u0003G\f9/\u0003\u0003\u0002f\u0006%'AC\"pY2,7\r^5p]B!\u0011QAAu\u0013\u0011\tY/a\u0002\u0003\u001b\u0005cG/\u001a:D_:4\u0017nZ(q\u0011\u001d\ty\u000f\ba\u0001\u0003O\n1bY8oM&<g+\u00197vK\u0006\u0011s/Y5u+:$\u0018\u000e\u001c+sC:\u001c\u0018m\u0019;j_:\fGn\u0015;bi\u0016,\u0005\u0010]5sKN\f1b]3sm\u0016\u0014\bK]8qgR\u0011\u0011q\u001f\t\u0005\u0003\u000f\fI0\u0003\u0003\u0002|\u0006%'A\u0003)s_B,'\u000f^5fg\u0002")
public class ProducerIdExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final int numPartitions;
    private final int replicationFactor;
    private final TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
    private final ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;
    private Admin admin;

    public String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public ConfigResource configResource() {
        return this.configResource;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$2 = false;
        boolean x$3 = true;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$4, x$5, x$2, x$3, x$6, x$7, x$8, x$9, x$10, x$11));
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), TestUtils$.MODULE$.createAdminClient$default$3()));
        this.createTopic(this.topic1(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        if (this.consumer() != null) {
            this.consumer().close();
        }
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProducerIdExpirationWithNoTransactions(String quorum) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$2 = true;
        int x$3 = TestUtils$.MODULE$.createProducer$default$2();
        long x$4 = TestUtils$.MODULE$.createProducer$default$3();
        long x$5 = TestUtils$.MODULE$.createProducer$default$4();
        int x$6 = TestUtils$.MODULE$.createProducer$default$5();
        int x$7 = TestUtils$.MODULE$.createProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createProducer$default$7();
        int x$9 = TestUtils$.MODULE$.createProducer$default$8();
        String x$10 = TestUtils$.MODULE$.createProducer$default$9();
        int x$11 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$12 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$13 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$14 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$16 = TestUtils$.MODULE$.createProducer$default$15();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$2));
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        this.ensureConsistentKRaftMetadata();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testProducerIdExpirationWithNoTransactions$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testProducerIdExpirationWithNoTransactions$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionAfterTransactionIdExpiresButProducerIdRemains(String quorum) {
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), TestUtils$.MODULE$.createTransactionalProducer$default$3(), TestUtils$.MODULE$.createTransactionalProducer$default$4(), TestUtils$.MODULE$.createTransactionalProducer$default$5(), TestUtils$.MODULE$.createTransactionalProducer$default$6(), TestUtils$.MODULE$.createTransactionalProducer$default$7(), TestUtils$.MODULE$.createTransactionalProducer$default$8()));
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().flush();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().abortTransaction();
        this.waitUntilTransactionalStateExpires();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "1", "1", false));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!failedFuture.isDone()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "3", "3", true));
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        this.producer().commitTransaction();
        this.consumer().subscribe(Collections.singletonList(this.topic1()));
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicProducerIdExpirationMs(String quorum) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$2 = true;
        int x$3 = TestUtils$.MODULE$.createProducer$default$2();
        long x$4 = TestUtils$.MODULE$.createProducer$default$3();
        long x$5 = TestUtils$.MODULE$.createProducer$default$4();
        int x$6 = TestUtils$.MODULE$.createProducer$default$5();
        int x$7 = TestUtils$.MODULE$.createProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createProducer$default$7();
        int x$9 = TestUtils$.MODULE$.createProducer$default$8();
        String x$10 = TestUtils$.MODULE$.createProducer$default$9();
        int x$11 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$12 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$13 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$14 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$16 = TestUtils$.MODULE$.createProducer$default$15();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$2));
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        this.ensureConsistentKRaftMetadata();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.admin().incrementalAlterConfigs(this.producerIdExpirationConfig("100000"));
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$3(broker);
            return BoxedUnit.UNIT;
        });
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        Assertions.assertThrows(AssertionFailedError.class, () -> {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 4000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$7(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$8());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
        this.admin().incrementalAlterConfigs(this.producerIdExpirationConfig("100"));
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$9(broker);
            return BoxedUnit.UNIT;
        });
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$12(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private List<ProducerState> producerState() {
        return ((DescribeProducersResult.PartitionProducerState)this.admin().describeProducers(Collections.singletonList(this.tp0())).partitionResult(this.tp0()).get()).activeProducers();
    }

    private Map<ConfigResource, Collection<AlterConfigOp>> producerIdExpirationConfig(String configValue) {
        ConfigEntry producerIdCfg = new ConfigEntry(KafkaConfig$.MODULE$.ProducerIdExpirationMsProp(), configValue);
        List<AlterConfigOp> configs = Collections.singletonList(new AlterConfigOp(producerIdCfg, AlterConfigOp.OpType.SET));
        return Collections.singletonMap(this.configResource(), configs);
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTransactionalStateExpires() {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$waitUntilTransactionalStateExpires$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$waitUntilTransactionalStateExpires$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        serverProps.put(KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp(), "500");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsRemoveExpiredTransactionalIdCleanupIntervalMsProp(), "500");
        serverProps.put(KafkaConfig$.MODULE$.ProducerIdExpirationMsProp(), "2000");
        serverProps.put(KafkaConfig$.MODULE$.ProducerIdExpirationCheckIntervalMsProp(), "500");
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerIdExpirationWithNoTransactions$1(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testProducerIdExpirationWithNoTransactions$2() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$1(ProducerIdExpirationTest $this) {
        return $this.producerState().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$2() {
        return "Producer IDs were not added.";
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$4() {
        return "Producer future never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$1(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$2() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$4(KafkaBroker broker$1) {
        return broker$1.logManager().producerStateManagerConfig().producerIdExpirationMs() == 100000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$5() {
        return "Configuration was not updated.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDynamicProducerIdExpirationMs$3(KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$4(broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$7(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$8() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$10(KafkaBroker broker$2) {
        return broker$2.logManager().producerStateManagerConfig().producerIdExpirationMs() == 100;
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$11() {
        return "Configuration was not updated.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDynamicProducerIdExpirationMs$9(KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$10(broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$12(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$13() {
        return "Producer ID did not expire.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExpires$1(ProducerIdExpirationTest $this) {
        void var1_1;
        boolean removedTransactionState = false;
        try {
            $this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer").get();
        }
        catch (Exception exception) {
            removedTransactionState = exception.getCause() instanceof TransactionalIdNotFoundException;
        }
        return (boolean)var1_1;
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExpires$2() {
        return "Transaction state never expired.";
    }

    public ProducerIdExpirationTest() {
        this.topic1 = "topic1";
        this.numPartitions = 1;
        this.replicationFactor = 3;
    }
}

