/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]s!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007k\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fY\n!\u0019!C\u0001o!11)\u0001Q\u0001\naBq\u0001R\u0001C\u0002\u0013\u0005Q\t\u0003\u0004J\u0003\u0001\u0006IA\u0012\u0004\u0005M}\u0001!\nC\u0003/\u0013\u0011\u00051\nC\u0004N\u0013\t\u0007I\u0011\u0001(\t\rUK\u0001\u0015!\u0003P\u0011%1\u0016\u00021AA\u0002\u0013\u0005q\u000bC\u0005\\\u0013\u0001\u0007\t\u0019!C\u00019\"I!-\u0003a\u0001\u0002\u0003\u0006K\u0001\u0017\u0005\u0006G&!\t\u0001\u001a\u0005\u0006a&!I!\u001d\u0005\u0006y&!\t! \u0005\b\u0003\u000fIA\u0011BA\u0005\u0011\u001d\t9\"\u0003C\u0005\u00033Aq!a\u000b\n\t\u0013\ti\u0003\u0003\u0004\u00022%!\t\u0001\u001a\u0005\u0007\u0003wIA\u0011\u00013\t\r\u0005}\u0012\u0002\"\u0001e\u0011\u0019\t\u0019%\u0003C\u0001I\"1\u0011qI\u0005\u0005\u0002\u0011Da!a\u0013\n\t\u0003!\u0007BBA(\u0013\u0011\u0005A\r\u0003\u0004\u0002T%!\t\u0001Z\u0001\f%\u0016\u0004H.[2b)\u0016\u001cHO\u0003\u0002!C\u000591\r\\;ti\u0016\u0014(\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q%A\u0007\u0002?\tY!+\u001a9mS\u000e\fG+Z:u'\t\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\n\u0001B\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0002eA\u0011\u0011fM\u0005\u0003i)\u00121!\u00138u\u0003%\u0011%o\\6fe&#\u0007%A\u0005QCJ$\u0018\u000e^5p]V\t\u0001\b\u0005\u0002:\u00036\t!H\u0003\u0002<y\u000511m\\7n_:T!AI\u001f\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005j\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006QCJ$\u0018\u000e^5p]\u0002\n1CU3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN,\u0012A\u0012\t\u0003S\u001dK!\u0001\u0013\u0016\u0003\t1{gnZ\u0001\u0015%\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj\u001d\u0011\u0014\u0005%AC#\u0001'\u0011\u0005\u0015J\u0011\u0001\u0002;j[\u0016,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0006\nQ!\u001e;jYNL!\u0001V)\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nqA]3qY&\u001c\u0017-F\u0001Y!\t)\u0013,\u0003\u0002[?\t9!+\u001a9mS\u000e\f\u0017a\u0003:fa2L7-Y0%KF$\"!\u00181\u0011\u0005%r\u0016BA0+\u0005\u0011)f.\u001b;\t\u000f\u0005t\u0011\u0011!a\u00011\u0006\u0019\u0001\u0010J\u0019\u0002\u0011I,\u0007\u000f\\5dC\u0002\nQa]3ukB$\u0012!\u0018\u0015\u0003!\u0019\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\u0007\u0005\u0004\u0018N\u0003\u0002lY\u00069!.\u001e9ji\u0016\u0014(BA7@\u0003\u0015QWO\\5u\u0013\ty\u0007N\u0001\u0006CK\u001a|'/Z#bG\"\f!#Y:tKJ$(+\u001a9mS\u000e\f7\u000b^1uKR1QL\u001d;wqjDQa]\tA\u0002\u0019\u000ba\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0003v#\u0001\u0007a)\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0003x#\u0001\u0007a)\u0001\nmCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\b\"B=\u0012\u0001\u00041\u0015a\u00077bgR4U\r^2i\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fC\u0003|#\u0001\u0007a)A\bmCN$h)\u001a;dQRKW.Z't\u0003}\t7o]3siJ+\u0007\u000f\\5dCN#\u0018\r^3E_\u0016\u001chj\u001c;DQ\u0006tw-\u001a\u000b\u0003;zDqa \n\u0005\u0002\u0004\t\t!\u0001\u0002paB!\u0011&a\u0001^\u0013\r\t)A\u000b\u0002\ty\tLh.Y7f}\u0005\u0001R\u000f\u001d3bi\u00164U\r^2i'R\fG/\u001a\u000b\b\r\u0006-\u0011qBA\n\u0011\u0019\tia\u0005a\u0001\r\u0006\u0019bm\u001c7m_^,'OR3uG\"|eMZ:fi\"1\u0011\u0011C\nA\u0002\u0019\u000b1CZ8mY><XM]*uCJ$xJ\u001a4tKRDa!!\u0006\u0014\u0001\u00041\u0015a\u00047fC\u0012,'/\u00128e\u001f\u001a47/\u001a;\u0002#I,7/\u001a;SKBd\u0017nY1Ti\u0006$X\rF\u0004G\u00037\ti\"a\n\t\r\u0005UA\u00031\u0001G\u0011\u001d\ty\u0002\u0006a\u0001\u0003C\t1\"[:OK^dU-\u00193feB\u0019\u0011&a\t\n\u0007\u0005\u0015\"FA\u0004C_>dW-\u00198\t\u000f\u0005%B\u00031\u0001\u0002\"\u0005\u0001\u0012n\u001d$pY2|w/\u001a:J]NKhnY\u0001\u000bSN\u001c\u0015-^4iiV\u0003H\u0003BA\u0011\u0003_Aa!!\u0006\u0016\u0001\u00041\u0015\u0001\u0005;fgRLe.\u001b;jC2\u001cF/\u0019;fQ\r1\u0012Q\u0007\t\u0004O\u0006]\u0012bAA\u001dQ\n!A+Z:u\u0003Q!Xm\u001d;Va\u0012\fG/\u001a$fi\u000eD7\u000b^1uK\"\u001aq#!\u000e\u0002yQ,7\u000f\u001e*fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uK^CWM\u001c'fC\u0012,'/S:SK\u0016dWm\u0019;fI\u0006sGMU3qY&\u001c\u0017-S:J]NKhn\u0019\u0015\u00041\u0005U\u0012a\u0010;fgR\u0014Vm]3u%\u0016\u0004H.[2b'R\fG/Z,iK:dU-\u00193fe&\u001b(+Z3mK\u000e$X\rZ!oIJ+\u0007\u000f\\5dC&\u001bhj\u001c;J]NKhn\u0019\u0015\u00043\u0005U\u0012!\u0010;fgR\u0014Vm]3u%\u0016\u0004H.[2b'R\fG/Z,iK:tUm\u001e'fC\u0012,'/S:FY\u0016\u001cG/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006L5/\u00138Ts:\u001c\u0007f\u0001\u000e\u00026\u0005\u0001E/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u001d\u0016<H*Z1eKJL5/\u00127fGR,G-\u00118e%\u0016\u0004H.[2b\u0013Ntu\u000e^%o'ft7\rK\u0002\u001c\u0003k\t1\u0006^3ti&\u001b8)Y;hQR,\u0006o\u00165f]J+\u0007\u000f\\5dC&\u001b8)Y;hQR,\u0006\u000fV8M_\u001e,e\u000e\u001a\u0015\u00049\u0005U\u0012A\f;fgRL5oQ1vO\"$X\u000b],iK:\u0014V\r\u001d7jG\u0006L5OT8u\u0007\u0006,x\r\u001b;VaR{Gj\\4F]\u0012D3!HA\u001b\u0001")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition()));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs());
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchState(new LogOffsetMetadata(followerFetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), followerStartOffset, currentTimeMs, leaderEndOffset);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L);
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1);
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2);
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), resetTimeMs1, UnifiedLog$.MODULE$.UnknownOffset(), 0L);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, UnifiedLog$.MODULE$.UnknownOffset(), 0L);
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }
}

