/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.SnapshotFile;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001B(Q\u0001UCQ\u0001\u0018\u0001\u0005\u0002uC\u0011\u0002\u0019\u0001A\u0002\u0003\u0007I\u0011B1\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0007\"C9\u0001\u0001\u0004\u0005\t\u0015)\u0003c\u0011%\u0011\b\u00011AA\u0002\u0013%1\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\"I!\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\t\t\u0002\u0001Q\u0001\nuD\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005u\u0001\u0001)A\u0005\u0003/A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005%\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%I!!\t\t\u0011\u0005e\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u007fAq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002h\u0001!\t!a\u0014\t\u000f\u0005E\u0004\u0001\"\u0001\u0002P!9\u00111\u0010\u0001\u0005\u0002\u0005=\u0003bBA@\u0001\u0011\u0005\u0011q\n\u0005\b\u0003\u0007\u0003A\u0011AA(\u0011\u001d\t9\t\u0001C\u0001\u0003\u001fBq!a#\u0001\t\u0003\ty\u0005C\u0004\u0002\u0010\u0002!\t!a\u0014\t\u000f\u0005M\u0005\u0001\"\u0001\u0002P!9\u0011q\u0013\u0001\u0005\u0002\u0005=\u0003bBAN\u0001\u0011\u0005\u0011q\n\u0005\b\u0003?\u0003A\u0011AA(\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u001fBq!a*\u0001\t\u0003\ty\u0005C\u0004\u0002,\u0002!\t!a\u0014\t\u000f\u0005=\u0006\u0001\"\u0001\u0002P!9\u00111\u0017\u0001\u0005\u0002\u0005=\u0003bBA\\\u0001\u0011\u0005\u0011q\n\u0005\b\u0003w\u0003A\u0011AA(\u0011\u001d\ty\f\u0001C\u0001\u0003\u001fBq!a1\u0001\t\u0003\ty\u0005C\u0004\u0002H\u0002!\t!a\u0014\t\u000f\u0005-\u0007\u0001\"\u0001\u0002P!9\u0011q\u001a\u0001\u0005\u0002\u0005=\u0003bBAj\u0001\u0011\u0005\u0011q\n\u0005\b\u0003/\u0004A\u0011AA(\u0011\u001d\tY\u000e\u0001C\u0001\u0003\u001fBq!a8\u0001\t\u0003\ty\u0005C\u0004\u0002d\u0002!\t!a\u0014\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002P!9\u00111\u001e\u0001\u0005\u0002\u0005=\u0003bBAx\u0001\u0011\u0005\u0011q\n\u0005\b\u0003g\u0004A\u0011AA(\u0011\u001d\t9\u0010\u0001C\u0001\u0003\u001fBq!a?\u0001\t\u0003\ty\u0005C\u0004\u0002\u0000\u0002!\t!a\u0014\t\u000f\t\r\u0001\u0001\"\u0001\u0002P!9!q\u0001\u0001\u0005\u0002\u0005=\u0003b\u0002B\u0006\u0001\u0011\u0005\u0011q\n\u0005\b\u0005\u001f\u0001A\u0011AA(\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003\u001fBqAa\u0006\u0001\t\u0003\ty\u0005C\u0004\u0003\u001c\u0001!\t!a\u0014\t\u000f\t}\u0001\u0001\"\u0001\u0002P!9!1\u0005\u0001\u0005\u0002\u0005=\u0003b\u0002B\u0014\u0001\u0011\u0005\u0011q\n\u0005\b\u0005W\u0001A\u0011AA(\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003\u001fBqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003R\u0001!IAa\u0015\t\u0013\t5\u0005!%A\u0005\n\t=\u0005\"\u0003BS\u0001E\u0005I\u0011\u0002BT\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005[C\u0011B!5\u0001#\u0003%IAa*\t\u0013\tM\u0007!%A\u0005\n\tU\u0007\"\u0003Bm\u0001E\u0005I\u0011\u0002Bn\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005?DqAa=\u0001\t\u0013\u0011)P\u0001\rQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d+fgRT!!\u0015*\u0002\u00071|wMC\u0001T\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\f\u0005\u0002`\u00015\t\u0001+\u0001\u0004m_\u001e$\u0015N]\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0003S>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003Y>\u0004\"aV7\n\u00059D&\u0001B+oSRDq\u0001]\u0002\u0002\u0002\u0003\u0007!-A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0007ti\u0006$X-T1oC\u001e,'/F\u0001u!\tyV/\u0003\u0002w!\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u00051L\bb\u00029\u0007\u0003\u0003\u0005\r\u0001^\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tW#A?\u0011\u0007y\fi!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\r\r|W.\\8o\u0015\r\u0019\u0016Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\t1a\u001c:h\u0013\r\tya \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000baJ|G-^2fe&#WCAA\f!\r9\u0016\u0011D\u0005\u0004\u00037A&\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u00059R.\u0019=Ue\u0006t7/Y2uS>tG+[7f_V$Xj]\u000b\u0003\u0003G\u00012aVA\u0013\u0013\r\t9\u0003\u0017\u0002\u0004\u0013:$\u0018\u0001G7bqR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005Q\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jOV\u0011\u0011q\u0006\t\u0004?\u0006E\u0012bAA\u001a!\nQ\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0006Y\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0002\n\u0001\u0004\\1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0003ea\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bz\u0018!B;uS2\u001c\u0018\u0002BA%\u0003\u0007\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002Y\"\u001aA#a\u0015\u0011\t\u0005U\u00131M\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005\u0019\u0011\r]5\u000b\t\u0005u\u0013qL\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t\t'!\u0003\u0002\u000b),h.\u001b;\n\t\u0005\u0015\u0014q\u000b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007U\tY\u0007\u0005\u0003\u0002V\u00055\u0014\u0002BA8\u0003/\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002%Q,7\u000f\u001e\"bg&\u001c\u0017\nZ'baBLgn\u001a\u0015\u0004-\u0005U\u0004\u0003BA+\u0003oJA!!\u001f\u0002X\t!A+Z:u\u0003\u0019\"Xm\u001d;BaB,g\u000e\u001a+y]6\u000b'o[3s/&$\bNT8Qe>$WoY3s'R\fG/\u001a\u0015\u0004/\u0005U\u0014A\b;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cWm\u0016:ba\u0006\u0013x.\u001e8eQ\rA\u0012QO\u0001.i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3XSRDwK]1q\u0003J|WO\u001c3CCR\u001c\u0007NU3d_J$\u0007fA\r\u0002v\u0005)C/Z:u!J|G-^2feN+\u0017/^3oG\u0016LeN^1mS\u0012<&/\u00199Be>,h\u000e\u001a\u0015\u00045\u0005U\u0014A\u000b;fgRtuNV1mS\u0012\fG/[8o\u001f:4\u0015N]:u\u000b:$(/_,iK:du.\u00193j]\u001edun\u001a\u0015\u00047\u0005U\u0014a\t;fgR\u001cuN\u001c;s_2\u0014VmY8sI\n+X\u000e]:Qe>$WoY3s\u000bB|7\r\u001b\u0015\u00049\u0005U\u0014\u0001\t;fgR$\u0006P\u001c$jeN$xJ\u001a4tKRlU\r^1eCR\f7)Y2iK\u0012D3!HA;\u0003e!Xm\u001d;TW&\u0004X)\u001c9usR\u0013\u0018M\\:bGRLwN\\:)\u0007y\t)(\u0001\fuKN$\b*Y:MCR,GK]1og\u0006\u001cG/[8oQ\ry\u0012QO\u0001-i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]&s\u0017\u000e^5bY&TX\rZ!gi\u0016\u0014(+\u001a7pC\u0012D3\u0001IA;\u0003M\"Xm\u001d;ICNd\u0015\r^3Ue\u0006t7/Y2uS>tW\u000b\u001d3bi\u0016$\u0017I\u001a;feB\u000b'\u000f^5bYR\u0013XO\\2bi&|g\u000eK\u0002\"\u0003k\n\u0001\u0007^3ti\"\u000b7\u000fT1uKR\u0013\u0018M\\:bGRLwN\\+qI\u0006$X\rZ!gi\u0016\u0014h)\u001e7m)J,hnY1uS>t\u0007f\u0001\u0012\u0002v\u0005\u0001C/Z:u\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\u001cu.\u001c9mKR,G\r\u0016=oQ\r\u0019\u0013QO\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3\u0001JA;\u0003y)\b\u000fZ1uKB\u0013x\u000eZ;dKJ$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rK\u0002&\u0003k\nA\u0006^3ti>+Ho\u00144TKF,XM\\2f\u0003\u001a$XM]\"p]R\u0014x\u000e\u001c*fG>\u0014H-\u00129pG\"\u0014U/\u001c9)\u0007\u0019\n)(\u0001\u0019uKN$hj\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\!qa\u0016tGmV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004O\u0005U\u0014a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bf\u0001\u0015\u0002v\u0005\u0001B/Z:u)\u0006\\Wm\u00158baNDw\u000e\u001e\u0015\u0004S\u0005U\u0014\u0001\f;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u+:4\u0017N\\5tQ\u0016$GK]1og\u0006\u001cG/[8oQ\rQ\u0013QO\u0001+i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R4\u0015N\\5tQ\u0016$GK]1og\u0006\u001cG/[8oQ\rY\u0013QO\u0001(i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R,U\u000e\u001d;z)J\fgn]1di&|g\u000eK\u0002-\u0003k\n\u0001\u0006^3tiB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u0003\u001a$XM\u001d$f]\u000eLgnZ!c_J$X*\u0019:lKJD3!LA;\u0003u!Xm\u001d;SK6|g/Z#ya&\u0014X\r\u001a)jIN|eNU3m_\u0006$\u0007f\u0001\u0018\u0002v\u0005iC/Z:u\u0003\u000e\u001cW\r\u001d;BaB,g\u000eZ,ji\"|W\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$Xm\u00148SKBd\u0017nY1)\u0007=\n)(A\u0015uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[*fcV,gnY3HCB\u001cxJ\u001c*fa2L7-\u0019\u0015\u0004a\u0005U\u0014!\u0007;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016D3!MA;\u0003m!Xm\u001d;UeVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;Bi\"\u001a!'!\u001e\u0002MQ,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u00024\u0003k\na\u0006^3ti2{\u0017\r\u001a$s_6\u001cf.\u00199tQ>$(+\u001a;bS:\u001chj\u001c8FqBL'/\u001a3Qe>$WoY3sg\"\u001aA'!\u001e\u0002CQ,7\u000f^*lSB\u001cf.\u00199tQ>$\u0018JZ(gMN,G/\u00168dQ\u0006tw-\u001a3)\u0007U\n)(\u0001\ruKN$\b+\u001b3FqBL'/\u0019;j_:$\u0016.\\3pkRD3ANA;\u0003]!Xm\u001d;GSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G\u000fK\u00028\u0003k\na\u0006^3tiB\u0013x\u000eZ;dKJ\u001cx+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|gn\u001d#p]R,\u0005\u0010]5sK\"\u001a\u0001(!\u001e\u0002[Q,7\u000f^*fcV,gnY3O_R4\u0016\r\\5eCR,GMR8s\u000fJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7\rK\u0002:\u0003k\nA\u0004^3ti>cG-\u00129pG\"4uN]\"p]R\u0014x\u000e\u001c*fG>\u0014H\rK\u0002;\u0003k\na\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000eLgn\u001a\u0015\u0004w\u0005U\u0014\u0001\t;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ!gi\u0016\u0014(+\u001a7pC\u0012D3\u0001PA;\u0003u!Xm\u001d;M_\u0006$gI]8n\u000b6\u0004H/_*oCB\u001c\bn\u001c;GS2,\u0007fA\u001f\u0002v\u0005\tC/Z:u\u0019>\fGM\u0012:p[R\u0013XO\\2bi\u0016$7K\\1qg\"|GOR5mK\"\u001aa(!\u001e\u0002?Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u\r&dW\rK\u0002@\u0003k\n1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007f\u0001!\u0002v\u0005\tD/Z:u%\u0016lwN^3TiJ\f\u0017p\u00158baNDw\u000e^:LK\u0016\u00048\t\\3b]NCW\u000f\u001e3po:\u001cf.\u00199tQ>$\bfA!\u0002v\u0005YB/Z:u%\u0016lwN^3BY2\u001cFO]1z':\f\u0007o\u001d5piND3AQA;\u0003\u0011\"Xm\u001d;SK6|g/Z!oI6\u000b'o[*oCB\u001c\bn\u001c;G_J$U\r\\3uS>t\u0007fA\"\u0002v\u0005\u0011D/Z:u%\u0016lwN^3B]\u0012l\u0015M]6T]\u0006\u00048\u000f[8u\r>\u0014H)\u001a7fi&|g.\u00117sK\u0006$\u0017\u0010R3mKR,G\rK\u0002E\u0003k\n1\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$Hc\u00017\u00038!9!\u0011H#A\u0002\tm\u0012aD7bW\u00164\u0015\u000e\\3D_J\u0014X\u000f\u001d;\u0011\r]\u0013iD!\u0011m\u0013\r\u0011y\u0004\u0017\u0002\n\rVt7\r^5p]F\u0002BAa\u0011\u0003N5\u0011!Q\t\u0006\u0005\u0005\u000f\u0012I%\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011YEZ\u0001\u0004]&|\u0017\u0002\u0002B(\u0005\u000b\u00121BR5mK\u000eC\u0017M\u001c8fY\u0006\u0011\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3s)A\u0011)F!\u0019\u0003f\t\u001d$\u0011\u000fBA\u0005\u000b\u0013I\tE\u0003X\u0005/\u0012Y&C\u0002\u0003Za\u0013aa\u00149uS>t\u0007cA0\u0003^%\u0019!q\f)\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\r\t\rd\t1\u0001u\u0003\u001di\u0017\r\u001d9j]\u001eDq!a\u0005G\u0001\u0004\t9\u0002C\u0004\u0003j\u0019\u0003\rAa\u001b\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r9&QN\u0005\u0004\u0005_B&!B*i_J$\bb\u0002B:\r\u0002\u0007!QO\u0001\fG>tGO]8m)f\u0004X\r\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011Yh`\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t}$\u0011\u0010\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007b\u0002BB\r\u0002\u0007\u0011qC\u0001\u0007_\u001a47/\u001a;\t\u0013\t\u001de\t%AA\u0002\u0005\r\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011%\u0011YI\u0012I\u0001\u0002\u0004\t9\"A\u0005uS6,7\u000f^1na\u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u00122TC\u0001BIU\u0011\t\u0019Ca%,\u0005\tU\u0005\u0003\u0002BL\u0005Ck!A!'\u000b\t\tm%QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa(Y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0013IJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003**\"\u0011q\u0003BJ\u0003\u0019\t\u0007\u000f]3oIR\tBNa,\u00032\nM&Q\u0017B]\u0005w\u0013iLa2\t\u000bIL\u0005\u0019\u0001;\t\u000f\u0005M\u0011\n1\u0001\u0002\u0018!9!\u0011N%A\u0002\t-\u0004b\u0002B\\\u0013\u0002\u0007\u00111E\u0001\u0004g\u0016\f\bb\u0002BB\u0013\u0002\u0007\u0011q\u0003\u0005\n\u0005\u0017K\u0005\u0013!a\u0001\u0003/A\u0011Ba0J!\u0003\u0005\rA!1\u0002\u001f%\u001cHK]1og\u0006\u001cG/[8oC2\u00042a\u0016Bb\u0013\r\u0011)\r\u0017\u0002\b\u0005>|G.Z1o\u0011%\u0011I-\u0013I\u0001\u0002\u0004\u0011Y-\u0001\u0004pe&<\u0017N\u001c\t\u0004?\n5\u0017b\u0001Bh!\na\u0011\t\u001d9f]\u0012|%/[4j]\u0006\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HEN\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uI]*\"Aa6+\t\t\u0005'1S\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uIa*\"A!8+\t\t-'1\u0013\u000b\fY\n\u0005(1\u001dBs\u0005O\u0014\t\u0010C\u0003s\u001b\u0002\u0007A\u000fC\u0004\u0002\u00145\u0003\r!a\u0006\t\u000f\t\rU\n1\u0001\u0002\u0018!9!\u0011^'A\u0002\t-\u0018!\u00022bi\u000eD\u0007\u0003\u0002B<\u0005[LAAa<\u0003z\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\u0011I-\u0014a\u0001\u0005\u0017\facY;se\u0016tGo\u00158baNDw\u000e^(gMN,Go]\u000b\u0003\u0005o\u0004bA!?\u0004\b\u0005]a\u0002\u0002B~\u0007\u0007\u00012A!@Y\u001b\t\u0011yPC\u0002\u0004\u0002Q\u000ba\u0001\u0010:p_Rt\u0014bAB\u00031\u00061\u0001K]3eK\u001aLAa!\u0003\u0004\f\t\u00191+\u001a;\u000b\u0007\r\u0015\u0001\f")
public class ProducerStateManagerTest {
    private File logDir;
    private ProducerStateManager stateManager;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
    private final int lateTransactionTimeoutMs = this.maxTransactionTimeoutMs() + ProducerStateManager$.MODULE$.LateTransactionBufferMs();
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private int lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), 16L), (Object)firstAppend.startedTransactions().head());
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        Assertions.assertEquals((int)2, (int)secondAppend.startedTransactions().size());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().head());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().last());
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId1, epoch1, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        int x$12 = 0;
        long x$13 = 150L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, producerId2, epoch2, x$12, x$13, x$15, x$14, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() - 500 + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId1, epoch1, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        int x$12 = 0;
        long x$13 = 150L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, producerId2, epoch2, x$12, x$13, x$15, x$14, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep((long)(this.lateTransactionTimeoutMs() - 500 + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), this.time().milliseconds());
        Assertions.assertTrue((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Option completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isDefined());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assertions.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = this.append$default$8();
            this.append(x$17, x$18, bumpedEpoch, x$20, x$21, x$23, x$22, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = this.append$default$8();
        this.append(x$33, x$34, bumpedEpoch, x$36, x$37, x$39, x$38, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            int x$12 = 1;
            long x$13 = 1L;
            boolean x$14 = false;
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = this.append$default$8();
            this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head())).nonEmpty(), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        int x$20 = 2;
        long x$21 = 2L;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = this.append$default$8();
        this.append(recoveredMapping, x$18, epoch, x$20, x$21, x$23, x$22, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        ControlRecordType x$4 = ControlRecordType.ABORT;
        long x$5 = 0L;
        int x$7 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$1, x$2, epoch, x$4, x$5, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isDefined());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        long x$5 = 2L;
        long x$6 = 70001L;
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean x$8 = this.append$default$7();
        this.append(recoveredMapping, x$2, epoch, sequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$5 = 1L;
            long x$6 = 1L;
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, epoch, outOfOrderSequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        });
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$13 = 1L;
        long x$14 = 1L;
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, epoch, outOfOrderSequence, x$13, x$14, x$16, (AppendOrigin)x$15);
        Assertions.assertEquals((int)outOfOrderSequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$52, x$72, x$62, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$82 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$82);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$132 = 105L;
        boolean x$142 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$92, anotherPid, epoch, sequence, x$132, x$15, x$142, x$16);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, x$4, x$5, x$8, x$6, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, x$12, x$13, x$16, x$14, (AppendOrigin)x$15);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, producerEpoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).toPath(), new FileAttribute[0]);
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).toPath(), new FileAttribute[0]);
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)42)), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).toPath(), new FileAttribute[0]);
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).toPath(), new FileAttribute[0]);
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L})));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Files.delete(file.toPath());
        Assertions.assertTrue((boolean)manager.removeAndMarkSnapshotForDeletion(5L).isEmpty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            mapping.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)UnifiedLog$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds());
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

