/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaNetworkChannelTest$;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u0019Y\u0005\u0001)A\u0005\u0011\"9A\n\u0001b\u0001\n\u0013i\u0005BB.\u0001A\u0003%a\nC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0011\u0004\u0001\u0015!\u0003_\u0011\u001d)\u0007A1A\u0005\n\u0019Daa\u001b\u0001!\u0002\u00139\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007c\u0002\u0001\u000b\u0011\u00028\t\u000fI\u0004!\u0019!C\u0005g\"1q\u000f\u0001Q\u0001\nQDQ\u0001\u001f\u0001\u0005\u0002eDa!!\u0005\u0001\t\u0003I\bBBA\u000e\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002 \u0001!\t!\u001f\u0005\u0007\u0003G\u0001A\u0011A=\t\r\u0005\u001d\u0002\u0001\"\u0001z\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aa!a\r\u0001\t\u0003I\bBBA\u001c\u0001\u0011\u0005\u0011\u0010C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!a(\u0001\t\u0003\t\tkB\u0004\u00024.B\t!!.\u0007\r)Z\u0003\u0012AA\\\u0011\u00199\u0014\u0005\"\u0001\u0002:\"I\u00111X\u0011C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u0017\f\u0003\u0015!\u0003\u0002@\u001a1\u0011QZ\u0011\u0005\u0003\u001fDaaN\u0013\u0005\u0002\u0005m\bb\u0002B\u0001K\u0011\u0005#1\u0001\u0005\b\u0005/)C\u0011\tB\r\u0011\u001d\u0011\t#\nC!\u0005G\u0011qcS1gW\u0006tU\r^<pe.\u001c\u0005.\u00198oK2$Vm\u001d;\u000b\u00051j\u0013\u0001\u0002:bMRT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003-\n\u0011b\u00197vgR,'/\u00133\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t+\u0005A\u0005C\u0001\u001aJ\u0013\tQ5GA\u0002J]R\f\u0011C]3rk\u0016\u001cH\u000fV5nK>,H/T:!\u0003\u0011!\u0018.\\3\u0016\u00039\u0003\"aT-\u000e\u0003AS!!\u0015*\u0002\u000bU$\u0018\u000e\\:\u000b\u0005M#\u0016AB2p[6|gN\u0003\u0002/+*\u0011akV\u0001\u0007CB\f7\r[3\u000b\u0003a\u000b1a\u001c:h\u0013\tQ\u0006K\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019\u0019G.[3oiV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b)\u000691\r\\5f]R\u001c\u0018BA2a\u0005)iunY6DY&,g\u000e^\u0001\bG2LWM\u001c;!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\u001a\t\u0003Q&l\u0011AU\u0005\u0003UJ\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u001d!x\u000e]5d\u0013\u0012,\u0012A\u001c\t\u0003Q>L!\u0001\u001d*\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u000591\r[1o]\u0016dW#\u0001;\u0011\u0005i*\u0018B\u0001<,\u0005MY\u0015MZ6b\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m\u0003!\u0019\u0007.\u00198oK2\u0004\u0013AE:fiV\u00048+\u001e9q_J$X\rZ!qSN$\u0012A\u001f\t\u0003emL!\u0001`\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003!y\u00042a`A\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011aA1qS*!\u0011qAA\u0005\u0003\u001dQW\u000f]5uKJT1!a\u0003X\u0003\u0015QWO\\5u\u0013\u0011\ty!!\u0001\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u000fuKN$8+\u001a8e)>,fn\u001b8po:$Um\u001d;j]\u0006$\u0018n\u001c8)\u0007E\t)\u0002E\u0002\u0000\u0003/IA!!\u0007\u0002\u0002\t!A+Z:u\u0003}!Xm\u001d;TK:$Gk\u001c\"mC\u000e\\W\rZ(vi\u0012+7\u000f^5oCRLwN\u001c\u0015\u0004%\u0005U\u0011A\u0006;fgR<\u0016m[3va\u000ec\u0017.\u001a8u\u001f:\u001cVM\u001c3)\u0007M\t)\"A\u000buKN$8+\u001a8e\u0003:$G)[:d_:tWm\u0019;)\u0007Q\t)\"A\u000fuKN$8+\u001a8e\u0003:$g)Y5m\u0003V$\b.\u001a8uS\u000e\fG/[8oQ\r)\u0012QC\u0001\u0019CN\u001cXM\u001d;Ce>\\WM\u001d(pi\u00063\u0018-\u001b7bE2,Gc\u0001>\u00020!1\u0011\u0011\u0007\fA\u0002!\u000bQ\u0002Z3ti&t\u0017\r^5p]&#\u0017!\t;fgR\u001cVM\u001c3B]\u0012\u0014VmY3jm\u0016|U\u000f\u001e2pk:$'+Z9vKN$\bfA\f\u0002\u0016\u0005YB/Z:u+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012:s_JD3\u0001GA\u000b\u0003=\u0019XM\u001c3UKN$(+Z9vKN$HCBA \u0003#\n\t\u0007\u0005\u0003\u0002B\u0005-c\u0002BA\"\u0003\u000fj!!!\u0012\u000b\u00051\"\u0016\u0002BA%\u0003\u000b\n1BU1giJ+\u0017/^3ti&!\u0011QJA(\u0005!yU\u000f\u001e2pk:$'\u0002BA%\u0003\u000bBq!a\u0015\u001a\u0001\u0004\t)&\u0001\u0004ba&\\U-\u001f\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f*\u0002\u0011A\u0014x\u000e^8d_2LA!a\u0018\u0002Z\t9\u0011\t]5LKf\u001c\bBBA\u00193\u0001\u0007\u0001*A\fbgN,'\u000f\u001e*fgB|gn]3D_6\u0004H.\u001a;fIR)!0a\u001a\u0002l!9\u0011\u0011\u000e\u000eA\u0002\u0005}\u0012a\u0002:fcV,7\u000f\u001e\u0005\b\u0003[R\u0002\u0019AA8\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB!\u0011qKA9\u0013\u0011\t\u0019(!\u0017\u0003\r\u0015\u0013(o\u001c:t\u0003i\u0019XM\u001c3B]\u0012\f5o]3si\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u001dQ\u0018\u0011PA>\u0003{Bq!a\u0015\u001c\u0001\u0004\t)\u0006\u0003\u0004\u00022m\u0001\r\u0001\u0013\u0005\b\u0003\u007fZ\u0002\u0019AA8\u0003\u0015)'O]8s\u0003A\u0011W/\u001b7e)\u0016\u001cHOU3rk\u0016\u001cH\u000f\u0006\u0003\u0002\u0006\u0006-\u0005\u0003BA,\u0003\u000fKA!!#\u0002Z\tQ\u0011\t]5NKN\u001c\u0018mZ3\t\u000f\u00055E\u00041\u0001\u0002V\u0005\u00191.Z=\u0002-\t,\u0018\u000e\u001c3UKN$XI\u001d:peJ+7\u000f]8og\u0016$b!!\"\u0002\u0014\u0006U\u0005bBAG;\u0001\u0007\u0011Q\u000b\u0005\b\u0003\u007fj\u0002\u0019AA8\u00031)\u0007\u0010\u001e:bGR,%O]8s)\u0011\ty'a'\t\u000f\u0005ue\u00041\u0001\u0002\u0006\u0006A!/Z:q_:\u001cX-A\u0007ck&dGMU3ta>t7/\u001a\u000b\u0005\u0003G\u000by\u000b\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tIKU\u0001\te\u0016\fX/Z:ug&!\u0011QVAT\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rC\u0004\u00022~\u0001\r!!\"\u0002\u0019I,7\u000f]8og\u0016$\u0015\r^1\u0002/-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7UKN$\bC\u0001\u001e\"'\t\t\u0013\u0007\u0006\u0002\u00026\u0006A!+\u00194u\u0003BL7/\u0006\u0002\u0002@B1\u0011\u0011YAd\u0003+j!!a1\u000b\u0007\u0005\u00157'\u0001\u0006d_2dWm\u0019;j_:LA!!3\u0002D\n\u00191+Z9\u0002\u0013I\u000bg\r^!qSN\u0004#aE*uk\nlU\r^1eCR\fW\u000b\u001d3bi\u0016\u00148#B\u0013\u0002R\u0006]\u0007c\u0001 \u0002T&\u0019\u0011Q[ \u0003\r=\u0013'.Z2u!\u0011\tI.!>\u000f\t\u0005m\u0017\u0011\u001f\b\u0005\u0003;\fyO\u0004\u0003\u0002`\u00065h\u0002BAq\u0003WtA!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O|\u0013A\u0002\u001fs_>$h(C\u0001Y\u0013\t1v+\u0003\u0002/+&\u0011\u0011\rV\u0005\u0004\u0003g\u0004\u0017AC'pG.\u001cE.[3oi&!\u0011q_A}\u0005MiunY6NKR\fG-\u0019;b+B$\u0017\r^3s\u0015\r\t\u0019\u0010\u0019\u000b\u0003\u0003{\u00042!a@&\u001b\u0005\t\u0013A\u00034fi\u000eDgj\u001c3fgR\u0011!Q\u0001\t\u0007\u0005\u000f\u0011iA!\u0005\u000e\u0005\t%!b\u0001B\u0006\u0003\u0006!Q\u000f^5m\u0013\u0011\u0011yA!\u0003\u0003\t1K7\u000f\u001e\t\u0004Q\nM\u0011b\u0001B\u000b%\n!aj\u001c3f\u00039I7/\u00169eCR,g*Z3eK\u0012$\"Aa\u0007\u0011\u0007I\u0012i\"C\u0002\u0003 M\u0012qAQ8pY\u0016\fg.\u0001\u0004va\u0012\fG/\u001a\u000b\u0006u\n\u0015\"Q\u0006\u0005\u0007\u0019&\u0002\rAa\n\u0011\u0007=\u0013I#C\u0002\u0003,A\u0013A\u0001V5nK\"9!\u0011E\u0015A\u0002\t=\u0002\u0003\u0002B\u0019\u0005gq1aXAy\u0013\u0011\u0011)$!?\u0003\u001d5+G/\u00193bi\u0006,\u0006\u000fZ1uK\u0002")
public class KafkaNetworkChannelTest {
    private final String clusterId;
    private final int requestTimeoutMs;
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time(), (MockClient.MockMetadataUpdater)new StubMetadataUpdater());
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Uuid topicId = Uuid.randomUuid();
    private final KafkaNetworkChannel kafka$raft$KafkaNetworkChannelTest$$channel = new KafkaNetworkChannel((Time)this.time(), (KafkaClient)this.client(), this.requestTimeoutMs(), "test-raft");

    public static Seq<ApiKeys> RaftApis() {
        return KafkaNetworkChannelTest$.MODULE$.RaftApis();
    }

    private String clusterId() {
        return this.clusterId;
    }

    private int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    public KafkaNetworkChannel kafka$raft$KafkaNetworkChannelTest$$channel() {
        return this.kafka$raft$KafkaNetworkChannelTest$$channel;
    }

    @BeforeEach
    public void setupSupportedApis() {
        Seq supportedApis = (Seq)KafkaNetworkChannelTest$.MODULE$.RaftApis().map((Function1 & Serializable & scala.Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1), Seq$.MODULE$.canBuildFrom());
        this.client().setNodeApiVersions(NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(supportedApis).asJava())));
    }

    @Test
    public void testSendToUnknownDestination() {
        int destinationId = 2;
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testSendToBlackedOutDestination() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.client().backoff(destinationNode, 500L);
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testWakeupClientOnSend() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.client().enableBlockingUntilWakeup(1);
        Thread ioThread = new Thread(this){
            private final /* synthetic */ KafkaNetworkChannelTest $outer;

            public void run() {
                this.$outer.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
                this.$outer.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        AbstractResponse response = this.buildResponse(this.buildTestErrorResponse(ApiKeys.FETCH, Errors.INVALID_REQUEST));
        this.client().prepareResponseFrom(response, destinationNode, false);
        ioThread.start();
        RaftRequest.Outbound request = this.sendTestRequest(ApiKeys.FETCH, destinationId);
        ioThread.join();
        this.assertResponseCompleted(request, Errors.INVALID_REQUEST);
    }

    @Test
    public void testSendAndDisconnect() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndDisconnect$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndFailAuthentication() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndFailAuthentication$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private void assertBrokerNotAvailable(int destinationId) {
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.sendAndAssertErrorResponse(apiKey, destinationId, Errors.BROKER_NOT_AVAILABLE);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndReceiveOutboundRequest() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndReceiveOutboundRequest$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUnsupportedVersionError() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testUnsupportedVersionError$1(this, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private RaftRequest.Outbound sendTestRequest(ApiKeys apiKey, int destinationId) {
        int correlationId = this.kafka$raft$KafkaNetworkChannelTest$$channel().newCorrelationId();
        long createdTimeMs = this.time().milliseconds();
        ApiMessage apiRequest = this.buildTestRequest(apiKey);
        RaftRequest.Outbound request = new RaftRequest.Outbound(correlationId, apiRequest, destinationId, createdTimeMs);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().send(request);
        return request;
    }

    private void assertResponseCompleted(RaftRequest.Outbound request, Errors expectedError) {
        Assertions.assertTrue((boolean)request.completion.isDone());
        RaftResponse.Inbound response = (RaftResponse.Inbound)request.completion.get();
        Assertions.assertEquals((int)request.destinationId(), (int)response.sourceId());
        Assertions.assertEquals((int)request.correlationId(), (int)response.correlationId());
        Assertions.assertEquals((short)request.data().apiKey(), (short)response.data().apiKey());
        Assertions.assertEquals((Object)expectedError, (Object)this.extractError(response.data()));
    }

    private void sendAndAssertErrorResponse(ApiKeys apiKey, int destinationId, Errors error) {
        RaftRequest.Outbound request = this.sendTestRequest(apiKey, destinationId);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
        this.assertResponseCompleted(request, error);
    }

    /*
     * WARNING - void declaration
     */
    private ApiMessage buildTestRequest(ApiKeys key) {
        BeginQuorumEpochRequestData beginQuorumEpochRequestData;
        int leaderEpoch = 5;
        int leaderId = 1;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochRequestData = BeginQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId);
        } else if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochRequestData = EndQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderId, (int)leaderEpoch, Collections.singletonList(Predef$.MODULE$.int2Integer(2)));
        } else if (ApiKeys.VOTE.equals(key)) {
            int lastEpoch = 4;
            beginQuorumEpochRequestData = VoteRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId, (int)lastEpoch, (long)329L);
        } else if (ApiKeys.FETCH.equals(key)) {
            void singletonFetchRequest_topicId;
            Uuid uuid = this.topicId();
            TopicPartition singletonFetchRequest_topicPartition = this.topicPartition();
            FetchRequestData.FetchPartition singletonFetchRequest_fetchPartition = new FetchRequestData.FetchPartition().setPartition(singletonFetchRequest_topicPartition.partition());
            KafkaNetworkChannelTest.$anonfun$buildTestRequest$1(singletonFetchRequest_fetchPartition);
            FetchRequestData.FetchTopic singletonFetchRequest_fetchTopic = new FetchRequestData.FetchTopic().setTopic(singletonFetchRequest_topicPartition.topic()).setTopicId((Uuid)singletonFetchRequest_topicId).setPartitions(Collections.singletonList(singletonFetchRequest_fetchPartition));
            beginQuorumEpochRequestData = new FetchRequestData().setTopics(Collections.singletonList(singletonFetchRequest_fetchTopic)).setReplicaId(1);
        } else {
            throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
        }
        return beginQuorumEpochRequestData;
    }

    private ApiMessage buildTestErrorResponse(ApiKeys key, Errors error) {
        BeginQuorumEpochResponseData beginQuorumEpochResponseData;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochResponseData = new BeginQuorumEpochResponseData().setErrorCode(error.code());
        } else if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochResponseData = new EndQuorumEpochResponseData().setErrorCode(error.code());
        } else if (ApiKeys.VOTE.equals(key)) {
            beginQuorumEpochResponseData = VoteResponse.singletonResponse((Errors)error, (TopicPartition)this.topicPartition(), (Errors)Errors.NONE, (int)1, (int)5, (boolean)false);
        } else if (ApiKeys.FETCH.equals(key)) {
            beginQuorumEpochResponseData = new FetchResponseData().setErrorCode(error.code());
        } else {
            throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
        }
        return beginQuorumEpochResponseData;
    }

    private Errors extractError(ApiMessage response) {
        short s;
        if (response instanceof BeginQuorumEpochResponseData) {
            s = ((BeginQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof EndQuorumEpochResponseData) {
            s = ((EndQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof FetchResponseData) {
            s = ((FetchResponseData)response).errorCode();
        } else if (response instanceof VoteResponseData) {
            s = ((VoteResponseData)response).errorCode();
        } else {
            throw new MatchError((Object)response);
        }
        return Errors.forCode((short)s);
    }

    public AbstractResponse buildResponse(ApiMessage responseData) {
        VoteResponse voteResponse;
        if (responseData instanceof VoteResponseData) {
            VoteResponseData voteResponseData = (VoteResponseData)responseData;
            voteResponse = new VoteResponse(voteResponseData);
        } else if (responseData instanceof BeginQuorumEpochResponseData) {
            BeginQuorumEpochResponseData beginQuorumEpochResponseData = (BeginQuorumEpochResponseData)responseData;
            voteResponse = new BeginQuorumEpochResponse(beginQuorumEpochResponseData);
        } else if (responseData instanceof EndQuorumEpochResponseData) {
            EndQuorumEpochResponseData endQuorumEpochResponseData = (EndQuorumEpochResponseData)responseData;
            voteResponse = new EndQuorumEpochResponse(endQuorumEpochResponseData);
        } else if (responseData instanceof FetchResponseData) {
            FetchResponseData fetchResponseData = (FetchResponseData)responseData;
            voteResponse = new FetchResponse(fetchResponseData);
        } else {
            throw new IllegalArgumentException(new StringBuilder(34).append("Unexpected type for responseData: ").append(responseData).toString());
        }
        return voteResponse;
    }

    public static final /* synthetic */ void $anonfun$testSendAndDisconnect$1(KafkaNetworkChannelTest $this, Node destinationNode$1, int destinationId$1, ApiKeys apiKey) {
        AbstractResponse response = $this.buildResponse($this.buildTestErrorResponse(apiKey, Errors.INVALID_REQUEST));
        $this.client().prepareResponseFrom(response, destinationNode$1, true);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$1, Errors.BROKER_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$testSendAndFailAuthentication$1(KafkaNetworkChannelTest $this, Node destinationNode$2, int destinationId$2, ApiKeys apiKey) {
        $this.client().createPendingAuthenticationError(destinationNode$2, 100L);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$2, Errors.NETWORK_EXCEPTION);
        $this.client().reset();
    }

    public static final /* synthetic */ void $anonfun$testSendAndReceiveOutboundRequest$1(KafkaNetworkChannelTest $this, Node destinationNode$3, int destinationId$4, ApiKeys apiKey) {
        Errors expectedError = Errors.INVALID_REQUEST;
        AbstractResponse response = $this.buildResponse($this.buildTestErrorResponse(apiKey, expectedError));
        $this.client().prepareResponseFrom(response, destinationNode$3);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$4, expectedError);
    }

    public static final /* synthetic */ void $anonfun$testUnsupportedVersionError$1(KafkaNetworkChannelTest $this, int destinationId$5, ApiKeys apiKey) {
        $this.client().prepareUnsupportedVersionResponse(request -> {
            ApiKeys apiKeys = request.apiKey();
            return !(apiKeys != null ? !apiKeys.equals(apiKey) : apiKey != null);
        });
        $this.sendAndAssertErrorResponse(apiKey, destinationId$5, Errors.UNSUPPORTED_VERSION);
    }

    public static final /* synthetic */ void $anonfun$buildTestRequest$1(FetchRequestData.FetchPartition fetchPartition) {
        fetchPartition.setCurrentLeaderEpoch(5).setFetchOffset(333L).setLastFetchedEpoch(5);
    }

    public KafkaNetworkChannelTest() {
        this.clusterId = "clusterId";
        this.requestTimeoutMs = 30000;
    }

    private static class StubMetadataUpdater
    implements MockClient.MockMetadataUpdater {
        public void updateWithCurrentMetadata(Time x$1) {
            super.updateWithCurrentMetadata(x$1);
        }

        public void close() {
            super.close();
        }

        public List<Node> fetchNodes() {
            return Collections.emptyList();
        }

        public boolean isUpdateNeeded() {
            return false;
        }

        public void update(Time time, MockClient.MetadataUpdate update) {
        }
    }
}

