/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002B\u0002\u0012\u0001A\u0003%q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u00036\u0001\u0011\u0005A\u0005C\u00038\u0001\u0011\u0005A\u0005C\u0003:\u0001\u0011\u0005A\u0005C\u0003<\u0001\u0011\u0005A\u0005C\u0003>\u0001\u0011\u0005A\u0005C\u0003@\u0001\u0011\u0005A\u0005C\u0003B\u0001\u0011\u0005AE\u0001\u0013D_:$(o\u001c7mKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]Z\u000bG.\u001b3bi>\u0014H+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001\nm\u0006d\u0017\u000eZ1u_J,\u0012a\b\t\u00039\u0001J!!I\u0007\u0003A\r{g\u000e\u001e:pY2,'oQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN]\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u0004\u0013A\t;fgR$UMZ1vYR$v\u000e]5d%\u0016\u001cx.\u001e:dK&\u001b(+\u001a6fGR,G\rF\u0001&!\t!b%\u0003\u0002(+\t!QK\\5uQ\t!\u0011\u0006\u0005\u0002+g5\t1F\u0003\u0002-[\u0005\u0019\u0011\r]5\u000b\u00059z\u0013a\u00026va&$XM\u001d\u0006\u0003aE\nQA[;oSRT\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b,\u0005\u0011!Vm\u001d;\u00029Q,7\u000f^%om\u0006d\u0017\u000e\u001a+pa&\u001cg*Y7f%\u0016TWm\u0019;fI\"\u0012Q!K\u0001\u0018i\u0016\u001cH/\u00168l]><hNU3t_V\u00148-\u001a+za\u0016D#AB\u0015\u00021Q,7\u000f\u001e(vY2$v\u000e]5d\u0007>tg-[4WC2,X\r\u000b\u0002\bS\u0005!B/Z:u-\u0006d\u0017\u000e\u001a+pa&\u001c7i\u001c8gS\u001eD#\u0001C\u0015\u0002-Q,7\u000f^%om\u0006d\u0017\u000e\u001a+pa&\u001c7i\u001c8gS\u001eD#!C\u0015\u0002/Q,7\u000f^%om\u0006d\u0017\u000e\u001a\"s_.,'/\u00128uSRL\bF\u0001\u0006*\u0003m!Xm\u001d;J]Z\fG.\u001b3OK\u001e\fG/\u001b<f\u0005J|7.\u001a:JI\"\u00121\"\u000b")
public class ControllerConfigurationValidatorTest {
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator();

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (Map)config)).getMessage());
    }
}

