/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.server.MockBrokerToControllerChannelManager$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019\t\u0005\u0001)A\u0005m!9!\t\u0001b\u0001\n\u0013\u0019\u0005BB$\u0001A\u0003%A\tC\u0004I\u0001\t\u0007I\u0011B%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u001dq\u0005A1A\u0005\n=Caa\u0015\u0001!\u0002\u0013\u0001\u0006b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u0007A\u0002\u0001\u000b\u0011\u0002,\t\u000b\u0005\u0004A\u0011\u00022\t\u000b\u0019\u0004A\u0011B4\t\u000b-\u0004A\u0011B4\t\u000b1\u0004A\u0011A7\t\u000bq\u0004A\u0011A7\t\u000by\u0004A\u0011A7\t\r\u0005\u0005\u0001\u0001\"\u0001n\u0011\u0019\t)\u0001\u0001C\u0001[\"1\u0011\u0011\u0002\u0001\u0005\u00025Dq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002\u000e\u0001!I!a\u0012\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x\t)bi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:UKN$(B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005!A/[7f+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001e\u0003\u0015)H/\u001b7t\u0013\t\u0011tF\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019\u0019G.[3oiV\ta\u0007\u0005\u00028\u007f5\t\u0001H\u0003\u0002:u\u000591\r\\5f]R\u001c(B\u0001\u0010<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001C$AC'pG.\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013AF2p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0016\u0003\u0011\u0003\"AK#\n\u0005\u0019[\"AF\"p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0002/\r|g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\u0004\u0013A\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ,\u0012A\u0013\t\u0003U-K!\u0001T\u000e\u0003I5{7m\u001b\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f1C\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u0002\n\u0011CZ8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s+\u0005\u0001\u0006C\u0001\u0016R\u0013\t\u00116DA\u000bG_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJLU\u000e\u001d7\u0002%\u0019|'o^1sI&tw-T1oC\u001e,'\u000fI\u0001\u0011aJLgnY5qC2\u0014U/\u001b7eKJ,\u0012A\u0016\t\u0003/zk\u0011\u0001\u0017\u0006\u00033j\u000bQ\"Y;uQ\u0016tG/[2bi>\u0014(BA.]\u0003!\u0019XmY;sSRL(BA/;\u0003\u0019\u0019w.\\7p]&\u0011q\f\u0017\u0002\u001d\t\u00164\u0017-\u001e7u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s\u0003E\u0001(/\u001b8dSB\fGNQ;jY\u0012,'\u000fI\u0001\u0016G>tGO]8mY\u0016\u0014\u0018\t]5WKJ\u001c\u0018n\u001c8t+\u0005\u0019\u0007CA\u001ce\u0013\t)\u0007HA\bO_\u0012,\u0017\t]5WKJ\u001c\u0018n\u001c8t\u00039\u0019wN\u001c;s_2dWM]%oM>,\u0012\u0001\u001b\t\u0003U%L!A[\u000e\u0003+\r{g\u000e\u001e:pY2,'/\u00138g_Jl\u0017\r^5p]\u0006\u0019R-\u001c9us\u000e{g\u000e\u001e:pY2,'/\u00138g_\u0006\tC/Z:u%\u0016\u001c\bo\u001c8tK\u000e{'O]3mCRLwN\\%e\u001b&\u001cX.\u0019;dQR\ta\u000e\u0005\u0002#_&\u0011\u0001o\t\u0002\u0005+:LG\u000f\u000b\u0002\u0012eB\u00111O_\u0007\u0002i*\u0011QO^\u0001\u0004CBL'BA<y\u0003\u001dQW\u000f]5uKJT!!_\u001f\u0002\u000b),h.\u001b;\n\u0005m$(\u0001\u0002+fgR\fq\u0003^3tiVs7/\u001e9q_J$X\r\u001a,feNLwN\\:)\u0005I\u0011\u0018A\r;fgR4uN]<be\u0012Lgn\u001a+j[\u0016|W\u000f^,bSRLgn\u001a$pe\u000e{g\u000e\u001e:pY2,'\u000fR5tG>4XM]=)\u0005M\u0011\u0018a\b;fgR4uN]<be\u0012Lgn\u001a+j[\u0016|W\u000f^!gi\u0016\u0014(+\u001a;ss\"\u0012AC]\u0001(i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u001a\u0013x.\u001c(fi^|'o[\"mS\u0016tG\u000f\u000b\u0002\u0016e\u0006AB/Z:u\r\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8)\u0005Y\u0011\u0018\u0001\u00042vS2$'+Z9vKN$HCBA\t\u0003g\ti\u0004E\u0004#\u0003'\t9\"a\t\n\u0007\u0005U1E\u0001\u0004UkBdWM\r\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004/\u0002\u0011I,\u0017/^3tiNLA!!\t\u0002\u001c\ti!+Z9vKN$\b*Z1eKJ\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0002oS>T!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t9C\u0001\u0006CsR,')\u001e4gKJDq!!\u000e\u0018\u0001\u0004\t9$\u0001\u0003c_\u0012L\b\u0003BA\r\u0003sIA!a\u000f\u0002\u001c\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002@]\u0001\r!!\u0011\u0002\u001b\r|'O]3mCRLwN\\%e!\r\u0011\u00131I\u0005\u0004\u0003\u000b\u001a#aA%oiRA\u0011\u0011JA/\u0003C\n)\u0007\u0005\u0003\u0002L\u0005]c\u0002BA'\u0003'j!!a\u0014\u000b\u0007\u0005ES$A\u0004oKR<xN]6\n\t\u0005U\u0013qJ\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\tI&a\u0017\u0003\u000fI+\u0017/^3ti*!\u0011QKA(\u0011\u001d\ty\u0006\u0007a\u0001\u0003/\tQB]3rk\u0016\u001cH\u000fS3bI\u0016\u0014\bbBA21\u0001\u0007\u00111E\u0001\u000ee\u0016\fX/Z:u\u0005V4g-\u001a:\t\u000f\u0005\u001d\u0004\u00041\u0001\u0002j\u0005I\u0001O]5oG&\u0004\u0018\r\u001c\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e.\u0002\t\u0005,H\u000f[\u0005\u0005\u0003g\niG\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002-Q,7\u000f^!mi\u0016\u00148i\u001c8gS\u001e\u0014V-];fgR,\"!!\u001f\u0011\t\u0005e\u00111P\u0005\u0005\u0003{\nYBA\nBYR,'oQ8oM&<7OU3rk\u0016\u001cH\u000f")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockBrokerToControllerChannelManager brokerToController = new MockBrokerToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((BrokerToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockBrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava()));
    }

    private ControllerInformation controllerInfo() {
        return new ControllerInformation((Option)new Some((Object)new Node(0, "host", 1234)), new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    private ControllerInformation emptyControllerInfo() {
        return new ControllerInformation((Option)None$.MODULE$, new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)requestHeader2, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().createPendingAuthenticationError((Node)this.controllerInfo().node().get(), 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }
}

