/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\u001d4A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)q\b\u0001C\u0001\u0001\n\u00013*\u00194lCN+'O^3s\u0017J\u000bg\r\u001e*fO&\u001cHO]1uS>tG+Z:u\u0015\t1q!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0011\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\f!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011!B\u0001\u001ci\u0016\u001cHOU3hSN$XM\u001d.l\u0005J|7.\u001a:J].\u0013\u0018M\u001a;\u0015\u0005]Q\u0002C\u0001\u0007\u0019\u0013\tIRB\u0001\u0003V]&$\b\"B\u000e\u0003\u0001\u0004a\u0012!\u0003>l\u00072,8\u000f^3s!\ti\u0002%D\u0001\u001f\u0015\tyr!\u0001\u0003uKN$\u0018BA\u0011\u001f\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0007\u0006\u0003\u0002$S)z\u0003'\r\u001a\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019r\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001&\n\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/A\u0006dYV\u001cH/\u001a:UsB,G%A\u0016\n\u00051j\u0013A\u0001.L\u0015\tqS%\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0007\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000eJ\u00014\u0013\t!T'A\u0006J\u0005B{6g\u0018\u001b`\u0013Z\u0003$B\u0001\u001c8\u0003=iU\r^1eCR\fg+\u001a:tS>t'B\u0001\u001d:\u0003\u0019\u0019w.\\7p]*\u0011aA\u000f\u0006\u0003\u0011mR!\u0001P\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0014aA8sO\u0006AC/Z:u%\u0016\u001cH/\u0019:u\u001f2$\u0017J\u00199[W\n\u0013xn[3s\u0013:l\u0015n\u001a:bi&|g.T8eKR\u0011q#\u0011\u0005\u00067\r\u0001\r\u0001\b\u0015\t\u0007\rJ#f\f\u00192\u0007\u0012\nA)\u0003\u0002Fk\u0005Y\u0011J\u0011)`g}\u001bt,\u0013,1Q\u0011\u0001qi\u0015+\u0011\u0005!\u000bV\"A%\u000b\u0005)[\u0015!C3yi\u0016t7/[8o\u0015\taU*A\u0002ba&T!AT(\u0002\u000f),\b/\u001b;fe*\u0011\u0001+P\u0001\u0006UVt\u0017\u000e^\u0005\u0003%&\u0013!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\u0005)6%\u0001,\u0011\u0005]KV\"\u0001-\u000b\u0005As\u0012B\u0001.Y\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]NDC\u0001\u0001/TAB\u0011QLX\u0007\u0002\u0017&\u0011ql\u0013\u0002\u0004)\u0006<\u0017%A1\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\u0005\u0001\r\u001cf\r\u0005\u0002^I&\u0011Qm\u0013\u0002\b)&lWm\\;u=\u0005A\b")
public class KafkaServerKRaftRegistrationTest {
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testRegisterZkBrokerInKraft(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            try {
                readyFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                Assertions.fail((String)"Did not see 3 brokers within 30 seconds");
            }
            catch (Throwable t) {
                Assertions.fail((String)"Had some other error waiting for brokers", (Throwable)t);
            }
        }
        finally {
            zkCluster.stop();
            kraftCluster.close();
        }
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testRestartOldIbpZkBrokerInMigrationMode(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            Assertions.assertThrows(IllegalArgumentException.class, () -> zkCluster.rollingBrokerRestart());
        }
        finally {
            zkCluster.stop();
            kraftCluster.close();
        }
    }
}

