/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayDeque;
import java.util.Iterator;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.MockBrokerToControllerChannelManager$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\r\u001b\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005Y!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u00111\u0003!\u0011!Q\u0001\n%C\u0001\"\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0013\")q\n\u0001C\u0001!\"9\u0001\f\u0001b\u0001\n\u0013I\u0006BB3\u0001A\u0003%!\fC\u0003g\u0001\u0011\u0005s\rC\u0003l\u0001\u0011\u0005s\rC\u0003m\u0001\u0011\u0005S\u000e\u0003\u0004D\u0001\u0011\u0005\u00131\u0004\u0005\t\u0003G\u0001A\u0011\u0001\u000e\u0002&!1\u0011Q\u0007\u0001\u0005\u0002\u001d<\u0011\"a\u000e\u001b\u0003\u0003E\t!!\u000f\u0007\u0011eQ\u0012\u0011!E\u0001\u0003wAaa\u0014\u000b\u0005\u0002\u0005u\u0002\"CA )E\u0005I\u0011AA!\u0011%\t9\u0006FI\u0001\n\u0003\tI\u0006C\u0005\u0002^Q\t\n\u0011\"\u0001\u0002Z\t!Sj\\2l\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'O\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dBS\"\u0001\u000e\n\u0005%R\"\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faa\u00197jK:$X#\u0001\u0017\u0011\u00055*T\"\u0001\u0018\u000b\u0005=\u0002\u0014aB2mS\u0016tGo\u001d\u0006\u0003;ER!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO&\u0011aG\f\u0002\u000b\u001b>\u001c7n\u00117jK:$\u0018aB2mS\u0016tG\u000fI\u0001\u0005i&lW\r\u0005\u0002;{5\t1H\u0003\u0002=9\u0005)Q\u000f^5mg&\u0011ah\u000f\u0002\t\u001b>\u001c7\u000eV5nK\u000612m\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'\u000f\u0005\u0002(\u0003&\u0011!I\u0007\u0002\u0017\u0007>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3fe\u0006)2m\u001c8ue>dG.\u001a:Ba&4VM]:j_:\u001c\bCA\u0017F\u0013\t1eFA\bO_\u0012,\u0017\t]5WKJ\u001c\u0018n\u001c8t\u00039\u0011X\r\u001e:z)&lWm\\;u\u001bN,\u0012!\u0013\t\u0003C)K!a\u0013\u0012\u0003\u0007%sG/A\bsKR\u0014\u0018\u0010V5nK>,H/T:!\u0003A\u0011X-];fgR$\u0016.\\3pkRl5/A\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0002\na\u0001P5oSRtDcB)S'R+fk\u0016\t\u0003O\u0001AQA\u000b\u0006A\u00021BQ\u0001\u000f\u0006A\u0002eBQa\u0010\u0006A\u0002\u0001Cqa\u0011\u0006\u0011\u0002\u0003\u0007A\tC\u0004H\u0015A\u0005\t\u0019A%\t\u000f5S\u0001\u0013!a\u0001\u0013\u0006YQO\\:f]R\fV/Z;f+\u0005Q\u0006cA.aE6\tAL\u0003\u0002^=\u0006!Q\u000f^5m\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\u0015\u0005\u0013(/Y=EKF,X\r\u0005\u0002(G&\u0011AM\u0007\u0002\u001c\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'/U;fk\u0016LE/Z7\u0002\u0019Ut7/\u001a8u#V,W/\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0003!\u0004\"!I5\n\u0005)\u0014#\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003i]\u0006E\u0001\"B8\u0010\u0001\u0004\u0001\u0018a\u0002:fcV,7\u000f\u001e\u0019\u0003c~\u00042A\u001d>~\u001d\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0005sKF,Xm\u001d;t\u0015\t9\b'\u0001\u0004d_6lwN\\\u0005\u0003sR\fq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0003wr\u0014qAQ;jY\u0012,'O\u0003\u0002ziB\u0011ap \u0007\u0001\t-\t\tA\\A\u0001\u0002\u0003\u0015\t!a\u0001\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0006\u0005-\u0001cA\u0011\u0002\b%\u0019\u0011\u0011\u0002\u0012\u0003\u000f9{G\u000f[5oOB\u00191/!\u0004\n\u0007\u0005=AOA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011\u001d\t\u0019b\u0004a\u0001\u0003+\t\u0001bY1mY\n\f7m\u001b\t\u0004O\u0005]\u0011bAA\r5\t\u00113i\u001c8ue>dG.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ$\"!!\b\u0011\t\u0005\ny\u0002R\u0005\u0004\u0003C\u0011#AB(qi&|g.\u0001\biC:$G.\u001a*fgB|gn]3\u0015\t\u0005\u001d\u00121\u0007\u000b\u0004Q\u0006%\u0002bBA\u0016#\u0001\u0007\u0011QF\u0001\te\u0016\u001c\bo\u001c8tKB\u0019Q&a\f\n\u0007\u0005EbF\u0001\bDY&,g\u000e\u001e*fgB|gn]3\t\u000b=\f\u0002\u0019\u00012\u0002\tA|G\u000e\\\u0001%\u001b>\u001c7N\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011q\u0005F\n\u0003)\u0001\"\"!!\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019EK\u0002E\u0003\u000bZ#!a\u0012\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#\u0012\u0013AC1o]>$\u0018\r^5p]&!\u0011QKA&\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005m#fA%\u0002F\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\u0002")
public class MockBrokerToControllerChannelManager
implements BrokerToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ArrayDeque<BrokerToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$4();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private ArrayDeque<BrokerToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new BrokerToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Option<NodeApiVersions> controllerApiVersions() {
        return new Some((Object)this.controllerApiVersions);
    }

    public void handleResponse(BrokerToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<BrokerToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            BrokerToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.getControllerInfo().node();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public MockBrokerToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ArrayDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

