/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.RawMetaProperties;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!B\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0016\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0004\"\u0003 \u0001\u0001\u0004\u0005\t\u0015)\u0003-\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005E\u0001\u0001\u0007\t\u0019!C\u0001\u000b\"Iq\t\u0001a\u0001\u0002\u0003\u0006K!\u0011\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\u0002-B\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001&\t\u00131\u0003\u0001\u0019!A!B\u0013a\u0003\"C'\u0001\u0001\u0004\u0005\r\u0011\"\u0001A\u0011%q\u0005\u00011AA\u0002\u0013\u0005q\nC\u0005R\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006B\u0002.\u0001A\u0003%A\u000bC\u0004\\\u0001\u0001\u0007I\u0011\u0001/\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"1\u0011\u000e\u0001Q!\nuCQA\u001b\u0001\u0005B-DQA \u0001\u0005B}Da!!\u0003\u0001\t\u0003y\bBBA\n\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\u0018\u0001!\ta \u0005\u0007\u00037\u0001A\u0011A@\t\r\u0005}\u0001\u0001\"\u0001\u0000\u0011\u0019\t\u0019\u0003\u0001C\u0001\u007f\"9\u0011q\u0005\u0001\u0005\u0002\u0005%\"AG*feZ,'oR3oKJ\fG/\u001a\"s_.,'/\u00133UKN$(B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013&\u001b\u0005i\u0012B\u0001\u0014\u001e\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"\u0001\n\u0001\u0002\rA\u0014x\u000e]:2+\u0005a\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011)H/\u001b7\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00039s_B\u001c\u0018g\u0018\u0013fcR\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000fC\u0004>\u0007\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0013'A\u0004qe>\u00048/\r\u0011\u0002\u000f\r|gNZ5hcU\t\u0011\t\u0005\u0002%\u0005&\u00111)\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006d_:4\u0017nZ\u0019`I\u0015\fHC\u0001\u001cG\u0011\u001did!!AA\u0002\u0005\u000b\u0001bY8oM&<\u0017\u0007I\u0001\u0007aJ|\u0007o\u001d\u001a\u0002\u0015A\u0014x\u000e]:3?\u0012*\u0017\u000f\u0006\u00027\u0017\"9Q(CA\u0001\u0002\u0004a\u0013a\u00029s_B\u001c(\u0007I\u0001\bG>tg-[43\u0003-\u0019wN\u001c4jOJzF%Z9\u0015\u0005Y\u0002\u0006bB\u001f\r\u0003\u0003\u0005\r!Q\u0001\tG>tg-[43A\u0005\u0019\"M]8lKJlU\r^1Qe>\u00048OR5mKV\tA\u000b\u0005\u0002V16\taK\u0003\u0002Xa\u0005!A.\u00198h\u0013\tIfK\u0001\u0004TiJLgnZ\u0001\u0015EJ|7.\u001a:NKR\f\u0007K]8qg\u001aKG.\u001a\u0011\u0002\u000fM,'O^3sgV\tQ\fE\u0002_C\u000el\u0011a\u0018\u0006\u0003Ab\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011wLA\u0002TKF\u0004\"\u0001\n3\n\u0005\u0015l\"aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011a\u0007\u001b\u0005\b{E\t\t\u00111\u0001^\u0003!\u0019XM\u001d<feN\u0004\u0013!B:fiV\u0003HC\u0001\u001cm\u0011\u0015i7\u00031\u0001o\u0003!!Xm\u001d;J]\u001a|\u0007CA8y\u001b\u0005\u0001(BA9s\u0003\r\t\u0007/\u001b\u0006\u0003gR\fqA[;qSR,'O\u0003\u0002vm\u0006)!.\u001e8ji*\tq/A\u0002pe\u001eL!!\u001f9\u0003\u0011Q+7\u000f^%oM>D#aE>\u0011\u0005=d\u0018BA?q\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\ta\u0007K\u0002\u0015\u0003\u0007\u00012a\\A\u0003\u0013\r\t9\u0001\u001d\u0002\n\u0003\u001a$XM]#bG\"\f\u0001\u0004^3ti\u0006+Ho\\$f]\u0016\u0014\u0018\r^3Ce>\\WM]%eQ\r)\u0012Q\u0002\t\u0004_\u0006=\u0011bAA\ta\n!A+Z:u\u0003\t\"Xm\u001d;Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ$f]\u0016\u0014\u0018\r^3e\u0005J|7.\u001a:JI\"\u001aa#!\u0004\u00029Q,7\u000f\u001e#jg\u0006\u0014G.Z$f]\u0016\u0014\u0018\r^3e\u0005J|7.\u001a:JI\"\u001aq#!\u0004\u00029Q,7\u000f^'vYRL\u0007\u000f\\3M_\u001e$\u0015N]:NKR\f\u0007K]8qg\"\u001a\u0001$!\u0004\u0002aQ,7\u000f^\"p]NL7\u000f^3oi\n\u0013xn[3s\u0013\u00124%o\\7Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ'fi\u0006\u0004&o\u001c9tQ\rI\u0012QB\u0001 i\u0016\u001cHO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00148JI\u000e{G\u000e\\5tS>t\u0007f\u0001\u000e\u0002\u000e\u0005!b/\u001a:jMf\u0014%o\\6fe6+G/\u00193bi\u0006$b!a\u000b\u00022\u0005-\u0003cA\u001c\u0002.%\u0019\u0011q\u0006\u001d\u0003\u000f\t{w\u000e\\3b]\"9\u00111G\u000eA\u0002\u0005U\u0012a\u00027pO\u0012K'o\u001d\t\u0005=\u0006\f9\u0004\u0005\u0003\u0002:\u0005\u001dc\u0002BA\u001e\u0003\u0007\u00022!!\u00109\u001b\t\tyDC\u0002\u0002B\u0005\na\u0001\u0010:p_Rt\u0014bAA#q\u00051\u0001K]3eK\u001aL1!WA%\u0015\r\t)\u0005\u000f\u0005\b\u0003\u001bZ\u0002\u0019AA(\u0003!\u0011'o\\6fe&#\u0007cA\u001c\u0002R%\u0019\u00111\u000b\u001d\u0003\u0007%sG\u000f")
public class ServerGenerateBrokerIdTest
extends QuorumTestHarness {
    private Properties props1;
    private KafkaConfig config1;
    private Properties props2;
    private KafkaConfig config2;
    private final String brokerMetaPropsFile;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateBrokerId() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$12 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$12, x$3, x$2, x$4);
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server2 = new KafkaServer(x$5, x$7, x$6, x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(props3);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$122 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server3 = new KafkaServer(x$9, x$11, x$10, x$122);
        server1.startup();
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server2.startup();
        Assertions.assertEquals((int)server2.config().brokerId(), (int)0);
        server3.startup();
        Assertions.assertEquals((int)server3.config().brokerId(), (int)1002);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testDisableGeneratedBrokerId() {
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        KafkaServer server3 = TestUtils$.MODULE$.createServer(config3, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server3, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server3.config().brokerId(), (int)3);
        server3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testBrokerMetadataOnIdCollision() {
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        KafkaServer serverA = TestUtils$.MODULE$.createServer(configA, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer serverB = new KafkaServer(configB, x$3, x$2, x$4);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> serverB.startup());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)Nil$.MODULE$));
        serverB.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$2(this, logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer newServerB = TestUtils$.MODULE$.createServer(newConfigB, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)new .colon.colon((Object)newServerB, (List)Nil$.MODULE$)));
        serverA.shutdown();
        newServerB.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(this, brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$2(ServerGenerateBrokerIdTest $this, String logDir) {
        Assertions.assertFalse((boolean)new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString()).exists());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateBrokerIdTest $this, int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            Properties properties = (Properties)((Some)brokerMetadataOpt).value();
            if (new RawMetaProperties(properties).brokerId().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != brokerId$1)) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
        } else {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public ServerGenerateBrokerIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

