/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.TestUtils$;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0001a3Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C!)!\u0006\u0001C\u0001W!)A\b\u0001C\u0001W!)a\b\u0001C\u0001W!)\u0001\t\u0001C\u0001W!)!\t\u0001C\u0001W!)A\t\u0001C\u0001W!)a\t\u0001C\u0001W!)\u0001\n\u0001C\u0001W!)!\n\u0001C\u0001W!)A\n\u0001C\u0001W!)a\n\u0001C\u0001W!)\u0001\u000b\u0001C\u0001W\ty1\u000b^8sC\u001e,Gk\\8m)\u0016\u001cHO\u0003\u0002\u0012%\u0005)Ao\\8mg*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002!\u0005Ab.Z<TK24W*\u00198bO\u0016$\u0007K]8qKJ$\u0018.Z:\u0015\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0006Qe>\u0004XM\u001d;jKN\f!\u0004^3ti\u000e{gNZ5h)>dun\u001a#je\u0016\u001cGo\u001c:jKN$\u0012\u0001\f\t\u0003/5J!A\f\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007A\u0002\"!\r\u001e\u000e\u0003IR!a\r\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00026m\u00059!.\u001e9ji\u0016\u0014(BA\u001c9\u0003\u0015QWO\\5u\u0015\u0005I\u0014aA8sO&\u00111H\r\u0002\u0005)\u0016\u001cH/\u0001\u0015uKN$8i\u001c8gS\u001e$v\u000eT8h\t&\u0014Xm\u0019;pe&,7oV5uQ6+G/\u0019'pO\u0012K'\u000f\u000b\u0002\u0005a\u0005yB/Z:u\u0013:4wnQ8n[\u0006tGm\u00148F[B$\u0018\u0010R5sK\u000e$xN]=)\u0005\u0015\u0001\u0014!\t;fgRLeNZ8D_6l\u0017M\u001c3P]6K7o]5oO\u0012K'/Z2u_JL\bF\u0001\u00041\u0003\u0001\"Xm\u001d;J]\u001a|7i\\7nC:$wJ\u001c#je\u0016\u001cGo\u001c:z\u0003N4\u0015\u000e\\3)\u0005\u001d\u0001\u0014a\n;fgRLeNZ8XSRDW*[:nCR\u001c\u0007.\u001a3MK\u001e\f7-_&bM.\f7i\u001c8gS\u001eD#\u0001\u0003\u0019\u0002YQ,7\u000f^%oM><\u0016\u000e\u001e5NSNl\u0017\r^2iK\u0012\u001cV\r\u001c4NC:\fw-\u001a3LC\u001a\\\u0017mQ8oM&<\u0007FA\u00051\u0003a!Xm\u001d;G_Jl\u0017\r^#naRLH)\u001b:fGR|'/\u001f\u0015\u0003\u0015A\na\u0004^3ti\u001a{'/\\1u/&$\b.\u00138wC2LGm\u00117vgR,'/\u00133)\u0005-\u0001\u0014A\u0007;fgR$UMZ1vYRlU\r^1eCR\fg+\u001a:tS>t\u0007F\u0001\u00071\u0003u!Xm\u001d;D_:4\u0017nZ;sK\u0012lU\r^1eCR\fg+\u001a:tS>t\u0007FA\u00071\u0003a!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o\r2\fwm\u001d\u0015\u0003\u001dABC\u0001A*W/B\u0011\u0011\u0007V\u0005\u0003+J\u0012q\u0001V5nK>,H/A\u0003wC2,XMH\u0001)\u0001")
public class StorageToolTest {
    /*
     * WARNING - void declaration
     */
    private Properties newSelfManagedProperties() {
        void var1_1;
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo,/tmp/bar");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        return var1_1;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils$.MODULE$.tempFile();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(235).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedSelfManagedKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatEmptyDirectory() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            MetaProperties metaProperties = new MetaProperties("XcZZOzUqS4yHOjhMQB6JLQ", 2);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, MetadataVersion.latest(), false));
            Assertions.assertTrue((boolean)stream.toString().startsWith(new StringOps(Predef$.MODULE$.augmentString("Formatting %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempDir}))));
            try {
                Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(new ByteArrayOutputStream()), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, MetadataVersion.latest(), false));
            }
            catch (TerseFailure e) {
                Assertions.assertEquals((Object)new StringBuilder(107).append("Log directory ").append(tempDir).append(" is already ").append("formatted. Use --ignore-formatted to ignore this directory and format the ").append("others.").toString(), (Object)e.getMessage());
            }
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream2), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, MetadataVersion.latest(), true));
            Assertions.assertEquals((Object)new StringOps(Predef$.MODULE$.augmentString("All of the log directories are already formatted.%n")).format((Seq)Nil$.MODULE$), (Object)stream2.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatWithInvalidClusterId() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)"Cluster ID string invalid does not appear to be a valid UUID: Input string `invalid` decoded as 5 bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.buildMetadataProperties("invalid", config)).getMessage());
    }

    @Test
    public void testDefaultMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
        Assertions.assertEquals((short)MetadataVersion.latest().featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be the latest version");
    }

    @Test
    public void testConfiguredMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)new Some((Object)MetadataVersion.IBP_3_3_IV2.toString()));
        Assertions.assertEquals((short)MetadataVersion.IBP_3_3_IV2.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be 3.3-IV2");
    }

    @Test
    public void testMetadataVersionFlags() {
        MetadataVersion mv = StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0"}));
        Assertions.assertEquals((Object)"3.0", (Object)mv.shortVersion());
        mv = StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0-IV1"}));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)mv);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "0.0"})));
    }

    private static final MetadataVersion parseMetadataVersion$1(Seq strings) {
        scala.collection.mutable.Seq args = (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (scala.collection.mutable.Seq)args.$plus$plus((GenTraversableOnce)strings, Seq$.MODULE$.canBuildFrom());
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
    }
}

