/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ZkFourLetterWords$;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d4AAE\n\u00011!)Q\u0006\u0001C\u0001]!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004B\u0002\u001c\u0001A\u0003%1\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u001a\t\ra\u0002\u0001\u0015!\u00034\u0011\u001dI\u0004A1A\u0005\u0002iBa!\u0011\u0001!\u0002\u0013Y\u0004b\u0002\"\u0001\u0005\u0004%\ta\u0011\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002#\t\u000fA\u0003!\u0019!C\u0001#\"1Q\u000b\u0001Q\u0001\nICqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0001;\u0011\u0019\u0001\u0007\u0001)A\u0005w!)\u0011\r\u0001C\u0001E\")a\r\u0001C!E\n\tR)\u001c2fI\u0012,GMW8pW\u0016,\u0007/\u001a:\u000b\u0005Q)\u0012A\u0001>l\u0015\u00051\u0012!B6bM.\f7\u0001A\n\u0005\u0001e\ts\u0005\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005!A.\u00198h\u0015\u0005q\u0012\u0001\u00026bm\u0006L!\u0001I\u000e\u0003\r=\u0013'.Z2u!\t\u0011S%D\u0001$\u0015\t!S$\u0001\u0002j_&\u0011ae\t\u0002\n\u00072|7/Z1cY\u0016\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000b\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003M\t1b\u001d8baNDw\u000e\u001e#jeV\t1\u0007\u0005\u0002#i%\u0011Qg\t\u0002\u0005\r&dW-\u0001\u0007t]\u0006\u00048\u000f[8u\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003!!\u0018nY6US6,W#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u0007%sG/A\u0005uS\u000e\\G+[7fA\u0005I!p\\8lK\u0016\u0004XM]\u000b\u0002\tB\u0011Q)T\u0007\u0002\r*\u0011q\tS\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\tK%B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!A\u0014$\u0003\u001fi{wnS3fa\u0016\u00148+\u001a:wKJ\f!B_8pW\u0016,\u0007/\u001a:!\u0003\u001d1\u0017m\u0019;pef,\u0012A\u0015\t\u0003\u000bNK!\u0001\u0016$\u0003)9KujU3sm\u0016\u00148I\u001c=o\r\u0006\u001cGo\u001c:z\u0003!1\u0017m\u0019;pef\u0004\u0013\u0001B1eIJ,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037v\t1A\\3u\u0013\ti&LA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\fQ!\u00193ee\u0002\nA\u0001]8si\u0006)\u0001o\u001c:uA\u0005A1\u000f[;uI><h\u000eF\u0001d!\taD-\u0003\u0002f{\t!QK\\5u\u0003\u0015\u0019Gn\\:f\u0001")
public class EmbeddedZookeeper
implements Closeable,
Logging {
    private final File snapshotDir;
    private final File logDir;
    private final int tickTime;
    private final ZooKeeperServer zookeeper;
    private final NIOServerCnxnFactory factory;
    private final InetSocketAddress addr;
    private final int port;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File snapshotDir() {
        return this.snapshotDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public int tickTime() {
        return this.tickTime;
    }

    public ZooKeeperServer zookeeper() {
        return this.zookeeper;
    }

    public NIOServerCnxnFactory factory() {
        return this.factory;
    }

    private InetSocketAddress addr() {
        return this.addr;
    }

    public int port() {
        return this.port;
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.factory().shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        package$.MODULE$.Iterator().continually((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.isDown$1()).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)EmbeddedZookeeper.$anonfun$shutdown$3(BoxesRunTime.unboxToBoolean((Object)x))));
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zookeeper().getZKDatabase().close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        Utils.delete((File)this.logDir());
        Utils.delete((File)this.snapshotDir());
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private final boolean isDown$1() {
        try {
            ZkFourLetterWords$.MODULE$.sendStat("127.0.0.1", this.port(), 3000);
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public EmbeddedZookeeper() {
        Logging.$init$((Logging)this);
        this.snapshotDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.tickTime = 800;
        System.setProperty("zookeeper.forceSync", "no");
        this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), this.tickTime());
        this.factory = new NIOServerCnxnFactory();
        this.addr = new InetSocketAddress("127.0.0.1", TestUtils$.MODULE$.RandomPort());
        this.factory().configure(this.addr(), 0);
        this.factory().startup(this.zookeeper());
        this.port = this.zookeeper().getClientPort();
    }
}

