/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.server.ConfigType$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAdminManager$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZkMigrationClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u00048\u0001\u0001\u0006I!\r\u0005\bq\u0001\u0011\r\u0011\"\u00031\u0011\u0019I\u0004\u0001)A\u0005c!I!\b\u0001a\u0001\u0002\u0004%Ia\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\n\u0001C\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001f\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0003X\u0011%I\u0006\u00011A\u0001B\u0003&\u0011\nC\u0003[\u0001\u0011\u00053\fC\u0003m\u0001\u0011%\u0001\nC\u0003n\u0001\u0011\u0005a\u000eC\u0003t\u0001\u0011\u0005a\u000eC\u0003v\u0001\u0011\u0005a\u000eC\u0003x\u0001\u0011\u0005a\u000eC\u0003z\u0001\u0011\u0005a\u000eC\u0003|\u0001\u0011%A\u0010\u0003\u0004\u0002N\u0001!\tA\u001c\u0005\u0007\u0003#\u0002A\u0011\u00018\t\r\u0005U\u0003\u0001\"\u0001o\u0011\u0019\tI\u0006\u0001C\u0001]\"1\u0011Q\f\u0001\u0005\u00029Da!!\u0019\u0001\t\u0003q\u0007BBA3\u0001\u0011\u0005a\u000e\u0003\u0004\u0002j\u0001!\tA\u001c\u0005\u0007\u0003[\u0002A\u0011\u00018\t\r\u0005E\u0004\u0001\"\u0001o\u0005UQ6.T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e+fgRT!\u0001I\u0011\u0002\u0005i\\'\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0003Q\u0005\naa]3sm\u0016\u0014\u0018B\u0001\u0016(\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003}\ta#\u00138ji&\fGnQ8oiJ|G\u000e\\3s\u000bB|7\r[\u000b\u0002cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t\u0019\u0011J\u001c;\u0002/%s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0013!E%oSRL\u0017\r\\&SC\u001a$X\t]8dQ\u0006\u0011\u0012J\\5uS\u0006d7JU1gi\u0016\u0003xn\u00195!\u0003=i\u0017n\u001a:bi&|gn\u00117jK:$X#\u0001\u001f\u0011\u00059j\u0014B\u0001  \u0005EQ6.T5he\u0006$\u0018n\u001c8DY&,g\u000e^\u0001\u0014[&<'/\u0019;j_:\u001cE.[3oi~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"A\r\"\n\u0005\r\u001b$\u0001B+oSRDq!R\u0004\u0002\u0002\u0003\u0007A(A\u0002yIE\n\u0001#\\5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e\u0011\u0002\u001d5LwM]1uS>t7\u000b^1uKV\t\u0011\n\u0005\u0002K)6\t1J\u0003\u0002M\u001b\u0006IQ.[4sCRLwN\u001c\u0006\u0003\u001d>\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003EAS!!\u0015*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0016aA8sO&\u0011Qk\u0013\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/Z\u0001\u0013[&<'/\u0019;j_:\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002B1\"9QICA\u0001\u0002\u0004I\u0015aD7jOJ\fG/[8o'R\fG/\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005c\u0006\"B/\r\u0001\u0004q\u0016\u0001\u0003;fgRLeNZ8\u0011\u0005}3W\"\u00011\u000b\u0005\u0005\u0014\u0017aA1qS*\u00111\rZ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)'+A\u0003kk:LG/\u0003\u0002hA\nAA+Z:u\u0013:4w\u000e\u000b\u0002\rSB\u0011qL[\u0005\u0003W\u0002\u0014!BQ3g_J,W)Y2i\u0003UIg.\u001b;jC2l\u0015n\u001a:bi&|gn\u0015;bi\u0016\f!\u0003^3ti6KwM]1uK\u0016k\u0007\u000f^=[WR\t\u0011\t\u000b\u0002\u000faB\u0011q,]\u0005\u0003e\u0002\u0014A\u0001V3ti\u0006qA/Z:u\u000b6\u0004H/_,sSR,\u0007FA\bq\u0003q!Xm\u001d;Va\u0012\fG/Z#ySN$\u0018N\\4QCJ$\u0018\u000e^5p]ND#\u0001\u00059\u0002/Q,7\u000f^\"sK\u0006$XMT3x!\u0006\u0014H/\u001b;j_:\u001c\bFA\tq\u0003i!Xm\u001d;JI\u0016l\u0007o\u001c;f]R\u001c%/Z1uKR{\u0007/[2tQ\t\u0011\u0002/A\rxe&$Xm\u00117jK:$\u0018+^8uC\u0006sGMV3sS\u001aLH#D%~}\u0006\u001d\u0011\u0011BA\u0018\u0003\u000b\nI\u0005C\u0003;'\u0001\u0007A\b\u0003\u0004\u0000'\u0001\u0007\u0011\u0011A\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0011\u00079\n\u0019!C\u0002\u0002\u0006}\u0011Q\"\u00113nS:T6n\u00117jK:$\b\"B$\u0014\u0001\u0004I\u0005bBA\u0006'\u0001\u0007\u0011QB\u0001\u0007K:$\u0018\u000e^=\u0011\u0011\u0005=\u0011QCA\r\u00033i!!!\u0005\u000b\u0007\u0005M1'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0006\u0002\u0012\t\u0019Q*\u00199\u0011\t\u0005m\u0011\u0011\u0006\b\u0005\u0003;\t)\u0003E\u0002\u0002 Mj!!!\t\u000b\u0007\u0005\r2%\u0001\u0004=e>|GOP\u0005\u0004\u0003O\u0019\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(MBq!!\r\u0014\u0001\u0004\t\u0019$\u0001\u0004rk>$\u0018m\u001d\t\t\u0003\u001f\t)\"!\u0007\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012\u0001\u00027b]\u001eT!!a\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\nID\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003\u000f\u001a\u0002\u0019AA\r\u00031Q8.\u00128uSRLH+\u001f9f\u0011\u001d\tYe\u0005a\u0001\u00033\tAB_6F]RLG/\u001f(b[\u0016\fQ\u0004^3ti^\u0013\u0018\u000e^3Fq&\u001cH/\u001b8h\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0003)A\f\u0001\u0004^3ti^\u0013\u0018\u000e^3OK^\u001cE.[3oiF+x\u000e^1tQ\t)\u0002/A\ruKN$8\t\\1j[\u0006\u00137/\u001a8u\u0007>tGO]8mY\u0016\u0014\bF\u0001\fq\u0003\u0001\"Xm\u001d;Fq&\u001cH/\u001b8h\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7fe\u000ec\u0017-[7)\u0005]\u0001\u0018a\u0007;fgRtuN\\%oGJ,\u0017m]5oO.\u0013\u0016M\u001a;Fa>\u001c\u0007\u000e\u000b\u0002\u0019a\u0006)C/Z:u\u00072\f\u0017.\\!oIJ+G.Z1tK\u0016C\u0018n\u001d;j]\u001e\u001cuN\u001c;s_2dWM\u001d\u0015\u00033A\f!\u0004^3tiJ+\u0017\rZ!oI^\u0013\u0018\u000e^3Qe>$WoY3s\u0013\u0012D#A\u00079\u0002/Q,7\u000f^'jOJ\fG/\u001a+pa&\u001c7i\u001c8gS\u001e\u001c\bFA\u000eq\u0003a!Xm\u001d;Xe&$XMT3x)>\u0004\u0018nY\"p]\u001aLwm\u001d\u0015\u00039A\fQ\u0004^3ti^\u0013\u0018\u000e^3Fq&\u001cH/\u001b8h)>\u0004\u0018nY\"p]\u001aLwm\u001d\u0015\u0003;A\u0004")
public class ZkMigrationClientTest
extends QuorumTestHarness {
    private final int InitialControllerEpoch;
    private final int InitialKRaftEpoch;
    private ZkMigrationClient migrationClient;
    private ZkMigrationLeadershipState migrationState;

    private int InitialControllerEpoch() {
        return this.InitialControllerEpoch;
    }

    private int InitialKRaftEpoch() {
        return this.InitialKRaftEpoch;
    }

    private ZkMigrationClient migrationClient() {
        return this.migrationClient;
    }

    private void migrationClient_$eq(ZkMigrationClient x$1) {
        this.migrationClient = x$1;
    }

    private ZkMigrationLeadershipState migrationState() {
        return this.migrationState;
    }

    private void migrationState_$eq(ZkMigrationLeadershipState x$1) {
        this.migrationState = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.zkClient().createControllerEpochRaw(1);
        this.migrationClient_$eq(new ZkMigrationClient(this.zkClient()));
        this.migrationState_$eq(this.initialMigrationState());
        this.migrationState_$eq(this.migrationClient().getOrCreateMigrationRecoveryState(this.migrationState()));
    }

    /*
     * WARNING - void declaration
     */
    private ZkMigrationLeadershipState initialMigrationState() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = (Tuple2)this.zkClient().getControllerEpoch().get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int epoch = tuple2._1$mcI$sp();
        Stat stat = (Stat)tuple2._2();
        return new ZkMigrationLeadershipState(3000, this.InitialControllerEpoch(), 100L, this.InitialKRaftEpoch(), Time.SYSTEM.milliseconds(), -1, (int)var2_2, var3_3.getVersion());
    }

    @Test
    public void testMigrateEmptyZk() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyWrite() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.zkClient().retryMigrationRequestsUntilConnected((Seq)Nil$.MODULE$, this.migrationState());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int zkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Assertions.assertEquals((int)this.migrationState().migrationZkVersion(), (int)var2_2);
        Assertions.assertTrue((boolean)var3_3.isEmpty());
    }

    @Test
    public void testUpdateExistingPartitions() {
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment("test", (Option)new Some((Object)Uuid.randomUuid()), assignment);
        Map leaderAndIsrs = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(0, 5, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, 5, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, -1), 1))}));
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs, 0);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{1, 2}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 6, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{3}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 3, LeaderRecoveryState.RECOVERED, 7, -1))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            PartitionRegistration v = (PartitionRegistration)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
        this.migrationState_$eq(this.migrationClient().updateTopicPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)partitions)}))).asJava(), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        LeaderAndIsr partition0 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 0)).get()).leaderAndIsr();
        Assertions.assertEquals((int)1, (int)partition0.leader());
        Assertions.assertEquals((int)6, (int)partition0.leaderEpoch());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)partition0.isr());
        LeaderAndIsr partition1 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 1)).get()).leaderAndIsr();
        Assertions.assertEquals((int)3, (int)partition1.leader());
        Assertions.assertEquals((int)7, (int)partition1.leaderEpoch());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)partition1.isr());
    }

    @Test
    public void testCreateNewPartitions() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, LeaderRecoveryState.RECOVERED, 0, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            PartitionRegistration v = (PartitionRegistration)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
        this.migrationState_$eq(this.migrationClient().createTopic("test", Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        LeaderAndIsr partition0 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 0)).get()).leaderAndIsr();
        Assertions.assertEquals((int)0, (int)partition0.leader());
        Assertions.assertEquals((int)0, (int)partition0.leaderEpoch());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)partition0.isr());
        LeaderAndIsr partition1 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 1)).get()).leaderAndIsr();
        Assertions.assertEquals((int)1, (int)partition1.leader());
        Assertions.assertEquals((int)0, (int)partition1.leaderEpoch());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition1.isr());
    }

    @Test
    public void testIdempotentCreateTopics() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, LeaderRecoveryState.RECOVERED, 0, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            PartitionRegistration v = (PartitionRegistration)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
        Uuid topicId = Uuid.randomUuid();
        this.migrationState_$eq(this.migrationClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
    }

    private ZkMigrationLeadershipState writeClientQuotaAndVerify(ZkMigrationClient migrationClient, AdminZkClient adminZkClient, ZkMigrationLeadershipState migrationState, Map<String, String> entity, Map<String, Double> quotas, String zkEntityType, String zkEntityName) {
        ZkMigrationLeadershipState nextMigrationState = migrationClient.writeClientQuotas((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(entity).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotas).asJava(), migrationState);
        Map newProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(adminZkClient.fetchEntityConfig(zkEntityType, zkEntityName)).asScala());
        Assertions.assertEquals(quotas, (Object)newProps);
        return nextMigrationState;
    }

    @Test
    public void testWriteExistingClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        this.adminZkClient().changeConfigs(ConfigType$.MODULE$.User(), "user1", props);
        this.adminZkClient().changeConfigs(ConfigType$.MODULE$.User(), "user1/clients/clientA", props);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)Map$.MODULE$.empty(), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)3, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)4, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testWriteNewClientQuotas() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), ConfigType$.MODULE$.User(), "user2"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), ConfigType$.MODULE$.User(), "user2/clients/clientA"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testClaimAbsentController() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
    }

    @Test
    public void testExistingKRaftControllerClaim() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
        ZkMigrationLeadershipState otherNodeState = ZkMigrationLeadershipState.EMPTY.withNewKRaftController(3001, 43).withKRaftMetadataOffsetAndEpoch(100L, 42);
        otherNodeState = this.migrationClient().claimControllerLeadership(otherNodeState);
        Assertions.assertEquals((int)2, (int)otherNodeState.zkControllerEpochZkVersion());
        Assertions.assertEquals((int)3001, (int)otherNodeState.kraftControllerId());
        Assertions.assertEquals((int)43, (int)otherNodeState.kraftControllerEpoch());
    }

    @Test
    public void testNonIncreasingKRaftEpoch() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch()));
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch() - 1));
        ControllerMovedException t1 = (ControllerMovedException)Assertions.assertThrows(ControllerMovedException.class, () -> this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((Object)"Cannot register KRaft controller 3001 with epoch 41 as the current controller register in ZK has the same or newer epoch 42.", (Object)t1.getMessage());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch()));
        ControllerMovedException t2 = (ControllerMovedException)Assertions.assertThrows(ControllerMovedException.class, () -> this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((Object)"Cannot register KRaft controller 3001 with epoch 42 as the current controller register in ZK has the same or newer epoch 42.", (Object)t2.getMessage());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, 100));
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)this.migrationState().kraftControllerEpoch(), (int)100);
        Assertions.assertEquals((int)this.migrationState().kraftControllerId(), (int)3001);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClaimAndReleaseExistingController() {
        void var10_10;
        void var9_9;
        Tuple2 tuple2;
        void var3_3;
        void var2_2;
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        Tuple2 tuple22 = this.zkClient().registerControllerAndIncrementControllerEpoch(100);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int epoch = tuple22._1$mcI$sp();
        int zkVersion = tuple22._2$mcI$sp();
        Assertions.assertEquals((int)var2_2, (int)2);
        Assertions.assertEquals((int)var3_3, (int)1);
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().zkControllerEpochZkVersion());
        Option option = this.zkClient().getControllerEpoch();
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            int zkEpoch = tuple2._1$mcI$sp();
            Stat stat = (Stat)tuple2._2();
            Assertions.assertEquals((int)3, (int)zkEpoch);
            Assertions.assertEquals((int)2, (int)stat.getVersion());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail();
        } else {
            throw new MatchError((Object)option);
        }
        Assertions.assertEquals((int)3000, (int)BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get()));
        Assertions.assertThrows(ControllerMovedException.class, () -> this.zkClient().registerControllerAndIncrementControllerEpoch(100));
        this.migrationState_$eq(this.migrationClient().releaseControllerLeadership(this.migrationState()));
        Tuple2 tuple23 = this.zkClient().registerControllerAndIncrementControllerEpoch(100);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int epoch1 = tuple23._1$mcI$sp();
        int zkVersion1 = tuple23._2$mcI$sp();
        Assertions.assertEquals((int)var9_9, (int)4);
        Assertions.assertEquals((int)var10_10, (int)3);
    }

    @Test
    public void testReadAndWriteProducerId() {
        Assertions.assertEquals((long)0L, (long)this.generateNextProducerIdWithZkAndRead$1());
        this.migrationState_$eq(this.migrationClient().writeProducerId(6000L, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Assertions.assertEquals((long)7000L, (long)this.generateNextProducerIdWithZkAndRead$1());
    }

    @Test
    public void testMigrateTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "test";
        Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        boolean x$4 = true;
        boolean x$52 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment(x$1, props, x$3, x$52, x$4);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateTopics(MetadataVersion.latest(), batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)1, (int)batches.size());
        Seq configs = ((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((List)batches.get(0)).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.message(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateTopicConfigs$4(message)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ConfigRecord)x$6, Buffer$.MODULE$.canBuildFrom())).toSeq();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"flush.ms", (Object)((ConfigRecord)configs.head()).name());
        Assertions.assertEquals((Object)"60000", (Object)((ConfigRecord)configs.head()).value());
        Assertions.assertEquals((Object)"retention.ms", (Object)((ConfigRecord)configs.last()).name());
        Assertions.assertEquals((Object)"300000", (Object)((ConfigRecord)configs.last()).value());
    }

    @Test
    public void testWriteNewTopicConfigs() {
        this.migrationState_$eq(this.migrationClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testWriteExistingTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), "test", props);
        this.migrationState_$eq(this.migrationClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    private final long generateNextProducerIdWithZkAndRead$1() {
        ProducerIdManager$.MODULE$.zk(1, this.zkClient()).generateProducerId();
        ArrayList records = new ArrayList();
        this.migrationClient().migrateProducerId(MetadataVersion.latest(), batch -> records.add(batch));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((int)1, (int)((List)records.get(0)).size());
        return ((ProducerIdsRecord)((ApiMessageAndVersion)((List)records.get(0)).get(0)).message()).nextProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicConfigs$4(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public ZkMigrationClientTest() {
        this.InitialControllerEpoch = 42;
        this.InitialKRaftEpoch = 0;
    }
}

