/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import kafka.server.BaseFetchRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u0001'\u0011\u0019y\u0003\u0001)A\u0005O!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0004B\u0002\u001e\u0001A\u0003%!\u0007C\u0004<\u0001\t\u0007I\u0011\u0001\u0014\t\rq\u0002\u0001\u0015!\u0003(\u0011\u001di\u0004A1A\u0005\u0002\u0019BaA\u0010\u0001!\u0002\u00139\u0003\"B \u0001\t\u0003\u0001\u0005\"B$\u0001\t\u0003B\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003?\u0001A\u0011AA\u000b\u0011\u0019\t\u0019\u0003\u0001C\u0005M\t\u0001c)\u001a;dQ\u001a\u0013x.\u001c$pY2|w/\u001a:J]R,wM]1uS>tG+Z:u\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0003-]\tQa[1gW\u0006T\u0011\u0001G\u0001\fS:$Xm\u001a:bi&|gn\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"B\u0001\u000b\u001f\u0015\u00051\u0012B\u0001\u0011\u001e\u0005Q\u0011\u0015m]3GKR\u001c\u0007NU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011aE\u0001\t]Vlgj\u001c3fgV\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]R\f\u0011B\\;n\u001d>$Wm\u001d\u0011\u0002\u00119,X\u000eU1siN\f\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001d1,\u0017\rZ3s\u0005J|7.\u001a:JI\u0006yA.Z1eKJ\u0014%o\\6fe&#\u0007%\u0001\tg_2dwn^3s\u0005J|7.\u001a:JI\u0006\tbm\u001c7m_^,'O\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tZ\nA!\u001e;jY&\u0011ai\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003%\u00032AS'P\u001b\u0005Y%B\u0001'*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001d.\u00131aU3r!\ta\u0002+\u0003\u0002R;\tY1*\u00194lC\u000e{gNZ5h\u0003=\"Xm\u001d;G_2dwn^3s\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI\u001a+Go\u00195fg>s'+\u001a9mS\u000e\fG/[8o)\t!v\u000b\u0005\u0002)+&\u0011a+\u000b\u0002\u0005+:LG\u000fC\u0003Y\u001d\u0001\u0007\u0011,\u0001\u0004rk>\u0014X/\u001c\t\u00035\u0006t!aW0\u0011\u0005qKS\"A/\u000b\u0005yK\u0012A\u0002\u001fs_>$h(\u0003\u0002aS\u00051\u0001K]3eK\u001aL!!\u000f2\u000b\u0005\u0001L\u0003\u0006\u0002\beaF\u0004\"!\u001a8\u000e\u0003\u0019T!a\u001a5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002jU\u00069!.\u001e9ji\u0016\u0014(BA6m\u0003\u0015QWO\\5u\u0015\u0005i\u0017aA8sO&\u0011qN\u001a\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005y\u0001\u0006\u0002\btwr\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0011A\u0014xN^5eKJT!\u0001\u001f5\u0002\rA\f'/Y7t\u0013\tQXOA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003{~\f\u0013A`\u0001\u0003u.\f#!!\u0001\u0002\u000b-\u0014\u0018M\u001a;)\u000f9\t)!!\u0004\u0002\u0010A!\u0011qAA\u0005\u001b\u00059\u0018bAA\u0006o\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003#\t\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003e\"Xm\u001d;GKR\u001c\u0007N\u0012:p[2+\u0017\rZ3s/\"LG.\u001a)sK\u001a,'O]3e%\u0016\fGMU3qY&\u001c\u0017-S:V]\u00064\u0018-\u001b7bE2,G#\u0001+)\u0007=\tI\u0002E\u0002f\u00037I1!!\bg\u0005\u0011!Vm\u001d;\u0002;Q,7\u000f\u001e$fi\u000eDgI]8n\r>dGn\\<fe^KG\u000f\u001b*pY2D3\u0001EA\r\u0003M9W\r\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u0001")
public class FetchFromFollowerIntegrationTest
extends BaseFetchRequestTest {
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final int leaderBrokerId;
    private final int followerBrokerId;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public int leaderBrokerId() {
        return this.leaderBrokerId;
    }

    public int followerBrokerId() {
        return this.followerBrokerId;
    }

    /*
     * WARNING - void declaration
     */
    public Properties overridingProps() {
        void var1_1;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.numNodes()));
        return var1_1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = this.numNodes();
        String x$2 = this.zkConnectOrNull();
        boolean x$3 = false;
        boolean x$4 = true;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        int x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$4).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    @Timeout(value=15L)
    public void testFollowerCompleteDelayedFetchesOnReplication(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$5 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        Properties x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$5, x$6, (Map<Object, Seq<Object>>)x$4, x$7);
        short version = ApiKeys.FETCH.latestVersion();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        FetchRequest fetchRequest = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version, 20000, 1, this.createConsumerFetchRequest$default$8());
        try (Socket socket = this.connect(this.brokerSocketServer(this.followerBrokerId()), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            FetchResponse response = (FetchResponse)this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable() {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$5 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        Properties x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$5, x$6, (Map<Object, Seq<Object>>)x$4, x$7);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertEquals((int)1, (int)this.getPreferredReplica());
        ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)-1, (int)this.getPreferredReplica());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchFromFollowerWithRoll() {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$5 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        Properties x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$5, x$6, (Map<Object, Seq<Object>>)x$4, x$7);
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("client.rack", Integer.toString(this.followerBrokerId()));
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$1(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).startup();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$3(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
    }

    private int getPreferredReplica() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        FetchRequest request = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, ApiKeys.FETCH.latestVersion(), 500, 1, Integer.toString(this.followerBrokerId()));
        FetchResponse response = (FetchResponse)this.connectAndReceive((AbstractRequest)request, ((KafkaBroker)this.brokers().apply(this.leaderBrokerId())).socketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        Assertions.assertEquals((int)1, (int)response.data().responses().size());
        FetchResponseData.FetchableTopicResponse topicResponse = (FetchResponseData.FetchableTopicResponse)response.data().responses().get(0);
        Assertions.assertEquals((int)1, (int)topicResponse.partitions().size());
        return ((FetchResponseData.PartitionData)topicResponse.partitions().get(0)).preferredReadReplica();
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(FetchFromFollowerIntegrationTest $this, TopicPartition topicPartition$1) {
        return !((KafkaBroker)$this.brokers().apply($this.leaderBrokerId())).metadataCache().getPartitionReplicaEndpoints(topicPartition$1, $this.listenerName()).contains((Object)BoxesRunTime.boxToInteger((int)$this.followerBrokerId()));
    }

    public static final /* synthetic */ String $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2() {
        return "follower is still reachable.";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$1(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica() == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$2() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$3(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica() == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$4() {
        return "Preferred replica is not set";
    }

    public FetchFromFollowerIntegrationTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.topic = "test-fetch-from-follower";
        this.leaderBrokerId = 0;
        this.followerBrokerId = 1;
    }
}

