/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogSegments;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t%g\u0001\u0002\u001b6\u0001iBQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0011\u0006\u0001)A\u0005\u001b\"91\u000b\u0001b\u0001\n\u0003a\u0005B\u0002+\u0001A\u0003%Q\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\ri\u0003\u0001\u0015!\u0003X\u0011\u001dY\u0006A1A\u0005\u0002qCa!\u001a\u0001!\u0002\u0013i\u0006b\u00024\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007O\u0002\u0001\u000b\u0011B/\t\u000f!\u0004!\u0019!C\u0001S\"1!\u000f\u0001Q\u0001\n)Dqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\bs\u0002\u0011\r\u0011\"\u0001u\u0011\u0019Q\b\u0001)A\u0005k\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0001 \u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\nuD1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001a!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0012\u0011-\t9\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0007\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\"\u0001\u0001\u0006I!!\f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011q\f\u0001\u0005\u0002\u0005\u001d\u0003bBA5\u0001\u0011\u0005\u0011q\t\u0005\b\u0003g\u0002A\u0011AA$\u0011\u001d\t9\b\u0001C\u0001\u0003\u000fBq!a\u001f\u0001\t\u0003\t9\u0005C\u0004\u0002\u0000\u0001!I!a\u0012\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002H!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0004\u0003*\u0001!IAa\u000b\t\u000f\tE\u0002\u0001\"\u0003\u00034\u00191!q\b\u0001\u0005\u0005\u0003B!\"!\u0001,\u0005\u0003\u0005\u000b\u0011\u0002B\"\u0011)\u0011Ie\u000bB\u0001B\u0003%\u0011q\u001f\u0005\u000b\u0005\u0017Z#\u0011!Q\u0001\n\t5\u0003B\u0003B*W\t\u0005\t\u0015!\u0003\u0003V!a!1N\u0016\u0003\u0002\u0003\u0006IA!\u001c\u0003t!A1o\u000bB\u0001B\u0003%Q\u000f\u0003\u0004HW\u0011\u0005!Q\u000f\u0005\b\u0005\u000f[C\u0011\tBE\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dWR+7\u000f\u001e\u0006\u0003m]\nqa\u00197vgR,'OC\u00019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u001eB!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011!)R\u0007\u0002\u0007*\u0011AiN\u0001\u0006kRLGn]\u0005\u0003\r\u000e\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013B\u0011!\nA\u0007\u0002k\u0005\u0011b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:t+\u0005i\u0005C\u0001\u001fO\u0013\tyUHA\u0002J]R\f1C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\u0002\nAB\\;n!J|G-^2feN\fQB\\;n!J|G-^2feN\u0004\u0013!\u00068v[J+7m\u001c:egB+'\u000f\u0015:pIV\u001cWM]\u0001\u0017]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3sA\u0005AQn\\2l)&lW-F\u0001X!\t\u0011\u0005,\u0003\u0002Z\u0007\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00051A/\u001c9ESJ,\u0012!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\f!![8\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u000bG>t7-\u001e:sK:$(BA8b\u0003\u0011)H/\u001b7\n\u0005Ed'aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013aD1qa\u0016tGmU3nCBDwN]3\u0016\u0003U\u0004\"a\u001b<\n\u0005]d'!C*f[\u0006\u0004\bn\u001c:f\u0003A\t\u0007\u000f]3oIN+W.\u00199i_J,\u0007%\u0001\ntQJLgn[%teN+W.\u00199i_J,\u0017aE:ie&t7.S:s'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013A\u00037pO6\u000bg.Y4feV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00039\u0014a\u00017pO&\u0019\u0011QA@\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u0004y\u00055\u0011bAA\b{\t!QK\\5u\u0011!\t\u0019\"FA\u0001\u0002\u0004i\u0018a\u0001=%c\u0005YAn\\4NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002\u001cA\u0019!*!\b\n\u0007\u0005}QGA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$B!a\u0003\u0002&!I\u00111\u0003\r\u0002\u0002\u0003\u0007\u00111D\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003[\u0001B!a\f\u0002@5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0004d_6lwN\u001c\u0006\u0004q\u0005]\"\u0002BA\u001d\u0003w\ta!\u00199bG\",'BAA\u001f\u0003\ry'oZ\u0005\u0005\u0003\u0003\n\tD\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nQa]3u+B$\"!a\u0003)\u0007q\tY\u0005\u0005\u0003\u0002N\u0005mSBAA(\u0015\u0011\t\t&a\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002V\u0005]\u0013a\u00026va&$XM\u001d\u0006\u0005\u00033\nY$A\u0003kk:LG/\u0003\u0003\u0002^\u0005=#A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u001e\u0003G\u0002B!!\u0014\u0002f%!\u0011qMA(\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0013uKN$hj\u001c'pG.\u001cuN\u001c;f]RLwN\\,ji\"|W\u000f^%teV\u0003H-\u0019;fQ\rq\u0012Q\u000e\t\u0005\u0003\u001b\ny'\u0003\u0003\u0002r\u0005=#\u0001\u0002+fgR\fA\u0007^3ti\u0006\u0003\b/\u001a8e%\u0016\u0004H.[2b\r\u0016$8\r[,ji\"\u001c6\r[3ek2,'o\u00115fG.4uN]*ie&t7.S:sQ\ry\u0012QN\u0001$i\u0016\u001cH/\u00119qK:$'+\u001a9mS\u000e\fg)\u001a;dQ^KG\u000f[+qI\u0006$X-S:sQ\r\u0001\u0013QN\u0001)i\u0016\u001cHoR3u%\u0016\u0004H.[2b/&$\b.\u00169eCR,\u0017i]:jO:lWM\u001c;B]\u0012L5O\u001d\u0015\u0004C\u00055\u0014AJ2p]\u000e,(O]3oiB\u0013x\u000eZ;dK\u001a+Go\u00195XSRD'+Z1e\u0019>\u001c7n\u00148ms\u0006\u00193m\u001c8dkJ\u0014XM\u001c;Qe>$WoY3GKR\u001c\u0007nV5uQ^\u0013\u0018\u000e^3M_\u000e\\\u0017aD:dQ\u0016$W\u000f\\3BaB,g\u000eZ:\u0015\u0005\u0005\u001d\u0005CBAE\u00033\u000byJ\u0004\u0003\u0002\f\u0006Ue\u0002BAG\u0003'k!!a$\u000b\u0007\u0005E\u0015(\u0001\u0004=e>|GOP\u0005\u0002}%\u0019\u0011qS\u001f\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005\r\u0019V-\u001d\u0006\u0004\u0003/k\u0004\u0007BAQ\u0003W\u0003Ra[AR\u0003OK1!!*m\u0005\u00191U\u000f^;sKB!\u0011\u0011VAV\u0019\u0001!1\"!,%\u0003\u0003\u0005\tQ!\u0001\u00020\n\u0019q\fJ\u0019\u0012\t\u0005E\u0016q\u0017\t\u0004y\u0005M\u0016bAA[{\t9aj\u001c;iS:<\u0007c\u0001\u001f\u0002:&\u0019\u00111X\u001f\u0003\u0007\u0005s\u00170A\ftG\",G-\u001e7f\r>dGn\\<fe\u001a+Go\u00195fgR1\u0011\u0011YAg\u0003#\u0004b!!#\u0002\u001a\u0006\r\u0007\u0007BAc\u0003\u0013\u0004Ra[AR\u0003\u000f\u0004B!!+\u0002J\u0012Y\u00111Z\u0013\u0002\u0002\u0003\u0005)\u0011AAX\u0005\ryFE\r\u0005\u0007\u0003\u001f,\u0003\u0019A'\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\u0007\u0003',\u0003\u0019A'\u0002\u00159,XNU3d_J$7/A\ttG\",G-\u001e7f'\"\u0014\u0018N\\6JgJ$b!!7\u0002d\u0006M\b\u0007BAn\u0003?\u0004Ra[AR\u0003;\u0004B!!+\u0002`\u0012Y\u0011\u0011\u001d\u0014\u0002\u0002\u0003\u0005)\u0011AAX\u0005\ryFe\r\u0005\b\u0003K4\u0003\u0019AAt\u0003)\t7\r^5wK\u001ac\u0017m\u001a\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q\u001e7\u0002\r\u0005$x.\\5d\u0013\u0011\t\t0a;\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u001d\t)P\na\u0001\u0003o\fq\"\\8dWRKW.Z*mK\u0016\u0004Xj\u001d\t\u0004y\u0005e\u0018bAA~{\t!Aj\u001c8h\u0003]\u0019X\r^;q!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5N_\u000e\\7\u000f\u0006\u0003\u0002\u001c\t\u0005\u0001\"B>(\u0001\u0004i\u0018aE2sK\u0006$X\rT8h!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\u0004\u0005\u001f\u0001BA!\u0003\u0003\f5\ta.C\u0002\u0003\u000e9\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011\t\u0002\u000ba\u0001\u0005'\t\u0011b\u001c<feJLG-Z:\u0011\u0011\tU!Q\u0004B\u0012\u0005GqAAa\u0006\u0003\u001aA\u0019\u0011QR\u001f\n\u0007\tmQ(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005?\u0011\tCA\u0002NCBT1Aa\u0007>!\u0011\u0011)B!\n\n\t\t\u001d\"\u0011\u0005\u0002\u0007'R\u0014\u0018N\\4\u0002\r\u0005\u0004\b/\u001a8e)\u0019\tYA!\f\u00030!9\u0011qC\u0015A\u0002\u0005m\u0001BBAjS\u0001\u0007Q*A\u0007gKR\u001c\u0007NR8mY><XM\u001d\u000b\u000b\u0003\u0017\u0011)Da\u000e\u0003<\tu\u0002bBA\fU\u0001\u0007\u00111\u0004\u0005\u0007\u0005sQ\u0003\u0019A'\u0002\u0015\u0019|G\u000e\\8xKJLE\r\u0003\u0004\u0002P*\u0002\r!\u0014\u0005\u0007\u0003'T\u0003\u0019A'\u0003\u000fMcwn\u001e'pON\u00191Fa\u0011\u0011\u0007y\u0014)%C\u0002\u0003H}\u0014!\"\u00168jM&,G\rT8h\u00039awnZ*uCJ$xJ\u001a4tKR\f\u0001\u0002\\8dC2dun\u001a\t\u0004}\n=\u0013b\u0001B)\u007f\nAAj\\2bY2{w-\u0001\tmK\u0006$WM]#q_\u000eD7)Y2iKB)AHa\u0016\u0003\\%\u0019!\u0011L\u001f\u0003\r=\u0003H/[8o!\u0011\u0011iFa\u001a\u000e\u0005\t}#\u0002\u0002B1\u0005G\nQ!\u001a9pG\"T1A!\u001a8\u0003\u0019\u0019XM\u001d<fe&!!\u0011\u000eB0\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u0006!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u00042A B8\u0013\r\u0011\th \u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\n\t\t-$Q\t\u000b\u000f\u0005o\u0012YH! \u0003\u0000\t\u0005%1\u0011BC!\r\u0011IhK\u0007\u0002\u0001!9\u0011\u0011\u0001\u001aA\u0002\t\r\u0003b\u0002B%e\u0001\u0007\u0011q\u001f\u0005\b\u0005\u0017\u0012\u0004\u0019\u0001B'\u0011\u001d\u0011\u0019F\ra\u0001\u0005+BqAa\u001b3\u0001\u0004\u0011i\u0007C\u0003te\u0001\u0007Q/\u0001\bbaB,g\u000eZ!t\u0019\u0016\fG-\u001a:\u0015\u0019\t-%\u0011\u0013BQ\u0005G\u0013iK!0\u0011\u0007y\u0014i)C\u0002\u0003\u0010~\u0014Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002BJg\u0001\u0007!QS\u0001\be\u0016\u001cwN\u001d3t!\u0011\u00119J!(\u000e\u0005\te%\u0002\u0002BN\u0003c\taA]3d_J$\u0017\u0002\u0002BP\u00053\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\bBBAhg\u0001\u0007Q\nC\u0005\u0003&N\u0002\n\u00111\u0001\u0003(\u00061qN]5hS:\u00042A BU\u0013\r\u0011Yk \u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\u001c\u0005\n\u0005_\u001b\u0004\u0013!a\u0001\u0005c\u000b!$\u001b8uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:\u0004BAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0003g\u00119L\u0003\u0003\u0003f\u0005U\u0012\u0002\u0002B^\u0005k\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\u001c\u0005\n\u0005\u007f\u001b\u0004\u0013!a\u0001\u0005\u0003\fAB]3rk\u0016\u001cH\u000fT8dC2\u0004BAa1\u0003F6\u0011!1M\u0005\u0005\u0005\u000f\u0014\u0019G\u0001\u0007SKF,Xm\u001d;M_\u000e\fG\u000e")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime;
    private final File tmpDir;
    private final File logDir;
    private final ExecutorService executorService;
    private final Semaphore appendSemaphore;
    private final Semaphore shrinkIsrSemaphore;
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, configRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.mockTime(), TestUtils$.MODULE$.createLogManager$default$6(), TestUtils$.MODULE$.createLogManager$default$7()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints, (Option)None$.MODULE$);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleFollowerFetches(leaderEpoch, 1).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(15L, TimeUnit.SECONDS));
    }

    private Seq<Future<?>> scheduleAppends() {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable & scala.Serializable)x$8 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Future<?>> scheduleFollowerFetches(int leaderEpoch, int numRecords) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)index -> PartitionLockTest.$anonfun$scheduleFollowerFetches$1(this, leaderEpoch, numRecords, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        AlterPartitionListener isrChangeListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(CommittedPartitionState currentState, scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(currentState, outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxTransactionTimeout = 300000;
                ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeout, producerStateManagerConfig, (Time)this.$outer.mockTime());
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset(), localLog, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), MetadataVersion.latest(), brokerId$1, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1);
            }
        };
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)partition.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), this.kafka$cluster$PartitionLockTest$$topicPartition());
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)alterIsrManager.submit((TopicIdPartition)ArgumentMatchers.eq((Object)topicIdPartition), (LeaderAndIsr)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$2(brokerId, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)x$9 -> PartitionLockTest.$anonfun$append$1(partition, requestLocal, BoxesRunTime.unboxToInt((Object)x$9)));
    }

    private void fetchFollower(Partition partition, int followerId, int leaderEpoch, int numRecords) {
        long logStartOffset = 0L;
        long fetchOffset = 0L;
        Optional<Object> lastFetchedEpoch = Optional.empty();
        int maxBytes = 1;
        while (fetchOffset < (long)numRecords) {
            FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), followerId, 0L, 1, maxBytes, (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
            FetchRequest.PartitionData fetchPartitionData = new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, maxBytes, Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), lastFetchedEpoch);
            LogReadInfo logReadInfo = partition.fetchRecords(fetchParams, fetchPartitionData, this.mockTime().milliseconds(), maxBytes, true, true);
            Assertions.assertTrue((boolean)logReadInfo.divergingEpoch().isEmpty());
            Iterable batches = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.fetchedData().records().batches()).asScala();
            if (!batches.nonEmpty()) continue;
            Assertions.assertEquals((int)1, (int)batches.size());
            RecordBatch batch = (RecordBatch)batches.head();
            lastFetchedEpoch = Optional.of(BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch()));
            fetchOffset = batch.lastOffset() + 1L;
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$8) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleFollowerFetches$1(PartitionLockTest $this, int leaderEpoch$1, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.fetchFollower($this.partition(), index, leaderEpoch$1, numRecords$1);
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$2(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$append$1(Partition partition$1, RequestLocal requestLocal$1, int x$9) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        return partition$1.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal$1);
    }

    public PartitionLockTest() {
        Logging.$init$((Logging)this);
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
        this.mockTime = new MockTime();
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
        this.appendSemaphore = new Semaphore(0);
        this.shrinkIsrSemaphore = new Semaphore(0);
        this.kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, MetadataVersion interBrokerProtocolVersion, RequestLocal requestLocal) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion, requestLocal);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
        }
    }
}

