/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.internals.generated.TransactionLogKey;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.UnifiedLog;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rMf\u0001B2e\u0001-DQA\u001d\u0001\u0005\u0002MDqA\u001e\u0001C\u0002\u0013\u0005q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0001x\u0011\u0019i\b\u0001)A\u0005q\"9a\u0010\u0001b\u0001\n\u00039\bBB@\u0001A\u0003%\u0001\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u00111\u0004\u0001!\u0002\u0013\t)\u0001\u0003\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001x\u0011\u001d\ty\u0002\u0001Q\u0001\naD\u0011\"!\t\u0001\u0005\u0004%\t!a\t\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003KA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0012\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u000fB\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\t\u0011\u0005\r\u0004\u0001)A\u0005\u00033B\u0011\"!\u001a\u0001\u0005\u0004%\t!a\u001a\t\u0011\u0005U\u0004\u0001)A\u0005\u0003SB\u0011\"a\u001e\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u001d\u0005\u0001)A\u0005\u0003wB\u0011\"!#\u0001\u0005\u0004%\t!a#\t\u0011\u0005]\u0005\u0001)A\u0005\u0003\u001bC\u0011\"!'\u0001\u0005\u0004%\t!a'\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003;C\u0011\"!*\u0001\u0005\u0004%\t!a*\t\u0011\u0005=\u0006\u0001)A\u0005\u0003SC\u0011\"!-\u0001\u0005\u0004%\t!a-\t\u0011\u0005-\u0007\u0001)A\u0005\u0003kC\u0011\"!4\u0001\u0005\u0004%\t!a-\t\u0011\u0005=\u0007\u0001)A\u0005\u0003kC\u0011\"!5\u0001\u0005\u0004%\t!a5\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003+D\u0011\"a9\u0001\u0005\u0004%\t!a5\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003+D\u0011\"a:\u0001\u0005\u0004%\t!!;\t\u0011\u0005e\b\u0001)A\u0005\u0003WD\u0011\"a?\u0001\u0001\u0004%\t!!@\t\u0013\t\u0015\u0001\u00011A\u0005\u0002\t\u001d\u0001\u0002\u0003B\n\u0001\u0001\u0006K!a@\t\u0013\tU\u0001\u00011A\u0005\u0002\u0005u\b\"\u0003B\f\u0001\u0001\u0007I\u0011\u0001B\r\u0011!\u0011i\u0002\u0001Q!\n\u0005}\b\"\u0003B\u0010\u0001\u0001\u0007I\u0011\u0001B\u0011\u0011%\u0011y\u0003\u0001a\u0001\n\u0003\u0011\t\u0004\u0003\u0005\u00036\u0001\u0001\u000b\u0015\u0002B\u0012\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqA!\u0015\u0001\t\u0003\u0011I\u0004C\u0004\u0003\\\u0001!\tA!\u000f\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003:!9!\u0011\u000e\u0001\u0005\u0002\te\u0002b\u0002B7\u0001\u0011\u0005!\u0011\b\u0005\b\u0005c\u0002A\u0011\u0001B\u001d\u0011\u001d\u0011)\b\u0001C\u0001\u0005sAqA!\u001f\u0001\t\u0003\u0011I\u0004C\u0004\u0003~\u0001!\tA!\u000f\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003:!9!Q\u0011\u0001\u0005\u0002\te\u0002b\u0002BE\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u001b\u0003A\u0011\u0001B\u001d\u0011\u001d\u0011\t\n\u0001C\u0001\u0005sAqA!&\u0001\t\u0003\u0011I\u0004C\u0004\u0003\u001a\u0002!\tA!\u000f\t\u000f\tu\u0005\u0001\"\u0001\u0003:!9!\u0011\u0015\u0001\u0005\u0002\te\u0002b\u0002BS\u0001\u0011\u0005!\u0011\b\u0005\b\u0005S\u0003A\u0011\u0001B\u001d\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005sAqA!-\u0001\t\u0003\u0011I\u0004C\u0004\u00036\u0002!\tA!\u000f\t\u000f\te\u0006\u0001\"\u0001\u0003:!9!Q\u0018\u0001\u0005\u0002\te\u0002b\u0002Ba\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u000b\u0004A\u0011\u0001B\u001d\u0011\u001d\u0011I\r\u0001C\u0001\u0005sAqA!4\u0001\t\u0003\u0011I\u0004C\u0004\u0003R\u0002!\tA!\u000f\t\u000f\tU\u0007\u0001\"\u0001\u0003:!9!\u0011\u001c\u0001\u0005\n\tm\u0007b\u0002B|\u0001\u0011%!\u0011 \u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0005sAqaa\u0002\u0001\t\u0003\u0011I\u0004C\u0004\u0004\f\u0001!Ia!\u0004\t\u000f\rM\u0001\u0001\"\u0003\u0004\u0016!91\u0011\u0004\u0001\u0005\n\rm\u0001bBB\u0013\u0001\u0011%1q\u0005\u0005\b\u0007\u007f\u0001A\u0011BB!\u0011\u001d\u0019I\u0005\u0001C\u0005\u0007\u0017Bqaa\u0017\u0001\t\u0013\u0019i\u0006C\u0004\u0004d\u0001!Ia!\u001a\t\u000f\r%\u0004\u0001\"\u0003\u0004l!I1\u0011\u0010\u0001\u0012\u0002\u0013%11\u0010\u0005\n\u0007#\u0003\u0011\u0013!C\u0005\u0007'Cqaa&\u0001\t\u0013\u0019I\nC\u0004\u0004&\u0002!Iaa*\t\u000f\r-\u0006\u0001\"\u0001\u0003:!91q\u0016\u0001\u0005\u0002\te\"a\u0007+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002fM\u0006YAO]1og\u0006\u001cG/[8o\u0015\t9\u0007.A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A5\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\bCA;\u0001\u001b\u0005!\u0017a\u00039beRLG/[8o\u0013\u0012,\u0012\u0001\u001f\t\u0003[fL!A\u001f8\u0003\u0007%sG/\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0006)BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004d_6lwN\u001c\u0006\u0004S\u0006=!\u0002BA\t\u0003'\ta!\u00199bG\",'BAA\u000b\u0003\ry'oZ\u0005\u0005\u00033\tIA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007%\u0001\u0006uq:\u0014VmY8sIN,\"!!\n\u0011\r\u0005\u001d\u0012\u0011GA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_q\u0017AC2pY2,7\r^5p]&!\u00111GA\u0015\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQA!a\u000f\u0002\n\u00051!/Z2pe\u0012LA!a\u0010\u0002:\ta1+[7qY\u0016\u0014VmY8sI\u0006YA\u000f\u001f8SK\u000e|'\u000fZ:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\t\u00055\u0013\u0011B\u0001\u0006kRLGn]\u0005\u0005\u0003#\nYE\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002ZA!\u00111LA0\u001b\t\tiFC\u0002\u0002N!LA!!\u0019\u0002^\tiQj\\2l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003!Q8n\u00117jK:$XCAA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8Q\u0006\u0011!p[\u0005\u0005\u0003g\niGA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002|A!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002\"\faa]3sm\u0016\u0014\u0018\u0002BAC\u0003\u007f\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003\u001diW\r\u001e:jGN,\"!!$\u0011\t\u0005=\u00151S\u0007\u0003\u0003#SA!!#\u0002\n%!\u0011QSAI\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\nibt7i\u001c8gS\u001e,\"!!(\u0011\u0007U\fy*C\u0002\u0002\"\u0012\u0014\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003)!\bP\\\"p]\u001aLw\rI\u0001\u0013iJ\fgn]1di&|g.T1oC\u001e,'/\u0006\u0002\u0002*B\u0019Q/a+\n\u0007\u00055FMA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sA\u0005\u0001BO]1og\u0006\u001cG/[8oC2LE-M\u000b\u0003\u0003k\u0003B!a.\u0002F:!\u0011\u0011XAa!\r\tYL\\\u0007\u0003\u0003{S1!a0k\u0003\u0019a$o\\8u}%\u0019\u00111\u00198\u0002\rA\u0013X\rZ3g\u0013\u0011\t9-!3\u0003\rM#(/\u001b8h\u0015\r\t\u0019M\\\u0001\u0012iJ\fgn]1di&|g.\u00197JIF\u0002\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333\u0003E!(/\u00198tC\u000e$\u0018n\u001c8bY&#'\u0007I\u0001\u0014ibtW*Z:tC\u001e,7*Z=CsR,7/M\u000b\u0003\u0003+\u0004R!\\Al\u00037L1!!7o\u0005\u0015\t%O]1z!\ri\u0017Q\\\u0005\u0004\u0003?t'\u0001\u0002\"zi\u0016\fA\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgF\u0002\u0013a\u0005;y]6+7o]1hK.+\u0017PQ=uKN\u0014\u0014\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\u0014\u0004%A\u0006qe>$WoY3s\u0013\u0012\u001cXCAAv!!\ti/a<\u00026\u0006MXBAA\u0017\u0013\u0011\t\t0!\f\u0003\u00075\u000b\u0007\u000fE\u0002n\u0003kL1!a>o\u0005\u0011auN\\4\u0002\u0019A\u0014x\u000eZ;dKJLEm\u001d\u0011\u0002\u0019QDh.T3uC\u0012\fG/Y\u0019\u0016\u0005\u0005}\bcA;\u0003\u0002%\u0019!1\u00013\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0002!QDh.T3uC\u0012\fG/Y\u0019`I\u0015\fH\u0003\u0002B\u0005\u0005\u001f\u00012!\u001cB\u0006\u0013\r\u0011iA\u001c\u0002\u0005+:LG\u000fC\u0005\u0003\u0012\u001d\n\t\u00111\u0001\u0002\u0000\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQDh.T3uC\u0012\fG/Y\u0019!\u00031!\bP\\'fi\u0006$\u0017\r^13\u0003A!\bP\\'fi\u0006$\u0017\r^13?\u0012*\u0017\u000f\u0006\u0003\u0003\n\tm\u0001\"\u0003B\tU\u0005\u0005\t\u0019AA\u0000\u00035!\bP\\'fi\u0006$\u0017\r^13A\u0005iQ\r\u001f9fGR,G-\u0012:s_J,\"Aa\t\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQAA!\u000b\u0002\n\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003.\t\u001d\"AB#se>\u00148/A\tfqB,7\r^3e\u000bJ\u0014xN]0%KF$BA!\u0003\u00034!I!\u0011C\u0017\u0002\u0002\u0003\u0007!1E\u0001\u000fKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:!\u0003\u0015\u0019X\r^+q)\t\u0011I\u0001K\u00020\u0005{\u0001BAa\u0010\u0003N5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%A\u0002ba&TAAa\u0012\u0003J\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B&\u0003'\tQA[;oSRLAAa\u0014\u0003B\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3\u0001\rB+!\u0011\u0011yDa\u0016\n\t\te#\u0011\t\u0002\n\u0003\u001a$XM]#bG\"\fa\u0004^3tiZ\u000bG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;)\u0007E\u0012y\u0006\u0005\u0003\u0003@\t\u0005\u0014\u0002\u0002B2\u0005\u0003\u0012A\u0001V3ti\u0006qA/Z:u\u0003\u0012$w)\u001a;QS\u0012\u001c\bf\u0001\u001a\u0003`\u0005\u0019B/Z:u\t\u0016dW\r^3QCJ$\u0018\u000e^5p]\"\u001a1Ga\u0018\u00025Q,7\u000f\u001e#fY\u0016$X\rT8bI&tw\rU1si&$\u0018n\u001c8)\u0007Q\u0012y&A\u0015uKN$Hj\\1e\u0003:$'+Z7pm\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014\b+\u0019:uSRLwN\u001c\u0015\u0004k\t}\u0013!\u000b;fgR\u001cu.\u001c9mKR,GK]1og&$\u0018n\u001c8XQ\u0016t\u0017\t\u001d9f]\u0012\u001cVoY2fK\u0012,G\rK\u00027\u0005?\nA\u0006^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8D_>\u0014H-\u001b8bi>\u0014hj\u001c;Bm\u0006LG.\u00192mK\u0016\u0013(o\u001c:)\u0007]\u0012y&A\u0012uKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_:{GoQ8pe\u0012Lg.\u0019;pe\u0016\u0013(o\u001c:)\u0007a\u0012y&A\u0014uKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012LgnZ#se>\u0014\bfA\u001d\u0003`\u0005aB/Z:u\u0003B\u0004XM\u001c3GC&dGk\\+oW:|wO\\#se>\u0014\bf\u0001\u001e\u0003`\u0005)C/Z:u!\u0016tG-\u001b8h'R\fG/\u001a(piJ+7/\u001a;P]J+GO]=BaB,g\u000e\u001a\u0015\u0004w\t}\u0013!\f;fgR\f\u0005\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><w\u000b[5mKB\u0013x\u000eZ;dKJ4UM\\2fI\"\u001aAHa\u0018\u0002eQ,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\rU3oI&twm\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012D3!\u0010B0\u0003}\u001a\bn\\;mIJ+G/\u001e:o\u001d>$8i\\8sI&t\u0017\r^8s\u000bJ\u0014xN]%g)J\fgn]1di&|g.\u00133QCJ$\u0018\u000e^5p]:{GoT<oK\u0012D3A\u0010B0\u0003Q\"Xm\u001d;MSN$HK]1og\u0006\u001cG/[8og^KG\u000f[\"p_J$\u0017N\\1u_Jdu.\u00193j]\u001eLe\u000e\u0015:pOJ,7o\u001d\u0015\u0004\u007f\t}\u0013!\b;fgRd\u0015n\u001d;Ue\u0006t7/Y2uS>t7OR5mi\u0016\u0014\u0018N\\4)\u0007\u0001\u0013y&\u0001\u001ctQ>,H\u000eZ(oYf\u001cuN\\:jI\u0016\u0014HK]1og\u0006\u001cG/[8og&sG\u000b[3P]\u001e|\u0017N\\4Ti\u0006$X\rV8BE>\u0014H\u000fK\u0002B\u0005?\n\u0001h\u001d5pk2$wK]5uKRCh.T1sW\u0016\u00148OR8s)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3e\u0007>lW.\u001b;Ti\u0006$X\rK\u0002C\u0005?\nqg\u001d5pk2$wK]5uKRCh.T1sW\u0016\u00148OR8s)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3e\u0003\n|'\u000f^*uCR,\u0007fA\"\u0003`\u0005\t4\u000f[8vY\u0012\u0014V-\\8wK\u000e{W\u000e\u001d7fi\u0016\u001cu.\\7ji\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001#\u0003`\u0005\u00014\u000f[8vY\u0012\u0014V-\\8wK\u000e{W\u000e\u001d7fi\u0016\f%m\u001c:u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIND3!\u0012B0\u0003!\u001a\bn\\;mIJ+Wn\u001c<f\u000b6\u0004H/_#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\r1%qL\u00017g\"|W\u000f\u001c3O_R\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001a'pO\u0006\u0003\b/\u001a8e\r\u0006LGn\u001d\u0015\u0004\u000f\n}\u0013AJ:i_VdGMT8u%\u0016lwN^3P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001a\u0001Ja\u0018\u0002WMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\f%m\u001c:u)J\fgn]1di&|g.\u00197JIND3!\u0013B0\u00031\u001a\bn\\;mI:{GOU3n_Z,\u0007K]3qCJ,7i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002K\u0005?\n\u0001\u0007^3tiR\u0013\u0018M\\:bGRLwN\\1m\u000bb\u0004\u0018N]1uS>tw+\u001b;i)>|7+\\1mY\n\u000bGo\u00195TSj,\u0007fA&\u0003`\u0005aC/Z:u)J\fgn]1di&|g.\u00197FqBL'/\u0019;j_:<\u0016\u000e\u001e5PM\u001ad\u0017N\\3M_\u001e$\u0015N\u001d\u0015\u0004\u0019\n}\u0013a\f;fgR$&/\u00198tC\u000e$\u0018n\u001c8FqBL'/\u0019;j_:\u001c\u0006n\\;mIJ+7\u000f]3di\n\u000bGo\u00195TSj,\u0007fA'\u0003`\u0005QE/Z:u)J\fgn]1di&|g.\u0012=qSJ\fG/[8o'\"|W\u000f\u001c3O_R4\u0015-\u001b7XSRDWK\\5oSRL\u0017\r\\5{K\u0012$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;bQ\rq%qL\u0001&G>dG.Z2u)J\fgn]1di&|g.\u00197JIN4%o\\7U_6\u00147\u000f^8oKN$BA!8\u0003dB1\u0011q\u0017Bp\u0003kKAA!9\u0002J\n\u00191+\u001a;\t\u000f\t\u0015x\n1\u0001\u0003h\u0006y\u0011\r\u001d9f]\u0012,GMU3d_J$7\u000f\u0005\u0005\u0002(\t%\u0018Q\u0001Bv\u0013\u0011\t\t0!\u000b\u0011\r\u0005\u001d\"Q\u001eBy\u0013\u0011\u0011y/!\u000b\u0003\r\t+hMZ3s!\u0011\t9Da=\n\t\tU\u0018\u0011\b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u000271|\u0017\rZ#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t)\u0011\u0011iNa?\t\r\tu\b\u000b1\u0001y\u0003MqW/\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0003ua\u0017n\u001d;FqBL'/\u00192mKR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001cHC\u0001Bo\u0003m!Xm\u001d;Tk\u000e\u001cWm]:gk2\u0014V-[7nS\u001e\u0014\u0018\r^5p]\"\u001a!Ka\u0018\u0002WQ,7\u000f\u001e'pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b/&$\bnQ8seV\u0004H/\u001a3M_\u001eD3a\u0015B0\u0003\t2XM]5gs6+G/\u00193bi\u0006$u.Z:Fq&\u001cH/\u00118e\u0013N,6/\u00192mKR!!\u0011BB\b\u0011\u001d\u0019\t\u0002\u0016a\u0001\u0003k\u000bq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0001\u001am\u0016\u0014\u0018NZ=NKR\fG-\u0019;b\t>,7O\u001c;Fq&\u001cH\u000f\u0006\u0003\u0003\n\r]\u0001bBB\t+\u0002\u0007\u0011QW\u0001 Kb\u0004Xm\u0019;Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tGC\u0002B\u0005\u0007;\u0019\t\u0003C\u0004\u0004 Y\u0003\rAa\t\u0002\u0017\u0005\u0004\b/\u001a8e\u000bJ\u0014xN\u001d\u0005\b\u0007G1\u0006\u0019\u0001Bt\u0003=\u0019\u0017\r\u001d;ve\u0016$\u0017\t\u001d9f]\u0012\u001c\u0018!\b7pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014\b+\u0019:uSRLwN\\:\u0015\t\t%1\u0011\u0006\u0005\b\u0007W9\u0006\u0019AB\u0017\u00031\u0001\u0018M\u001d;ji&|g.\u00133t!\u0015\u0019yc!\u000fy\u001d\u0011\u0019\td!\u000e\u000f\t\u0005m61G\u0005\u0002_&\u00191q\u00078\u0002\u000fA\f7m[1hK&!11HB\u001f\u0005\r\u0019V-\u001d\u0006\u0004\u0007oq\u0017aD3ya\u0016\u001cG\u000fT8h\u0007>tg-[4\u0015\r\t%11IB#\u0011\u001d\u0019Y\u0003\u0017a\u0001\u0007[Aaaa\u0012Y\u0001\u0004A\u0018\u0001D7bq\n\u000bGo\u00195TSj,\u0017\u0001J:fiV\u0004\u0018I\u001c3Sk:$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8\u0015\r\t%1QJB)\u0011\u001d\u0019y%\u0017a\u0001\u0005G\tQ!\u001a:s_JDqaa\u0015Z\u0001\u0004\u0019)&\u0001\u0005uq:\u001cF/\u0019;f!\r)8qK\u0005\u0004\u00073\"'\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0003\u00112XM]5gs^\u0013\u0018\u000e^3t)btW*\u0019:lKJ\u001c\u0018J\u001c)sKB\f'/Z*uCR,G\u0003\u0002B\u0005\u0007?Bqa!\u0019[\u0001\u0004\u0019)&A\u0003ti\u0006$X-\u0001\bbgN,'\u000f^\"bY2\u0014\u0017mY6\u0015\t\t%1q\r\u0005\b\u0007\u001fZ\u0006\u0019\u0001B\u0012\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b))\typ!\u001c\u0004p\rM4Q\u000f\u0005\b\u0007#a\u0006\u0019AA[\u0011\u001d\u0019\t\b\u0018a\u0001\u0003g\f!\u0002\u001d:pIV\u001cWM]%e\u0011%\u0019\t\u0007\u0018I\u0001\u0002\u0004\u0019)\u0006\u0003\u0005\u0004xq\u0003\n\u00111\u0001y\u0003)!\bP\u001c+j[\u0016|W\u000f^\u0001\u001eiJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\u0010\u0016\u0005\u0007+\u001ayh\u000b\u0002\u0004\u0002B!11QBG\u001b\t\u0019)I\u0003\u0003\u0004\b\u000e%\u0015!C;oG\",7m[3e\u0015\r\u0019YI\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBH\u0007\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003u!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"TCABKU\rA8qP\u0001\u000eaJ,\u0007/\u0019:f)btGj\\4\u0015\u0011\t%11TBO\u0007CCq!!\u0001`\u0001\u0004\t)\u0001C\u0004\u0004 ~\u0003\r!a=\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0007G{\u0006\u0019\u0001By\u0003\u001d\u0011XmY8sIN\f!\u0004\u001d:fa\u0006\u0014XMR8s)btW*Z:tC\u001e,\u0017\t\u001d9f]\u0012$BA!\u0003\u0004*\"91q\n1A\u0002\t\r\u0012a\u0006;fgR\u0004\u0016M\u001d;ji&|g\u000eT8bI6+GO]5dQ\r\t'qL\u0001\u001ci\u0016\u001cH/S4o_J,WK\\6o_^t'+Z2pe\u0012$\u0016\u0010]3)\u0007\t\u0014y\u0006")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    @Test
    public void testDeleteLoadingPartition() {
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))});
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            latch.await();
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(BoxesRunTime.unboxToInt((Object)x$3), x$4, x$5, x$6);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$7 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$9, x$10, x$11, x$12) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$9), x$10, x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString());
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString());
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$13 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$14 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        String x$1 = this.transactionalId1();
        int x$2 = this.coordinatorEpoch();
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        String x$13 = this.transactionalId1();
        int x$14 = 10;
        Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, x$14, failedMetadata, (Function1)x$16, x$18, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        String x$19 = this.transactionalId1();
        int x$20 = 10;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, x$20, failedMetadata, (Function1)x$22, x$24, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        String x$13 = this.transactionalId1();
        int x$14 = 10;
        Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, x$14, failedMetadata, (Function1)x$16, x$18, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        String x$19 = this.transactionalId1();
        int x$20 = 10;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, x$20, failedMetadata, (Function1)x$22, x$24, requestLocal);
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$15)), RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> {
            String x$1 = this.transactionalId1();
            int x$2 = 10;
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                this.assertCallback(error);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
            this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        });
    }

    @Test
    public void shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$16 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void testListTransactionsWithCoordinatorLoadingInProgress() {
        this.transactionManager().addLoadingPartition(0, 15);
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty());
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)Errors.forCode((short)listResponse.errorCode()));
    }

    @Test
    public void testListTransactionsFiltering() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.putTransaction$1("t0", 0L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t1", 1L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t2", 2L, (TransactionState)PrepareCommit$.MODULE$);
        this.putTransaction$1("t3", 3L, (TransactionState)PrepareAbort$.MODULE$);
        this.putTransaction$1("t4", 4L, (TransactionState)CompleteCommit$.MODULE$);
        this.putTransaction$1("t5", 5L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t6", 6L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t7", 7L, (TransactionState)PrepareEpochFence$.MODULE$);
        this.putTransaction$1("t8", 8L, (TransactionState)Dead$.MODULE$);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"})), TransactionStateManagerTest.assertListTransactions$default$2$1(), TransactionStateManagerTest.assertListTransactions$default$3$1());
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing"}));
        scala.collection.immutable.Set x$3 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$1, x$3, x$2);
        scala.collection.immutable.Set x$4 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing", "UnknownState"}));
        scala.collection.immutable.Set x$6 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$4, x$6, x$5);
        scala.collection.immutable.Set x$7 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2", "t4"}));
        scala.collection.immutable.Set x$8 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PrepareCommit", "CompleteCommit"}));
        scala.collection.immutable.Set x$9 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$7, x$9, x$8);
        scala.collection.immutable.Set x$10 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$11 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"}));
        scala.collection.immutable.Set x$12 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$10, x$12, x$11);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})), TransactionStateManagerTest.assertListTransactions$default$3$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t5", "t6"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L, 6L, 8L, 9L})), TransactionStateManagerTest.assertListTransactions$default$3$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4", "t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit", "CompleteAbort"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{3L, 6L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})));
        scala.collection.immutable.Set x$13 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$14 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead"}));
        scala.collection.immutable.Set x$15 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$13, x$15, x$14);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        attemptedAppends.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        void var9_9;
        void var8_8;
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).thenReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partition()), scala.collection.Set$.MODULE$.canBuildFrom()));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
        void transactionalIdsForOnlinePartition2 = var8_8;
        void transactionalIdsForOfflinePartition2 = var9_9;
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)transactionalIdsForOnlinePartition2, expiredTransactionalIds);
        Assertions.assertEquals((Object)transactionalIdsForOfflinePartition2, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assertions.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.partition()), Iterable$.MODULE$.canBuildFrom()));
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    @Test
    public void testTransactionExpirationShouldNotFailWithUninitializedTransactionMetadata() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        String transactionalId = "id";
        scala.collection.immutable.Set allTransactionalIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{transactionalId}));
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, 1L, (short)-1, this.transactionTimeoutMs(), (TransactionState)Empty$.MODULE$, this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        this.time().sleep((long)(this.txnConfig().transactionalIdExpirationMs() + 1));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1 & Serializable & scala.Serializable)i -> TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, BoxesRunTime.unboxToInt((Object)i)));
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((TraversableOnce)((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty()).transactionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.transactionalId(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$2(this, transactionalId)))).toSet();
    }

    @Test
    public void testSuccessfulReimmigration() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$23, x$24, x$25, x$26) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$23), x$24, x$25, x$26);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$27, x$28, x$29, x$30) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$27), x$28, x$29, x$30);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$31, x$32, x$33, x$34) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$31), x$32, x$33, x$34);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getLog(this.topicPartition());
        ((UnifiedLog)Mockito.verify((Object)logMock)).logStartOffset();
        ((UnifiedLog)Mockito.verify((Object)logMock)).read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true));
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).getLogEndOffset(this.topicPartition());
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$35 -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError, x$35);
            return BoxedUnit.UNIT;
        });
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)logConfig.maxMessageSize()).thenReturn((Object)Predef$.MODULE$.int2Integer(maxBatchSize));
        partitionIds.foreach((Function1 & Serializable & scala.Serializable)partitionId -> TransactionStateManagerTest.$anonfun$expectLogConfig$1(this, logConfig, BoxesRunTime.unboxToInt((Object)partitionId)));
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, Defaults$.MODULE$.MaxMessageSize());
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        boolean bl = Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState));
        boolean bl2 = bl;
        if (bl2) {
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            MemoryRecords expectedRecords = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{expectedTombstone});
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assertions.assertEquals((Object)new .colon.colon((Object)expectedRecords, (List)Nil$.MODULE$), (Object)((SeqLike)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assertions.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        Mockito.when((Object)this.replicaManager().getLog(topicPartition)).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(topicPartition)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$36 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
    }

    private void prepareForTxnMessageAppend(Errors error) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        ArgumentCaptor capturedArgument = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)capturedArgument.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$37 -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error, x$37);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getMagic((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$38, x$39, x$40, x$41) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$38), x$39, x$40, x$41);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIgnoreUnknownRecordType() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        TransactionLogKey unknownKey = new TransactionLogKey();
        byte[] unknownMessage = MessageUtil.toVersionPrefixedBytes((short)Short.MAX_VALUE, (Message)unknownKey);
        SimpleRecord unknownRecord = new SimpleRecord(unknownMessage, unknownMessage);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)new .colon.colon((Object)unknownRecord, (List)Nil$.MODULE$).$plus$plus(this.txnRecords(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$42, x$43, x$44, x$45) -> {
            TransactionStateManagerTest.$anonfun$testIgnoreUnknownRecordType$1(BoxesRunTime.unboxToInt((Object)x$42), x$43, x$44, x$45);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Pool txnMetadataPool = ((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).metadataPerTransactionalId();
        Assertions.assertFalse((boolean)txnMetadataPool.isEmpty());
        Assertions.assertTrue((boolean)txnMetadataPool.contains((Object)this.transactionalId1()));
        TransactionMetadata txnMetadata = (TransactionMetadata)txnMetadataPool.get((Object)this.transactionalId1());
        Assertions.assertEquals((Object)this.txnMetadata1().transactionalId(), (Object)txnMetadata.transactionalId());
        Assertions.assertEquals((long)this.txnMetadata1().producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.txnMetadata1().lastProducerId(), (long)txnMetadata.lastProducerId());
        Assertions.assertEquals((short)this.txnMetadata1().producerEpoch(), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)this.txnMetadata1().lastProducerEpoch(), (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)this.txnMetadata1().txnTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)this.txnMetadata1().state(), (Object)txnMetadata.state());
        Assertions.assertEquals((Object)this.txnMetadata1().topicPartitions(), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$3(int x$3, TransactionResult x$4, TransactionMetadata x$5, TxnTransitMetadata x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$4(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$5() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$9, TransactionResult x$10, TransactionMetadata x$11, TxnTransitMetadata x$12) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$15) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private final void putTransaction$1(String transactionalId, long producerId, TransactionState state) {
        TransactionMetadata txnMetadata = this.transactionMetadata(transactionalId, producerId, state, this.transactionMetadata$default$4());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata).left().toOption().foreach((Function1 & Serializable & scala.Serializable)error -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Failed to insert transaction ").append(txnMetadata).append(" due to error ").append(error).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testListTransactionsFiltering$4(String state) {
        return TransactionState$.MODULE$.fromName(state).isEmpty();
    }

    private final void assertListTransactions$1(scala.collection.immutable.Set expectedTransactionalIds, scala.collection.immutable.Set filterProducerIds, scala.collection.immutable.Set filterStates) {
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(filterProducerIds, filterStates);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)listResponse.errorCode()));
        Assertions.assertEquals((Object)expectedTransactionalIds, (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listResponse.transactionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.transactionalId(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)filterStates.filter((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testListTransactionsFiltering$4(state)))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(listResponse.unknownStateFilters()).asScala()).toSet());
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$2$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$3$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assertions.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$21) {
        return x$21.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assertions.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)batches.forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$21))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assertions.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = new StringBuilder(3).append("id_").append(i).toString();
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, $this.transactionMetadata$default$3(), $this.transactionMetadata$default$4());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$2(TransactionStateManagerTest $this, String transactionalId) {
        boolean bl;
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            bl = $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$23, TransactionResult x$24, TransactionMetadata x$25, TxnTransitMetadata x$26) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$27, TransactionResult x$28, TransactionMetadata x$29, TxnTransitMetadata x$30) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$31, TransactionResult x$32, TransactionMetadata x$33, TxnTransitMetadata x$34) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(ArgumentCaptor callbackCapture$1, ArgumentCaptor recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1, InvocationOnMock x$35) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((TraversableOnce)((TraversableLike)recordsCapture$1.getValue()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            MemoryRecords records = (MemoryRecords)x0$1._2();
            ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                void var2_2;
                Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                capturedAppends$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)batches));
                return var2_2;
            })).$plus$eq((Object)records);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$expectLogConfig$1(TransactionStateManagerTest $this, LogConfig logConfig$1, int partitionId) {
        return Mockito.when((Object)$this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).thenReturn((Object)new Some((Object)logConfig$1));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, ArgumentCaptor capturedArgument$1, Errors error$1, InvocationOnMock x$37) {
        ((Function1)capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$38, TransactionResult x$39, TransactionMetadata x$40, TxnTransitMetadata x$41) {
    }

    public static final /* synthetic */ void $anonfun$testIgnoreUnknownRecordType$1(int x$42, TransactionResult x$43, TransactionMetadata x$44, TxnTransitMetadata x$45) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        Mockito.when((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions())));
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

