/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BQA\u000f\u0001\u0005\u0002mBQ\u0001\u0014\u0001\u0005\n5CQA\u0018\u0001\u0005\u0002mBQa\u0019\u0001\u0005\u0002mBQ!\u001a\u0001\u0005\u0002mBQa\u001a\u0001\u0005\u0002mBQ!\u001b\u0001\u0005\u0002mBQa\u001b\u0001\u0005\u0002mBQ!\u001c\u0001\u0005\n9Dq\u0001\u001f\u0001\u0012\u0002\u0013%\u0011\u0010C\u0004\u0002\n\u0001!I!a\u0003\t\u0013\u0005]\u0002!%A\u0005\n\u0005e\u0002bBA\u001f\u0001\u0011%\u0011q\b\u0004\u0007\u0003\u000f\u0002A!!\u0013\t\u0015\u0005EsB!A!\u0002\u0013\t\u0019\u0006\u0003\u00047\u001f\u0011\u0005\u0011q\f\u0005\u0007\u0003OzA\u0011I\u001e\t\r\u0005%t\u0002\"\u0011<\u0011\u001d\tYg\u0004C!\u0003[Bq!a\u001c\u0010\t\u0003\n\t\bC\u0004\u0002\u001a>!\t%a'\t\u000f\u0005-v\u0002\"\u0011\u0002.\"9\u00111W\b\u0005B\u0005U\u0006bBAv\u001f\u0011\u0005\u0013Q\u001e\u0005\n\u0005;y!\u0019!C!\u0005?A\u0001Ba\n\u0010A\u0003%!\u0011\u0005\u0004\u0007\u0005S\u0001AAa\u000b\t\u0015\u0005ECD!A!\u0002\u0013\t\u0019\u0006\u0003\u0006\u00034q\u0011\t\u0011)A\u0005\u0005kAaA\u000e\u000f\u0005\u0002\tm\u0002b\u0002B\"9\u0011E#Q\t\u0005\b\u0005KbB\u0011\u000bB4\u0011\u001d\u0011)\b\bC)\u0005oBqAa \u001d\t#\u0012\t\tC\u0004\u0003\br!\tF!#\t\u000f\t5E\u0004\"\u0015\u0003\u0010\"9!1\u0013\u000f\u0005R\tU\u0005\"\u0003BS9\t\u0007I\u0011\u000bB\u0010\u0011!\u00119\u000b\bQ\u0001\n\t\u0005\"AG!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:UKN$(BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\tQ&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002U\u0005\u00192\r\\3b]6+GO]5d%\u0016<\u0017n\u001d;ssR\tA\b\u0005\u00022{%\u0011aH\r\u0002\u0005+:LG\u000f\u000b\u0002\u0003\u0001B\u0011\u0011IS\u0007\u0002\u0005*\u00111\tR\u0001\u0004CBL'BA#G\u0003\u001dQW\u000f]5uKJT!a\u0012%\u0002\u000b),h.\u001b;\u000b\u0003%\u000b1a\u001c:h\u0013\tY%I\u0001\u0006CK\u001a|'/Z#bG\"\fabZ3u\u001b\u0016$(/[2WC2,X\r\u0006\u0002O#B\u0011\u0011gT\u0005\u0003!J\u00121!\u00118z\u0011\u0015\u00116\u00011\u0001T\u0003\u0011q\u0017-\\3\u0011\u0005Q[fBA+Z!\t1&'D\u0001X\u0015\tAf&\u0001\u0004=e>|GOP\u0005\u00035J\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!LM\u0001\u001ai\u0016\u001cH/\u00113e\u0003:$'+Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0005AB\u0011\u0011)Y\u0005\u0003E\n\u0013A\u0001V3ti\u0006qB/Z:u\u001b\u0016$(/[2GC&dW\r\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0003\u000b\u0001\f\u0011\u0004^3ti\u0012+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG\"\u0012a\u0001Y\u0001\u0018i\u0016\u001cH/T1zE\u0016,\u0006\u000fZ1uKR{\u0007/[2JIND#a\u00021\u0002)Q,7\u000f^#ya\u0006tG\r\u00165sK\u0006$\u0007k\\8mQ\tA\u0001-\u0001\u000buKN$8\u000b\u001b:j].$\u0006N]3bIB{w\u000e\u001c\u0015\u0003\u0013\u0001\fA\u0003^3tiJ+7/\u001b>f)\"\u0014X-\u00193Q_>dG\u0003\u0002\u001fpiZDQ\u0001\u001d\u0006A\u0002E\f!cY;se\u0016tGOR3uG\",'oU5{KB\u0011\u0011G]\u0005\u0003gJ\u00121!\u00138u\u0011\u0015)(\u00021\u0001r\u00039qWm\u001e$fi\u000eDWM]*ju\u0016Dqa\u001e\u0006\u0011\u0002\u0003\u0007\u0011/A\u0005ce>\\WM\u001d(v[\u0006qB/Z:u%\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$C-\u001a4bk2$HeM\u000b\u0002u*\u0012\u0011o_\u0016\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004I\n!\"\u00198o_R\fG/[8o\u0013\r\t9A \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE7bW\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\u0002\"!\u0004\u0002,\u0005=\u00121\u0007\t\u0007\u0003\u001f\t)\"!\u0007\u000e\u0005\u0005E!bAA\ne\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0011\u0011\u0003\u0002\u0004'\u0016$\b\u0003BA\u000e\u0003Oi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0007G>lWn\u001c8\u000b\u00075\n\u0019CC\u0002\u0002&!\u000ba!\u00199bG\",\u0017\u0002BA\u0015\u0003;\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002.1\u0001\r!]\u0001\ti>\u0004\u0018n\u0019(v[\"1\u0011\u0011\u0007\u0007A\u0002E\fA\u0002]1si&$\u0018n\u001c8Ok6D\u0001\"!\u000e\r!\u0003\u0005\raU\u0001\fi>\u0004\u0018n\u0019)sK\u001aL\u00070\u0001\u000fnC.,Gk\u001c9jGB\u000b'\u000f^5uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m\"FA*|\u0003-9W\r\u001e\"s_.,'/\u00133\u0015\u000bE\f\t%!\u0012\t\u000f\u0005\rc\u00021\u0001\u0002\u001a\u0005\u0011A\u000f\u001d\u0005\u0006o:\u0001\r!\u001d\u0002\u0013\u001b>\u001c7\u000eT3bI\u0016\u0014XI\u001c3Q_&tGo\u0005\u0003\u0010a\u0005-\u0003cA\u001d\u0002N%\u0019\u0011q\n\u0016\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi\u0006a1o\\;sG\u0016\u0014%o\\6feB!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z1\nqa\u00197vgR,'/\u0003\u0003\u0002^\u0005]#A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0005\u0003C\n)\u0007E\u0002\u0002d=i\u0011\u0001\u0001\u0005\b\u0003#\n\u0002\u0019AA*\u00035Ig.\u001b;jCR,7\t\\8tK\u0006)1\r\\8tK\u0006q!M]8lKJ,e\u000e\u001a)pS:$HCAA*\u0003\u00151W\r^2i)\u0011\t\u0019(!!\u0011\u0011\u0005=\u0011QOA\r\u0003sJA!a\u001e\u0002\u0012\t\u0019Q*\u00199\u0011\t\u0005m\u0014QP\u0007\u0002\u001f%!\u0011qPA'\u0005%1U\r^2i\t\u0006$\u0018\rC\u0004\u0002\u0004V\u0001\r!!\"\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005\u001d\u00151\u0013\b\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*!\u0011QRA\u000f\u0003!\u0011X-];fgR\u001c\u0018\u0002BAI\u0003\u0017\u000bABR3uG\"\u0014V-];fgRLA!!&\u0002\u0018\n9!)^5mI\u0016\u0014(\u0002BAI\u0003\u0017\u000b1CZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR$b!!(\u0002$\u0006\u001d\u0006cA\u0019\u0002 &\u0019\u0011\u0011\u0015\u001a\u0003\t1{gn\u001a\u0005\b\u0003K3\u0002\u0019AA\r\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!+\u0017\u0001\u0004\t\u0018AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\ti*a,\u00022\"9\u0011QU\fA\u0002\u0005e\u0001BBAU/\u0001\u0007\u0011/\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003o\u000by\u000e\u0005\u0005\u0002\u0010\u0005U\u0014\u0011DA]!\u0011\tY,!7\u000f\t\u0005u\u00161\u001b\b\u0005\u0003\u007f\u000byM\u0004\u0003\u0002B\u00065g\u0002BAb\u0003\u0017tA!!2\u0002J:\u0019a+a2\n\u0003%K1!!\nI\u0013\ri\u00131E\u0005\u0005\u0003?\t\t#\u0003\u0003\u0002R\u0006u\u0011aB7fgN\fw-Z\u0005\u0005\u0003+\f9.\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f'\u0002BAi\u0003;IA!a7\u0002^\nqQ\t]8dQ\u0016sGm\u00144gg\u0016$(\u0002BAk\u0003/Dq!!9\u0019\u0001\u0004\t\u0019/\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002\"a\u0004\u0002v\u0005e\u0011Q\u001d\t\u0005\u0003w\n9/\u0003\u0003\u0002j\u00065#!C#q_\u000eDG)\u0019;b\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0003_\u0014\t\u0002\u0005\u0004\u0002r\u0006}(Q\u0001\b\u0005\u0003g\fYP\u0004\u0003\u0002v\u0006ehb\u0001,\u0002x&\tQ&\u0003\u0002,Y%\u0019\u0011Q \u0016\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!!\u0011\u0001B\u0002\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019\u0011Q \u0016\u0011\u000bE\u00129Aa\u0003\n\u0007\t%!G\u0001\u0004PaRLwN\u001c\t\u0005\u0003c\u0014i!\u0003\u0003\u0003\u0010\t\r!\u0001\u0004*fa2L7-\u0019$fi\u000eD\u0007b\u0002B\n3\u0001\u0007!QC\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\t\u0003\u001f\t)(!\u0007\u0003\u0018A\u0019\u0011H!\u0007\n\u0007\tm!FA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-\u0001\u000fjgR\u0013XO\\2bi&|gn\u00148GKR\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\t\u0005\u0002cA\u0019\u0003$%\u0019!Q\u0005\u001a\u0003\u000f\t{w\u000e\\3b]\u0006i\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$\u0007EA\fUKN$(+Z:ju\u00164U\r^2iKJ$\u0006N]3bIN\u0019AD!\f\u0011\u0007e\u0012y#C\u0002\u00032)\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0019\u0011Ha\u000e\n\u0007\te\"F\u0001\tGC&dW\r\u001a)beRLG/[8ogR1!Q\bB \u0005\u0003\u00022!a\u0019\u001d\u0011\u001d\t\tf\ba\u0001\u0003'BqAa\r \u0001\u0004\u0011)$\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0005\u000f\u0012)Fa\u0016\u0003\\A)\u0011Ga\u0002\u0003JA!!1\nB)\u001b\t\u0011iEC\u0002\u0003P1\n1\u0001\\8h\u0013\u0011\u0011\u0019F!\u0014\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t)\u000b\ta\u0001\u00033AqA!\u0017!\u0001\u0004\ti*A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bb\u0002B/A\u0001\u0007!qL\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\t\u0005$1M\u0007\u00029%!\u0011q\u0010B\u0018\u0003!!(/\u001e8dCR,G#\u0002\u001f\u0003j\t-\u0004bBASC\u0001\u0007\u0011\u0011\u0004\u0005\b\u0005[\n\u0003\u0019\u0001B8\u0003=!(/\u001e8dCRLwN\\*uCR,\u0007cA\u001d\u0003r%\u0019!1\u000f\u0016\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0006y\te$1\u0010\u0005\b\u0003K\u0013\u0003\u0019AA\r\u0011\u001d\u0011iH\ta\u0001\u0003;\u000baa\u001c4gg\u0016$\u0018a\u00037bi\u0016\u001cH/\u00129pG\"$BAa!\u0003\u0006B!\u0011Ga\u0002r\u0011\u001d\t)k\ta\u0001\u00033\ta\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002\u001e\n-\u0005bBASI\u0001\u0007\u0011\u0011D\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003;\u0013\t\nC\u0004\u0002&\u0016\u0002\r!!\u0007\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0003\u0018\n}%\u0011\u0015\t\u0006c\t\u001d!\u0011\u0014\t\u0004s\tm\u0015b\u0001BOU\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBASM\u0001\u0007\u0011\u0011\u0004\u0005\u0007\u0005G3\u0003\u0019A9\u0002\u000b\u0015\u0004xn\u00195\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0003")
public class AbstractFetcherManagerTest {
    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn((Object)Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)None$.MODULE$, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId1, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$)));
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)None$.MODULE$, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId2, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, this.testResizeThreadPool$default$3());
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, this.testResizeThreadPool$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, this.makeTopicPartition$default$3());
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1);
            }
        };
        try {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            fetcherManager.addFetcherForPartitions((Map)((TraversableOnce)fetchingTopicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            ((IterableLike)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = scala.collection.mutable.Set$.MODULE$.empty();
            Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1);
            Map map = Implicits$.MODULE$.MapExtensionMethods((Map)fetcherManager.fetcherThreadMap());
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable & scala.Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(name$1) : name$1 != null);
        return bl;
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return Map$.MODULE$.empty();
        }

        public long fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public long fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return Map$.MODULE$.empty();
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, Set$.MODULE$.empty());
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            String x$1 = "test-resize-fetcher";
            String x$2 = "mock-fetcher";
            MockLeaderEndPoint x$3 = new MockLeaderEndPoint(AbstractFetcherManagerTest.this, sourceBroker);
            int x$5 = 0;
            BrokerTopicStats x$6 = new BrokerTopicStats();
            boolean x$7 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6();
            super(x$1, x$2, (LeaderEndPoint)x$3, failedPartitions, x$5, x$7, x$6);
            this.isOffsetForLeaderEpochSupported = false;
        }
    }
}

