/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FinalizedFeatureChangeListener;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.server.QuorumTestHarness;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.TestUtils$;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001]3A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00057!)q\u0004\u0001C\u0005A!)A\u0005\u0001C\u0005K!)\u0011\b\u0001C\u0001u!)1\n\u0001C\u0001u!)Q\n\u0001C\u0001u!)q\n\u0001C\u0001u!)\u0011\u000b\u0001C\u0001u!)1\u000b\u0001C\u0001u!)Q\u000b\u0001C\u0001u\t\u0011c)\u001b8bY&TX\r\u001a$fCR,(/Z\"iC:<W\rT5ti\u0016tWM\u001d+fgRT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u00035I!AF\u0007\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011A\u0003A\u0001\u0015GJ,\u0017\r^3Ce>\\WM\u001d$fCR,(/Z:\u0015\u0003q\u0001\"\u0001F\u000f\n\u0005yi!A\u0004\"s_.,'OR3biV\u0014Xm]\u0001\u0018GJ,\u0017\r^3GS:\fG.\u001b>fI\u001a+\u0017\r^;sKN$\u0012!\t\t\u0003)\tJ!aI\u0007\u00033\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7/\u00118e\u000bB|7\r[\u0001\u000fGJ,\u0017\r^3MSN$XM\\3s)\r1\u0013&\r\t\u0003)\u001dJ!\u0001K\u0007\u0003=\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b\"\u0002\u0016\u0005\u0001\u0004Y\u0013!B2bG\",\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u000e\u0003!iW\r^1eCR\f\u0017B\u0001\u0019.\u0005=Q6.T3uC\u0012\fG/Y\"bG\",\u0007\"\u0002\u001a\u0005\u0001\u0004\u0019\u0014\u0001F3ya\u0016\u001cG/\u001a3DC\u000eDWmQ8oi\u0016tG\u000fE\u00025o\u0005j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002KQ,7\u000f^%oSR\u001cVoY2fgN\fe\u000e\u001a(pi&4\u0017nY1uS>t7+^2dKN\u001cH#A\u001e\u0011\u0005Qb\u0014BA\u001f6\u0005\u0011)f.\u001b;)\u0005\u0015y\u0004C\u0001!J\u001b\u0005\t%B\u0001\"D\u0003\r\t\u0007/\u001b\u0006\u0003\t\u0016\u000bqA[;qSR,'O\u0003\u0002G\u000f\u0006)!.\u001e8ji*\t\u0001*A\u0002pe\u001eL!AS!\u0003\tQ+7\u000f^\u0001-i\u0016\u001cHOR3biV\u0014XM\u0017(pI\u0016$U\r\\3uK:{G/\u001b4jG\u0006$\u0018n\u001c8Qe>\u001cWm]:j]\u001eD#AB \u0002_Q,7\u000f\u001e$fCR,(/\u001a.O_\u0012,G)[:bE2Lgn\u001a(pi&4\u0017nY1uS>t\u0007K]8dKN\u001c\u0018N\\4)\u0005\u001dy\u0014!\f;fgR\u001c\u0015m\u00195f+B$\u0017\r^3XC&$h)Y5mg\u001a{'/\u00168sK\u0006\u001c\u0007.\u00192mKZ+'o]5p]\"\u0012\u0001bP\u0001+i\u0016\u001cH/\u00138ji\u001a\u000b\u0017\u000e\\;sK\u0012+X\rV8GK\u0006$XO]3J]\u000e|W\u000e]1uS\nLG.\u001b;zQ\tIq(A\u0012uKN$\u0018J\\5u\r\u0006LG.\u001e:f\tV,Gk\\%om\u0006d\u0017\u000eZ,bSR$\u0016.\\3)\u0005)y\u0014A\r;fgRtu\u000e^5gS\u000e\fG/[8o\r\u0006LG.\u001e:f\tV,Gk\u001c$fCR,(/Z%oG>l\u0007/\u0019;jE&d\u0017\u000e^=)\u0005-y\u0004")
public class FinalizedFeatureChangeListenerTest
extends QuorumTestHarness {
    /*
     * WARNING - void declaration
     */
    private BrokerFeatures createBrokerFeatures() {
        void var2_2;
        scala.collection.immutable.Map supportedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)new SupportedVersionRange(1, 3))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeaturesMap).asJava())));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeaturesAndEpoch createFinalizedFeatures() {
        void var3_3;
        scala.collection.immutable.Map finalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        this.zkClient().createFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)finalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var3_3.isEmpty());
        return new FinalizedFeaturesAndEpoch(finalizedFeaturesMap, (long)n);
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeatureChangeListener createListener(ZkMetadataCache cache, Option<FinalizedFeaturesAndEpoch> expectedCacheContent) {
        void var3_3;
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assertions.assertFalse((boolean)listener.isListenerInitiated());
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        listener.initOrThrow(15000L);
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
        if (expectedCacheContent.isDefined()) {
            Option mayBeNewCacheContent = cache.getFeatureOption();
            Assertions.assertFalse((boolean)mayBeNewCacheContent.isEmpty());
            FinalizedFeaturesAndEpoch newCacheContent = (FinalizedFeaturesAndEpoch)mayBeNewCacheContent.get();
            Assertions.assertEquals((Object)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).features(), (Object)newCacheContent.features());
            Assertions.assertEquals((long)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).epoch(), (long)newCacheContent.epoch());
        } else {
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        }
        return var3_3;
    }

    @Test
    public void testInitSuccessAndNotificationSuccess() {
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        this.updateAndCheckCache$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4))})), initialFinalizedFeatures, cache, listener);
        this.updateAndCheckCache$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)BoxesRunTime.boxToShort((short)3))})), initialFinalizedFeatures, cache, listener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDeleteNotificationProcessing() {
        void var6_6;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        this.zkClient().deleteFeatureZNode();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeDeletedBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertTrue((boolean)var6_6.isEmpty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FinalizedFeatureChangeListenerTest.$anonfun$testFeatureZNodeDeleteNotificationProcessing$1(cache)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)FinalizedFeatureChangeListenerTest.$anonfun$testFeatureZNodeDeleteNotificationProcessing$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDisablingNotificationProcessing() {
        void var6_6;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, (Map)updatedFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheUpdateWaitFailsForUnreachableVersion() {
        void var6_6;
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, this.createBrokerFeatures(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilFeatureEpochOrThrow(initialFinalizedFeatures.epoch() + 1L, 15000L));
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, (Map)updatedFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilFeatureEpochOrThrow((long)n, 15000L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitFailureDueToFeatureIncompatibility() {
        void var5_5;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)5))}));
        this.zkClient().createFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)incompatibleFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$7, x$8) -> exitLatch.countDown());
        try {
            FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
            Assertions.assertFalse((boolean)listener.isListenerInitiated());
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
            Assertions.assertThrows(TimeoutException.class, () -> listener.initOrThrow(5000L));
            exitLatch.await();
            Assertions.assertFalse((boolean)listener.isListenerInitiated());
            Assertions.assertTrue((boolean)listener.isListenerDead());
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testInitFailureDueToInvalidWaitTime() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assertions.assertThrows(IllegalArgumentException.class, () -> listener.initOrThrow(0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> listener.initOrThrow(-1L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotificationFailureDueToFeatureIncompatibility() {
        void var8_8;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$9, x$10) -> exitLatch.countDown());
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)((short)(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).max() + 1))))}));
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)incompatibleFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeIncompatibleBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var8_8.isEmpty());
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$2(exitLatch, listener, cache, initialFinalizedFeatures)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAndCheckCache$1(scala.collection.immutable.Map finalizedFeatures, FinalizedFeaturesAndEpoch initialFinalizedFeatures$1, ZkMetadataCache cache$1, FinalizedFeatureChangeListener listener$1) {
        void var6_6;
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures$1.epoch() ? 1 : 0) != 0);
        cache$1.waitUntilFeatureEpochOrThrow((long)n, 15000L);
        Assertions.assertEquals((Object)new FinalizedFeaturesAndEpoch(finalizedFeatures, (long)n), (Object)cache$1.getFeatureOption().get());
        Assertions.assertTrue((boolean)listener$1.isListenerInitiated());
    }

    public static final /* synthetic */ boolean $anonfun$testFeatureZNodeDeleteNotificationProcessing$1(ZkMetadataCache cache$2) {
        return cache$2.getFeatureOption().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testFeatureZNodeDeleteNotificationProcessing$2() {
        return "Timed out waiting for FinalizedFeatureCache to become empty";
    }

    public static final /* synthetic */ boolean $anonfun$testNotificationFailureDueToFeatureIncompatibility$2(CountDownLatch exitLatch$2, FinalizedFeatureChangeListener listener$4, ZkMetadataCache cache$4, FinalizedFeaturesAndEpoch initialFinalizedFeatures$3) {
        return exitLatch$2.getCount() == 0L && !listener$4.isListenerInitiated() && listener$4.isListenerDead() && ((FinalizedFeaturesAndEpoch)cache$4.getFeatureOption().get()).equals((Object)initialFinalizedFeatures$3);
    }

    public static final /* synthetic */ String $anonfun$testNotificationFailureDueToFeatureIncompatibility$3() {
        return "Timed out waiting for listener death and FinalizedFeatureCache to be updated";
    }
}

