/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\u00180\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004O\u0001\u0001\u0006Ia\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u00199\u0006\u0001)A\u0005#\"9\u0001\f\u0001b\u0001\n\u0013I\u0006BB/\u0001A\u0003%!\fC\u0003_\u0001\u0011\u0005q\fC\u0003o\u0001\u0011\u0005q\fC\u0003q\u0001\u0011\u0005q\fC\u0003s\u0001\u0011\u0005q\fC\u0003u\u0001\u0011\u0005q\fC\u0003w\u0001\u0011\u0005q\fC\u0003y\u0001\u0011\u0005q\fC\u0003{\u0001\u0011\u0005q\fC\u0003}\u0001\u0011\u0005q\fC\u0003\u007f\u0001\u0011\u0005q\f\u0003\u0004\u0002\u0002\u0001!\ta\u0018\u0005\u0007\u0003\u000b\u0001A\u0011A0\t\r\u0005%\u0001\u0001\"\u0001`\u0011\u0019\ti\u0001\u0001C\u0001?\"1\u0011\u0011\u0003\u0001\u0005\u0002}Ca!!\u0006\u0001\t\u0003y\u0006BBA\r\u0001\u0011\u0005q\f\u0003\u0004\u0002\u001e\u0001!\ta\u0018\u0005\u0007\u0003C\u0001A\u0011A0\t\r\u0005\u0015\u0002\u0001\"\u0001`\u0011\u0019\tI\u0003\u0001C\u0001?\"1\u0011Q\u0006\u0001\u0005\u0002}Ca!!\r\u0001\t\u0003y\u0006BBA\u001b\u0001\u0011\u0005q\f\u0003\u0004\u0002:\u0001!\ta\u0018\u0005\u0007\u0003{\u0001A\u0011A0\t\r\u0005\u0005\u0003\u0001\"\u0001`\u0011\u0019\t)\u0005\u0001C\u0001?\"1\u0011\u0011\n\u0001\u0005\u0002}Ca!!\u0014\u0001\t\u0003y\u0006BBA)\u0001\u0011\u0005q\f\u0003\u0004\u0002V\u0001!\ta\u0018\u0005\u0007\u00033\u0002A\u0011A0\t\r\u0005u\u0003\u0001\"\u0001`\u0011\u0019\t\t\u0007\u0001C\u0001?\"1\u0011Q\r\u0001\u0005\u0002}Ca!!\u001b\u0001\t\u0003y\u0006BBA7\u0001\u0011\u0005qL\u0001\rMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a+fgRT!\u0001M\u0019\u0002\u000b\u0015\u0004xn\u00195\u000b\u0005I\u001a\u0014AB:feZ,'OC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\b\u0005\u0002A\u00015\tq&\u0001\u0002uaV\t1\t\u0005\u0002E\u00196\tQI\u0003\u0002G\u000f\u000611m\\7n_:T!\u0001\u000e%\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u0016\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0002ua\u0002\n!b\u00195fG.\u0004x.\u001b8u+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+2\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\u0005Y\u001b&!\u0006'fC\u0012,'/\u00129pG\"\u001c\u0005.Z2la>Lg\u000e^\u0001\fG\",7m\u001b9pS:$\b%A\u0003dC\u000eDW-F\u0001[!\t\u00015,\u0003\u0002]_\t!B*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016\faaY1dQ\u0016\u0004\u0013!\u0005;fgR\u0004&/\u001a<j_V\u001cX\t]8dQR\t\u0001\r\u0005\u00029C&\u0011!-\u000f\u0002\u0005+:LG\u000f\u000b\u0002\tIB\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\u0004CBL'BA5k\u0003\u001dQW\u000f]5uKJT!a\u001b&\u0002\u000b),h.\u001b;\n\u000554'\u0001\u0002+fgR\fQe\u001d5pk2$\u0017\t\u001a3Fa>\u001c\u0007.\u00118e\u001b\u0016\u001c8/Y4f\u001f\u001a47/\u001a;U_\u000e\u000b7\r[3)\u0005%!\u0017AL:i_VdGMU3ukJtGj\\4F]\u0012|eMZ:fi&3G*\u0019;fgR,\u0005o\\2i%\u0016\fX/Z:uK\u0012D#A\u00033\u0002iMDw.\u001e7e%\u0016$XO\u001d8V]\u0012,g-\u001b8fI>3gm]3u\u0013\u001a,f\u000eZ3gS:,G-\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002\fI\u0006\u00115\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u00051!\u0017\u0001M:i_VdG-\u00128g_J\u001cW-T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\u000f\u000b\u0002\u000eI\u0006a4\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u001f\u001a47/\u001a;G_J\fE*Z1eKJ,\u0005o\\2i\u001f:\u001cW-\u0013;ICN\u0014U-\u001a8BgNLwM\\3eQ\tqA-\u0001\u0015tQ>,H\u000e\u001a*fiV\u0014h.\u00168tkB\u0004xN\u001d;fI&3gj\\#q_\u000eD'+Z2pe\u0012,G\r\u000b\u0002\u0010I\u0006\u00115\u000f[8vY\u0012\u0014V\r^;s]Vs7/\u001e9q_J$X\rZ%g\u001d>,\u0005o\\2i%\u0016\u001cwN\u001d3fI\u0006sG-\u00168eK\u001aLg.\u001a3Fa>\u001c\u0007NU3rk\u0016\u001cH/\u001a3)\u0005A!\u0017\u0001O:i_VdGMU3ukJtg)\u001b:ti\u0016\u0003xn\u00195JMJ+\u0017/^3ti\u0016$W\t]8dQ2+7o\u001d+iC:4\u0015N]:u\u000bB|7\r\u001b\u0015\u0003#\u0011\fQg\u001d5pk2$GK];oG\u0006$X-\u00134NCR\u001c\u0007.\u001b8h\u000bB|7\r\u001b\"vi\u0016\u000b'\u000f\\5feN#\u0018M\u001d;j]\u001e|eMZ:fi\"\u0012!\u0003Z\u0001Ig\"|W\u000f\u001c3HKR4\u0015N]:u\u001f\u001a47/\u001a;PMN+(m]3rk\u0016tG/\u00129pG\"<\u0006.\u001a8PM\u001a\u001cX\r\u001e*fcV,7\u000f^3e\r>\u0014\bK]3wS>,8/\u00129pG\"D#a\u00053\u0002\u000bNDw.\u001e7e%\u0016$XO\u001d8OKb$\u0018I^1jY\u0006\u0014G.Z#q_\u000eD\u0017J\u001a+iKJ,\u0017j\u001d(p\u000bb\f7\r^#q_\u000eDgi\u001c:UQ\u0016|e.\u001a*fcV,7\u000f^3eQ\t!B-\u0001\u001atQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u000bB|7\r[!oIN#\u0018M\u001d;PM\u001a\u001cX\r^%g\u0013R$\u0015\u000e\u001a(pi\u000eC\u0017M\\4fQ\t)B-A#tQ>,H\u000e\u001a*fiV\u0014h.\u00138wC2LGm\u00144gg\u0016$\u0018JZ#q_\u000eD\u0017j\u001d*fcV,7\u000f^3e/\"L7\r[%t\u001d>$8)\u001e:sK:$H.\u001f+sC\u000e\\W\r\u001a\u0015\u0003-\u0011\f\u0011f\u001d5pk2$7+\u001e9q_J$X\t]8dQN$\u0006.\u0019;E_:{Go\u0015;beR4%o\\7[KJ|\u0007FA\fe\u0003\r\u001a\bn\\;mIB+'o]5ti\u0016\u0003xn\u00195t\u0005\u0016$x/Z3o\u0013:\u001cH/\u00198dKND#\u0001\u00073\u0002UMDw.\u001e7e\u000b:4wN]2f\u001b>tw\u000e^8oS\u000e\fG\u000e\\=J]\u000e\u0014X-Y:j]\u001e,\u0005o\\2ig\"\u0012\u0011\u0004Z\u0001*g\"|W\u000f\u001c3F]\u001a|'oY3PM\u001a\u001cX\r^:J]\u000e\u0014X-Y:f\u001b>tw\u000e^8oS\u000e\fG\u000e\\=)\u0005i!\u0017\u0001N:i_VdG-\u00138de\u0016\f7/Z!oIR\u0013\u0018mY6Fa>\u001c\u0007n]!t\u0019\u0016\fG-\u001a:t\u0007\"\fgnZ3NC:LH+[7fg\"\u00121\u0004Z\u0001;g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003N4u\u000e\u001c7po\u0016\u0014(+Z2fSZ,7/T1os6+7o]1hKND#\u0001\b3\u0002sMDw.\u001e7e\tJ|\u0007/\u00128ue&,7o\u00148Fa>\u001c\u0007NQ8v]\u0012\f'/_,iK:\u0014V-\\8wS:<G*\u0019;fgR,e\u000e\u001e:jKND#!\b3\u0002gMDw.\u001e7e!J,7/\u001a:wKJ+7/\u001a;PM\u001a\u001cX\r^(o\u00072,\u0017M]#be2LWm\u001d;JM>sW-\u0012=jgR\u001c\bF\u0001\u0010e\u0003e\u001a\bn\\;mIV\u0003H-\u0019;f'\u00064X\rZ(gMN,Go\u00165f]>3gm]3u)>\u001cE.Z1s)>L5OQ3uo\u0016,g.\u00129pG\"\u001c\bFA\u0010e\u0003\u0015\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8FCJd\u0017\u0010\u000b\u0002!I\u0006Y3\u000f[8vY\u0012tu\u000e^\"mK\u0006\u0014\u0018I\\=uQ&tw-\u00134PM\u001a\u001cX\r\u001e+p\r&\u00148\u000f^(gMN,G\u000f\u000b\u0002\"I\u0006I3\u000f[8vY\u0012\u0014V\r^1j]2\u000bG/Z:u\u000bB|7\r[(o\u00072,\u0017M]!mY\u0016\u000b'\u000f\\5fgRD#A\t3\u0002oMDw.\u001e7e+B$\u0017\r^3PM\u001a\u001cX\r\u001e\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018.Z:P]\u000ecW-\u0019:FCJd\u0017.Z:uQ\t\u0019C-\u0001\u001dtQ>,H\u000eZ+qI\u0006$Xm\u00144gg\u0016$()\u001a;xK\u0016tW\t]8dQ\n{WO\u001c3be&,7o\u00148DY\u0016\f'/R1sY&,7\u000f\u001e\u001a)\u0005\u0011\"\u0017aO:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH/\u00118e+B$\u0017\r^3JiN|eMZ:fi\"\u0012Q\u0005Z\u00018g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001c()\u001a;xK\u0016tW\t]8dQ\n{WO\u001c3bef<\u0006.\u001a8SK6|g/\u001b8h\u001d\u0016<Xm\u001d;)\u0005\u0019\"\u0017!F:i_VdGm\u00117fCJ\fE\u000e\\#oiJLWm\u001d\u0015\u0003O\u0011\fqf\u001d5pk2$gj\u001c;SKN,G/\u00129pG\"D\u0015n\u001d;pefDU-\u00193JMVsG-\u001a4j]\u0016$\u0007+Y:tK\u0012D#\u0001\u000b3\u0002_MDw.\u001e7e\u001d>$(+Z:fi\u0016\u0003xn\u00195ISN$xN]=UC&d\u0017JZ+oI\u00164\u0017N\\3e!\u0006\u001c8/\u001a3)\u0005%\"\u0017AI:i_VdGMR3uG\"d\u0015\r^3ti\u0016\u0003xn\u00195PM\u0016k\u0007\u000f^=DC\u000eDW\r\u000b\u0002+I\u0006\u00013\u000f[8vY\u00124U\r^2i\u000b:$wJ\u001a4tKR|e-R7qif\u001c\u0015m\u00195fQ\tYC-A\u0010tQ>,H\u000eZ\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHo\u00148F[B$\u0018pQ1dQ\u0016D#\u0001\f3\u0002;MDw.\u001e7e\u00072,\u0017M\u001d'bi\u0016\u001cHo\u00148F[B$\u0018pQ1dQ\u0016D#!\f3")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Iterable<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = Nil$.MODULE$;
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1, 0L);
        Assertions.assertEquals((Object)expectedEpochEndOffset, (Object)epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0, 0L));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.cache().endOffsetFor(-1, 73L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4, 0L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6, 0L));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2, 17L));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3, 0L));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3, 100L));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), (Object)this.cache().endOffsetFor(0, (long)logEndOffset));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7, 0L));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }
}

